//
// mgui/sdk/cairo_utils.h
// This file is part of Bombono DVD project.
//
// Copyright (c) 2008 Ilya Murav'jov
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
// 

#ifndef __MGUI_SDK_CAIRO_UTILS_H__
#define __MGUI_SDK_CAIRO_UTILS_H__

#include <cairomm/cairomm.h>
#include <mlib/geom2d.h>
#include <mdemux/util.h>

std::string MakeSVGFilename(const char* prefix);

// Создать SVG-контекст для записи всех операций в файл <prefix>-NN.svg
// Может быть полезно для сохранения отрисованного в on_expose_event() в векторной форме (альтернатива
// снимкам экрана).
inline Cairo::RefPtr<Cairo::Context> CreateSVGCairoContext(const char* prefix, Point sz)
{
    std::string filename = MakeSVGFilename(prefix);
    Cairo::RefPtr<Cairo::SvgSurface> sur = Cairo::SvgSurface::create(filename, sz.x, sz.y);
    return Cairo::Context::create(sur);
}

#endif // #ifndef __MGUI_SDK_CAIRO_UTILS_H__

