/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.LipstikLookAndFeel;
import com.lipstikLF.theme.LipstikColorTheme;
import com.lipstikLF.util.LipstikBorderFactory;
import com.lipstikLF.util.LipstikGradients;
import com.lipstikLF.util.LipstikListenerFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public class LipstikInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    public LipstikInternalFrameTitlePane(JInternalFrame frame) {
        super(frame);
    }

    public JInternalFrame getFrame() {
        return this.frame;
    }

    public void paintComponent(Graphics g) {
        ColorUIResource buttonColor;
        Color fontColor;
        Color backColor;
        LipstikColorTheme theme = LipstikLookAndFeel.getMyCurrentTheme();
        if (this.frame.isSelected()) {
            backColor = UIManager.getColor("InternalFrame.activeTitleBackground");
            fontColor = UIManager.getColor("InternalFrame.activeTitleForeground");
            buttonColor = theme.getInternalButtonBackground();
        } else {
            backColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
            fontColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
            buttonColor = theme.getInternalButtonInactive();
        }
        LipstikGradients.drawGradient(g, backColor, null, 0, 0, this.getWidth(), this.getHeight(), true);
        if (!this.isPalette) {
            this.iconButton.setBackground(buttonColor);
            this.maxButton.setBackground(buttonColor);
            this.closeButton.setBackground(buttonColor);
            Icon frameIcon = this.frame.getFrameIcon();
            int frameIconWidth = 1;
            if (frameIcon != null) {
                frameIcon.paintIcon(this, g, 4, this.getHeight() / 2 - frameIcon.getIconHeight() / 2);
                frameIconWidth = frameIcon.getIconWidth();
            }
            g.setFont(UIManager.getFont("InternalFrame.font"));
            g.setColor(fontColor);
            FontMetrics fm = g.getFontMetrics();
            int yOffset = (this.getHeight() - fm.getHeight()) / 2 + fm.getAscent();
            int titleW = this.getWidth() - frameIconWidth - 10;
            if (this.frame.isClosable()) {
                titleW -= 17;
            }
            if (this.frame.isMaximizable()) {
                titleW -= 17;
            }
            if (this.frame.isIconifiable()) {
                titleW -= 17;
            }
            g.drawString(this.getTitle(this.frame.getTitle(), fm, titleW), 8 + frameIconWidth, yOffset);
        }
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected void createButtons() {
        LipstikBorderFactory.OptionalMatteBorder handyEmptyBorder = LipstikBorderFactory.getOptionalMatteBorder();
        MouseAdapter handler = LipstikListenerFactory.getFrameButtonMouseHandler();
        this.iconButton = new JButton();
        this.iconButton.setFocusPainted(false);
        this.iconButton.setFocusable(false);
        this.iconButton.setOpaque(true);
        this.iconButton.addActionListener(this.iconifyAction);
        this.iconButton.addMouseListener(handler);
        this.iconButton.setBorder(handyEmptyBorder);
        this.maxButton = new JButton();
        this.maxButton.setFocusPainted(false);
        this.maxButton.setFocusable(false);
        this.maxButton.setOpaque(true);
        this.maxButton.addActionListener(this.maximizeAction);
        this.maxButton.addMouseListener(handler);
        this.maxButton.setBorder(handyEmptyBorder);
        this.closeButton = new JButton();
        this.closeButton.setFocusPainted(false);
        this.closeButton.setFocusable(false);
        this.closeButton.setOpaque(true);
        this.closeButton.addActionListener(this.closeAction);
        this.closeButton.addMouseListener(handler);
        this.closeButton.setBorder(handyEmptyBorder);
        this.setButtonIcons();
    }

    public void setPalette(boolean b) {
        super.setPalette(b);
        if (b) {
            MouseAdapter handler = LipstikListenerFactory.getFrameButtonMouseHandler();
            this.maxButton.removeMouseListener(handler);
            this.iconButton.removeMouseListener(handler);
            this.closeButton.removeMouseListener(handler);
        }
    }

    class TitlePaneLayout
    implements LayoutManager {
        TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public Dimension minimumLayoutSize(Container c) {
            int height;
            int subtitle_w;
            int title_length;
            int width = 30;
            if (LipstikInternalFrameTitlePane.this.frame.isClosable()) {
                width += 12;
            }
            if (LipstikInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 12;
            }
            if (LipstikInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 12;
            }
            FontMetrics fm = LipstikInternalFrameTitlePane.this.getFontMetrics(UIManager.getFont("InternalFrame.font"));
            String frameTitle = LipstikInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = fm.stringWidth(String.valueOf(LipstikInternalFrameTitlePane.this.frame.getTitle().substring(0, 2)) + "...")) ? title_w : subtitle_w) : (width += title_w);
            if (LipstikInternalFrameTitlePane.this.isPalette) {
                height = LipstikInternalFrameTitlePane.this.paletteTitleHeight;
            } else {
                int fontHeight = fm.getHeight() + 2;
                int iconHeight = 0;
                Icon icon = LipstikInternalFrameTitlePane.this.frame.getFrameIcon();
                if (icon != null) {
                    iconHeight = Math.min(icon.getIconHeight(), 16);
                }
                height = Math.max(fontHeight, iconHeight);
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(Container c) {
            boolean leftToRight = c.getComponentOrientation().isLeftToRight();
            int w = LipstikInternalFrameTitlePane.this.getWidth();
            int x = leftToRight ? w : 0;
            int spacing = 3;
            int buttonHeight = 12;
            int buttonWidth = 12;
            int y = LipstikInternalFrameTitlePane.this.getHeight() / 2 - buttonHeight / 2;
            if (LipstikInternalFrameTitlePane.this.frame.isClosable()) {
                if (LipstikInternalFrameTitlePane.this.isPalette) {
                    LipstikInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -buttonWidth - 1 : 0, 0, buttonWidth, LipstikInternalFrameTitlePane.this.getHeight() - 1);
                } else {
                    LipstikInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
            if (LipstikInternalFrameTitlePane.this.frame.isMaximizable() && !LipstikInternalFrameTitlePane.this.isPalette) {
                LipstikInternalFrameTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (LipstikInternalFrameTitlePane.this.frame.isIconifiable() && !LipstikInternalFrameTitlePane.this.isPalette) {
                LipstikInternalFrameTitlePane.this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
        }
    }
}

