/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class LipstikSplitPaneContentBorder
implements Border {
    private Color fromColor;
    private Color toColor;
    private Color bg;
    private boolean drawBoundaryLine;

    public LipstikSplitPaneContentBorder() {
        this(null, null, null, false);
    }

    public LipstikSplitPaneContentBorder(boolean drawBoundaryLine) {
        this(null, null, null, drawBoundaryLine);
    }

    public LipstikSplitPaneContentBorder(Color bg, Color fromColor, Color toColor) {
        this(bg, fromColor, toColor, false);
    }

    public LipstikSplitPaneContentBorder(Color bg, Color fromColor, Color toColor, boolean drawBoundaryLine) {
        this.drawBoundaryLine = drawBoundaryLine;
        this.bg = bg != null ? bg : UIManager.getColor("Button.borderColor");
        this.fromColor = fromColor != null ? fromColor : UIManager.getColor("Button.borderColor");
        this.toColor = toColor != null ? toColor : UIManager.getColor("ScrollPane.background");
    }

    public Insets getBorderInsets(Component c) {
        int leftTop = this.drawBoundaryLine ? 1 : 0;
        int rightBottom = this.drawBoundaryLine ? 4 : 3;
        return new Insets(leftTop, leftTop, rightBottom, rightBottom);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.toColor);
        g.fillRect(x, y + height - 3, 3, 3);
        g.fillRect(x + width - 3, y, 3, 3);
        int i = 0;
        while (i < 3) {
            g.setColor(LipstikSplitPaneContentBorder.blendColors(this.fromColor, this.toColor, (double)(i + 2) / 4.0));
            g.drawLine(x + width - 3 + i, y + i + 1, x + width - 3 + i, y + height - 3 + i);
            g.drawLine(x + i + 1, y + height - 3 + i, x + width - 3 + i, y + height - 3 + i);
            ++i;
        }
        if (this.drawBoundaryLine) {
            g.setColor(this.bg);
            g.drawRect(x, y, x + width - 4, y + height - 4);
        }
    }

    private static Color blendColors(Color c1, Color c2, double factor) {
        if (c1 == null || c2 == null) {
            if (c1 != null) {
                return c1;
            }
            if (c2 != null) {
                return c2;
            }
            return Color.BLACK;
        }
        int r = (int)((double)c2.getRed() * factor + (double)c1.getRed() * (1.0 - factor));
        int g = (int)((double)c2.getGreen() * factor + (double)c1.getGreen() * (1.0 - factor));
        int b = (int)((double)c2.getBlue() * factor + (double)c1.getBlue() * (1.0 - factor));
        return new Color(r, g, b);
    }
}

