/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.delegate.LipstikDefaultTreeCellRenderer;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;

public final class LipstikTreeUI
extends BasicTreeUI {
    private boolean linesEnabled = true;
    private PropertyChangeListener lineStyleHandler;
    private static final String TREE_LINE_STYLE_KEY = "JTree.lineStyle";
    private static final String TREE_LINE_STYLE_NONE_VALUE = "None";
    private static BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 1.0f);

    public static ComponentUI createUI(JComponent c) {
        return new LipstikTreeUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateLineStyle(c.getClientProperty(TREE_LINE_STYLE_KEY));
        this.lineStyleHandler = new LineStyleHandler();
        c.addPropertyChangeListener(this.lineStyleHandler);
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.lineStyleHandler);
        super.uninstallUI(c);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new LipstikDefaultTreeCellRenderer();
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        if (this.linesEnabled) {
            this.drawDashedVerticalLine(g, x, top, bottom);
        }
    }

    protected void drawDashedVerticalLine(Graphics g, int x, int y1, int y2) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke s = g2d.getStroke();
        g2d.setStroke(stroke);
        g2d.drawLine(x, y1, x, y2);
        g2d.setStroke(s);
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        if (this.linesEnabled) {
            this.drawDashedHorizontalLine(g, y, left + 1, right);
        }
    }

    protected void drawDashedHorizontalLine(Graphics g, int y, int x1, int x2) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke s = g2d.getStroke();
        g2d.setStroke(stroke);
        g2d.drawLine(x1, y, x2, y);
        g2d.setStroke(s);
    }

    protected void drawCentered(Component c, Graphics graphics, Icon icon, int x, int y) {
        icon.paintIcon(c, graphics, x - icon.getIconWidth() / 2 - 1, y - icon.getIconHeight() / 2);
    }

    private void updateLineStyle(Object lineStyle) {
        this.linesEnabled = !TREE_LINE_STYLE_NONE_VALUE.equals(lineStyle);
    }

    private class LineStyleHandler
    implements PropertyChangeListener {
        private LineStyleHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            Object value = e.getNewValue();
            if (name.equals(LipstikTreeUI.TREE_LINE_STYLE_KEY)) {
                LipstikTreeUI.this.updateLineStyle(value);
            }
        }
    }
}

