#!/bin/sh
### BEGIN INIT INFO
# Provides:          minidlna
# Required-Start:    $network $local_fs $remote_fs
# Required-Stop:     $network $local_fs $remote_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start minidlna at boot time
# Description:       Manage the minidlna daemon, a DLNA/UPnP-AV media server.
### END INIT INFO

unset USER

# PATH should only include /usr/* if it runs after the mountnfs.sh script
PATH=/sbin:/usr/sbin:/bin:/usr/bin
DESC="DLNA/UPnP-AV media server"
NAME=minidlna
DAEMON=/usr/sbin/minidlnad
DAEMON_ARGS="-f /etc/minidlna/minidlna.conf"
PIDFILE=/var/run/minidlna/minidlna.pid
SCRIPTNAME=/etc/init.d/minidlna
DEFAULT=/etc/default/$NAME

# Exit if the package is not installed
[ -x $DAEMON ] || exit 0

# Read configuration variable file if it is present
[ -r $DEFAULT ] && . $DEFAULT

# Load the VERBOSE setting and other rcS variables
. /lib/init/vars.sh

# Do not start the daemon if NO_START is enabled in DEFAULT
if [ "$START_DAEMON" != "yes" ] && [ "$1" != "stop" ]; then
	log_warning_msg "$NAME: Not starting $DESC."
	log_warning_msg "$NAME: Disabled in $DEFAULT."
	exit 0
fi

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.0-6) to ensure that this file is present.
. /lib/lsb/init-functions

# Set the default configuration file
if [ -z $CONFIGFILE ]; then
	CONFIGFILE=/etc/minidlna.conf
fi

# Set the default log file
if [ -z $LOGFILE ]; then
	LOGFILE=/var/log/minidlna.log
fi

# Run as `minidlna' if USER is not specified or is `root'
if [ -z $USER ]; then
	USER=minidlna
fi

# If no group is specified, use USER
if [ -z $GROUP ]; then
	GROUP=$USER
fi

if [ ! -d /var/run/minidlna ]; then
	mkdir /var/run/minidlna
	chown $USER:$GROUP /var/run/minidlna
fi

DAEMON_ARGS="-f $CONFIGFILE -P $PIDFILE $DAEMON_OPTS"

#
# Function that starts the daemon/service
#
do_start()
{
	# Return
	#   0 if daemon has been started
	#   1 if daemon was already running
	#   2 if daemon could not be started
	touch $LOGFILE && chown $USER:$GROUP $LOGFILE || return 2

	start-stop-daemon --start --quiet --pidfile $PIDFILE \
		--chuid $USER:$GROUP --exec $DAEMON --test > /dev/null \
		|| return 1
	start-stop-daemon --start --quiet --pidfile $PIDFILE \
		--chuid $USER:$GROUP --exec $DAEMON -- \
		$DAEMON_ARGS \
		|| return 2
}

#
# Function that stops the daemon/service
#
do_stop()
{
	# Return
	#   0 if daemon has been stopped
	#   1 if daemon was already stopped
	#   2 if daemon could not be stopped
	#   other if a failure occurred
	start-stop-daemon --stop --quiet --retry=TERM/30/KILL/5 --pidfile $PIDFILE --name $NAME
	RETVAL="$?"
	[ "$RETVAL" = 2 ] && return 2
	# Wait for children to finish too if this is a daemon that forks
	# and if the daemon is only ever run from this initscript.
	start-stop-daemon --stop --quiet --oknodo --retry=0/30/KILL/5 --exec $DAEMON
	[ "$?" = 2 ] && return 2
	# Many daemons don't delete their pidfiles when they exit.
	rm -f $PIDFILE
	return "$RETVAL"
}

#
# Function that sends a SIGHUP to the daemon/service
#
do_reload() {
	start-stop-daemon --stop --signal 1 --quiet --pidfile $PIDFILE --name $NAME
	return 0
}

case "$1" in
  start)
    [ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC " "$NAME"
    do_start
    case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
  ;;
  stop)
	[ "$VERBOSE" != no ] && log_daemon_msg "Stopping $DESC" "$NAME"
	do_stop
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  status)
       status_of_proc -p "$PIDFILE" "$DAEMON" "$NAME" && exit 0 || exit $?
       ;;
  restart|force-reload)
	log_daemon_msg "Restarting $DESC" "$NAME"
	do_stop
	case "$?" in
	  0|1)
		if [ "$1" = "force-reload" ]; then
			# Rescan the collection
			DAEMON_ARGS="$DAEMON_ARGS -R"
		fi
		do_start
		case "$?" in
			0) log_end_msg 0 ;;
			1) log_end_msg 1 ;; # Old process is still running
			*) log_end_msg 1 ;; # Failed to start
		esac
		;;
	  *)
	  	# Failed to stop
		log_end_msg 1
		;;
	esac
	;;
  *)
	#echo "Usage: $SCRIPTNAME {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $SCRIPTNAME {start|stop|status|restart|force-reload}" >&2
	exit 3
	;;
esac

:
