#!/usr/bin/env python
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.3.5.1 on Thu Apr 21 12:10:56 2005

# Papagayo-NG, a lip-sync tool for use with several different animation suites
# Original Copyright (C) 2005 Mike Clifton
# Contact information at http://www.lostmarble.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import math, random
import PySide2.QtCore as QtCore
import PySide2.QtGui as QtGui
import PySide2.QtWidgets as QtWidgets
#from PySide2.QtWidgets import QtGui, QtCore, QtWidgets

from LipsyncDoc import *

fill_color = QtGui.QColor(162, 205, 242)
line_color = QtGui.QColor(30, 121, 198)
frame_col = QtGui.QColor(192, 192, 192)
frame_text_col = QtGui.QColor(64, 64, 64)
play_back_col = QtGui.QColor(255, 127, 127)
play_fore_col = QtGui.QColor(209, 102, 121)
play_outline_col = QtGui.QColor(128, 0, 0)
text_col = QtGui.QColor(64, 64, 64)
phrase_fill_col = QtGui.QColor(205, 242, 162)
phrase_outline_col = QtGui.QColor(121, 198, 30)
word_fill_col = QtGui.QColor(242, 205, 162)
word_outline_col = QtGui.QColor(198, 121, 30)
phoneme_fill_col = QtGui.QColor(231, 185, 210)
phoneme_outline_col = QtGui.QColor(173, 114, 146)
font = QtGui.QFont("Swiss", 6)

# default_sample_width = 2
# default_samples_per_frame = 4
default_sample_width = 4
default_samples_per_frame = 2


class SceneWithDrag(QtWidgets.QGraphicsScene):
    def dragEnterEvent(self, e):
        e.acceptProposedAction()

    def dropEvent(self, e):
        # find item at these coordinates
        item = self.itemAt(e.scenePos(), QtGui.QTransform())
        if item:
            if item.setAcceptDrops:
                # pass on event to item at the coordinates
                item.dropEvent(e)
                try:
                    item.dropEvent(e)
                except RuntimeError:
                    pass  # This will suppress a Runtime Error generated when dropping into a widget with no MyProxy

    def dragMoveEvent(self, e):
        e.acceptProposedAction()


class MovableButton(QtWidgets.QPushButton):
    def __init__(self, title, me, style, parent, parent_obj=None, phoneme_offset=None):
        super(MovableButton, self).__init__(title, None)
        self.me = me
        self.is_resizing = False
        self.hotspot = 0
        self.parent = parent
        self.parent_object = parent_obj
        self.left_edge = 0
        self.right_edge = 0
        self.left_most = 0
        self.right_most = 0
        self.phoneme_offset = phoneme_offset
        self.calc_edges()
        # self.setStyleSheet(f"background-color:rgb({phoneme_fill_col.red()},{phoneme_fill_col.green()},{phoneme_fill_col.blue()})")
        # self.background_string = "background-color:rgb({0},{1},{2});".format(phoneme_fill_col.red(),
        #                                                                      phoneme_fill_col.green(),
        #                                                                      phoneme_fill_col.blue())
        # self.background_string += "border:1px solid rgb({0},{1},{2});".format(phoneme_outline_col.red(),
        #                                                                       phoneme_outline_col.green(),
        #                                                                       phoneme_outline_col.blue())
        self.setStyleSheet(style)

    # def paintEvent(self, e):
    #     QtWidgets.QPushButton.paintEvent(self, e)
    #     painter = QtGui.QPainter(self)
    #     background_brush = QtGui.QBrush(QtGui.QColor(255, 0, 0, 64), QtCore.Qt.SolidPattern)
    #     pen = QtGui.QPen(QtGui.QColor(255, 255, 0, 255), 3, QtCore.Qt.DashDotLine, QtCore.Qt.RoundCap, QtCore.Qt.RoundJoin)
    #     painter.setPen(pen)
    #     rect = QtCore.QRectF(0, 0, self.width(), self.height())
    #     # rect = QtCore.QRectF(self.x(), self.y(), self.x()+self.width(), self.y()+self.height())
    #     painter.fillRect(rect, background_brush)

    def mouseMoveEvent(self, e):

        if e.buttons() != QtCore.Qt.LeftButton:
            return
        if ((e.pos().x() > self.width()-10) or self.is_resizing) and not self.me.is_phoneme:
            if e.pos().x() > self.parent.frame_width + 10:  # TODO: Is this even needed? Seems Useless.
                if e.pos().x() <= self.right_edge:
                    self.resize(e.pos().x(), self.height())
                    self.is_resizing = True

        else:
            mime_data = QtCore.QMimeData()
            drag = QtGui.QDrag(self)
            drag.setMimeData(mime_data)
            drag.setHotSpot(e.pos() - self.rect().topLeft())
            print("HotSpot:")
            print(drag.hotSpot())
            self.hotspot = drag.hotSpot().x()
            # PyQt5 and PySide use different function names here, likely a Qt4 vs Qt5 problem.
            try:
                exec("dropAction = drag.exec(QtCore.Qt.MoveAction)")  # Otherwise we can't catch it and it will crash...
            except (SyntaxError, AttributeError):
                dropAction = drag.start(QtCore.Qt.MoveAction)

    def mousePressEvent(self, e):
        # QtGui.QPushButton.mousePressEvent(self, e)
        if e.button() == QtCore.Qt.RightButton and "phonemes" in dir(self.me):
            # manually enter the pronunciation for this word
            dlg = PronunciationDialog(self, self.parent.doc.parent.phonemeset.set)
            dlg.word_label.setText(dlg.word_label.text() + ' ' + self.text())
            prev_phoneme_list = ""
            for p in self.me.phonemes:
                prev_phoneme_list += " " + p.text
            dlg.phoneme_ctrl.setText(prev_phoneme_list)
            if dlg.exec_():
                # Stupid workaround for the random crash, we add it here instead of in the draw routine.
                # If we did change the phonemes we delete here the existing ones from both lists
                for item in self.parent.scene().items():
                    try:
                        if item.widget().parent_object == self.me:
                            self.parent.scene().removeItem(item)
                    except AttributeError:
                        pass

                for item in self.parent.mov_widget_list:
                    if item.widget().parent_object == self.me:
                        self.parent.mov_widget_list.remove(item)

                self.me.phonemes = []
                for phoneme_count, p in enumerate(dlg.phoneme_ctrl.text().split()):
                    if len(p) == 0:
                        continue
                    phoneme = LipsyncPhoneme()
                    phoneme.text = p
                    phoneme.frame = self.me.end_frame
                    self.me.phonemes.append(phoneme)
                    # Here we add the new phonemes for this word to both lists
                    font_metrics = QtGui.QFontMetrics(font)
                    phoneme_col_string = "color: #000000; background-color:rgb({0},{1},{2});".format(
                        phoneme_fill_col.red(),
                        phoneme_fill_col.green(),
                        phoneme_fill_col.blue())
                    phoneme_col_string += "border:1px solid rgb({0},{1},{2});".format(phoneme_outline_col.red(),
                                                                                      phoneme_outline_col.green(),
                                                                                      phoneme_outline_col.blue())
                    text_width, text_height = font_metrics.width("Ojyg"), font_metrics.height() + 6

                    self.parent.mov_widget_list.append(self.parent.scene().addWidget(
                        MovableButton(phoneme.text, phoneme, phoneme_col_string, self.parent, self.me,
                                      phoneme_offset=phoneme_count % 2)))
                    # self.mov_widget_list.append(self.scene().addWidget(MovableButton(phoneme.text, phoneme, phoneme_col_string, self, word)))
                    # self.temp_phoneme = self.scene().addWidget(MovableButton(phoneme.text, phoneme, phoneme_col_string))
                    self.parent.mov_widget_list[-1].setGeometry(QtCore.QRect(phoneme.frame * self.parent.frame_width,
                                                                             self.height() - (
                                                                                     self.parent.horizontalScrollBar().height() + 10 + text_height + (
                                                                                     text_height * (
                                                                                     phoneme_count % 2))),
                                                                             self.parent.frame_width + 1,
                                                                             text_height))
                    self.parent.mov_widget_list[-1].setParent(self.parent)
                    self.parent.mov_widget_list[-1].setZValue(99)
                    # self.mov_widget_list[-1].parent_object = word # word seems to get gc'd and is then None
                    phoneme.top = self.parent.mov_widget_list[-1].y()
                    phoneme.bottom = self.parent.mov_widget_list[-1].y() + text_height
                    #

                self.parent_object.reposition_word(self.me)
                # This might be the culprit
                self.parent.first_update = False
                self.parent.update_drawing()
                # Works quite good in theory but it seems to crash randomly. Debugging did not help.
                # self.parent.set_document(self.parent.doc)
            else:
                print("No change!")

    def mouseReleaseEvent(self, e):
        print("Released")
        new_right_edge = round((self.x() + self.width()) / self.parent.frame_width) - 1
        self.calc_edges((-1, new_right_edge))
        if self.is_resizing:
            try:
                self.parent_object.reposition_word(self.me)
            except AttributeError:
                self.parent.doc.current_voice.reposition_phrase(self.me, self.me.end_frame)
        self.is_resizing = False
        self.parent.first_update = False
        self.parent.update_drawing()

    def __del__(self):
        try:
            self.deleteLater()
        except RuntimeError:
            pass

    def mouseDoubleClickEvent(self, e):
        if not self.me.is_phoneme:
            print("Double Click: ")
            print(self.text())
            start = self.me.start_frame / self.parent.doc.fps
            length = (self.me.end_frame - self.me.start_frame) / self.parent.doc.fps
            self.parent.doc.sound.play_segment(start, length)

    def calc_edges(self, new_coords = None):
        previous_one = None
        next_one = None
        parent = None

        for index, phrase in enumerate(self.parent.doc.current_voice.phrases):
            if self.me == phrase:
                #print("It's a phrase: " + phrase.text)
                #print(index)
                if index > 0:
                    previous_one = self.parent.doc.current_voice.phrases[index-1]
                try:
                    next_one = self.parent.doc.current_voice.phrases[index + 1]
                except IndexError:
                    pass
            else:
                for index1, word in enumerate(phrase.words):
                    if self.me == word:
                        #print("It's a word: " + word.text)
                        #print(index1)
                        parent = self.parent.doc.current_voice.phrases[index]
                        if index1 > 0:
                            previous_one = phrase.words[index1 - 1]
                        else:
                            if index > 0:
                                try:
                                    previous_one = self.parent.doc.current_voice.phrases[index-1].words[-1]
                                except IndexError:
                                    pass
                        try:
                            next_one = phrase.words[index1 + 1]
                        except IndexError:
                            try:
                                next_one = self.parent.doc.current_voice.phrases[index + 1].words[0]
                            except IndexError:
                                pass
                    else:
                        for index2, phoneme in enumerate(word.phonemes):
                            if self.me == phoneme:
                                #print("It's a phoneme: " + phoneme.text)
                                #print(index2)
                                parent = phrase.words[index1]
                                if index2 > 0:
                                    previous_one = word.phonemes[index2 - 1]
                                else:
                                    if index1 > 0:
                                        try:
                                            previous_one = phrase.words[index1 - 1].phonemes[-1]
                                        except IndexError:
                                            pass
                                try:
                                    next_one = word.phonemes[index2 + 1]
                                except IndexError:
                                    try:
                                        next_one = phrase.words[index1 + 1].phonemes[0]
                                    except IndexError:
                                        pass
        # if parent:
        #     print("Parent : " + parent.text)
        #     print(dir(parent))
        # if previous_one:
        #     print("Previous one: " + previous_one.text)
        #     print(dir(previous_one))
        # if next_one:
        #     print("Next one: " + next_one.text)
        #     print(dir(next_one))
        # We should now have the previous and next object and it's parent here.

        self.left_edge = 0
        self.right_edge = 0
        self.left_most = 0
        self.right_most = 0

        if previous_one:
            if previous_one.is_phoneme:
                self.left_edge = previous_one.frame * self.parent.frame_width
            else:
                self.left_edge = previous_one.end_frame * self.parent.frame_width
        if next_one:
            if next_one.is_phoneme:
                self.right_edge = next_one.frame * self.parent.frame_width
            else:
                self.right_edge = next_one.start_frame * self.parent.frame_width
        if parent:
            self.left_most = parent.start_frame * self.parent.frame_width
            self.right_most = parent.end_frame * self.parent.frame_width

        if self.right_edge == 0:
            self.right_edge = self.parent.scene().width()
        self.left_edge = max(self.left_edge, self.left_most) + (1 * self.parent.frame_width)
        if self.right_most:
            self.right_edge = min(self.right_edge, self.right_most) + (1 * self.parent.frame_width)

        # TODO: Some more testing is needed to see if dragging and resizing is correctly working

        real_new_x = int(round(self.pos().x() / (self.parent.sample_width * self.parent.samples_per_frame)))
        real_new_end = int(round(real_new_x + (self.width() / (self.parent.sample_width * self.parent.samples_per_frame))))
        left_frame_edge = real_new_x  # round(self.left_edge / self.parent.frame_width)
        right_frame_edge = real_new_end  # round(self.right_edge / self.parent.frame_width)
        if new_coords:
            if not self.me.is_phoneme:
                if new_coords[0] != -1:
                    old_diff = self.me.end_frame - self.me.start_frame
                    if True:  # (left_frame_edge < new_coords[0] < right_frame_edge) and (left_frame_edge < new_coords[0] + old_diff < right_frame_edge):
                        self.me.start_frame = new_coords[0]
                        self.me.end_frame = self.me.start_frame + old_diff
                if new_coords[1] != -1:
                    if True:  # left_frame_edge < new_coords[1] < right_frame_edge:
                        self.me.end_frame = new_coords[1]
            else:
                if new_coords[0] != -1:
                    if True:  # left_frame_edge < new_coords[0] < right_frame_edge:
                        self.me.frame = new_coords[0] -1
                #else:
                #    if True:  # left_frame_edge < new_coords[1] < right_frame_edge:
                #        self.me.frame = new_coords[1]


class WaveformView(QtWidgets.QGraphicsView):
    def __init__(self, parent=None):
        super(WaveformView, self).__init__(parent)
        self.setScene(SceneWithDrag(self))
        self.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
        self.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOn)

        self.setAcceptDrops(True)
        self.setMouseTracking(True)

        # Other initialization
        self.doc = None
        self.max_width = 1
        self.max_height = 1
        self.is_dragging = False
        self.basic_scrubbing = False
        self.cur_frame = 0
        self.old_frame = 0
        self.buffer = None
        self.clip_rect = None
        self.sample_width = default_sample_width
        self.samples_per_frame = default_samples_per_frame
        self.samples_per_sec = 24 * self.samples_per_frame
        self.frame_width = self.sample_width * self.samples_per_frame
        self.phrase_bottom = 16
        self.word_bottom = 32
        self.phoneme_top = 128
        self.did_resize = 0
        self.waveform_polygon = None
        self.wv_height = 1
        self.temp_phrase = None
        self.temp_word = None
        self.temp_phoneme = None
        self.draw_play_marker = False
        self.num_samples = 0
        self.amp = []
        self.temp_play_marker = None
        self.did_resize = False
        self.scroll_position = 0
        self.mov_widget_list = []
        self.first_update = True

    def dragEnterEvent(self, e):
        print("DragEnter!")
        e.accept()

    def dragMoveEvent(self, e):
        print("DragMove!")
        # TODO: If we construct the mov_widget_list better we can use that to find previous and next items.
        position = e.pos()
        new_x = e.pos().x() + self.horizontalScrollBar().value()
        print(e.pos())
        dropped_widget = e.source()
        if new_x < dropped_widget.left_edge:
            new_x = dropped_widget.left_edge
        if new_x + dropped_widget.width() > dropped_widget.right_edge:
            new_x = dropped_widget.right_edge - dropped_widget.width()
        rastered_x = int((round(new_x / self.frame_width)) * self.frame_width)
        dropped_widget.move(QtCore.QPoint(rastered_x, dropped_widget.y()))
        dropped_widget.calc_edges()
        e.accept()

    def dropMoveEvent(self, e):
        print("DropMove")
        e.source().calc_edges()
        return

    def dropEvent(self, e):
        new_x = e.pos().x() + self.horizontalScrollBar().value()
        dropped_widget = e.source()

        previous_one = None
        next_one = None
        parent = None

        # for index, phrase in enumerate(self.doc.current_voice.phrases):
        #     if dropped_widget.me == phrase:
        #         print("It's a phrase: " + phrase.text)
        #         if index > 0:
        #             previous_one = self.doc.current_voice.phrases[index - 1]
        #         try:
        #             next_one = self.doc.current_voice.phrases[index + 1]
        #         except IndexError:
        #             pass
        #         break
        #     else:
        #         parent = phrase
        #         for index1, word in enumerate(phrase.words):
        #             if dropped_widget.me == word:
        #                 print("It's a word: " + word.text)
        #                 if index1 > 0:
        #                     previous_one = phrase.words[index1 - 1]
        #                 try:
        #                     next_one = phrase.words[index1 + 1]
        #                 except IndexError:
        #                     pass
        #                 break
        #             else:
        #                 parent = word
        #                 for index2, phoneme in enumerate(word.phonemes):
        #                     if dropped_widget.me == phoneme:
        #                         print("It's a phoneme: " + phoneme.text)
        #                         if index2 > 0:
        #                             previous_one = word.phonemes[index2 - 1]
        #                         try:
        #                             next_one = word.phonemes[index2 + 1]
        #                         except IndexError:
        #                             pass
        #                         break
        # if parent:
        #     print("DParent : " + parent.text)
        # if previous_one:
        #     print("DPrevious one: " + previous_one.text)
        # if next_one:
        #     print("DNext one: " + next_one.text)
        # frame_pos = int((new_x - dropped_widget.hotspot) / self.frame_width)
        # frame_start = int(dropped_widget.pos().x() / self.frame_width)
        # frame_end = int((frame_start + dropped_widget.rect().width()) / self.frame_width)
        # new_pos = int(frame_pos * self.frame_width)
        # if parent:
        #     if frame_start >= parent.start_frame:
        #         if frame_end <= parent.end_frame:
        #             dropped_widget.move(QtCore.QPoint(new_pos, dropped_widget.y()))  # We keep the Y-Position
        #         else:
        #             dropped_widget.move(QtCore.QPoint(parent.end_frame * self.frame_width,
        #                                               dropped_widget.y()))  # We keep the Y-Position
        #     else:
        #         dropped_widget.move(QtCore.QPoint(parent.start_frame * self.frame_width, dropped_widget.y()))  # We keep the Y-Position
        # elif frame_start > 0 & frame_end < (self.scene().rect().width() / self.frame_width):
        #     dropped_widget.move(QtCore.QPoint(new_pos, dropped_widget.y()))  # We keep the Y-Position

        print("Dropped")
        print(dropped_widget.pos().x() / self.frame_width)
        e.source().calc_edges((round(dropped_widget.pos().x() / self.frame_width), round((dropped_widget.pos().x() + dropped_widget.width()) / self.frame_width)))

        # print(e.source())
        # print(e.pos())
        # if e.source().me.is_phoneme:
        #     print(e.source().me.frame)
        # else:
        #     print(e.source().me.start_frame)
        # print(e.source().pos().x() / self.frame_width)
        # # We need to change the original still in the list and not this.
        # e.source().me.start_frame = int(e.source().pos().x() / self.frame_width)

    def wheelEvent(self, event):
        self.scroll_position = self.horizontalScrollBar().value()+(event.delta()/1.2)
        self.horizontalScrollBar().setValue(self.scroll_position)

    def on_slider_change(self, value):
        self.scroll_position = value

    def resizeEvent(self, event):
        update_rect = self.scene().sceneRect()
        update_rect.setWidth(self.width())
        update_rect.setHeight(event.size().height())
        if self.doc:
            self.set_document(self.doc)
        self.fitInView(update_rect, QtCore.Qt.IgnoreAspectRatio)
        self.horizontalScrollBar().setValue(self.scroll_position)

    def do_idle(self):
        pass

    def OnMouseDown(self, event):
        # self.isDragging = False
        # self.dragChange = False
        # self.draggingEnd = -1  # which end of the object (beginning or end) are you dragging
        # self.selectedPhrase = None
        # self.selectedWord = None
        # self.selectedPhoneme = None
        # x, y = event.GetPosition()
        # x, y = self.CalcUnscrolledPosition(x, y)
        # self.scrubFrame = x / self.frameWidth
        # self.lastFrame = self.scrubFrame
        # self.dragStartFrame = self.scrubFrame
        # if (self.doc is not None) and (self.doc.sound is not None) and (not self.doc.sound.IsPlaying()):
        #     self.isDragging = True
        #     if self.doc.currentVoice is not None:
        #         # test to see if the user clicked on a phrase, word, or phoneme
        #         # first, find the phrase that was clicked on
        #         for phrase in self.doc.currentVoice.phrases:
        #             if (self.scrubFrame >= phrase.startFrame) and (self.scrubFrame < phrase.endFrame + 1):
        #                 self.selectedPhrase = phrase
        #         # next, find the word that was clicked on
        #         if self.selectedPhrase is not None:
        #             for word in self.selectedPhrase.words:
        #                 if (self.scrubFrame >= word.startFrame) and (self.scrubFrame < word.endFrame + 1):
        #                     self.selectedWord = word
        #         # finally, find the phoneme that was clicked on
        #         if self.selectedWord is not None:
        #             for phoneme in self.selectedWord.phonemes:
        #                 if (self.scrubFrame >= phoneme.frame) and (self.scrubFrame < phoneme.frame + 1):
        #                     self.selectedPhoneme = phoneme
        #
        #         self.parentPhrase = self.selectedPhrase
        #         self.parentWord = self.selectedWord
        #
        #         # now, test if the click was within the vertical range of one of these objects
        #         if ( (self.selectedPhrase is not None)
        #          and (y > self.selectedPhrase.top)
        #          and (y < self.selectedPhrase.bottom) ):
        #             self.selectedWord = None
        #             self.selectedPhoneme = None
        #             self.draggingEnd = 0  # beginning of phrase
        #             dist = self.scrubFrame - self.selectedPhrase.startFrame
        #             if (self.selectedPhrase.endFrame - self.scrubFrame) < dist:
        #                 self.draggingEnd = 1  # end of phrase
        #                 dist = self.selectedPhrase.endFrame - self.scrubFrame
        #             if ( (self.selectedPhrase.endFrame - self.selectedPhrase.startFrame > 1)
        #              and (math.fabs((self.selectedPhrase.endFrame + self.selectedPhrase.startFrame)/2 - self.scrubFrame) < dist) ):
        #                 self.draggingEnd = 2  # middle of phrase
        #         elif ( (self.selectedWord is not None)
        #            and (y > self.selectedWord.top)
        #            and (y < self.selectedWord.bottom) ):
        #             self.selectedPhrase = None
        #             self.selectedPhoneme = None
        #             self.draggingEnd = 0  # beginning of word
        #             dist = self.scrubFrame - self.selectedWord.startFrame
        #             if (self.selectedWord.endFrame - self.scrubFrame) < dist:
        #                 self.draggingEnd = 1  # end of word
        #                 dist = self.selectedWord.endFrame - self.scrubFrame
        #             if ( (self.selectedWord.endFrame - self.selectedWord.startFrame > 1)
        #              and (math.fabs((self.selectedWord.endFrame + self.selectedWord.startFrame)/2 - self.scrubFrame) < dist) ):
        #                 self.draggingEnd = 2  # middle of word
        #         elif ( (self.selectedPhoneme is not None)
        #            and (y > self.selectedPhoneme.top)
        #            and (y < self.selectedPhoneme.bottom) ):
        #             self.selectedPhrase = None
        #             self.selectedWord = None
        #             self.draggingEnd = 0
        #         else:
        #             self.selectedPhrase = None
        #             self.selectedWord = None
        #             self.selectedPhoneme = None
        #
        #     self.basicScrubbing = False
        #     if (self.selectedPhrase is None) and (self.selectedWord is None) and (self.selectedPhoneme is None):
        #         self.basicScrubbing = True
        #         self.oldFrame = 0
        #         self.doc.sound.PlaySegment(float(self.scrubFrame) / float(self.doc.fps), 15.0 / self.doc.fps, 1.0)
        #         self.mouthView.SetFrame(self.scrubFrame)
        #         self.UpdateDrawing(False)
        #     elif event.RightIsDown() and self.selectedWord:
        #         self.isDragging = False
        #         # manually enter the pronunciation for this word
        #         dlg = PronunciationDialog(self, self.doc.parent.phonemeset.set)
        #         dlg.wordLabel.SetLabel(dlg.wordLabel.GetLabel() + ' ' + self.selectedWord.text)
        #         phonemeString = ""
        #         for p in self.selectedWord.phonemes:
        #             phonemeString += p.text + ' '
        #         dlg.phonemeCtrl.SetValue(phonemeString.strip())
        #         if dlg.ShowModal() == wx.ID_OK:
        #             self.doc.dirty = True
        #             self.selectedWord.phonemes = []
        #             for p in dlg.phonemeCtrl.GetValue().split():
        #                 if len(p) == 0:
        #                     continue
        #                 phoneme = LipsyncPhoneme()
        #                 phoneme.text = p
        #                 self.selectedWord.phonemes.append(phoneme)
        #             self.parentPhrase.RepositionWord(self.selectedWord)
        #             self.UpdateDrawing()
        #         dlg.Destroy()
        #         self.isDragging = False
        #         self.draggingEnd = -1  # which end of the object (beginning or end) are you dragging
        #         self.selectedPhrase = None
        #         self.selectedWord = None
        #         self.selectedPhoneme = None
        #     elif event.LeftDClick():
        #         playSegment = False
        #         if self.selectedPhrase is not None:
        #             playSegment = True
        #             self.doc.sound.PlaySegment(float(self.selectedPhrase.startFrame) / float(self.doc.fps),
        #                                        float(
        #                                            self.selectedPhrase.endFrame - self.selectedPhrase.startFrame + 1) / self.doc.fps,
        #                                        1.0)
        #         elif self.selectedWord is not None:
        #             playSegment = True
        #             self.doc.sound.PlaySegment(float(self.selectedWord.startFrame) / float(self.doc.fps),
        #                                        float(
        #                                            self.selectedWord.endFrame - self.selectedWord.startFrame + 1) / self.doc.fps,
        #                                        1.0)
        #         elif self.selectedPhoneme is not None:
        #             playSegment = True
        #             self.doc.sound.PlaySegment(float(self.selectedPhoneme.frame) / float(self.doc.fps),
        #                                        1.0 / self.doc.fps,
        #                                        1.0)
        #         self.isDragging = False
        #         self.draggingEnd = -1  # which end of the object (beginning or end) are you dragging
        #         self.selectedPhrase = None
        #         self.selectedWord = None
        #         self.selectedPhoneme = None
        #         if playSegment:
        #             frame = -1
        #             while self.doc.sound.IsPlaying():
        #                 nextFrame = int(math.floor(self.doc.sound.CurrentTime() * self.doc.fps))
        #                 if frame != nextFrame:
        #                     frame = nextFrame
        #                     self.mouthView.SetFrame(frame)
        #                     # self.SetFrame(frame) # I'm not sure if it's good to display the playback marker during this operation or not
        #                     self.TheApp.Yield()
        #                 wx.MilliSleep(250.0 / self.doc.fps)
        # if event.RightIsDown():
        #     self.isDragging = False
        #     self.draggingEnd = -1  # which end of the object (beginning or end) are you dragging
        #     self.selectedPhrase = None
        #     self.selectedWord = None
        #     self.selectedPhoneme = None
        # if self.isDragging:
        #     self.CaptureMouse()
        pass

    def OnMouseUp(self, event):
        # if self.isDragging:
        #     self.ReleaseMouse()
        #     self.isDragging = False
        #     self.scrubFrame = -1
        #     self.draggingEnd = -1
        #     self.selectedPhrase = None
        #     self.selectedWord = None
        #     self.selectedPhoneme = None
        #     if (self.doc is not None) and (self.doc.sound is not None):
        #         while self.doc.sound.IsPlaying():
        #             pass  # don't redraw until the playback for the last frame is done
        # self.didresize = True
        pass

    def OnMouseWheel(self, event):
        # if self.doc is not None:
        #     if event.ControlDown():
        #         if event.GetWheelRotation() > 0:
        #             self.OnZoomIn(event)
        #         else:
        #             self.OnZoomOut(event)
        #     else:
        #         x = self.GetScrollPos(wx.HORIZONTAL)
        #         self.Scroll(x - (event.GetWheelRotation() / 10), 0)
        pass

    def OnMouseMove(self, event):
        # if self.isDragging:
        #     try:
        #         x, y = event.GetPositionTuple()
        #     except AttributeError:
        #         x, y = event.GetLogicalPosition(self.cdc)
        #     x, y = self.CalcUnscrolledPosition(x, y)
        #     frame = x / self.frameWidth
        #     if frame == self.dragStartFrame:
        #         return
        #     self.dragStartFrame = -1000  # kick it far out of the way
        #
        #     if self.selectedPhrase is not None:
        #         if self.draggingEnd == 0:
        #             if frame != self.selectedPhrase.startFrame:
        #                 self.dragChange = True
        #                 self.doc.dirty = True
        #                 self.selectedPhrase.startFrame = frame
        #                 if self.selectedPhrase.startFrame > self.selectedPhrase.endFrame - 1:
        #                     self.selectedPhrase.startFrame = self.selectedPhrase.endFrame - 1
        #                 self.doc.currentVoice.RepositionPhrase(self.selectedPhrase, self.doc.soundDuration - 1)
        #         elif self.draggingEnd == 1:
        #             if frame != self.selectedPhrase.endFrame:
        #                 self.dragChange = True
        #                 self.doc.dirty = True
        #                 self.selectedPhrase.endFrame = frame
        #                 if self.selectedPhrase.endFrame < self.selectedPhrase.startFrame + 1:
        #                     self.selectedPhrase.endFrame = self.selectedPhrase.startFrame + 1
        #                 self.doc.currentVoice.RepositionPhrase(self.selectedPhrase, self.doc.soundDuration - 1)
        #         elif self.draggingEnd == 2:
        #             if frame != self.lastFrame:
        #                 self.dragChange = True
        #                 self.doc.dirty = True
        #                 self.selectedPhrase.startFrame += frame - self.lastFrame
        #                 self.selectedPhrase.endFrame += frame - self.lastFrame
        #                 self.doc.currentVoice.RepositionPhrase(self.selectedPhrase, self.doc.soundDuration - 1)
        #     elif self.selectedWord is not None:
        #         if self.draggingEnd == 0:
        #             if frame != self.selectedWord.startFrame:
        #                 self.dragChange = True
        #                 self.doc.dirty = True
        #                 self.selectedWord.startFrame = frame
        #                 if self.selectedWord.startFrame > self.selectedWord.endFrame - 1:
        #                     self.selectedWord.startFrame = self.selectedWord.endFrame - 1
        #                 self.parentPhrase.RepositionWord(self.selectedWord)
        #         elif self.draggingEnd == 1:
        #             if frame != self.selectedWord.endFrame:
        #                 self.dragChange = True
        #                 self.doc.dirty = True
        #                 self.selectedWord.endFrame = frame
        #                 if self.selectedWord.endFrame < self.selectedWord.startFrame:
        #                     self.selectedWord.endFrame = self.selectedWord.startFrame + 1
        #                 self.parentPhrase.RepositionWord(self.selectedWord)
        #         elif self.draggingEnd == 2:
        #             if frame != self.lastFrame:
        #                 self.dragChange = True
        #                 self.doc.dirty = True
        #                 self.selectedWord.startFrame += frame - self.lastFrame
        #                 self.selectedWord.endFrame += frame - self.lastFrame
        #                 self.parentPhrase.RepositionWord(self.selectedWord)
        #     elif self.selectedPhoneme is not None:
        #         if self.draggingEnd == 0:
        #             if frame != self.selectedPhoneme.frame:
        #                 self.dragChange = True
        #                 self.doc.dirty = True
        #                 self.selectedPhoneme.frame = frame
        #                 self.parentWord.RepositionPhoneme(self.selectedPhoneme)
        #
        #     if (frame != self.scrubFrame) and (self.doc is not None) and (
        #                 self.doc.sound is not None):  # and (not self.doc.sound.IsPlaying()):
        #         self.oldFrame = self.scrubFrame
        #         self.scrubFrame = frame
        #         self.doc.sound.PlaySegment(float(self.scrubFrame) / float(self.doc.fps), 15.0 / self.doc.fps, 1.0)
        #         self.mouthView.SetFrame(self.scrubFrame)
        #         self.UpdateDrawing(not self.basicScrubbing)
        #         self.lastFrame = self.scrubFrame
        pass

    def set_frame(self, frame):
        self.centerOn(self.temp_play_marker)
        self.temp_play_marker.setPos(
            frame * self.frame_width, 0)
        # update_rect = QtCore.QRectF(self.main_window.waveform_view.temp_play_marker.x() - self.main_window.waveform_view.temp_play_marker.rect().width(),
        #                             self.main_window.waveform_view.temp_play_marker.y(),
        #                             self.main_window.waveform_view.temp_play_marker.rect().width() * 2,
        #                             self.main_window.waveform_view.temp_play_marker.rect().height())
        update_rect = self.scene().sceneRect()
        self.scene().update(update_rect)

    def set_document(self, doc):
        if (self.doc is None) and (doc is not None):
            self.sample_width = default_sample_width
            self.samples_per_frame = default_samples_per_frame
            self.samples_per_sec = doc.fps * self.samples_per_frame
            self.frame_width = self.sample_width * self.samples_per_frame
        self.doc = doc
        self.num_samples = 0
        self.amp = []
        self.max_width = 32
        self.max_height = 32
        if (self.doc is not None) and (self.doc.sound is not None):
            self.frame_width = self.sample_width * self.samples_per_frame
            duration = self.doc.sound.Duration()
            time = 0.0
            sample_dur = 1.0 / self.samples_per_sec
            max_amp = 0.0
            while time < duration:
                self.num_samples += 1
                amp = self.doc.sound.GetRMSAmplitude(time, sample_dur)
                self.amp.append(amp)
                if amp > max_amp:
                    max_amp = amp
                time += sample_dur
            # normalize amplitudes
            max_amp = 0.95 / max_amp
            for i in range(len(self.amp)):
                self.amp[i] *= max_amp
            self.max_width = (self.num_samples + 1) * self.sample_width
            self.wv_height = self.height() - self.horizontalScrollBar().height()
            self.max_height = self.wv_height
        elif self.doc is not None:
            self.max_width = self.doc.sound_duration * self.frame_width
            self.wv_height = self.height() - self.horizontalScrollBar().height()
            self.max_height = self.wv_height
        self.update_drawing()

    def update_drawing(self, redraw_all=True):
        self.draw()

    def drawForeground(self, painter, rect):
        # We might draw the play marker here instead.
        # if self.draw_play_marker:
        #     foreground_brush = QtGui.QBrush(play_fore_col, QtCore.Qt.SolidPattern)
        #     outline = QtGui.QPen(play_outline_col)
        #     painter.fillRect()
        pass

    def drawBackground(self, painter, rect):
        background_brush = QtGui.QBrush(QtGui.QColor(255, 255, 255), QtCore.Qt.SolidPattern)
        painter.fillRect(rect, background_brush)
        if self.doc is not None:
            pen = QtGui.QPen(frame_col)
            # pen.setWidth(5)
            painter.setPen(pen)
            painter.setFont(font)

            first_sample = 0
            last_sample = len(self.amp)
            self.wv_height = self.scene().height()  # - self.horizontalScrollBar().height()
            half_client_height = self.wv_height / 2
            font_metrics = QtGui.QFontMetrics(font)
            text_width, top_border = font_metrics.width("Ojyg"), font_metrics.height() * 2
            x = first_sample * self.sample_width
            frame = first_sample / self.samples_per_frame
            fps = int(round(self.doc.fps))
            sample = first_sample
            list_of_lines = []
            list_of_textmarkers = []
            for i in range(int(first_sample), int(last_sample)):
                if (i + 1) % self.samples_per_frame == 0:
                    frame_x = (frame + 1) * self.frame_width
                    if (self.frame_width > 2) or ((frame + 2) % fps == 0):
                        list_of_lines.append(QtCore.QLineF(frame_x, top_border, frame_x, self.wv_height))
                    # draw frame label
                    if (self.frame_width > 30) or ((int(frame) + 2) % 5 == 0):
                        list_of_lines.append(QtCore.QLineF(frame_x, 0, frame_x, top_border))
                        list_of_lines.append(QtCore.QLineF(frame_x + 1, 0, frame_x + 1, self.wv_height))
                        temp_rect = QtCore.QRectF(int(frame_x + 4), font_metrics.height() - 2, text_width, top_border)
                        # Positioning is a bit different in QT here
                        list_of_textmarkers.append((temp_rect, str(int(frame + 2))))
                x += self.sample_width
                sample += 1
                if sample % self.samples_per_frame == 0:
                    frame += 1
            painter.drawLines(list_of_lines)
            for text_marker in list_of_textmarkers:
                painter.drawText(text_marker[0], QtCore.Qt.AlignLeft, text_marker[1])

    def draw(self):
        print("Begin Drawing")
        self.draw_play_marker = False
        # TestWaveform
        print("before clear")
        if self.first_update:
            self.scene().clear()
            print("cleared")
        else:
            self.scene().removeItem(self.waveform_polygon)


        first_sample = 0
        last_sample = len(self.amp)
        self.wv_height = self.height()  # - self.horizontalScrollBar().height()
        half_client_height = self.wv_height / 2
        font_metrics = QtGui.QFontMetrics(font)
        text_width, top_border = font_metrics.width("Ojyg"), font_metrics.height() * 2
        x = first_sample * self.sample_width
        frame = first_sample / self.samples_per_frame
        fps = int(round(self.doc.fps))
        sample = first_sample
        last_height = -1
        last_half_height = 1
        amp = 0
        frame_rectangle_list = []
        frame_rectangle_polygon_upper = []
        frame_rectangle_polygon_lower = []
        for i in range(int(first_sample), int(last_sample)):
            height = round(self.wv_height * self.amp[i])
            half_height = height / 2
            if self.draw_play_marker and (frame == self.cur_frame):
                pass
            else:
                # frame_rectangle_list.append((x, half_client_height - half_height, self.sample_width+1, height))
                # self.scene().addRect(x, half_client_height - half_height, self.sample_width+1, height, line_color, fill_color)
                frame_rectangle_polygon_upper.append((x, half_client_height - half_height))
                frame_rectangle_polygon_upper.append((x + self.sample_width, half_client_height - half_height))
                frame_rectangle_polygon_lower.append((x, half_client_height + half_height))
                frame_rectangle_polygon_lower.append((x + self.sample_width, half_client_height + half_height))
            x += self.sample_width
            sample += 1
            if sample % self.samples_per_frame == 0:
                frame += 1
        frame_rectangle_polygon_lower.reverse()
        temp_polygon = QtGui.QPolygonF()
        for coordinates in (frame_rectangle_polygon_upper + frame_rectangle_polygon_lower):
            temp_polygon.append(QtCore.QPointF(coordinates[0], coordinates[1]))
        self.waveform_polygon = self.scene().addPolygon(temp_polygon, line_color, fill_color)
        self.waveform_polygon.setZValue(1)
        self.temp_phrase = None
        self.temp_word = None
        self.temp_phoneme = None
        phrase_col_string = "color: #000000; background-color:rgb({0},{1},{2});".format(phrase_fill_col.red(),
                                                                        phrase_fill_col.green(),
                                                                        phrase_fill_col.blue())
        phrase_col_string += "background-image: url(:/rsrc/marker.png); background-repeat: repeat-y; background-position: right;"
        phrase_col_string += "border:1px solid rgb({0},{1},{2});".format(phrase_outline_col.red(),
                                                                         phrase_outline_col.green(),
                                                                         phrase_outline_col.blue())

        word_col_string = "color: #000000; background-color:rgb({0},{1},{2});".format(word_fill_col.red(),
                                                                      word_fill_col.green(),
                                                                      word_fill_col.blue())
        word_col_string += "background-image: url(:/rsrc/marker.png); background-repeat: repeat-y; background-position: right;"

        word_col_string += "border:1px solid rgb({0},{1},{2});".format(word_outline_col.red(),
                                                                       word_outline_col.green(),
                                                                       word_outline_col.blue())
        phoneme_col_string = "color: #000000; background-color:rgb({0},{1},{2});".format(phoneme_fill_col.red(),
                                                                         phoneme_fill_col.green(),
                                                                         phoneme_fill_col.blue())
        phoneme_col_string += "border:1px solid rgb({0},{1},{2});".format(phoneme_outline_col.red(),
                                                                          phoneme_outline_col.green(),
                                                                          phoneme_outline_col.blue())
        text_width, text_height = font_metrics.width("Ojyg"), font_metrics.height() + 6
        if self.first_update:
            self.mov_widget_list = []
            if self.doc.current_voice is not None:
                top_border += 4

                # self.phrase_bottom = top_border + text_height
                # self.word_bottom = top_border + 4 + (text_height * 3)
                # self.phoneme_top = self.height() - 4 - (text_height * 2)
                # TODO: The appends are killing our performance, we should only need to do this once!
                for phrase in self.doc.current_voice.phrases:
                    self.mov_widget_list.append(self.scene().addWidget(MovableButton(phrase.text, phrase, phrase_col_string, self)))
                    #self.mov_widget_list.append(self.scene().addWidget(MovableButton(phrase.text, phrase, phrase_col_string, self)))

                    #self.temp_phrase = self.scene().addWidget(MovableButton(phrase.text, phrase, phrase_col_string))
                    self.mov_widget_list[-1].setGeometry(QtCore.QRect(phrase.start_frame * self.frame_width,
                                                         top_border,
                                                         (phrase.end_frame - phrase.start_frame + 1) * self.frame_width + 1,
                                                         text_height))
                    self.mov_widget_list[-1].setParent(self)
                    self.mov_widget_list[-1].setZValue(99)
                    phrase.top = self.mov_widget_list[-1].y()
                    phrase.bottom = self.mov_widget_list[-1].y() + text_height
                    word_count = 0
                    for word in phrase.words:
                        self.mov_widget_list.append(self.scene().addWidget(MovableButton(word.text, word, word_col_string, self, phrase)))
                        #self.mov_widget_list.append(self.scene().addWidget(MovableButton(word.text, word, word_col_string, self, phrase)))

                        self.mov_widget_list[-1].setGeometry(QtCore.QRect(word.start_frame * self.frame_width,
                                                                 top_border + 4 + text_height + (text_height * (word_count % 2)),
                                                                 (word.end_frame - word.start_frame + 1) * self.frame_width + 1,
                                                                 text_height))
                        self.mov_widget_list[-1].setParent(self)
                        self.mov_widget_list[-1].setZValue(99)
                        # self.mov_widget_list[-1].parent_object = phrase # phrase seems to get gc'd and is then None
                        word.top = self.mov_widget_list[-1].y()
                        word.bottom = self.mov_widget_list[-1].y() + text_height
                        word_count += 1
                        phoneme_count = 0
                        for phoneme in word.phonemes:
                            self.mov_widget_list.append(self.scene().addWidget(MovableButton(phoneme.text, phoneme, phoneme_col_string, self, word, phoneme_offset=phoneme_count % 2)))
                            #self.mov_widget_list.append(self.scene().addWidget(MovableButton(phoneme.text, phoneme, phoneme_col_string, self, word)))
                            #self.temp_phoneme = self.scene().addWidget(MovableButton(phoneme.text, phoneme, phoneme_col_string))
                            self.mov_widget_list[-1].setGeometry(QtCore.QRect(phoneme.frame * self.frame_width,
                                                                        self.height() - (self.horizontalScrollBar().height() + 10 + text_height + (text_height * (phoneme_count % 2))),
                                                                        self.frame_width + 1,
                                                                        text_height))
                            self.mov_widget_list[-1].setParent(self)
                            self.mov_widget_list[-1].setZValue(99)
                            # self.mov_widget_list[-1].parent_object = word # word seems to get gc'd and is then None
                            phoneme.top = self.mov_widget_list[-1].y()
                            phoneme.bottom = self.mov_widget_list[-1].y() + text_height
                            phoneme_count += 1
        else:
            for widget in self.mov_widget_list:

                if widget.widget().me.is_phoneme:
                    new_width = self.frame_width + 1
                    new_x = widget.widget().me.frame * self.frame_width
                    new_y = self.height() - (self.horizontalScrollBar().height() + 10 + text_height + (text_height * (widget.widget().phoneme_offset)))

                else:
                    new_width = (widget.widget().me.end_frame - widget.widget().me.start_frame + 1) * self.frame_width + 1
                    new_x = widget.widget().me.start_frame * self.frame_width
                    new_y = widget.widget().y()
                widget.setGeometry(QtCore.QRect(new_x, new_y, new_width, text_height))
                widget.setZValue(99)
        print("Playing, now drawing marker!")
        x = self.cur_frame * self.frame_width
        #     foreground_brush = QtGui.QBrush(play_fore_col, QtCore.Qt.SolidPattern)
        #     outline = QtGui.QPen(play_outline_col)
        self.temp_play_marker = self.scene().addRect(x,
                                                     0,
                                                     self.frame_width + 1,
                                                     self.height() - self.horizontalScrollBar().height(),
                                                     QtGui.QPen(play_outline_col),
                                                     QtGui.QBrush(play_fore_col, QtCore.Qt.SolidPattern))
        self.temp_play_marker.setZValue(1000)
        self.temp_play_marker.setOpacity(0.5)
        self.temp_play_marker.setVisible(False)
        if self.doc.sound.is_playing():
            self.temp_play_marker.setVisible(True)
        print("End Drawing")
        if self.first_update:
            self.first_update = False

    def on_zoom_in(self, event=None):
        if (self.doc is not None) and (self.samples_per_frame < 16):
            self.samples_per_frame *= 2
            self.samples_per_sec = self.doc.fps * self.samples_per_frame
            self.frame_width = self.sample_width * self.samples_per_frame
            self.set_document(self.doc)
            self.scroll_position *= 2
            self.horizontalScrollBar().setValue(self.scroll_position)

    def on_zoom_out(self, event=None):
        if (self.doc is not None) and (self.samples_per_frame > 1):
            self.samples_per_frame /= 2
            self.samples_per_sec = self.doc.fps * self.samples_per_frame
            self.frame_width = self.sample_width * self.samples_per_frame
            self.set_document(self.doc)
            self.scroll_position /= 2
            self.horizontalScrollBar().setValue(self.scroll_position)

    def on_zoom_reset(self, event=None):
        if self.doc is not None:
            self.scroll_position /= (self.samples_per_frame / default_samples_per_frame)
            self.sample_width = default_sample_width
            self.samples_per_frame = default_samples_per_frame
            self.samples_per_sec = self.doc.fps * self.samples_per_frame
            self.frame_width = self.sample_width * self.samples_per_frame
            self.set_document(self.doc)
            self.horizontalScrollBar().setValue(self.scroll_position)

# end of class WaveformView
