/*	Copyright (C) 2018-2024 Martin Guy <martinwguy@gmail.com>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* text.h: Declarations for text.c */

#ifndef TEXT_H
#define TEXT_H 1

typedef enum {
    LEFT, RIGHT, CENTER,
} alignment_t;

#define TOP LEFT
#define BOTTOM RIGHT

extern int text_width(const char *text);
extern int text_height(const char *text);
extern void draw_text(const char *text, int at_x, int at_y,
		      alignment_t alignment_x, alignment_t alignment_y);

#endif
