;; NOTE: Assertions have been generated by update_lit_checks.py --output=fuzz-exec and should not be edited.

;; RUN: wasm-opt %s -all --fuzz-exec-before -q -o /dev/null 2>&1 | filecheck %s

;; The elem is out of bounds, leading to a trap during initialization.
(assert_unlinkable
  (module
    (table $table 1 1 funcref)
    (elem $elem (i32.const 1) $foo)
    (func $foo)
  )
  "trap"
)

;; Now it is in bounds, with the elem offset reduced to 0.
(module
  (table $table 1 1 funcref)
  (elem $elem (i32.const 0) $foo)
  (func $foo)
)

;; The table begins with a function that returns zero. table.init will replace
;; it with one that returns 1.
(module
  (type $i (func (result i32)))

  (table $table 10 funcref)
  (elem $zero (i32.const 0) $zero)
  (elem $one $one)

  (func $call (export "call") (result i32)
    (call_indirect (type $i) (i32.const 0))
  )

  (func $init (export "init") (result i32)
    (table.init $table $one (i32.const 0) (i32.const 0) (i32.const 1))
    (call $call)
  )

  (func $zero (result i32)
    (i32.const 0)
  )

  (func $one (result i32)
    (i32.const 1)
  )
)

;; First we get 0, then 1.
(assert_return (invoke "call") (i32.const 0))
(assert_return (invoke "init") (i32.const 1))

