.TH mt-dds 1L 2.4 \" -*- nroff -*-
.\"----------
.SH NAME
.\"----------
mt-dds \- tool to control a dds device.
.\"----------
.SH SYNOPSIS
.\"----------
.B mt-dds
.BR comp-on | comp-off | comp-query | comp-log 
.PD 0
.PP
.B mt-dds
<
.BR tell | label
> [
.B -b \ #
]
.PD 1
.\"----------
.SH DESCRIPTION
.\"----------
.B mt-dds
controls the compression mode of dds tape devices (DAT).
.PP
.B mt-dds
may also report the current tape position in
absolute records (relative to begin of tape) in a format
that may be used later by 
.B dds2tar(1)
to access tar archives that are not the first file on tape.
.PP
The default device is
.IR /dev/tape ,
which may be overridden with the environment variable
.BR TAPE ,
which in turn may be overridden with the
.BI -f \ device
option. The device must be a character special file.
.\"----------
.SH OPTIONS
.\"----------
.SS DDS tape device control options

.TP
.B comp-on
Enable the hardware compression mode if supported by the device.
.TP 
.B comp-off
Disable the compression mode, switch to normal mode.
.TP 
.B comp-query
Print to stderr if compression mode currently is disabled 
or enabled.  A 
.B 0
means compression is disabled, a
.B 1
means compression in enabled.
.TP 
.B comp-log
Print to stdout four lines of information about transferred kilobytes 
before and after hardware compression from and to the device
since initialization.
.\"----------
.SS dds2tar service functions

.TP
.B tell
Print three lines with the 
.BR "current tape position" ", a" 
.B block size 
value (20 by default, may be overridden with 
.B -b
option) and a 
.B block length
value (blocksize*512) to 
.IR stdout .
If this output is redirected to a location file 
.IR locfile ,
this file may be used by 
.B dds2tar(1)
to access archives on tape.
.TP
.B label
If the current tape position is the beginning of an archive and the archive
is labeled,
.B mt-dds
writes the label to stdout
and moves the tape back to the
current position (or back over the filemark).
.TP
.B ts
If the current tape position is the beginning of an archive and the archive
is labeled,
.B mt-dds
writes the timestamp in octal format to stdout
and moves the tape back to the
current position (or back over the filemark).
If you are using only one computer, the timestamp can be used as a unique
archive identifier.
.TP
.BI -b \  #
Specify the block size 
.I #
value that is used as a default for the written value with the
.B mt-dds tell
command (see above).
Also the internal buffer size is specified with this option
which is used to read one block in order to get the block size
of the current tape block. So specify the block size of the archive
or a larger number.
.\"----------
.SS other options

.TP
.BI -f\  device
Device of the tape archive (default is /dev/tape).
Must be a character special file connected to a dds tape device.
.TP
.BR -V , --version
Print the version number of
.B mt-dds
to stderr and exit immediately.
.TP
.B --help
print some screens of online help with examples through a pager
and exit immediately.
.\"----------
.SH EXAMPLES
.\"----------
.B Example 1: 
checking the compression mode of the default tape device
.RS 10
mt-dds comp-query
.RE
.PP
.B Example 2: 
Write the location information as
.B dds2tar
command line options to stdout.
.RS 10
mt-dds
.RE
.PP
.PD 1
.\"----------
.SH ENVIRONMENT
.\"----------
The environment variable
.B TAPE
overrides the default tape device /dev/tape.
.TP
PAGER
The environment variable
.B PAGER
overrides the builtin pager command ("/bin/more") to display the output
of the
.B --help
option.
.\"----------
.SH "SEE ALSO"
.\"----------
dds2tar(1), dds2index(1), mt(1), tar(1)
.\"----------
.SH HISTORY
.\"----------
This program was created to use it in conjunction with dds2tar.
.\"----------
.SH AUTHOR
.\"----------
J"org Weule (weule@cs.uni-duesseldorf.de), Phone +49 211 751409.
This software is available at
ftp.uni-duesseldorf.de:/pub/unix/apollo

