.TH DCPOSN 1 "6 March 2014" "DICOM PS3" "DICOM PS3 - DICOM locate position"
.SH NAME
dcposn \- ACR/NEMA DICOM PS3 ... DICOM PS3 - DICOM locate position
.SH SYNOPSIS
.HP 10
.B dcposn
.so man1/gen.so
[
.B \-col|x n
]
[
.B \-row|y n
]
[
.B \-v|verbose
]
[
.B \-filename
]
.so man1/optin.so
.SH DESCRIPTION
.LP
.B dcposn
reads the named dicom input file and locates the requested image
pixel position in 3D space using the attributes of the Image Plane module
(Image Position Patient and Image Orientation Patient) if present.
.LP
The spatial position is described as patient (not gantry) relative
x, y and z co-ordinates, where x is +ve leftwards,
y is +ve anteriorly and
z is +ve cranially.
.SH OPTIONS
The co-ordinates and verbose output go to standard error.
.PP
The basic input switches are described in dcintro(1). Options specific to this program are:
.TP
.B \-col|x n \-row|y n
.RS
The specified image pixel position begins from 0 in the top left hand
corner of the image.
.RE
.TP
.B \-verbose
.RS
Display byte offset from file start and message start, in hexadecimal, and dump contents while reading and once read.
.RE
.TP
.B \-filename
.RS
Show the name of the file supplied in the arguments; a hyphen will be reported if no filename was supplied.
.RE
.SH ENVIRONMENT
.LP
\ 
.SH EXAMPLES
.LP
.RE
\ 
.RE
%dcposn -x 0 -y 0 expmeta.dc3
.RE
Row=0 Col=0   X=45.0 Y=-119.5 Z=119.5
.RE
.SH FILES
.LP
\ 
.SH SEE ALSO
.BR dcintro(1)
.SH AUTHOR
Copyright (c) 1993-2022, David A. Clunie DBA PixelMed Publishing. All rights reserved.
.SH BUGS
This program really only exists for automated testing of the image plane
module.
