// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file primitives_structTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "primitives_structTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "primitives_struct.hpp"


using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_PrimitivesStruct_type_identifier(
        TypeIdentifierPair& type_ids_PrimitivesStruct)
{

    ReturnCode_t return_code_PrimitivesStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_PrimitivesStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "PrimitivesStruct", type_ids_PrimitivesStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_PrimitivesStruct)
    {
        StructTypeFlag struct_flags_PrimitivesStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_PrimitivesStruct = "PrimitivesStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_PrimitivesStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_PrimitivesStruct;
        CompleteTypeDetail detail_PrimitivesStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_PrimitivesStruct, ann_custom_PrimitivesStruct, type_name_PrimitivesStruct.to_string());
        CompleteStructHeader header_PrimitivesStruct;
        header_PrimitivesStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_PrimitivesStruct);
        CompleteStructMemberSeq member_seq_PrimitivesStruct;
        {
            TypeIdentifierPair type_ids_my_bool;
            ReturnCode_t return_code_my_bool {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_bool =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_my_bool);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_bool)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_bool Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_bool = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_bool = 0x00000000;
            bool common_my_bool_ec {false};
            CommonStructMember common_my_bool {TypeObjectUtils::build_common_struct_member(member_id_my_bool, member_flags_my_bool, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_bool, common_my_bool_ec))};
            if (!common_my_bool_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_bool member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_bool = "my_bool";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_bool;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_bool = TypeObjectUtils::build_complete_member_detail(name_my_bool, member_ann_builtin_my_bool, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_bool = TypeObjectUtils::build_complete_struct_member(common_my_bool, detail_my_bool);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_bool);
        }
        {
            TypeIdentifierPair type_ids_my_octet;
            ReturnCode_t return_code_my_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_my_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_octet Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_octet = 0x00000001;
            bool common_my_octet_ec {false};
            CommonStructMember common_my_octet {TypeObjectUtils::build_common_struct_member(member_id_my_octet, member_flags_my_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_octet, common_my_octet_ec))};
            if (!common_my_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_octet = "my_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_octet;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_octet = TypeObjectUtils::build_complete_member_detail(name_my_octet, member_ann_builtin_my_octet, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_octet = TypeObjectUtils::build_complete_struct_member(common_my_octet, detail_my_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_octet);
        }
        {
            TypeIdentifierPair type_ids_my_char;
            ReturnCode_t return_code_my_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_my_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_char)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_char Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_char = 0x00000002;
            bool common_my_char_ec {false};
            CommonStructMember common_my_char {TypeObjectUtils::build_common_struct_member(member_id_my_char, member_flags_my_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_char, common_my_char_ec))};
            if (!common_my_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_char = "my_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_char;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_char = TypeObjectUtils::build_complete_member_detail(name_my_char, member_ann_builtin_my_char, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_char = TypeObjectUtils::build_complete_struct_member(common_my_char, detail_my_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_char);
        }
        {
            TypeIdentifierPair type_ids_my_wchar;
            ReturnCode_t return_code_my_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_my_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_wchar)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_wchar Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_wchar = 0x00000003;
            bool common_my_wchar_ec {false};
            CommonStructMember common_my_wchar {TypeObjectUtils::build_common_struct_member(member_id_my_wchar, member_flags_my_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_wchar, common_my_wchar_ec))};
            if (!common_my_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_wchar = "my_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_wchar;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_wchar = TypeObjectUtils::build_complete_member_detail(name_my_wchar, member_ann_builtin_my_wchar, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_wchar = TypeObjectUtils::build_complete_struct_member(common_my_wchar, detail_my_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_wchar);
        }
        {
            TypeIdentifierPair type_ids_my_long;
            ReturnCode_t return_code_my_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_my_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_long = 0x00000004;
            bool common_my_long_ec {false};
            CommonStructMember common_my_long {TypeObjectUtils::build_common_struct_member(member_id_my_long, member_flags_my_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_long, common_my_long_ec))};
            if (!common_my_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_long = "my_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_long;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_long = TypeObjectUtils::build_complete_member_detail(name_my_long, member_ann_builtin_my_long, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_long = TypeObjectUtils::build_complete_struct_member(common_my_long, detail_my_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_long);
        }
        {
            TypeIdentifierPair type_ids_my_ulong;
            ReturnCode_t return_code_my_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_my_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_ulong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_ulong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_ulong = 0x00000005;
            bool common_my_ulong_ec {false};
            CommonStructMember common_my_ulong {TypeObjectUtils::build_common_struct_member(member_id_my_ulong, member_flags_my_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_ulong, common_my_ulong_ec))};
            if (!common_my_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_ulong = "my_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_ulong;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_ulong = TypeObjectUtils::build_complete_member_detail(name_my_ulong, member_ann_builtin_my_ulong, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_ulong = TypeObjectUtils::build_complete_struct_member(common_my_ulong, detail_my_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_ulong);
        }
        {
            TypeIdentifierPair type_ids_my_int8;
            ReturnCode_t return_code_my_int8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_int8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int8_t", type_ids_my_int8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_int8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_int8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_int8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_int8 = 0x00000006;
            bool common_my_int8_ec {false};
            CommonStructMember common_my_int8 {TypeObjectUtils::build_common_struct_member(member_id_my_int8, member_flags_my_int8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_int8, common_my_int8_ec))};
            if (!common_my_int8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_int8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_int8 = "my_int8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_int8;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_int8 = TypeObjectUtils::build_complete_member_detail(name_my_int8, member_ann_builtin_my_int8, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_int8 = TypeObjectUtils::build_complete_struct_member(common_my_int8, detail_my_int8);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_int8);
        }
        {
            TypeIdentifierPair type_ids_my_uint8;
            ReturnCode_t return_code_my_uint8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_uint8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint8_t", type_ids_my_uint8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_uint8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_uint8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_uint8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_uint8 = 0x00000007;
            bool common_my_uint8_ec {false};
            CommonStructMember common_my_uint8 {TypeObjectUtils::build_common_struct_member(member_id_my_uint8, member_flags_my_uint8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_uint8, common_my_uint8_ec))};
            if (!common_my_uint8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_uint8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_uint8 = "my_uint8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_uint8;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_uint8 = TypeObjectUtils::build_complete_member_detail(name_my_uint8, member_ann_builtin_my_uint8, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_uint8 = TypeObjectUtils::build_complete_struct_member(common_my_uint8, detail_my_uint8);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_uint8);
        }
        {
            TypeIdentifierPair type_ids_my_short;
            ReturnCode_t return_code_my_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_my_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_short = 0x00000008;
            bool common_my_short_ec {false};
            CommonStructMember common_my_short {TypeObjectUtils::build_common_struct_member(member_id_my_short, member_flags_my_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_short, common_my_short_ec))};
            if (!common_my_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_short = "my_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_short;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_short = TypeObjectUtils::build_complete_member_detail(name_my_short, member_ann_builtin_my_short, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_short = TypeObjectUtils::build_complete_struct_member(common_my_short, detail_my_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_short);
        }
        {
            TypeIdentifierPair type_ids_my_ushort;
            ReturnCode_t return_code_my_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_my_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_ushort)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_ushort Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_ushort = 0x00000009;
            bool common_my_ushort_ec {false};
            CommonStructMember common_my_ushort {TypeObjectUtils::build_common_struct_member(member_id_my_ushort, member_flags_my_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_ushort, common_my_ushort_ec))};
            if (!common_my_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_ushort = "my_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_ushort;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_ushort = TypeObjectUtils::build_complete_member_detail(name_my_ushort, member_ann_builtin_my_ushort, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_ushort = TypeObjectUtils::build_complete_struct_member(common_my_ushort, detail_my_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_ushort);
        }
        {
            TypeIdentifierPair type_ids_my_longlong;
            ReturnCode_t return_code_my_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_my_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_longlong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_longlong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_longlong = 0x0000000a;
            bool common_my_longlong_ec {false};
            CommonStructMember common_my_longlong {TypeObjectUtils::build_common_struct_member(member_id_my_longlong, member_flags_my_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_longlong, common_my_longlong_ec))};
            if (!common_my_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_longlong = "my_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_longlong;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_longlong = TypeObjectUtils::build_complete_member_detail(name_my_longlong, member_ann_builtin_my_longlong, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_longlong = TypeObjectUtils::build_complete_struct_member(common_my_longlong, detail_my_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_longlong);
        }
        {
            TypeIdentifierPair type_ids_my_ulonglong;
            ReturnCode_t return_code_my_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_my_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_ulonglong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_ulonglong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_ulonglong = 0x0000000b;
            bool common_my_ulonglong_ec {false};
            CommonStructMember common_my_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_my_ulonglong, member_flags_my_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_ulonglong, common_my_ulonglong_ec))};
            if (!common_my_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_ulonglong = "my_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_ulonglong;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_ulonglong = TypeObjectUtils::build_complete_member_detail(name_my_ulonglong, member_ann_builtin_my_ulonglong, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_ulonglong = TypeObjectUtils::build_complete_struct_member(common_my_ulonglong, detail_my_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_ulonglong);
        }
        {
            TypeIdentifierPair type_ids_my_float;
            ReturnCode_t return_code_my_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_my_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_float)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_float Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_float = 0x0000000c;
            bool common_my_float_ec {false};
            CommonStructMember common_my_float {TypeObjectUtils::build_common_struct_member(member_id_my_float, member_flags_my_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_float, common_my_float_ec))};
            if (!common_my_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_float = "my_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_float;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_float = TypeObjectUtils::build_complete_member_detail(name_my_float, member_ann_builtin_my_float, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_float = TypeObjectUtils::build_complete_struct_member(common_my_float, detail_my_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_float);
        }
        {
            TypeIdentifierPair type_ids_my_double;
            ReturnCode_t return_code_my_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_my_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_double)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_double Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_double = 0x0000000d;
            bool common_my_double_ec {false};
            CommonStructMember common_my_double {TypeObjectUtils::build_common_struct_member(member_id_my_double, member_flags_my_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_double, common_my_double_ec))};
            if (!common_my_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_double = "my_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_double;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_double = TypeObjectUtils::build_complete_member_detail(name_my_double, member_ann_builtin_my_double, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_double = TypeObjectUtils::build_complete_struct_member(common_my_double, detail_my_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_double);
        }
        {
            TypeIdentifierPair type_ids_my_longdouble;
            ReturnCode_t return_code_my_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_my_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_longdouble)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_longdouble Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_longdouble = 0x0000000e;
            bool common_my_longdouble_ec {false};
            CommonStructMember common_my_longdouble {TypeObjectUtils::build_common_struct_member(member_id_my_longdouble, member_flags_my_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_longdouble, common_my_longdouble_ec))};
            if (!common_my_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_longdouble = "my_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_longdouble;
            ann_custom_PrimitivesStruct.reset();
            CompleteMemberDetail detail_my_longdouble = TypeObjectUtils::build_complete_member_detail(name_my_longdouble, member_ann_builtin_my_longdouble, ann_custom_PrimitivesStruct);
            CompleteStructMember member_my_longdouble = TypeObjectUtils::build_complete_struct_member(common_my_longdouble, detail_my_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_PrimitivesStruct, member_my_longdouble);
        }
        CompleteStructType struct_type_PrimitivesStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_PrimitivesStruct, header_PrimitivesStruct, member_seq_PrimitivesStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_PrimitivesStruct, type_name_PrimitivesStruct.to_string(), type_ids_PrimitivesStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "PrimitivesStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

