//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapimanagement_test

import (
	"context"
	"testing"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/internal/testutil"
	"github.com/stretchr/testify/suite"
)

type ApimportalrevisionsTestSuite struct {
	suite.Suite

	ctx               context.Context
	cred              azcore.TokenCredential
	options           *arm.ClientOptions
	portalRevisionId  string
	serviceName       string
	location          string
	resourceGroupName string
	subscriptionId    string
}

func (testsuite *ApimportalrevisionsTestSuite) SetupSuite() {
	testutil.StartRecording(testsuite.T(), "sdk/resourcemanager/apimanagement/armapimanagement/testdata")
	testsuite.ctx = context.Background()
	testsuite.cred, testsuite.options = testutil.GetCredAndClientOptions(testsuite.T())
	testsuite.portalRevisionId = testutil.GenerateAlphaNumericID(testsuite.T(), "portalrevi", 6)
	testsuite.serviceName = testutil.GenerateAlphaNumericID(testsuite.T(), "servicerevision", 6)
	testsuite.location = testutil.GetEnv("LOCATION", "westus")
	testsuite.resourceGroupName = testutil.GetEnv("RESOURCE_GROUP_NAME", "scenarioTestTempGroup")
	testsuite.subscriptionId = testutil.GetEnv("AZURE_SUBSCRIPTION_ID", "00000000-0000-0000-0000-000000000000")

	resourceGroup, _, err := testutil.CreateResourceGroup(testsuite.ctx, testsuite.subscriptionId, testsuite.cred, testsuite.options, testsuite.location)
	testsuite.Require().NoError(err)
	testsuite.resourceGroupName = *resourceGroup.Name
	testsuite.Prepare()
}

func (testsuite *ApimportalrevisionsTestSuite) TearDownSuite() {
	_, err := testutil.DeleteResourceGroup(testsuite.ctx, testsuite.subscriptionId, testsuite.cred, testsuite.options, testsuite.resourceGroupName)
	testsuite.Require().NoError(err)
	testutil.StopRecording(testsuite.T())
}

func TestApimportalrevisionsTestSuite(t *testing.T) {
	suite.Run(t, new(ApimportalrevisionsTestSuite))
}

func (testsuite *ApimportalrevisionsTestSuite) Prepare() {
	var err error
	// From step ApiManagementService_CreateOrUpdate
	serviceClient, err := armapimanagement.NewServiceClient(testsuite.subscriptionId, testsuite.cred, testsuite.options)
	testsuite.Require().NoError(err)
	serviceClientCreateOrUpdateResponsePoller, err := serviceClient.BeginCreateOrUpdate(testsuite.ctx, testsuite.resourceGroupName, testsuite.serviceName, armapimanagement.ServiceResource{
		Tags: map[string]*string{
			"Name": to.Ptr("Contoso"),
			"Test": to.Ptr("User"),
		},
		Location: to.Ptr(testsuite.location),
		Properties: &armapimanagement.ServiceProperties{
			PublisherEmail: to.Ptr("foo@contoso.com"),
			PublisherName:  to.Ptr("foo"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypeStandard),
			Capacity: to.Ptr[int32](1),
		},
	}, nil)
	testsuite.Require().NoError(err)
	_, err = testutil.PollForTest(testsuite.ctx, serviceClientCreateOrUpdateResponsePoller)
	testsuite.Require().NoError(err)
}

// Microsoft.ApiManagement/service/portalRevisions
func (testsuite *ApimportalrevisionsTestSuite) TestPortalrevision() {
	var err error
	// From step PortalRevision_CreateOrUpdate
	portalRevisionClient, err := armapimanagement.NewPortalRevisionClient(testsuite.subscriptionId, testsuite.cred, testsuite.options)
	testsuite.Require().NoError(err)
	portalRevisionClientCreateOrUpdateResponsePoller, err := portalRevisionClient.BeginCreateOrUpdate(testsuite.ctx, testsuite.resourceGroupName, testsuite.serviceName, testsuite.portalRevisionId, armapimanagement.PortalRevisionContract{
		Properties: &armapimanagement.PortalRevisionContractProperties{
			Description: to.Ptr("portal revision 1"),
			IsCurrent:   to.Ptr(true),
		},
	}, nil)
	testsuite.Require().NoError(err)
	_, err = testutil.PollForTest(testsuite.ctx, portalRevisionClientCreateOrUpdateResponsePoller)
	testsuite.Require().NoError(err)

	// From step PortalRevision_GetEntityTag
	_, err = portalRevisionClient.GetEntityTag(testsuite.ctx, testsuite.resourceGroupName, testsuite.serviceName, testsuite.portalRevisionId, nil)
	testsuite.Require().NoError(err)

	// From step PortalRevision_ListByService
	portalRevisionClientNewListByServicePager := portalRevisionClient.NewListByServicePager(testsuite.resourceGroupName, testsuite.serviceName, &armapimanagement.PortalRevisionClientListByServiceOptions{Filter: nil,
		Top:  nil,
		Skip: nil,
	})
	for portalRevisionClientNewListByServicePager.More() {
		_, err := portalRevisionClientNewListByServicePager.NextPage(testsuite.ctx)
		testsuite.Require().NoError(err)
		break
	}

	// From step PortalRevision_Get
	_, err = portalRevisionClient.Get(testsuite.ctx, testsuite.resourceGroupName, testsuite.serviceName, testsuite.portalRevisionId, nil)
	testsuite.Require().NoError(err)

	// From step PortalRevision_Update
	portalRevisionClientUpdateResponsePoller, err := portalRevisionClient.BeginUpdate(testsuite.ctx, testsuite.resourceGroupName, testsuite.serviceName, testsuite.portalRevisionId, "*", armapimanagement.PortalRevisionContract{
		Properties: &armapimanagement.PortalRevisionContractProperties{
			Description: to.Ptr("portal revision update"),
		},
	}, nil)
	testsuite.Require().NoError(err)
	_, err = testutil.PollForTest(testsuite.ctx, portalRevisionClientUpdateResponsePoller)
	testsuite.Require().NoError(err)
}
