// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the service network and VPC associations. You can filter the list either
// by VPC or service network. You must provide either the service network
// identifier or the VPC identifier.
func (c *Client) ListServiceNetworkVpcAssociations(ctx context.Context, params *ListServiceNetworkVpcAssociationsInput, optFns ...func(*Options)) (*ListServiceNetworkVpcAssociationsOutput, error) {
	if params == nil {
		params = &ListServiceNetworkVpcAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListServiceNetworkVpcAssociations", params, optFns, c.addOperationListServiceNetworkVpcAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListServiceNetworkVpcAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListServiceNetworkVpcAssociationsInput struct {

	// The maximum number of results to return.
	MaxResults *int32

	// A pagination token for the next page of results.
	NextToken *string

	// The ID or Amazon Resource Name (ARN) of the service network.
	ServiceNetworkIdentifier *string

	// The ID or Amazon Resource Name (ARN) of the VPC.
	VpcIdentifier *string

	noSmithyDocumentSerde
}

type ListServiceNetworkVpcAssociationsOutput struct {

	// Information about the associations.
	//
	// This member is required.
	Items []types.ServiceNetworkVpcAssociationSummary

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListServiceNetworkVpcAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListServiceNetworkVpcAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListServiceNetworkVpcAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListServiceNetworkVpcAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListServiceNetworkVpcAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListServiceNetworkVpcAssociationsAPIClient is a client that implements the
// ListServiceNetworkVpcAssociations operation.
type ListServiceNetworkVpcAssociationsAPIClient interface {
	ListServiceNetworkVpcAssociations(context.Context, *ListServiceNetworkVpcAssociationsInput, ...func(*Options)) (*ListServiceNetworkVpcAssociationsOutput, error)
}

var _ ListServiceNetworkVpcAssociationsAPIClient = (*Client)(nil)

// ListServiceNetworkVpcAssociationsPaginatorOptions is the paginator options for
// ListServiceNetworkVpcAssociations
type ListServiceNetworkVpcAssociationsPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListServiceNetworkVpcAssociationsPaginator is a paginator for
// ListServiceNetworkVpcAssociations
type ListServiceNetworkVpcAssociationsPaginator struct {
	options   ListServiceNetworkVpcAssociationsPaginatorOptions
	client    ListServiceNetworkVpcAssociationsAPIClient
	params    *ListServiceNetworkVpcAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListServiceNetworkVpcAssociationsPaginator returns a new
// ListServiceNetworkVpcAssociationsPaginator
func NewListServiceNetworkVpcAssociationsPaginator(client ListServiceNetworkVpcAssociationsAPIClient, params *ListServiceNetworkVpcAssociationsInput, optFns ...func(*ListServiceNetworkVpcAssociationsPaginatorOptions)) *ListServiceNetworkVpcAssociationsPaginator {
	if params == nil {
		params = &ListServiceNetworkVpcAssociationsInput{}
	}

	options := ListServiceNetworkVpcAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListServiceNetworkVpcAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListServiceNetworkVpcAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListServiceNetworkVpcAssociations page.
func (p *ListServiceNetworkVpcAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListServiceNetworkVpcAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListServiceNetworkVpcAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListServiceNetworkVpcAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListServiceNetworkVpcAssociations",
	}
}
