// Code generated by smithy-go-codegen DO NOT EDIT.

package redshift

import (
	"bytes"
	"context"
	"encoding/xml"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	awsxml "github.com/aws/aws-sdk-go-v2/aws/protocol/xml"
	"github.com/aws/aws-sdk-go-v2/service/redshift/types"
	smithy "github.com/aws/smithy-go"
	smithyxml "github.com/aws/smithy-go/encoding/xml"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"strconv"
	"strings"
	"time"
)

type awsAwsquery_deserializeOpAcceptReservedNodeExchange struct {
}

func (*awsAwsquery_deserializeOpAcceptReservedNodeExchange) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpAcceptReservedNodeExchange) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorAcceptReservedNodeExchange(response, &metadata)
	}
	output := &AcceptReservedNodeExchangeOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("AcceptReservedNodeExchangeResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentAcceptReservedNodeExchangeOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorAcceptReservedNodeExchange(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DependentServiceUnavailableFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response, errorBody)

	case strings.EqualFold("InvalidReservedNodeState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReservedNodeStateFault(response, errorBody)

	case strings.EqualFold("ReservedNodeAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ReservedNodeAlreadyMigrated", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeAlreadyMigratedFault(response, errorBody)

	case strings.EqualFold("ReservedNodeNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeNotFoundFault(response, errorBody)

	case strings.EqualFold("ReservedNodeOfferingNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeOfferingNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpAddPartner struct {
}

func (*awsAwsquery_deserializeOpAddPartner) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpAddPartner) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorAddPartner(response, &metadata)
	}
	output := &AddPartnerOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("AddPartnerResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentAddPartnerOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorAddPartner(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("PartnerNotFound", errorCode):
		return awsAwsquery_deserializeErrorPartnerNotFoundFault(response, errorBody)

	case strings.EqualFold("UnauthorizedPartnerIntegration", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedPartnerIntegrationFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpAssociateDataShareConsumer struct {
}

func (*awsAwsquery_deserializeOpAssociateDataShareConsumer) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpAssociateDataShareConsumer) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorAssociateDataShareConsumer(response, &metadata)
	}
	output := &AssociateDataShareConsumerOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("AssociateDataShareConsumerResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentAssociateDataShareConsumerOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorAssociateDataShareConsumer(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidDataShareFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidDataShareFault(response, errorBody)

	case strings.EqualFold("InvalidNamespaceFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidNamespaceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpAuthorizeClusterSecurityGroupIngress struct {
}

func (*awsAwsquery_deserializeOpAuthorizeClusterSecurityGroupIngress) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpAuthorizeClusterSecurityGroupIngress) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorAuthorizeClusterSecurityGroupIngress(response, &metadata)
	}
	output := &AuthorizeClusterSecurityGroupIngressOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("AuthorizeClusterSecurityGroupIngressResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentAuthorizeClusterSecurityGroupIngressOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorAuthorizeClusterSecurityGroupIngress(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("AuthorizationQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationQuotaExceededFault(response, errorBody)

	case strings.EqualFold("ClusterSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSecurityGroupStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpAuthorizeDataShare struct {
}

func (*awsAwsquery_deserializeOpAuthorizeDataShare) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpAuthorizeDataShare) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorAuthorizeDataShare(response, &metadata)
	}
	output := &AuthorizeDataShareOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("AuthorizeDataShareResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentAuthorizeDataShareOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorAuthorizeDataShare(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidDataShareFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidDataShareFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpAuthorizeEndpointAccess struct {
}

func (*awsAwsquery_deserializeOpAuthorizeEndpointAccess) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpAuthorizeEndpointAccess) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorAuthorizeEndpointAccess(response, &metadata)
	}
	output := &AuthorizeEndpointAccessOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("AuthorizeEndpointAccessResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentAuthorizeEndpointAccessOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorAuthorizeEndpointAccess(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("EndpointAuthorizationAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorEndpointAuthorizationAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("EndpointAuthorizationsPerClusterLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorEndpointAuthorizationsPerClusterLimitExceededFault(response, errorBody)

	case strings.EqualFold("InvalidAuthorizationState", errorCode):
		return awsAwsquery_deserializeErrorInvalidAuthorizationStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpAuthorizeSnapshotAccess struct {
}

func (*awsAwsquery_deserializeOpAuthorizeSnapshotAccess) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpAuthorizeSnapshotAccess) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorAuthorizeSnapshotAccess(response, &metadata)
	}
	output := &AuthorizeSnapshotAccessOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("AuthorizeSnapshotAccessResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentAuthorizeSnapshotAccessOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorAuthorizeSnapshotAccess(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("AuthorizationQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationQuotaExceededFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("DependentServiceRequestThrottlingFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceRequestThrottlingFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSnapshotState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSnapshotStateFault(response, errorBody)

	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpBatchDeleteClusterSnapshots struct {
}

func (*awsAwsquery_deserializeOpBatchDeleteClusterSnapshots) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpBatchDeleteClusterSnapshots) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorBatchDeleteClusterSnapshots(response, &metadata)
	}
	output := &BatchDeleteClusterSnapshotsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("BatchDeleteClusterSnapshotsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentBatchDeleteClusterSnapshotsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorBatchDeleteClusterSnapshots(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("BatchDeleteRequestSizeExceeded", errorCode):
		return awsAwsquery_deserializeErrorBatchDeleteRequestSizeExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpBatchModifyClusterSnapshots struct {
}

func (*awsAwsquery_deserializeOpBatchModifyClusterSnapshots) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpBatchModifyClusterSnapshots) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorBatchModifyClusterSnapshots(response, &metadata)
	}
	output := &BatchModifyClusterSnapshotsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("BatchModifyClusterSnapshotsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentBatchModifyClusterSnapshotsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorBatchModifyClusterSnapshots(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("BatchModifyClusterSnapshotsLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorBatchModifyClusterSnapshotsLimitExceededFault(response, errorBody)

	case strings.EqualFold("InvalidRetentionPeriodFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidRetentionPeriodFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCancelResize struct {
}

func (*awsAwsquery_deserializeOpCancelResize) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCancelResize) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCancelResize(response, &metadata)
	}
	output := &CancelResizeOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CancelResizeResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCancelResizeOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCancelResize(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("ResizeNotFound", errorCode):
		return awsAwsquery_deserializeErrorResizeNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCopyClusterSnapshot struct {
}

func (*awsAwsquery_deserializeOpCopyClusterSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCopyClusterSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCopyClusterSnapshot(response, &metadata)
	}
	output := &CopyClusterSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CopyClusterSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCopyClusterSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCopyClusterSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSnapshotState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSnapshotStateFault(response, errorBody)

	case strings.EqualFold("InvalidRetentionPeriodFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidRetentionPeriodFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateAuthenticationProfile struct {
}

func (*awsAwsquery_deserializeOpCreateAuthenticationProfile) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateAuthenticationProfile) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateAuthenticationProfile(response, &metadata)
	}
	output := &CreateAuthenticationProfileOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateAuthenticationProfileResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateAuthenticationProfileOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateAuthenticationProfile(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthenticationProfileAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorAuthenticationProfileAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("AuthenticationProfileQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorAuthenticationProfileQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidAuthenticationProfileRequestFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidAuthenticationProfileRequestFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateCluster struct {
}

func (*awsAwsquery_deserializeOpCreateCluster) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateCluster) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateCluster(response, &metadata)
	}
	output := &CreateClusterOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateClusterResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateClusterOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateCluster(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorClusterAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ClusterParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorClusterQuotaExceededFault(response, errorBody)

	case strings.EqualFold("ClusterSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorClusterSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("DependentServiceRequestThrottlingFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceRequestThrottlingFault(response, errorBody)

	case strings.EqualFold("HsmClientCertificateNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorHsmClientCertificateNotFoundFault(response, errorBody)

	case strings.EqualFold("HsmConfigurationNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorHsmConfigurationNotFoundFault(response, errorBody)

	case strings.EqualFold("InsufficientClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSubnetGroupStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSubnetGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterTrack", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterTrackFault(response, errorBody)

	case strings.EqualFold("InvalidElasticIpFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidElasticIpFault(response, errorBody)

	case strings.EqualFold("InvalidRetentionPeriodFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidRetentionPeriodFault(response, errorBody)

	case strings.EqualFold("InvalidSubnet", errorCode):
		return awsAwsquery_deserializeErrorInvalidSubnet(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("InvalidVPCNetworkStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidVPCNetworkStateFault(response, errorBody)

	case strings.EqualFold("Ipv6CidrBlockNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorIpv6CidrBlockNotFoundFault(response, errorBody)

	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("NumberOfNodesPerClusterLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorNumberOfNodesPerClusterLimitExceededFault(response, errorBody)

	case strings.EqualFold("NumberOfNodesQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorNumberOfNodesQuotaExceededFault(response, errorBody)

	case strings.EqualFold("RedshiftIdcApplicationNotExists", errorCode):
		return awsAwsquery_deserializeErrorRedshiftIdcApplicationNotExistsFault(response, errorBody)

	case strings.EqualFold("SnapshotScheduleNotFound", errorCode):
		return awsAwsquery_deserializeErrorSnapshotScheduleNotFoundFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateClusterParameterGroup struct {
}

func (*awsAwsquery_deserializeOpCreateClusterParameterGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateClusterParameterGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateClusterParameterGroup(response, &metadata)
	}
	output := &CreateClusterParameterGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateClusterParameterGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateClusterParameterGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateClusterParameterGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterParameterGroupAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorClusterParameterGroupAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ClusterParameterGroupQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorClusterParameterGroupQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateClusterSecurityGroup struct {
}

func (*awsAwsquery_deserializeOpCreateClusterSecurityGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateClusterSecurityGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateClusterSecurityGroup(response, &metadata)
	}
	output := &CreateClusterSecurityGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateClusterSecurityGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateClusterSecurityGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateClusterSecurityGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterSecurityGroupAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorClusterSecurityGroupAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("QuotaExceeded.ClusterSecurityGroup", errorCode):
		return awsAwsquery_deserializeErrorClusterSecurityGroupQuotaExceededFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateClusterSnapshot struct {
}

func (*awsAwsquery_deserializeOpCreateClusterSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateClusterSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateClusterSnapshot(response, &metadata)
	}
	output := &CreateClusterSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateClusterSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateClusterSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateClusterSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidRetentionPeriodFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidRetentionPeriodFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateClusterSubnetGroup struct {
}

func (*awsAwsquery_deserializeOpCreateClusterSubnetGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateClusterSubnetGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateClusterSubnetGroup(response, &metadata)
	}
	output := &CreateClusterSubnetGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateClusterSubnetGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateClusterSubnetGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateClusterSubnetGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterSubnetGroupAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorClusterSubnetGroupAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ClusterSubnetGroupQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorClusterSubnetGroupQuotaExceededFault(response, errorBody)

	case strings.EqualFold("ClusterSubnetQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorClusterSubnetQuotaExceededFault(response, errorBody)

	case strings.EqualFold("DependentServiceRequestThrottlingFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceRequestThrottlingFault(response, errorBody)

	case strings.EqualFold("InvalidSubnet", errorCode):
		return awsAwsquery_deserializeErrorInvalidSubnet(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateCustomDomainAssociation struct {
}

func (*awsAwsquery_deserializeOpCreateCustomDomainAssociation) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateCustomDomainAssociation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateCustomDomainAssociation(response, &metadata)
	}
	output := &CreateCustomDomainAssociationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateCustomDomainAssociationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateCustomDomainAssociationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateCustomDomainAssociation(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("CustomCnameAssociationFault", errorCode):
		return awsAwsquery_deserializeErrorCustomCnameAssociationFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateEndpointAccess struct {
}

func (*awsAwsquery_deserializeOpCreateEndpointAccess) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateEndpointAccess) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateEndpointAccess(response, &metadata)
	}
	output := &CreateEndpointAccessOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateEndpointAccessResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateEndpointAccessOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateEndpointAccess(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AccessToClusterDenied", errorCode):
		return awsAwsquery_deserializeErrorAccessToClusterDeniedFault(response, errorBody)

	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorClusterSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("EndpointAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorEndpointAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("EndpointsPerAuthorizationLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorEndpointsPerAuthorizationLimitExceededFault(response, errorBody)

	case strings.EqualFold("EndpointsPerClusterLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorEndpointsPerClusterLimitExceededFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSecurityGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateEventSubscription struct {
}

func (*awsAwsquery_deserializeOpCreateEventSubscription) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateEventSubscription) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateEventSubscription(response, &metadata)
	}
	output := &CreateEventSubscriptionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateEventSubscriptionResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateEventSubscriptionOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateEventSubscription(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("EventSubscriptionQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorEventSubscriptionQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("SNSInvalidTopic", errorCode):
		return awsAwsquery_deserializeErrorSNSInvalidTopicFault(response, errorBody)

	case strings.EqualFold("SNSNoAuthorization", errorCode):
		return awsAwsquery_deserializeErrorSNSNoAuthorizationFault(response, errorBody)

	case strings.EqualFold("SNSTopicArnNotFound", errorCode):
		return awsAwsquery_deserializeErrorSNSTopicArnNotFoundFault(response, errorBody)

	case strings.EqualFold("SourceNotFound", errorCode):
		return awsAwsquery_deserializeErrorSourceNotFoundFault(response, errorBody)

	case strings.EqualFold("SubscriptionAlreadyExist", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionAlreadyExistFault(response, errorBody)

	case strings.EqualFold("SubscriptionCategoryNotFound", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionCategoryNotFoundFault(response, errorBody)

	case strings.EqualFold("SubscriptionEventIdNotFound", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionEventIdNotFoundFault(response, errorBody)

	case strings.EqualFold("SubscriptionSeverityNotFound", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionSeverityNotFoundFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateHsmClientCertificate struct {
}

func (*awsAwsquery_deserializeOpCreateHsmClientCertificate) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateHsmClientCertificate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateHsmClientCertificate(response, &metadata)
	}
	output := &CreateHsmClientCertificateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateHsmClientCertificateResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateHsmClientCertificateOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateHsmClientCertificate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("HsmClientCertificateAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorHsmClientCertificateAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("HsmClientCertificateQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorHsmClientCertificateQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateHsmConfiguration struct {
}

func (*awsAwsquery_deserializeOpCreateHsmConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateHsmConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateHsmConfiguration(response, &metadata)
	}
	output := &CreateHsmConfigurationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateHsmConfigurationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateHsmConfigurationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateHsmConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("HsmConfigurationAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorHsmConfigurationAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("HsmConfigurationQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorHsmConfigurationQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateRedshiftIdcApplication struct {
}

func (*awsAwsquery_deserializeOpCreateRedshiftIdcApplication) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateRedshiftIdcApplication) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateRedshiftIdcApplication(response, &metadata)
	}
	output := &CreateRedshiftIdcApplicationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateRedshiftIdcApplicationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateRedshiftIdcApplicationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateRedshiftIdcApplication(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DependentServiceAccessDenied", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceAccessDeniedFault(response, errorBody)

	case strings.EqualFold("DependentServiceUnavailableFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response, errorBody)

	case strings.EqualFold("RedshiftIdcApplicationAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorRedshiftIdcApplicationAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("RedshiftIdcApplicationQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorRedshiftIdcApplicationQuotaExceededFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateScheduledAction struct {
}

func (*awsAwsquery_deserializeOpCreateScheduledAction) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateScheduledAction) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateScheduledAction(response, &metadata)
	}
	output := &CreateScheduledActionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateScheduledActionResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateScheduledActionOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateScheduledAction(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidSchedule", errorCode):
		return awsAwsquery_deserializeErrorInvalidScheduleFault(response, errorBody)

	case strings.EqualFold("InvalidScheduledAction", errorCode):
		return awsAwsquery_deserializeErrorInvalidScheduledActionFault(response, errorBody)

	case strings.EqualFold("ScheduledActionAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorScheduledActionAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ScheduledActionQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorScheduledActionQuotaExceededFault(response, errorBody)

	case strings.EqualFold("ScheduledActionTypeUnsupported", errorCode):
		return awsAwsquery_deserializeErrorScheduledActionTypeUnsupportedFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateSnapshotCopyGrant struct {
}

func (*awsAwsquery_deserializeOpCreateSnapshotCopyGrant) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateSnapshotCopyGrant) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateSnapshotCopyGrant(response, &metadata)
	}
	output := &CreateSnapshotCopyGrantOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateSnapshotCopyGrantResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateSnapshotCopyGrantOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateSnapshotCopyGrant(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DependentServiceRequestThrottlingFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceRequestThrottlingFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("SnapshotCopyGrantAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotCopyGrantAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("SnapshotCopyGrantQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotCopyGrantQuotaExceededFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateSnapshotSchedule struct {
}

func (*awsAwsquery_deserializeOpCreateSnapshotSchedule) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateSnapshotSchedule) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateSnapshotSchedule(response, &metadata)
	}
	output := &CreateSnapshotScheduleOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateSnapshotScheduleResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateSnapshotScheduleOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateSnapshotSchedule(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidSchedule", errorCode):
		return awsAwsquery_deserializeErrorInvalidScheduleFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("ScheduleDefinitionTypeUnsupported", errorCode):
		return awsAwsquery_deserializeErrorScheduleDefinitionTypeUnsupportedFault(response, errorBody)

	case strings.EqualFold("SnapshotScheduleAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorSnapshotScheduleAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("SnapshotScheduleQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorSnapshotScheduleQuotaExceededFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateTags struct {
}

func (*awsAwsquery_deserializeOpCreateTags) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateTags) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateTags(response, &metadata)
	}
	output := &CreateTagsOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateTags(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("ResourceNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateUsageLimit struct {
}

func (*awsAwsquery_deserializeOpCreateUsageLimit) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateUsageLimit) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateUsageLimit(response, &metadata)
	}
	output := &CreateUsageLimitOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateUsageLimitResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateUsageLimitOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateUsageLimit(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidUsageLimit", errorCode):
		return awsAwsquery_deserializeErrorInvalidUsageLimitFault(response, errorBody)

	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	case strings.EqualFold("UsageLimitAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorUsageLimitAlreadyExistsFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeauthorizeDataShare struct {
}

func (*awsAwsquery_deserializeOpDeauthorizeDataShare) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeauthorizeDataShare) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeauthorizeDataShare(response, &metadata)
	}
	output := &DeauthorizeDataShareOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeauthorizeDataShareResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeauthorizeDataShareOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeauthorizeDataShare(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidDataShareFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidDataShareFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteAuthenticationProfile struct {
}

func (*awsAwsquery_deserializeOpDeleteAuthenticationProfile) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteAuthenticationProfile) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteAuthenticationProfile(response, &metadata)
	}
	output := &DeleteAuthenticationProfileOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteAuthenticationProfileResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteAuthenticationProfileOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteAuthenticationProfile(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthenticationProfileNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorAuthenticationProfileNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidAuthenticationProfileRequestFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidAuthenticationProfileRequestFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteCluster struct {
}

func (*awsAwsquery_deserializeOpDeleteCluster) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteCluster) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteCluster(response, &metadata)
	}
	output := &DeleteClusterOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteClusterResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteClusterOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteCluster(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidRetentionPeriodFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidRetentionPeriodFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteClusterParameterGroup struct {
}

func (*awsAwsquery_deserializeOpDeleteClusterParameterGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteClusterParameterGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteClusterParameterGroup(response, &metadata)
	}
	output := &DeleteClusterParameterGroupOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteClusterParameterGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterParameterGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterParameterGroupStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteClusterSecurityGroup struct {
}

func (*awsAwsquery_deserializeOpDeleteClusterSecurityGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteClusterSecurityGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteClusterSecurityGroup(response, &metadata)
	}
	output := &DeleteClusterSecurityGroupOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteClusterSecurityGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSecurityGroupStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteClusterSnapshot struct {
}

func (*awsAwsquery_deserializeOpDeleteClusterSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteClusterSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteClusterSnapshot(response, &metadata)
	}
	output := &DeleteClusterSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteClusterSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteClusterSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteClusterSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterSnapshotNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSnapshotState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSnapshotStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteClusterSubnetGroup struct {
}

func (*awsAwsquery_deserializeOpDeleteClusterSubnetGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteClusterSubnetGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteClusterSubnetGroup(response, &metadata)
	}
	output := &DeleteClusterSubnetGroupOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteClusterSubnetGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorClusterSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSubnetGroupStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSubnetGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSubnetStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSubnetStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteCustomDomainAssociation struct {
}

func (*awsAwsquery_deserializeOpDeleteCustomDomainAssociation) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteCustomDomainAssociation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteCustomDomainAssociation(response, &metadata)
	}
	output := &DeleteCustomDomainAssociationOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteCustomDomainAssociation(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("CustomCnameAssociationFault", errorCode):
		return awsAwsquery_deserializeErrorCustomCnameAssociationFault(response, errorBody)

	case strings.EqualFold("CustomDomainAssociationNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorCustomDomainAssociationNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteEndpointAccess struct {
}

func (*awsAwsquery_deserializeOpDeleteEndpointAccess) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteEndpointAccess) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteEndpointAccess(response, &metadata)
	}
	output := &DeleteEndpointAccessOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteEndpointAccessResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteEndpointAccessOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteEndpointAccess(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("EndpointNotFound", errorCode):
		return awsAwsquery_deserializeErrorEndpointNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSecurityGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidEndpointState", errorCode):
		return awsAwsquery_deserializeErrorInvalidEndpointStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteEventSubscription struct {
}

func (*awsAwsquery_deserializeOpDeleteEventSubscription) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteEventSubscription) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteEventSubscription(response, &metadata)
	}
	output := &DeleteEventSubscriptionOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteEventSubscription(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidSubscriptionStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidSubscriptionStateFault(response, errorBody)

	case strings.EqualFold("SubscriptionNotFound", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteHsmClientCertificate struct {
}

func (*awsAwsquery_deserializeOpDeleteHsmClientCertificate) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteHsmClientCertificate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteHsmClientCertificate(response, &metadata)
	}
	output := &DeleteHsmClientCertificateOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteHsmClientCertificate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("HsmClientCertificateNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorHsmClientCertificateNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidHsmClientCertificateStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidHsmClientCertificateStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteHsmConfiguration struct {
}

func (*awsAwsquery_deserializeOpDeleteHsmConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteHsmConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteHsmConfiguration(response, &metadata)
	}
	output := &DeleteHsmConfigurationOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteHsmConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("HsmConfigurationNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorHsmConfigurationNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidHsmConfigurationStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidHsmConfigurationStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeletePartner struct {
}

func (*awsAwsquery_deserializeOpDeletePartner) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeletePartner) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeletePartner(response, &metadata)
	}
	output := &DeletePartnerOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeletePartnerResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeletePartnerOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeletePartner(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("PartnerNotFound", errorCode):
		return awsAwsquery_deserializeErrorPartnerNotFoundFault(response, errorBody)

	case strings.EqualFold("UnauthorizedPartnerIntegration", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedPartnerIntegrationFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteRedshiftIdcApplication struct {
}

func (*awsAwsquery_deserializeOpDeleteRedshiftIdcApplication) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteRedshiftIdcApplication) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteRedshiftIdcApplication(response, &metadata)
	}
	output := &DeleteRedshiftIdcApplicationOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteRedshiftIdcApplication(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DependentServiceAccessDenied", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceAccessDeniedFault(response, errorBody)

	case strings.EqualFold("DependentServiceUnavailableFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response, errorBody)

	case strings.EqualFold("RedshiftIdcApplicationNotExists", errorCode):
		return awsAwsquery_deserializeErrorRedshiftIdcApplicationNotExistsFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteResourcePolicy struct {
}

func (*awsAwsquery_deserializeOpDeleteResourcePolicy) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteResourcePolicy) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteResourcePolicy(response, &metadata)
	}
	output := &DeleteResourcePolicyOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteResourcePolicy(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ResourceNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteScheduledAction struct {
}

func (*awsAwsquery_deserializeOpDeleteScheduledAction) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteScheduledAction) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteScheduledAction(response, &metadata)
	}
	output := &DeleteScheduledActionOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteScheduledAction(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ScheduledActionNotFound", errorCode):
		return awsAwsquery_deserializeErrorScheduledActionNotFoundFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteSnapshotCopyGrant struct {
}

func (*awsAwsquery_deserializeOpDeleteSnapshotCopyGrant) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteSnapshotCopyGrant) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteSnapshotCopyGrant(response, &metadata)
	}
	output := &DeleteSnapshotCopyGrantOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteSnapshotCopyGrant(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidSnapshotCopyGrantStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidSnapshotCopyGrantStateFault(response, errorBody)

	case strings.EqualFold("SnapshotCopyGrantNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotCopyGrantNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteSnapshotSchedule struct {
}

func (*awsAwsquery_deserializeOpDeleteSnapshotSchedule) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteSnapshotSchedule) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteSnapshotSchedule(response, &metadata)
	}
	output := &DeleteSnapshotScheduleOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteSnapshotSchedule(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidClusterSnapshotScheduleState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSnapshotScheduleStateFault(response, errorBody)

	case strings.EqualFold("SnapshotScheduleNotFound", errorCode):
		return awsAwsquery_deserializeErrorSnapshotScheduleNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteTags struct {
}

func (*awsAwsquery_deserializeOpDeleteTags) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteTags) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteTags(response, &metadata)
	}
	output := &DeleteTagsOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteTags(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("ResourceNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteUsageLimit struct {
}

func (*awsAwsquery_deserializeOpDeleteUsageLimit) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteUsageLimit) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteUsageLimit(response, &metadata)
	}
	output := &DeleteUsageLimitOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteUsageLimit(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	case strings.EqualFold("UsageLimitNotFound", errorCode):
		return awsAwsquery_deserializeErrorUsageLimitNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeAccountAttributes struct {
}

func (*awsAwsquery_deserializeOpDescribeAccountAttributes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeAccountAttributes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeAccountAttributes(response, &metadata)
	}
	output := &DescribeAccountAttributesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeAccountAttributesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeAccountAttributesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeAccountAttributes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeAuthenticationProfiles struct {
}

func (*awsAwsquery_deserializeOpDescribeAuthenticationProfiles) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeAuthenticationProfiles) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeAuthenticationProfiles(response, &metadata)
	}
	output := &DescribeAuthenticationProfilesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeAuthenticationProfilesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeAuthenticationProfilesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeAuthenticationProfiles(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthenticationProfileNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorAuthenticationProfileNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidAuthenticationProfileRequestFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidAuthenticationProfileRequestFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeClusterDbRevisions struct {
}

func (*awsAwsquery_deserializeOpDescribeClusterDbRevisions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeClusterDbRevisions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeClusterDbRevisions(response, &metadata)
	}
	output := &DescribeClusterDbRevisionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeClusterDbRevisionsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeClusterDbRevisionsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeClusterDbRevisions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeClusterParameterGroups struct {
}

func (*awsAwsquery_deserializeOpDescribeClusterParameterGroups) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeClusterParameterGroups) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeClusterParameterGroups(response, &metadata)
	}
	output := &DescribeClusterParameterGroupsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeClusterParameterGroupsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeClusterParameterGroupsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeClusterParameterGroups(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeClusterParameters struct {
}

func (*awsAwsquery_deserializeOpDescribeClusterParameters) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeClusterParameters) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeClusterParameters(response, &metadata)
	}
	output := &DescribeClusterParametersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeClusterParametersResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeClusterParametersOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeClusterParameters(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterParameterGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeClusters struct {
}

func (*awsAwsquery_deserializeOpDescribeClusters) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeClusters) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeClusters(response, &metadata)
	}
	output := &DescribeClustersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeClustersResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeClustersOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeClusters(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeClusterSecurityGroups struct {
}

func (*awsAwsquery_deserializeOpDescribeClusterSecurityGroups) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeClusterSecurityGroups) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeClusterSecurityGroups(response, &metadata)
	}
	output := &DescribeClusterSecurityGroupsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeClusterSecurityGroupsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeClusterSecurityGroupsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeClusterSecurityGroups(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeClusterSnapshots struct {
}

func (*awsAwsquery_deserializeOpDescribeClusterSnapshots) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeClusterSnapshots) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeClusterSnapshots(response, &metadata)
	}
	output := &DescribeClusterSnapshotsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeClusterSnapshotsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeClusterSnapshotsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeClusterSnapshots(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeClusterSubnetGroups struct {
}

func (*awsAwsquery_deserializeOpDescribeClusterSubnetGroups) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeClusterSubnetGroups) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeClusterSubnetGroups(response, &metadata)
	}
	output := &DescribeClusterSubnetGroupsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeClusterSubnetGroupsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeClusterSubnetGroupsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeClusterSubnetGroups(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorClusterSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeClusterTracks struct {
}

func (*awsAwsquery_deserializeOpDescribeClusterTracks) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeClusterTracks) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeClusterTracks(response, &metadata)
	}
	output := &DescribeClusterTracksOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeClusterTracksResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeClusterTracksOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeClusterTracks(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidClusterTrack", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterTrackFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeClusterVersions struct {
}

func (*awsAwsquery_deserializeOpDescribeClusterVersions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeClusterVersions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeClusterVersions(response, &metadata)
	}
	output := &DescribeClusterVersionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeClusterVersionsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeClusterVersionsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeClusterVersions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeCustomDomainAssociations struct {
}

func (*awsAwsquery_deserializeOpDescribeCustomDomainAssociations) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeCustomDomainAssociations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeCustomDomainAssociations(response, &metadata)
	}
	output := &DescribeCustomDomainAssociationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeCustomDomainAssociationsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeCustomDomainAssociationsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeCustomDomainAssociations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CustomDomainAssociationNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorCustomDomainAssociationNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeDataShares struct {
}

func (*awsAwsquery_deserializeOpDescribeDataShares) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeDataShares) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeDataShares(response, &metadata)
	}
	output := &DescribeDataSharesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeDataSharesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeDataSharesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeDataShares(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidDataShareFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidDataShareFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeDataSharesForConsumer struct {
}

func (*awsAwsquery_deserializeOpDescribeDataSharesForConsumer) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeDataSharesForConsumer) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeDataSharesForConsumer(response, &metadata)
	}
	output := &DescribeDataSharesForConsumerOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeDataSharesForConsumerResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeDataSharesForConsumerOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeDataSharesForConsumer(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidNamespaceFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidNamespaceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeDataSharesForProducer struct {
}

func (*awsAwsquery_deserializeOpDescribeDataSharesForProducer) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeDataSharesForProducer) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeDataSharesForProducer(response, &metadata)
	}
	output := &DescribeDataSharesForProducerOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeDataSharesForProducerResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeDataSharesForProducerOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeDataSharesForProducer(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidNamespaceFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidNamespaceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeDefaultClusterParameters struct {
}

func (*awsAwsquery_deserializeOpDescribeDefaultClusterParameters) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeDefaultClusterParameters) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeDefaultClusterParameters(response, &metadata)
	}
	output := &DescribeDefaultClusterParametersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeDefaultClusterParametersResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeDefaultClusterParametersOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeDefaultClusterParameters(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeEndpointAccess struct {
}

func (*awsAwsquery_deserializeOpDescribeEndpointAccess) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeEndpointAccess) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeEndpointAccess(response, &metadata)
	}
	output := &DescribeEndpointAccessOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeEndpointAccessResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeEndpointAccessOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeEndpointAccess(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("EndpointNotFound", errorCode):
		return awsAwsquery_deserializeErrorEndpointNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeEndpointAuthorization struct {
}

func (*awsAwsquery_deserializeOpDescribeEndpointAuthorization) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeEndpointAuthorization) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeEndpointAuthorization(response, &metadata)
	}
	output := &DescribeEndpointAuthorizationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeEndpointAuthorizationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeEndpointAuthorizationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeEndpointAuthorization(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeEventCategories struct {
}

func (*awsAwsquery_deserializeOpDescribeEventCategories) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeEventCategories) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeEventCategories(response, &metadata)
	}
	output := &DescribeEventCategoriesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeEventCategoriesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeEventCategoriesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeEventCategories(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeEvents struct {
}

func (*awsAwsquery_deserializeOpDescribeEvents) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeEvents) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeEvents(response, &metadata)
	}
	output := &DescribeEventsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeEventsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeEventsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeEvents(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeEventSubscriptions struct {
}

func (*awsAwsquery_deserializeOpDescribeEventSubscriptions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeEventSubscriptions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeEventSubscriptions(response, &metadata)
	}
	output := &DescribeEventSubscriptionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeEventSubscriptionsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeEventSubscriptionsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeEventSubscriptions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("SubscriptionNotFound", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeHsmClientCertificates struct {
}

func (*awsAwsquery_deserializeOpDescribeHsmClientCertificates) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeHsmClientCertificates) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeHsmClientCertificates(response, &metadata)
	}
	output := &DescribeHsmClientCertificatesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeHsmClientCertificatesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeHsmClientCertificatesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeHsmClientCertificates(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("HsmClientCertificateNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorHsmClientCertificateNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeHsmConfigurations struct {
}

func (*awsAwsquery_deserializeOpDescribeHsmConfigurations) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeHsmConfigurations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeHsmConfigurations(response, &metadata)
	}
	output := &DescribeHsmConfigurationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeHsmConfigurationsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeHsmConfigurationsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeHsmConfigurations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("HsmConfigurationNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorHsmConfigurationNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeInboundIntegrations struct {
}

func (*awsAwsquery_deserializeOpDescribeInboundIntegrations) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeInboundIntegrations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeInboundIntegrations(response, &metadata)
	}
	output := &DescribeInboundIntegrationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeInboundIntegrationsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeInboundIntegrationsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeInboundIntegrations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("IntegrationNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorIntegrationNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidNamespaceFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidNamespaceFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeLoggingStatus struct {
}

func (*awsAwsquery_deserializeOpDescribeLoggingStatus) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeLoggingStatus) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeLoggingStatus(response, &metadata)
	}
	output := &DescribeLoggingStatusOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeLoggingStatusResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeLoggingStatusOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeLoggingStatus(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeNodeConfigurationOptions struct {
}

func (*awsAwsquery_deserializeOpDescribeNodeConfigurationOptions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeNodeConfigurationOptions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeNodeConfigurationOptions(response, &metadata)
	}
	output := &DescribeNodeConfigurationOptionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeNodeConfigurationOptionsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeNodeConfigurationOptionsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeNodeConfigurationOptions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AccessToSnapshotDenied", errorCode):
		return awsAwsquery_deserializeErrorAccessToSnapshotDeniedFault(response, errorBody)

	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSnapshotState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSnapshotStateFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeOrderableClusterOptions struct {
}

func (*awsAwsquery_deserializeOpDescribeOrderableClusterOptions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeOrderableClusterOptions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeOrderableClusterOptions(response, &metadata)
	}
	output := &DescribeOrderableClusterOptionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeOrderableClusterOptionsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeOrderableClusterOptionsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeOrderableClusterOptions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribePartners struct {
}

func (*awsAwsquery_deserializeOpDescribePartners) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribePartners) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribePartners(response, &metadata)
	}
	output := &DescribePartnersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribePartnersResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribePartnersOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribePartners(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("UnauthorizedPartnerIntegration", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedPartnerIntegrationFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeRedshiftIdcApplications struct {
}

func (*awsAwsquery_deserializeOpDescribeRedshiftIdcApplications) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeRedshiftIdcApplications) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeRedshiftIdcApplications(response, &metadata)
	}
	output := &DescribeRedshiftIdcApplicationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeRedshiftIdcApplicationsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeRedshiftIdcApplicationsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeRedshiftIdcApplications(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DependentServiceAccessDenied", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceAccessDeniedFault(response, errorBody)

	case strings.EqualFold("DependentServiceUnavailableFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response, errorBody)

	case strings.EqualFold("RedshiftIdcApplicationNotExists", errorCode):
		return awsAwsquery_deserializeErrorRedshiftIdcApplicationNotExistsFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeReservedNodeExchangeStatus struct {
}

func (*awsAwsquery_deserializeOpDescribeReservedNodeExchangeStatus) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeReservedNodeExchangeStatus) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeReservedNodeExchangeStatus(response, &metadata)
	}
	output := &DescribeReservedNodeExchangeStatusOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeReservedNodeExchangeStatusResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeReservedNodeExchangeStatusOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeReservedNodeExchangeStatus(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ReservedNodeExchangeNotFond", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeExchangeNotFoundFault(response, errorBody)

	case strings.EqualFold("ReservedNodeNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeReservedNodeOfferings struct {
}

func (*awsAwsquery_deserializeOpDescribeReservedNodeOfferings) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeReservedNodeOfferings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeReservedNodeOfferings(response, &metadata)
	}
	output := &DescribeReservedNodeOfferingsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeReservedNodeOfferingsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeReservedNodeOfferingsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeReservedNodeOfferings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DependentServiceUnavailableFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response, errorBody)

	case strings.EqualFold("ReservedNodeOfferingNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeOfferingNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeReservedNodes struct {
}

func (*awsAwsquery_deserializeOpDescribeReservedNodes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeReservedNodes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeReservedNodes(response, &metadata)
	}
	output := &DescribeReservedNodesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeReservedNodesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeReservedNodesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeReservedNodes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DependentServiceUnavailableFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response, errorBody)

	case strings.EqualFold("ReservedNodeNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeResize struct {
}

func (*awsAwsquery_deserializeOpDescribeResize) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeResize) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeResize(response, &metadata)
	}
	output := &DescribeResizeOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeResizeResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeResizeOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeResize(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("ResizeNotFound", errorCode):
		return awsAwsquery_deserializeErrorResizeNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeScheduledActions struct {
}

func (*awsAwsquery_deserializeOpDescribeScheduledActions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeScheduledActions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeScheduledActions(response, &metadata)
	}
	output := &DescribeScheduledActionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeScheduledActionsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeScheduledActionsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeScheduledActions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ScheduledActionNotFound", errorCode):
		return awsAwsquery_deserializeErrorScheduledActionNotFoundFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeSnapshotCopyGrants struct {
}

func (*awsAwsquery_deserializeOpDescribeSnapshotCopyGrants) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeSnapshotCopyGrants) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeSnapshotCopyGrants(response, &metadata)
	}
	output := &DescribeSnapshotCopyGrantsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeSnapshotCopyGrantsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeSnapshotCopyGrantsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeSnapshotCopyGrants(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("SnapshotCopyGrantNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotCopyGrantNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeSnapshotSchedules struct {
}

func (*awsAwsquery_deserializeOpDescribeSnapshotSchedules) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeSnapshotSchedules) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeSnapshotSchedules(response, &metadata)
	}
	output := &DescribeSnapshotSchedulesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeSnapshotSchedulesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeSnapshotSchedulesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeSnapshotSchedules(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeStorage struct {
}

func (*awsAwsquery_deserializeOpDescribeStorage) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeStorage) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeStorage(response, &metadata)
	}
	output := &DescribeStorageOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeStorageResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeStorageOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeStorage(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeTableRestoreStatus struct {
}

func (*awsAwsquery_deserializeOpDescribeTableRestoreStatus) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeTableRestoreStatus) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeTableRestoreStatus(response, &metadata)
	}
	output := &DescribeTableRestoreStatusOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeTableRestoreStatusResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeTableRestoreStatusOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeTableRestoreStatus(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("TableRestoreNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorTableRestoreNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeTags struct {
}

func (*awsAwsquery_deserializeOpDescribeTags) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeTags) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeTags(response, &metadata)
	}
	output := &DescribeTagsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeTagsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeTagsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeTags(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("ResourceNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeUsageLimits struct {
}

func (*awsAwsquery_deserializeOpDescribeUsageLimits) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeUsageLimits) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeUsageLimits(response, &metadata)
	}
	output := &DescribeUsageLimitsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeUsageLimitsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeUsageLimitsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeUsageLimits(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDisableLogging struct {
}

func (*awsAwsquery_deserializeOpDisableLogging) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDisableLogging) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDisableLogging(response, &metadata)
	}
	output := &DisableLoggingOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DisableLoggingResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDisableLoggingOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDisableLogging(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDisableSnapshotCopy struct {
}

func (*awsAwsquery_deserializeOpDisableSnapshotCopy) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDisableSnapshotCopy) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDisableSnapshotCopy(response, &metadata)
	}
	output := &DisableSnapshotCopyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DisableSnapshotCopyResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDisableSnapshotCopyOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDisableSnapshotCopy(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("SnapshotCopyAlreadyDisabledFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotCopyAlreadyDisabledFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDisassociateDataShareConsumer struct {
}

func (*awsAwsquery_deserializeOpDisassociateDataShareConsumer) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDisassociateDataShareConsumer) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDisassociateDataShareConsumer(response, &metadata)
	}
	output := &DisassociateDataShareConsumerOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DisassociateDataShareConsumerResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDisassociateDataShareConsumerOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDisassociateDataShareConsumer(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidDataShareFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidDataShareFault(response, errorBody)

	case strings.EqualFold("InvalidNamespaceFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidNamespaceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpEnableLogging struct {
}

func (*awsAwsquery_deserializeOpEnableLogging) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpEnableLogging) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorEnableLogging(response, &metadata)
	}
	output := &EnableLoggingOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("EnableLoggingResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentEnableLoggingOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorEnableLogging(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("BucketNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorBucketNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InsufficientS3BucketPolicyFault", errorCode):
		return awsAwsquery_deserializeErrorInsufficientS3BucketPolicyFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidS3BucketNameFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidS3BucketNameFault(response, errorBody)

	case strings.EqualFold("InvalidS3KeyPrefixFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidS3KeyPrefixFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpEnableSnapshotCopy struct {
}

func (*awsAwsquery_deserializeOpEnableSnapshotCopy) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpEnableSnapshotCopy) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorEnableSnapshotCopy(response, &metadata)
	}
	output := &EnableSnapshotCopyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("EnableSnapshotCopyResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentEnableSnapshotCopyOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorEnableSnapshotCopy(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("CopyToRegionDisabledFault", errorCode):
		return awsAwsquery_deserializeErrorCopyToRegionDisabledFault(response, errorBody)

	case strings.EqualFold("DependentServiceRequestThrottlingFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceRequestThrottlingFault(response, errorBody)

	case strings.EqualFold("IncompatibleOrderableOptions", errorCode):
		return awsAwsquery_deserializeErrorIncompatibleOrderableOptions(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidRetentionPeriodFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidRetentionPeriodFault(response, errorBody)

	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("SnapshotCopyAlreadyEnabledFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotCopyAlreadyEnabledFault(response, errorBody)

	case strings.EqualFold("SnapshotCopyGrantNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotCopyGrantNotFoundFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	case strings.EqualFold("UnknownSnapshotCopyRegionFault", errorCode):
		return awsAwsquery_deserializeErrorUnknownSnapshotCopyRegionFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpFailoverPrimaryCompute struct {
}

func (*awsAwsquery_deserializeOpFailoverPrimaryCompute) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpFailoverPrimaryCompute) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorFailoverPrimaryCompute(response, &metadata)
	}
	output := &FailoverPrimaryComputeOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("FailoverPrimaryComputeResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentFailoverPrimaryComputeOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorFailoverPrimaryCompute(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetClusterCredentials struct {
}

func (*awsAwsquery_deserializeOpGetClusterCredentials) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetClusterCredentials) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetClusterCredentials(response, &metadata)
	}
	output := &GetClusterCredentialsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetClusterCredentialsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetClusterCredentialsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetClusterCredentials(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetClusterCredentialsWithIAM struct {
}

func (*awsAwsquery_deserializeOpGetClusterCredentialsWithIAM) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetClusterCredentialsWithIAM) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetClusterCredentialsWithIAM(response, &metadata)
	}
	output := &GetClusterCredentialsWithIAMOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetClusterCredentialsWithIAMResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetClusterCredentialsWithIAMOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetClusterCredentialsWithIAM(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetReservedNodeExchangeConfigurationOptions struct {
}

func (*awsAwsquery_deserializeOpGetReservedNodeExchangeConfigurationOptions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetReservedNodeExchangeConfigurationOptions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetReservedNodeExchangeConfigurationOptions(response, &metadata)
	}
	output := &GetReservedNodeExchangeConfigurationOptionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetReservedNodeExchangeConfigurationOptionsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetReservedNodeExchangeConfigurationOptionsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetReservedNodeExchangeConfigurationOptions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("DependentServiceUnavailableFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response, errorBody)

	case strings.EqualFold("InvalidReservedNodeState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReservedNodeStateFault(response, errorBody)

	case strings.EqualFold("ReservedNodeAlreadyMigrated", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeAlreadyMigratedFault(response, errorBody)

	case strings.EqualFold("ReservedNodeNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeNotFoundFault(response, errorBody)

	case strings.EqualFold("ReservedNodeOfferingNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeOfferingNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetReservedNodeExchangeOfferings struct {
}

func (*awsAwsquery_deserializeOpGetReservedNodeExchangeOfferings) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetReservedNodeExchangeOfferings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetReservedNodeExchangeOfferings(response, &metadata)
	}
	output := &GetReservedNodeExchangeOfferingsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetReservedNodeExchangeOfferingsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetReservedNodeExchangeOfferingsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetReservedNodeExchangeOfferings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DependentServiceUnavailableFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response, errorBody)

	case strings.EqualFold("InvalidReservedNodeState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReservedNodeStateFault(response, errorBody)

	case strings.EqualFold("ReservedNodeAlreadyMigrated", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeAlreadyMigratedFault(response, errorBody)

	case strings.EqualFold("ReservedNodeNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeNotFoundFault(response, errorBody)

	case strings.EqualFold("ReservedNodeOfferingNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeOfferingNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpGetResourcePolicy struct {
}

func (*awsAwsquery_deserializeOpGetResourcePolicy) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpGetResourcePolicy) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorGetResourcePolicy(response, &metadata)
	}
	output := &GetResourcePolicyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("GetResourcePolicyResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentGetResourcePolicyOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorGetResourcePolicy(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidPolicyFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidPolicyFault(response, errorBody)

	case strings.EqualFold("ResourceNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyAquaConfiguration struct {
}

func (*awsAwsquery_deserializeOpModifyAquaConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyAquaConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyAquaConfiguration(response, &metadata)
	}
	output := &ModifyAquaConfigurationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyAquaConfigurationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyAquaConfigurationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyAquaConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyAuthenticationProfile struct {
}

func (*awsAwsquery_deserializeOpModifyAuthenticationProfile) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyAuthenticationProfile) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyAuthenticationProfile(response, &metadata)
	}
	output := &ModifyAuthenticationProfileOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyAuthenticationProfileResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyAuthenticationProfileOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyAuthenticationProfile(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthenticationProfileNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorAuthenticationProfileNotFoundFault(response, errorBody)

	case strings.EqualFold("AuthenticationProfileQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorAuthenticationProfileQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidAuthenticationProfileRequestFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidAuthenticationProfileRequestFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyCluster struct {
}

func (*awsAwsquery_deserializeOpModifyCluster) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyCluster) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyCluster(response, &metadata)
	}
	output := &ModifyClusterOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyClusterResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyClusterOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyCluster(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorClusterAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CustomCnameAssociationFault", errorCode):
		return awsAwsquery_deserializeErrorCustomCnameAssociationFault(response, errorBody)

	case strings.EqualFold("DependentServiceRequestThrottlingFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceRequestThrottlingFault(response, errorBody)

	case strings.EqualFold("HsmClientCertificateNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorHsmClientCertificateNotFoundFault(response, errorBody)

	case strings.EqualFold("HsmConfigurationNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorHsmConfigurationNotFoundFault(response, errorBody)

	case strings.EqualFold("InsufficientClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSecurityGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterTrack", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterTrackFault(response, errorBody)

	case strings.EqualFold("InvalidElasticIpFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidElasticIpFault(response, errorBody)

	case strings.EqualFold("InvalidRetentionPeriodFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidRetentionPeriodFault(response, errorBody)

	case strings.EqualFold("Ipv6CidrBlockNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorIpv6CidrBlockNotFoundFault(response, errorBody)

	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("NumberOfNodesPerClusterLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorNumberOfNodesPerClusterLimitExceededFault(response, errorBody)

	case strings.EqualFold("NumberOfNodesQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorNumberOfNodesQuotaExceededFault(response, errorBody)

	case strings.EqualFold("TableLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorTableLimitExceededFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	case strings.EqualFold("UnsupportedOptionFault", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOptionFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyClusterDbRevision struct {
}

func (*awsAwsquery_deserializeOpModifyClusterDbRevision) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyClusterDbRevision) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyClusterDbRevision(response, &metadata)
	}
	output := &ModifyClusterDbRevisionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyClusterDbRevisionResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyClusterDbRevisionOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyClusterDbRevision(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterOnLatestRevision", errorCode):
		return awsAwsquery_deserializeErrorClusterOnLatestRevisionFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyClusterIamRoles struct {
}

func (*awsAwsquery_deserializeOpModifyClusterIamRoles) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyClusterIamRoles) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyClusterIamRoles(response, &metadata)
	}
	output := &ModifyClusterIamRolesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyClusterIamRolesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyClusterIamRolesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyClusterIamRoles(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyClusterMaintenance struct {
}

func (*awsAwsquery_deserializeOpModifyClusterMaintenance) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyClusterMaintenance) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyClusterMaintenance(response, &metadata)
	}
	output := &ModifyClusterMaintenanceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyClusterMaintenanceResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyClusterMaintenanceOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyClusterMaintenance(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyClusterParameterGroup struct {
}

func (*awsAwsquery_deserializeOpModifyClusterParameterGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyClusterParameterGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyClusterParameterGroup(response, &metadata)
	}
	output := &ModifyClusterParameterGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyClusterParameterGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyClusterParameterGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyClusterParameterGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterParameterGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterParameterGroupStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyClusterSnapshot struct {
}

func (*awsAwsquery_deserializeOpModifyClusterSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyClusterSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyClusterSnapshot(response, &metadata)
	}
	output := &ModifyClusterSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyClusterSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyClusterSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyClusterSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterSnapshotNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSnapshotState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSnapshotStateFault(response, errorBody)

	case strings.EqualFold("InvalidRetentionPeriodFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidRetentionPeriodFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyClusterSnapshotSchedule struct {
}

func (*awsAwsquery_deserializeOpModifyClusterSnapshotSchedule) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyClusterSnapshotSchedule) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyClusterSnapshotSchedule(response, &metadata)
	}
	output := &ModifyClusterSnapshotScheduleOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyClusterSnapshotSchedule(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSnapshotScheduleState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSnapshotScheduleStateFault(response, errorBody)

	case strings.EqualFold("SnapshotScheduleNotFound", errorCode):
		return awsAwsquery_deserializeErrorSnapshotScheduleNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyClusterSubnetGroup struct {
}

func (*awsAwsquery_deserializeOpModifyClusterSubnetGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyClusterSubnetGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyClusterSubnetGroup(response, &metadata)
	}
	output := &ModifyClusterSubnetGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyClusterSubnetGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyClusterSubnetGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyClusterSubnetGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorClusterSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSubnetQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorClusterSubnetQuotaExceededFault(response, errorBody)

	case strings.EqualFold("DependentServiceRequestThrottlingFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceRequestThrottlingFault(response, errorBody)

	case strings.EqualFold("InvalidSubnet", errorCode):
		return awsAwsquery_deserializeErrorInvalidSubnet(response, errorBody)

	case strings.EqualFold("SubnetAlreadyInUse", errorCode):
		return awsAwsquery_deserializeErrorSubnetAlreadyInUse(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyCustomDomainAssociation struct {
}

func (*awsAwsquery_deserializeOpModifyCustomDomainAssociation) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyCustomDomainAssociation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyCustomDomainAssociation(response, &metadata)
	}
	output := &ModifyCustomDomainAssociationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyCustomDomainAssociationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyCustomDomainAssociationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyCustomDomainAssociation(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("CustomCnameAssociationFault", errorCode):
		return awsAwsquery_deserializeErrorCustomCnameAssociationFault(response, errorBody)

	case strings.EqualFold("CustomDomainAssociationNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorCustomDomainAssociationNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyEndpointAccess struct {
}

func (*awsAwsquery_deserializeOpModifyEndpointAccess) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyEndpointAccess) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyEndpointAccess(response, &metadata)
	}
	output := &ModifyEndpointAccessOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyEndpointAccessResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyEndpointAccessOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyEndpointAccess(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("EndpointNotFound", errorCode):
		return awsAwsquery_deserializeErrorEndpointNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSecurityGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidEndpointState", errorCode):
		return awsAwsquery_deserializeErrorInvalidEndpointStateFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyEventSubscription struct {
}

func (*awsAwsquery_deserializeOpModifyEventSubscription) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyEventSubscription) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyEventSubscription(response, &metadata)
	}
	output := &ModifyEventSubscriptionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyEventSubscriptionResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyEventSubscriptionOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyEventSubscription(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidSubscriptionStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidSubscriptionStateFault(response, errorBody)

	case strings.EqualFold("SNSInvalidTopic", errorCode):
		return awsAwsquery_deserializeErrorSNSInvalidTopicFault(response, errorBody)

	case strings.EqualFold("SNSNoAuthorization", errorCode):
		return awsAwsquery_deserializeErrorSNSNoAuthorizationFault(response, errorBody)

	case strings.EqualFold("SNSTopicArnNotFound", errorCode):
		return awsAwsquery_deserializeErrorSNSTopicArnNotFoundFault(response, errorBody)

	case strings.EqualFold("SourceNotFound", errorCode):
		return awsAwsquery_deserializeErrorSourceNotFoundFault(response, errorBody)

	case strings.EqualFold("SubscriptionCategoryNotFound", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionCategoryNotFoundFault(response, errorBody)

	case strings.EqualFold("SubscriptionEventIdNotFound", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionEventIdNotFoundFault(response, errorBody)

	case strings.EqualFold("SubscriptionNotFound", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionNotFoundFault(response, errorBody)

	case strings.EqualFold("SubscriptionSeverityNotFound", errorCode):
		return awsAwsquery_deserializeErrorSubscriptionSeverityNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyRedshiftIdcApplication struct {
}

func (*awsAwsquery_deserializeOpModifyRedshiftIdcApplication) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyRedshiftIdcApplication) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyRedshiftIdcApplication(response, &metadata)
	}
	output := &ModifyRedshiftIdcApplicationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyRedshiftIdcApplicationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyRedshiftIdcApplicationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyRedshiftIdcApplication(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DependentServiceAccessDenied", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceAccessDeniedFault(response, errorBody)

	case strings.EqualFold("DependentServiceUnavailableFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response, errorBody)

	case strings.EqualFold("RedshiftIdcApplicationNotExists", errorCode):
		return awsAwsquery_deserializeErrorRedshiftIdcApplicationNotExistsFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyScheduledAction struct {
}

func (*awsAwsquery_deserializeOpModifyScheduledAction) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyScheduledAction) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyScheduledAction(response, &metadata)
	}
	output := &ModifyScheduledActionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyScheduledActionResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyScheduledActionOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyScheduledAction(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidSchedule", errorCode):
		return awsAwsquery_deserializeErrorInvalidScheduleFault(response, errorBody)

	case strings.EqualFold("InvalidScheduledAction", errorCode):
		return awsAwsquery_deserializeErrorInvalidScheduledActionFault(response, errorBody)

	case strings.EqualFold("ScheduledActionNotFound", errorCode):
		return awsAwsquery_deserializeErrorScheduledActionNotFoundFault(response, errorBody)

	case strings.EqualFold("ScheduledActionTypeUnsupported", errorCode):
		return awsAwsquery_deserializeErrorScheduledActionTypeUnsupportedFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifySnapshotCopyRetentionPeriod struct {
}

func (*awsAwsquery_deserializeOpModifySnapshotCopyRetentionPeriod) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifySnapshotCopyRetentionPeriod) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifySnapshotCopyRetentionPeriod(response, &metadata)
	}
	output := &ModifySnapshotCopyRetentionPeriodOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifySnapshotCopyRetentionPeriodResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifySnapshotCopyRetentionPeriodOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifySnapshotCopyRetentionPeriod(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidRetentionPeriodFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidRetentionPeriodFault(response, errorBody)

	case strings.EqualFold("SnapshotCopyDisabledFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotCopyDisabledFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifySnapshotSchedule struct {
}

func (*awsAwsquery_deserializeOpModifySnapshotSchedule) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifySnapshotSchedule) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifySnapshotSchedule(response, &metadata)
	}
	output := &ModifySnapshotScheduleOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifySnapshotScheduleResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifySnapshotScheduleOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifySnapshotSchedule(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidSchedule", errorCode):
		return awsAwsquery_deserializeErrorInvalidScheduleFault(response, errorBody)

	case strings.EqualFold("SnapshotScheduleNotFound", errorCode):
		return awsAwsquery_deserializeErrorSnapshotScheduleNotFoundFault(response, errorBody)

	case strings.EqualFold("SnapshotScheduleUpdateInProgress", errorCode):
		return awsAwsquery_deserializeErrorSnapshotScheduleUpdateInProgressFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyUsageLimit struct {
}

func (*awsAwsquery_deserializeOpModifyUsageLimit) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyUsageLimit) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyUsageLimit(response, &metadata)
	}
	output := &ModifyUsageLimitOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyUsageLimitResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyUsageLimitOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyUsageLimit(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidUsageLimit", errorCode):
		return awsAwsquery_deserializeErrorInvalidUsageLimitFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	case strings.EqualFold("UsageLimitNotFound", errorCode):
		return awsAwsquery_deserializeErrorUsageLimitNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpPauseCluster struct {
}

func (*awsAwsquery_deserializeOpPauseCluster) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpPauseCluster) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorPauseCluster(response, &metadata)
	}
	output := &PauseClusterOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("PauseClusterResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentPauseClusterOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorPauseCluster(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpPurchaseReservedNodeOffering struct {
}

func (*awsAwsquery_deserializeOpPurchaseReservedNodeOffering) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpPurchaseReservedNodeOffering) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorPurchaseReservedNodeOffering(response, &metadata)
	}
	output := &PurchaseReservedNodeOfferingOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("PurchaseReservedNodeOfferingResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentPurchaseReservedNodeOfferingOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorPurchaseReservedNodeOffering(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ReservedNodeAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ReservedNodeOfferingNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeOfferingNotFoundFault(response, errorBody)

	case strings.EqualFold("ReservedNodeQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeQuotaExceededFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpPutResourcePolicy struct {
}

func (*awsAwsquery_deserializeOpPutResourcePolicy) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpPutResourcePolicy) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorPutResourcePolicy(response, &metadata)
	}
	output := &PutResourcePolicyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("PutResourcePolicyResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentPutResourcePolicyOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorPutResourcePolicy(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ConflictPolicyUpdateFault", errorCode):
		return awsAwsquery_deserializeErrorConflictPolicyUpdateFault(response, errorBody)

	case strings.EqualFold("InvalidPolicyFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidPolicyFault(response, errorBody)

	case strings.EqualFold("ResourceNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorResourceNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRebootCluster struct {
}

func (*awsAwsquery_deserializeOpRebootCluster) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRebootCluster) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRebootCluster(response, &metadata)
	}
	output := &RebootClusterOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RebootClusterResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRebootClusterOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRebootCluster(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRejectDataShare struct {
}

func (*awsAwsquery_deserializeOpRejectDataShare) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRejectDataShare) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRejectDataShare(response, &metadata)
	}
	output := &RejectDataShareOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RejectDataShareResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRejectDataShareOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRejectDataShare(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidDataShareFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidDataShareFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpResetClusterParameterGroup struct {
}

func (*awsAwsquery_deserializeOpResetClusterParameterGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpResetClusterParameterGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorResetClusterParameterGroup(response, &metadata)
	}
	output := &ResetClusterParameterGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ResetClusterParameterGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentResetClusterParameterGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorResetClusterParameterGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterParameterGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterParameterGroupStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpResizeCluster struct {
}

func (*awsAwsquery_deserializeOpResizeCluster) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpResizeCluster) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorResizeCluster(response, &metadata)
	}
	output := &ResizeClusterOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ResizeClusterResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentResizeClusterOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorResizeCluster(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("DependentServiceUnavailableFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response, errorBody)

	case strings.EqualFold("InsufficientClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidReservedNodeState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReservedNodeStateFault(response, errorBody)

	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("NumberOfNodesPerClusterLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorNumberOfNodesPerClusterLimitExceededFault(response, errorBody)

	case strings.EqualFold("NumberOfNodesQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorNumberOfNodesQuotaExceededFault(response, errorBody)

	case strings.EqualFold("ReservedNodeAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ReservedNodeAlreadyMigrated", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeAlreadyMigratedFault(response, errorBody)

	case strings.EqualFold("ReservedNodeNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeNotFoundFault(response, errorBody)

	case strings.EqualFold("ReservedNodeOfferingNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeOfferingNotFoundFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	case strings.EqualFold("UnsupportedOptionFault", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOptionFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRestoreFromClusterSnapshot struct {
}

func (*awsAwsquery_deserializeOpRestoreFromClusterSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRestoreFromClusterSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRestoreFromClusterSnapshot(response, &metadata)
	}
	output := &RestoreFromClusterSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RestoreFromClusterSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRestoreFromClusterSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRestoreFromClusterSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AccessToSnapshotDenied", errorCode):
		return awsAwsquery_deserializeErrorAccessToSnapshotDeniedFault(response, errorBody)

	case strings.EqualFold("ClusterAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorClusterAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ClusterParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorClusterQuotaExceededFault(response, errorBody)

	case strings.EqualFold("ClusterSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorClusterSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("DependentServiceRequestThrottlingFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceRequestThrottlingFault(response, errorBody)

	case strings.EqualFold("DependentServiceUnavailableFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response, errorBody)

	case strings.EqualFold("HsmClientCertificateNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorHsmClientCertificateNotFoundFault(response, errorBody)

	case strings.EqualFold("HsmConfigurationNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorHsmConfigurationNotFoundFault(response, errorBody)

	case strings.EqualFold("InsufficientClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSnapshotState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSnapshotStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSubnetGroupStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSubnetGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterTrack", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterTrackFault(response, errorBody)

	case strings.EqualFold("InvalidElasticIpFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidElasticIpFault(response, errorBody)

	case strings.EqualFold("InvalidReservedNodeState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReservedNodeStateFault(response, errorBody)

	case strings.EqualFold("InvalidRestore", errorCode):
		return awsAwsquery_deserializeErrorInvalidRestoreFault(response, errorBody)

	case strings.EqualFold("InvalidSubnet", errorCode):
		return awsAwsquery_deserializeErrorInvalidSubnet(response, errorBody)

	case strings.EqualFold("InvalidTagFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidTagFault(response, errorBody)

	case strings.EqualFold("InvalidVPCNetworkStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidVPCNetworkStateFault(response, errorBody)

	case strings.EqualFold("Ipv6CidrBlockNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorIpv6CidrBlockNotFoundFault(response, errorBody)

	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("NumberOfNodesPerClusterLimitExceeded", errorCode):
		return awsAwsquery_deserializeErrorNumberOfNodesPerClusterLimitExceededFault(response, errorBody)

	case strings.EqualFold("NumberOfNodesQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorNumberOfNodesQuotaExceededFault(response, errorBody)

	case strings.EqualFold("ReservedNodeAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ReservedNodeAlreadyMigrated", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeAlreadyMigratedFault(response, errorBody)

	case strings.EqualFold("ReservedNodeNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeNotFoundFault(response, errorBody)

	case strings.EqualFold("ReservedNodeOfferingNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedNodeOfferingNotFoundFault(response, errorBody)

	case strings.EqualFold("SnapshotScheduleNotFound", errorCode):
		return awsAwsquery_deserializeErrorSnapshotScheduleNotFoundFault(response, errorBody)

	case strings.EqualFold("TagLimitExceededFault", errorCode):
		return awsAwsquery_deserializeErrorTagLimitExceededFault(response, errorBody)

	case strings.EqualFold("UnauthorizedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedOperation(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRestoreTableFromClusterSnapshot struct {
}

func (*awsAwsquery_deserializeOpRestoreTableFromClusterSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRestoreTableFromClusterSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRestoreTableFromClusterSnapshot(response, &metadata)
	}
	output := &RestoreTableFromClusterSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RestoreTableFromClusterSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRestoreTableFromClusterSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRestoreTableFromClusterSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("InProgressTableRestoreQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorInProgressTableRestoreQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSnapshotState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSnapshotStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidTableRestoreArgument", errorCode):
		return awsAwsquery_deserializeErrorInvalidTableRestoreArgumentFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpResumeCluster struct {
}

func (*awsAwsquery_deserializeOpResumeCluster) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpResumeCluster) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorResumeCluster(response, &metadata)
	}
	output := &ResumeClusterOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ResumeClusterResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentResumeClusterOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorResumeCluster(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InsufficientClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRevokeClusterSecurityGroupIngress struct {
}

func (*awsAwsquery_deserializeOpRevokeClusterSecurityGroupIngress) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRevokeClusterSecurityGroupIngress) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRevokeClusterSecurityGroupIngress(response, &metadata)
	}
	output := &RevokeClusterSecurityGroupIngressOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RevokeClusterSecurityGroupIngressResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRevokeClusterSecurityGroupIngressOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRevokeClusterSecurityGroupIngress(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationNotFound", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSecurityGroupStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRevokeEndpointAccess struct {
}

func (*awsAwsquery_deserializeOpRevokeEndpointAccess) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRevokeEndpointAccess) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRevokeEndpointAccess(response, &metadata)
	}
	output := &RevokeEndpointAccessOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RevokeEndpointAccessResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRevokeEndpointAccessOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRevokeEndpointAccess(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("EndpointAuthorizationNotFound", errorCode):
		return awsAwsquery_deserializeErrorEndpointAuthorizationNotFoundFault(response, errorBody)

	case strings.EqualFold("EndpointNotFound", errorCode):
		return awsAwsquery_deserializeErrorEndpointNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidAuthorizationState", errorCode):
		return awsAwsquery_deserializeErrorInvalidAuthorizationStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterSecurityGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidEndpointState", errorCode):
		return awsAwsquery_deserializeErrorInvalidEndpointStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRevokeSnapshotAccess struct {
}

func (*awsAwsquery_deserializeOpRevokeSnapshotAccess) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRevokeSnapshotAccess) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRevokeSnapshotAccess(response, &metadata)
	}
	output := &RevokeSnapshotAccessOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RevokeSnapshotAccessResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRevokeSnapshotAccessOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRevokeSnapshotAccess(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AccessToSnapshotDenied", errorCode):
		return awsAwsquery_deserializeErrorAccessToSnapshotDeniedFault(response, errorBody)

	case strings.EqualFold("AuthorizationNotFound", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterSnapshotNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRotateEncryptionKey struct {
}

func (*awsAwsquery_deserializeOpRotateEncryptionKey) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRotateEncryptionKey) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRotateEncryptionKey(response, &metadata)
	}
	output := &RotateEncryptionKeyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RotateEncryptionKeyResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRotateEncryptionKeyOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRotateEncryptionKey(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("DependentServiceRequestThrottlingFault", errorCode):
		return awsAwsquery_deserializeErrorDependentServiceRequestThrottlingFault(response, errorBody)

	case strings.EqualFold("InvalidClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidClusterStateFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpUpdatePartnerStatus struct {
}

func (*awsAwsquery_deserializeOpUpdatePartnerStatus) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpUpdatePartnerStatus) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorUpdatePartnerStatus(response, &metadata)
	}
	output := &UpdatePartnerStatusOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("UpdatePartnerStatusResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentUpdatePartnerStatusOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorUpdatePartnerStatus(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("PartnerNotFound", errorCode):
		return awsAwsquery_deserializeErrorPartnerNotFoundFault(response, errorBody)

	case strings.EqualFold("UnauthorizedPartnerIntegration", errorCode):
		return awsAwsquery_deserializeErrorUnauthorizedPartnerIntegrationFault(response, errorBody)

	case strings.EqualFold("UnsupportedOperation", errorCode):
		return awsAwsquery_deserializeErrorUnsupportedOperationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsAwsquery_deserializeErrorAccessToClusterDeniedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AccessToClusterDeniedFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAccessToClusterDeniedFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorAccessToSnapshotDeniedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AccessToSnapshotDeniedFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAccessToSnapshotDeniedFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorAuthenticationProfileAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AuthenticationProfileAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAuthenticationProfileAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorAuthenticationProfileNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AuthenticationProfileNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAuthenticationProfileNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorAuthenticationProfileQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AuthenticationProfileQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAuthenticationProfileQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorAuthorizationAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AuthorizationAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAuthorizationAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorAuthorizationNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AuthorizationNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAuthorizationNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorAuthorizationQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AuthorizationQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAuthorizationQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorBatchDeleteRequestSizeExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.BatchDeleteRequestSizeExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentBatchDeleteRequestSizeExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorBatchModifyClusterSnapshotsLimitExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.BatchModifyClusterSnapshotsLimitExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentBatchModifyClusterSnapshotsLimitExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorBucketNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.BucketNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentBucketNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterOnLatestRevisionFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterOnLatestRevisionFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterOnLatestRevisionFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterParameterGroupAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterParameterGroupAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterParameterGroupAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterParameterGroupNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterParameterGroupNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterParameterGroupNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterParameterGroupQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterParameterGroupQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterParameterGroupQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterSecurityGroupAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterSecurityGroupAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterSecurityGroupAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterSecurityGroupNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterSecurityGroupNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterSecurityGroupNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterSecurityGroupQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterSecurityGroupQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterSecurityGroupQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterSnapshotAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterSnapshotAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterSnapshotAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterSnapshotNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterSnapshotNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterSnapshotNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterSnapshotQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterSnapshotQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterSnapshotQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterSubnetGroupAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterSubnetGroupAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterSubnetGroupAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterSubnetGroupNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterSubnetGroupNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterSubnetGroupNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterSubnetGroupQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterSubnetGroupQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterSubnetGroupQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterSubnetQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterSubnetQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterSubnetQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorConflictPolicyUpdateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ConflictPolicyUpdateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentConflictPolicyUpdateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCopyToRegionDisabledFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CopyToRegionDisabledFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCopyToRegionDisabledFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCustomCnameAssociationFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CustomCnameAssociationFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCustomCnameAssociationFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCustomDomainAssociationNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CustomDomainAssociationNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCustomDomainAssociationNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorDependentServiceAccessDeniedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.DependentServiceAccessDeniedFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentDependentServiceAccessDeniedFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorDependentServiceRequestThrottlingFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.DependentServiceRequestThrottlingFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentDependentServiceRequestThrottlingFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorDependentServiceUnavailableFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.DependentServiceUnavailableFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentDependentServiceUnavailableFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorEndpointAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.EndpointAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentEndpointAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorEndpointAuthorizationAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.EndpointAuthorizationAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentEndpointAuthorizationAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorEndpointAuthorizationNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.EndpointAuthorizationNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentEndpointAuthorizationNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorEndpointAuthorizationsPerClusterLimitExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.EndpointAuthorizationsPerClusterLimitExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentEndpointAuthorizationsPerClusterLimitExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorEndpointNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.EndpointNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentEndpointNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorEndpointsPerAuthorizationLimitExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.EndpointsPerAuthorizationLimitExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentEndpointsPerAuthorizationLimitExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorEndpointsPerClusterLimitExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.EndpointsPerClusterLimitExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentEndpointsPerClusterLimitExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorEventSubscriptionQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.EventSubscriptionQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentEventSubscriptionQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorHsmClientCertificateAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.HsmClientCertificateAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentHsmClientCertificateAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorHsmClientCertificateNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.HsmClientCertificateNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentHsmClientCertificateNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorHsmClientCertificateQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.HsmClientCertificateQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentHsmClientCertificateQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorHsmConfigurationAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.HsmConfigurationAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentHsmConfigurationAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorHsmConfigurationNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.HsmConfigurationNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentHsmConfigurationNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorHsmConfigurationQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.HsmConfigurationQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentHsmConfigurationQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorIncompatibleOrderableOptions(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.IncompatibleOrderableOptions{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentIncompatibleOrderableOptions(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInProgressTableRestoreQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InProgressTableRestoreQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInProgressTableRestoreQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInsufficientClusterCapacityFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InsufficientClusterCapacityFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInsufficientClusterCapacityFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInsufficientS3BucketPolicyFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InsufficientS3BucketPolicyFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInsufficientS3BucketPolicyFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorIntegrationNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.IntegrationNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentIntegrationNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidAuthenticationProfileRequestFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidAuthenticationProfileRequestFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidAuthenticationProfileRequestFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidAuthorizationStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidAuthorizationStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidAuthorizationStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidClusterParameterGroupStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidClusterParameterGroupStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidClusterParameterGroupStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidClusterSecurityGroupStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidClusterSecurityGroupStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidClusterSecurityGroupStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidClusterSnapshotScheduleStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidClusterSnapshotScheduleStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidClusterSnapshotScheduleStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidClusterSnapshotStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidClusterSnapshotStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidClusterSnapshotStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidClusterStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidClusterStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidClusterStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidClusterSubnetGroupStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidClusterSubnetGroupStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidClusterSubnetGroupStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidClusterSubnetStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidClusterSubnetStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidClusterSubnetStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidClusterTrackFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidClusterTrackFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidClusterTrackFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidDataShareFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidDataShareFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidDataShareFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidElasticIpFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidElasticIpFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidElasticIpFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidEndpointStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidEndpointStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidEndpointStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidHsmClientCertificateStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidHsmClientCertificateStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidHsmClientCertificateStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidHsmConfigurationStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidHsmConfigurationStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidHsmConfigurationStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidNamespaceFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidNamespaceFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidNamespaceFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidPolicyFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidPolicyFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidPolicyFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidReservedNodeStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidReservedNodeStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidReservedNodeStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidRestoreFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidRestoreFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidRestoreFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidRetentionPeriodFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidRetentionPeriodFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidRetentionPeriodFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidS3BucketNameFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidS3BucketNameFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidS3BucketNameFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidS3KeyPrefixFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidS3KeyPrefixFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidS3KeyPrefixFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidScheduledActionFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidScheduledActionFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidScheduledActionFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidScheduleFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidScheduleFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidScheduleFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidSnapshotCopyGrantStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidSnapshotCopyGrantStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidSnapshotCopyGrantStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidSubnet(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidSubnet{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidSubnet(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidSubscriptionStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidSubscriptionStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidSubscriptionStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidTableRestoreArgumentFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidTableRestoreArgumentFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidTableRestoreArgumentFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidTagFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidTagFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidTagFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidUsageLimitFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidUsageLimitFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidUsageLimitFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidVPCNetworkStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidVPCNetworkStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidVPCNetworkStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorIpv6CidrBlockNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.Ipv6CidrBlockNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentIpv6CidrBlockNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorLimitExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.LimitExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentLimitExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorNumberOfNodesPerClusterLimitExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.NumberOfNodesPerClusterLimitExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentNumberOfNodesPerClusterLimitExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorNumberOfNodesQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.NumberOfNodesQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentNumberOfNodesQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorPartnerNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.PartnerNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentPartnerNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorRedshiftIdcApplicationAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.RedshiftIdcApplicationAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentRedshiftIdcApplicationAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorRedshiftIdcApplicationNotExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.RedshiftIdcApplicationNotExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentRedshiftIdcApplicationNotExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorRedshiftIdcApplicationQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.RedshiftIdcApplicationQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentRedshiftIdcApplicationQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReservedNodeAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReservedNodeAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReservedNodeAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReservedNodeAlreadyMigratedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReservedNodeAlreadyMigratedFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReservedNodeAlreadyMigratedFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReservedNodeExchangeNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReservedNodeExchangeNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReservedNodeExchangeNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReservedNodeNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReservedNodeNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReservedNodeNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReservedNodeOfferingNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReservedNodeOfferingNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReservedNodeOfferingNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReservedNodeQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReservedNodeQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReservedNodeQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorResizeNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ResizeNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentResizeNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorResourceNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ResourceNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentResourceNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorScheduledActionAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ScheduledActionAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentScheduledActionAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorScheduledActionNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ScheduledActionNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentScheduledActionNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorScheduledActionQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ScheduledActionQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentScheduledActionQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorScheduledActionTypeUnsupportedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ScheduledActionTypeUnsupportedFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentScheduledActionTypeUnsupportedFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorScheduleDefinitionTypeUnsupportedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ScheduleDefinitionTypeUnsupportedFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentScheduleDefinitionTypeUnsupportedFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotCopyAlreadyDisabledFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotCopyAlreadyDisabledFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotCopyAlreadyDisabledFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotCopyAlreadyEnabledFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotCopyAlreadyEnabledFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotCopyAlreadyEnabledFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotCopyDisabledFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotCopyDisabledFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotCopyDisabledFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotCopyGrantAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotCopyGrantAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotCopyGrantAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotCopyGrantNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotCopyGrantNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotCopyGrantNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotCopyGrantQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotCopyGrantQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotCopyGrantQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotScheduleAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotScheduleAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotScheduleAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotScheduleNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotScheduleNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotScheduleNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotScheduleQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotScheduleQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotScheduleQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotScheduleUpdateInProgressFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotScheduleUpdateInProgressFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotScheduleUpdateInProgressFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSNSInvalidTopicFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SNSInvalidTopicFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSNSInvalidTopicFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSNSNoAuthorizationFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SNSNoAuthorizationFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSNSNoAuthorizationFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSNSTopicArnNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SNSTopicArnNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSNSTopicArnNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSourceNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SourceNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSourceNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSubnetAlreadyInUse(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SubnetAlreadyInUse{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSubnetAlreadyInUse(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSubscriptionAlreadyExistFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SubscriptionAlreadyExistFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSubscriptionAlreadyExistFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSubscriptionCategoryNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SubscriptionCategoryNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSubscriptionCategoryNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSubscriptionEventIdNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SubscriptionEventIdNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSubscriptionEventIdNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSubscriptionNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SubscriptionNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSubscriptionNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSubscriptionSeverityNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SubscriptionSeverityNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSubscriptionSeverityNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorTableLimitExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.TableLimitExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentTableLimitExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorTableRestoreNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.TableRestoreNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentTableRestoreNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorTagLimitExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.TagLimitExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentTagLimitExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUnauthorizedOperation(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UnauthorizedOperation{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUnauthorizedOperation(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUnauthorizedPartnerIntegrationFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UnauthorizedPartnerIntegrationFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUnauthorizedPartnerIntegrationFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUnknownSnapshotCopyRegionFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UnknownSnapshotCopyRegionFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUnknownSnapshotCopyRegionFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUnsupportedOperationFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UnsupportedOperationFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUnsupportedOperationFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUnsupportedOptionFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UnsupportedOptionFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUnsupportedOptionFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUsageLimitAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UsageLimitAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUsageLimitAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUsageLimitNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UsageLimitNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUsageLimitNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeDocumentAccessToClusterDeniedFault(v **types.AccessToClusterDeniedFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AccessToClusterDeniedFault
	if *v == nil {
		sv = &types.AccessToClusterDeniedFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAccessToSnapshotDeniedFault(v **types.AccessToSnapshotDeniedFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AccessToSnapshotDeniedFault
	if *v == nil {
		sv = &types.AccessToSnapshotDeniedFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAccountAttribute(v **types.AccountAttribute, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AccountAttribute
	if *v == nil {
		sv = &types.AccountAttribute{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AttributeName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AttributeName = ptr.String(xtv)
			}

		case strings.EqualFold("AttributeValues", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentAttributeValueList(&sv.AttributeValues, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAccountsWithRestoreAccessList(v *[]types.AccountWithRestoreAccess, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.AccountWithRestoreAccess
	if *v == nil {
		sv = make([]types.AccountWithRestoreAccess, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("AccountWithRestoreAccess", t.Name.Local):
			var col types.AccountWithRestoreAccess
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentAccountWithRestoreAccess(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAccountsWithRestoreAccessListUnwrapped(v *[]types.AccountWithRestoreAccess, decoder smithyxml.NodeDecoder) error {
	var sv []types.AccountWithRestoreAccess
	if *v == nil {
		sv = make([]types.AccountWithRestoreAccess, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.AccountWithRestoreAccess
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentAccountWithRestoreAccess(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentAccountWithRestoreAccess(v **types.AccountWithRestoreAccess, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AccountWithRestoreAccess
	if *v == nil {
		sv = &types.AccountWithRestoreAccess{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AccountAlias", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AccountAlias = ptr.String(xtv)
			}

		case strings.EqualFold("AccountId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AccountId = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAquaConfiguration(v **types.AquaConfiguration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AquaConfiguration
	if *v == nil {
		sv = &types.AquaConfiguration{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AquaConfigurationStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AquaConfigurationStatus = types.AquaConfigurationStatus(xtv)
			}

		case strings.EqualFold("AquaStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AquaStatus = types.AquaStatus(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAssociatedClusterList(v *[]types.ClusterAssociatedToSchedule, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ClusterAssociatedToSchedule
	if *v == nil {
		sv = make([]types.ClusterAssociatedToSchedule, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ClusterAssociatedToSchedule", t.Name.Local):
			var col types.ClusterAssociatedToSchedule
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentClusterAssociatedToSchedule(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAssociatedClusterListUnwrapped(v *[]types.ClusterAssociatedToSchedule, decoder smithyxml.NodeDecoder) error {
	var sv []types.ClusterAssociatedToSchedule
	if *v == nil {
		sv = make([]types.ClusterAssociatedToSchedule, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ClusterAssociatedToSchedule
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentClusterAssociatedToSchedule(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentAssociation(v **types.Association, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Association
	if *v == nil {
		sv = &types.Association{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CertificateAssociations", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCertificateAssociationList(&sv.CertificateAssociations, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("CustomDomainCertificateArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CustomDomainCertificateArn = ptr.String(xtv)
			}

		case strings.EqualFold("CustomDomainCertificateExpiryDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CustomDomainCertificateExpiryDate = ptr.Time(t)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAssociationList(v *[]types.Association, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Association
	if *v == nil {
		sv = make([]types.Association, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("Association", t.Name.Local):
			var col types.Association
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentAssociation(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAssociationListUnwrapped(v *[]types.Association, decoder smithyxml.NodeDecoder) error {
	var sv []types.Association
	if *v == nil {
		sv = make([]types.Association, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Association
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentAssociation(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentAttributeList(v *[]types.AccountAttribute, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.AccountAttribute
	if *v == nil {
		sv = make([]types.AccountAttribute, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("AccountAttribute", t.Name.Local):
			var col types.AccountAttribute
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentAccountAttribute(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAttributeListUnwrapped(v *[]types.AccountAttribute, decoder smithyxml.NodeDecoder) error {
	var sv []types.AccountAttribute
	if *v == nil {
		sv = make([]types.AccountAttribute, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.AccountAttribute
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentAccountAttribute(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentAttributeValueList(v *[]types.AttributeValueTarget, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.AttributeValueTarget
	if *v == nil {
		sv = make([]types.AttributeValueTarget, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("AttributeValueTarget", t.Name.Local):
			var col types.AttributeValueTarget
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentAttributeValueTarget(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAttributeValueListUnwrapped(v *[]types.AttributeValueTarget, decoder smithyxml.NodeDecoder) error {
	var sv []types.AttributeValueTarget
	if *v == nil {
		sv = make([]types.AttributeValueTarget, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.AttributeValueTarget
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentAttributeValueTarget(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentAttributeValueTarget(v **types.AttributeValueTarget, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AttributeValueTarget
	if *v == nil {
		sv = &types.AttributeValueTarget{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AttributeValue", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AttributeValue = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthenticationProfile(v **types.AuthenticationProfile, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AuthenticationProfile
	if *v == nil {
		sv = &types.AuthenticationProfile{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AuthenticationProfileContent", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AuthenticationProfileContent = ptr.String(xtv)
			}

		case strings.EqualFold("AuthenticationProfileName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AuthenticationProfileName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthenticationProfileAlreadyExistsFault(v **types.AuthenticationProfileAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AuthenticationProfileAlreadyExistsFault
	if *v == nil {
		sv = &types.AuthenticationProfileAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthenticationProfileList(v *[]types.AuthenticationProfile, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.AuthenticationProfile
	if *v == nil {
		sv = make([]types.AuthenticationProfile, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.AuthenticationProfile
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentAuthenticationProfile(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthenticationProfileListUnwrapped(v *[]types.AuthenticationProfile, decoder smithyxml.NodeDecoder) error {
	var sv []types.AuthenticationProfile
	if *v == nil {
		sv = make([]types.AuthenticationProfile, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.AuthenticationProfile
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentAuthenticationProfile(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentAuthenticationProfileNotFoundFault(v **types.AuthenticationProfileNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AuthenticationProfileNotFoundFault
	if *v == nil {
		sv = &types.AuthenticationProfileNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthenticationProfileQuotaExceededFault(v **types.AuthenticationProfileQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AuthenticationProfileQuotaExceededFault
	if *v == nil {
		sv = &types.AuthenticationProfileQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthorizationAlreadyExistsFault(v **types.AuthorizationAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AuthorizationAlreadyExistsFault
	if *v == nil {
		sv = &types.AuthorizationAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthorizationNotFoundFault(v **types.AuthorizationNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AuthorizationNotFoundFault
	if *v == nil {
		sv = &types.AuthorizationNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthorizationQuotaExceededFault(v **types.AuthorizationQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AuthorizationQuotaExceededFault
	if *v == nil {
		sv = &types.AuthorizationQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthorizedAudienceList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthorizedAudienceListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentAuthorizedTokenIssuer(v **types.AuthorizedTokenIssuer, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AuthorizedTokenIssuer
	if *v == nil {
		sv = &types.AuthorizedTokenIssuer{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AuthorizedAudiencesList", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentAuthorizedAudienceList(&sv.AuthorizedAudiencesList, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("TrustedTokenIssuerArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TrustedTokenIssuerArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthorizedTokenIssuerList(v *[]types.AuthorizedTokenIssuer, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.AuthorizedTokenIssuer
	if *v == nil {
		sv = make([]types.AuthorizedTokenIssuer, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.AuthorizedTokenIssuer
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentAuthorizedTokenIssuer(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthorizedTokenIssuerListUnwrapped(v *[]types.AuthorizedTokenIssuer, decoder smithyxml.NodeDecoder) error {
	var sv []types.AuthorizedTokenIssuer
	if *v == nil {
		sv = make([]types.AuthorizedTokenIssuer, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.AuthorizedTokenIssuer
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentAuthorizedTokenIssuer(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentAvailabilityZone(v **types.AvailabilityZone, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AvailabilityZone
	if *v == nil {
		sv = &types.AvailabilityZone{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Name", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Name = ptr.String(xtv)
			}

		case strings.EqualFold("SupportedPlatforms", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSupportedPlatformsList(&sv.SupportedPlatforms, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAvailabilityZoneList(v *[]types.AvailabilityZone, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.AvailabilityZone
	if *v == nil {
		sv = make([]types.AvailabilityZone, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("AvailabilityZone", t.Name.Local):
			var col types.AvailabilityZone
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentAvailabilityZone(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAvailabilityZoneListUnwrapped(v *[]types.AvailabilityZone, decoder smithyxml.NodeDecoder) error {
	var sv []types.AvailabilityZone
	if *v == nil {
		sv = make([]types.AvailabilityZone, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.AvailabilityZone
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentAvailabilityZone(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentBatchDeleteRequestSizeExceededFault(v **types.BatchDeleteRequestSizeExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.BatchDeleteRequestSizeExceededFault
	if *v == nil {
		sv = &types.BatchDeleteRequestSizeExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentBatchModifyClusterSnapshotsLimitExceededFault(v **types.BatchModifyClusterSnapshotsLimitExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.BatchModifyClusterSnapshotsLimitExceededFault
	if *v == nil {
		sv = &types.BatchModifyClusterSnapshotsLimitExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentBatchSnapshotOperationErrorList(v *[]types.SnapshotErrorMessage, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.SnapshotErrorMessage
	if *v == nil {
		sv = make([]types.SnapshotErrorMessage, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("SnapshotErrorMessage", t.Name.Local):
			var col types.SnapshotErrorMessage
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentSnapshotErrorMessage(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentBatchSnapshotOperationErrorListUnwrapped(v *[]types.SnapshotErrorMessage, decoder smithyxml.NodeDecoder) error {
	var sv []types.SnapshotErrorMessage
	if *v == nil {
		sv = make([]types.SnapshotErrorMessage, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.SnapshotErrorMessage
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentSnapshotErrorMessage(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentBatchSnapshotOperationErrors(v *[]types.SnapshotErrorMessage, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.SnapshotErrorMessage
	if *v == nil {
		sv = make([]types.SnapshotErrorMessage, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("SnapshotErrorMessage", t.Name.Local):
			var col types.SnapshotErrorMessage
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentSnapshotErrorMessage(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentBatchSnapshotOperationErrorsUnwrapped(v *[]types.SnapshotErrorMessage, decoder smithyxml.NodeDecoder) error {
	var sv []types.SnapshotErrorMessage
	if *v == nil {
		sv = make([]types.SnapshotErrorMessage, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.SnapshotErrorMessage
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentSnapshotErrorMessage(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentBucketNotFoundFault(v **types.BucketNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.BucketNotFoundFault
	if *v == nil {
		sv = &types.BucketNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCertificateAssociation(v **types.CertificateAssociation, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CertificateAssociation
	if *v == nil {
		sv = &types.CertificateAssociation{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ClusterIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("CustomDomainName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CustomDomainName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCertificateAssociationList(v *[]types.CertificateAssociation, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.CertificateAssociation
	if *v == nil {
		sv = make([]types.CertificateAssociation, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("CertificateAssociation", t.Name.Local):
			var col types.CertificateAssociation
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCertificateAssociation(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCertificateAssociationListUnwrapped(v *[]types.CertificateAssociation, decoder smithyxml.NodeDecoder) error {
	var sv []types.CertificateAssociation
	if *v == nil {
		sv = make([]types.CertificateAssociation, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.CertificateAssociation
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCertificateAssociation(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCluster(v **types.Cluster, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Cluster
	if *v == nil {
		sv = &types.Cluster{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AllowVersionUpgrade", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.AllowVersionUpgrade = ptr.Bool(xtv)
			}

		case strings.EqualFold("AquaConfiguration", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentAquaConfiguration(&sv.AquaConfiguration, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("AutomatedSnapshotRetentionPeriod", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.AutomatedSnapshotRetentionPeriod = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("AvailabilityZone", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AvailabilityZone = ptr.String(xtv)
			}

		case strings.EqualFold("AvailabilityZoneRelocationStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AvailabilityZoneRelocationStatus = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterAvailabilityStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterAvailabilityStatus = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterCreateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.ClusterCreateTime = ptr.Time(t)
			}

		case strings.EqualFold("ClusterIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterNamespaceArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterNamespaceArn = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterNodes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentClusterNodesList(&sv.ClusterNodes, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ClusterParameterGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentClusterParameterGroupStatusList(&sv.ClusterParameterGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ClusterPublicKey", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterPublicKey = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterRevisionNumber", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterRevisionNumber = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterSecurityGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentClusterSecurityGroupMembershipList(&sv.ClusterSecurityGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ClusterSnapshotCopyStatus", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentClusterSnapshotCopyStatus(&sv.ClusterSnapshotCopyStatus, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ClusterStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterStatus = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterSubnetGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterSubnetGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterVersion = ptr.String(xtv)
			}

		case strings.EqualFold("CustomDomainCertificateArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CustomDomainCertificateArn = ptr.String(xtv)
			}

		case strings.EqualFold("CustomDomainCertificateExpiryDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CustomDomainCertificateExpiryDate = ptr.Time(t)
			}

		case strings.EqualFold("CustomDomainName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CustomDomainName = ptr.String(xtv)
			}

		case strings.EqualFold("DataTransferProgress", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentDataTransferProgress(&sv.DataTransferProgress, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("DBName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DBName = ptr.String(xtv)
			}

		case strings.EqualFold("DefaultIamRoleArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DefaultIamRoleArn = ptr.String(xtv)
			}

		case strings.EqualFold("DeferredMaintenanceWindows", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentDeferredMaintenanceWindowsList(&sv.DeferredMaintenanceWindows, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ElasticIpStatus", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentElasticIpStatus(&sv.ElasticIpStatus, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ElasticResizeNumberOfNodeOptions", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ElasticResizeNumberOfNodeOptions = ptr.String(xtv)
			}

		case strings.EqualFold("Encrypted", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.Encrypted = ptr.Bool(xtv)
			}

		case strings.EqualFold("Endpoint", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEndpoint(&sv.Endpoint, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("EnhancedVpcRouting", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.EnhancedVpcRouting = ptr.Bool(xtv)
			}

		case strings.EqualFold("ExpectedNextSnapshotScheduleTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.ExpectedNextSnapshotScheduleTime = ptr.Time(t)
			}

		case strings.EqualFold("ExpectedNextSnapshotScheduleTimeStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ExpectedNextSnapshotScheduleTimeStatus = ptr.String(xtv)
			}

		case strings.EqualFold("HsmStatus", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentHsmStatus(&sv.HsmStatus, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("IamRoles", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentClusterIamRoleList(&sv.IamRoles, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("IpAddressType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IpAddressType = ptr.String(xtv)
			}

		case strings.EqualFold("KmsKeyId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.KmsKeyId = ptr.String(xtv)
			}

		case strings.EqualFold("MaintenanceTrackName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MaintenanceTrackName = ptr.String(xtv)
			}

		case strings.EqualFold("ManualSnapshotRetentionPeriod", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.ManualSnapshotRetentionPeriod = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("MasterPasswordSecretArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MasterPasswordSecretArn = ptr.String(xtv)
			}

		case strings.EqualFold("MasterPasswordSecretKmsKeyId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MasterPasswordSecretKmsKeyId = ptr.String(xtv)
			}

		case strings.EqualFold("MasterUsername", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MasterUsername = ptr.String(xtv)
			}

		case strings.EqualFold("ModifyStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ModifyStatus = ptr.String(xtv)
			}

		case strings.EqualFold("MultiAZ", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MultiAZ = ptr.String(xtv)
			}

		case strings.EqualFold("MultiAZSecondary", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSecondaryClusterInfo(&sv.MultiAZSecondary, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("NextMaintenanceWindowStartTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.NextMaintenanceWindowStartTime = ptr.Time(t)
			}

		case strings.EqualFold("NodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeType = ptr.String(xtv)
			}

		case strings.EqualFold("NumberOfNodes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.NumberOfNodes = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("PendingActions", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentPendingActionsList(&sv.PendingActions, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("PendingModifiedValues", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentPendingModifiedValues(&sv.PendingModifiedValues, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("PreferredMaintenanceWindow", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PreferredMaintenanceWindow = ptr.String(xtv)
			}

		case strings.EqualFold("PubliclyAccessible", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.PubliclyAccessible = ptr.Bool(xtv)
			}

		case strings.EqualFold("ReservedNodeExchangeStatus", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReservedNodeExchangeStatus(&sv.ReservedNodeExchangeStatus, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ResizeInfo", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentResizeInfo(&sv.ResizeInfo, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("RestoreStatus", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentRestoreStatus(&sv.RestoreStatus, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("SnapshotScheduleIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnapshotScheduleIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("SnapshotScheduleState", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnapshotScheduleState = types.ScheduleState(xtv)
			}

		case strings.EqualFold("Tags", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.Tags, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("TotalStorageCapacityInMegaBytes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.TotalStorageCapacityInMegaBytes = ptr.Int64(i64)
			}

		case strings.EqualFold("VpcId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.VpcId = ptr.String(xtv)
			}

		case strings.EqualFold("VpcSecurityGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentVpcSecurityGroupMembershipList(&sv.VpcSecurityGroups, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterAlreadyExistsFault(v **types.ClusterAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterAlreadyExistsFault
	if *v == nil {
		sv = &types.ClusterAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterAssociatedToSchedule(v **types.ClusterAssociatedToSchedule, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterAssociatedToSchedule
	if *v == nil {
		sv = &types.ClusterAssociatedToSchedule{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ClusterIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("ScheduleAssociationState", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ScheduleAssociationState = types.ScheduleState(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterDbRevision(v **types.ClusterDbRevision, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterDbRevision
	if *v == nil {
		sv = &types.ClusterDbRevision{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ClusterIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("CurrentDatabaseRevision", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CurrentDatabaseRevision = ptr.String(xtv)
			}

		case strings.EqualFold("DatabaseRevisionReleaseDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.DatabaseRevisionReleaseDate = ptr.Time(t)
			}

		case strings.EqualFold("RevisionTargets", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentRevisionTargetsList(&sv.RevisionTargets, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterDbRevisionsList(v *[]types.ClusterDbRevision, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ClusterDbRevision
	if *v == nil {
		sv = make([]types.ClusterDbRevision, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ClusterDbRevision", t.Name.Local):
			var col types.ClusterDbRevision
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentClusterDbRevision(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterDbRevisionsListUnwrapped(v *[]types.ClusterDbRevision, decoder smithyxml.NodeDecoder) error {
	var sv []types.ClusterDbRevision
	if *v == nil {
		sv = make([]types.ClusterDbRevision, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ClusterDbRevision
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentClusterDbRevision(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentClusterIamRole(v **types.ClusterIamRole, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterIamRole
	if *v == nil {
		sv = &types.ClusterIamRole{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ApplyStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ApplyStatus = ptr.String(xtv)
			}

		case strings.EqualFold("IamRoleArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IamRoleArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterIamRoleList(v *[]types.ClusterIamRole, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ClusterIamRole
	if *v == nil {
		sv = make([]types.ClusterIamRole, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ClusterIamRole", t.Name.Local):
			var col types.ClusterIamRole
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentClusterIamRole(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterIamRoleListUnwrapped(v *[]types.ClusterIamRole, decoder smithyxml.NodeDecoder) error {
	var sv []types.ClusterIamRole
	if *v == nil {
		sv = make([]types.ClusterIamRole, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ClusterIamRole
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentClusterIamRole(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentClusterList(v *[]types.Cluster, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Cluster
	if *v == nil {
		sv = make([]types.Cluster, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("Cluster", t.Name.Local):
			var col types.Cluster
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCluster(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterListUnwrapped(v *[]types.Cluster, decoder smithyxml.NodeDecoder) error {
	var sv []types.Cluster
	if *v == nil {
		sv = make([]types.Cluster, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Cluster
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCluster(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentClusterNode(v **types.ClusterNode, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterNode
	if *v == nil {
		sv = &types.ClusterNode{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NodeRole", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeRole = ptr.String(xtv)
			}

		case strings.EqualFold("PrivateIPAddress", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PrivateIPAddress = ptr.String(xtv)
			}

		case strings.EqualFold("PublicIPAddress", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PublicIPAddress = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterNodesList(v *[]types.ClusterNode, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ClusterNode
	if *v == nil {
		sv = make([]types.ClusterNode, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.ClusterNode
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentClusterNode(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterNodesListUnwrapped(v *[]types.ClusterNode, decoder smithyxml.NodeDecoder) error {
	var sv []types.ClusterNode
	if *v == nil {
		sv = make([]types.ClusterNode, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ClusterNode
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentClusterNode(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentClusterNotFoundFault(v **types.ClusterNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterNotFoundFault
	if *v == nil {
		sv = &types.ClusterNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterOnLatestRevisionFault(v **types.ClusterOnLatestRevisionFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterOnLatestRevisionFault
	if *v == nil {
		sv = &types.ClusterOnLatestRevisionFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterParameterGroup(v **types.ClusterParameterGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterParameterGroup
	if *v == nil {
		sv = &types.ClusterParameterGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterGroupFamily", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterGroupFamily = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("Tags", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.Tags, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterParameterGroupAlreadyExistsFault(v **types.ClusterParameterGroupAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterParameterGroupAlreadyExistsFault
	if *v == nil {
		sv = &types.ClusterParameterGroupAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterParameterGroupNotFoundFault(v **types.ClusterParameterGroupNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterParameterGroupNotFoundFault
	if *v == nil {
		sv = &types.ClusterParameterGroupNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterParameterGroupQuotaExceededFault(v **types.ClusterParameterGroupQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterParameterGroupQuotaExceededFault
	if *v == nil {
		sv = &types.ClusterParameterGroupQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterParameterGroupStatus(v **types.ClusterParameterGroupStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterParameterGroupStatus
	if *v == nil {
		sv = &types.ClusterParameterGroupStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ClusterParameterStatusList", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentClusterParameterStatusList(&sv.ClusterParameterStatusList, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ParameterApplyStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterApplyStatus = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterGroupName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterParameterGroupStatusList(v *[]types.ClusterParameterGroupStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ClusterParameterGroupStatus
	if *v == nil {
		sv = make([]types.ClusterParameterGroupStatus, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ClusterParameterGroup", t.Name.Local):
			var col types.ClusterParameterGroupStatus
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentClusterParameterGroupStatus(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterParameterGroupStatusListUnwrapped(v *[]types.ClusterParameterGroupStatus, decoder smithyxml.NodeDecoder) error {
	var sv []types.ClusterParameterGroupStatus
	if *v == nil {
		sv = make([]types.ClusterParameterGroupStatus, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ClusterParameterGroupStatus
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentClusterParameterGroupStatus(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentClusterParameterStatus(v **types.ClusterParameterStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterParameterStatus
	if *v == nil {
		sv = &types.ClusterParameterStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ParameterApplyErrorDescription", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterApplyErrorDescription = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterApplyStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterApplyStatus = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterParameterStatusList(v *[]types.ClusterParameterStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ClusterParameterStatus
	if *v == nil {
		sv = make([]types.ClusterParameterStatus, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.ClusterParameterStatus
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentClusterParameterStatus(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterParameterStatusListUnwrapped(v *[]types.ClusterParameterStatus, decoder smithyxml.NodeDecoder) error {
	var sv []types.ClusterParameterStatus
	if *v == nil {
		sv = make([]types.ClusterParameterStatus, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ClusterParameterStatus
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentClusterParameterStatus(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentClusterQuotaExceededFault(v **types.ClusterQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterQuotaExceededFault
	if *v == nil {
		sv = &types.ClusterQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSecurityGroup(v **types.ClusterSecurityGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSecurityGroup
	if *v == nil {
		sv = &types.ClusterSecurityGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ClusterSecurityGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterSecurityGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		case strings.EqualFold("EC2SecurityGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEC2SecurityGroupList(&sv.EC2SecurityGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("IPRanges", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentIPRangeList(&sv.IPRanges, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Tags", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.Tags, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSecurityGroupAlreadyExistsFault(v **types.ClusterSecurityGroupAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSecurityGroupAlreadyExistsFault
	if *v == nil {
		sv = &types.ClusterSecurityGroupAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSecurityGroupMembership(v **types.ClusterSecurityGroupMembership, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSecurityGroupMembership
	if *v == nil {
		sv = &types.ClusterSecurityGroupMembership{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ClusterSecurityGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterSecurityGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSecurityGroupMembershipList(v *[]types.ClusterSecurityGroupMembership, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ClusterSecurityGroupMembership
	if *v == nil {
		sv = make([]types.ClusterSecurityGroupMembership, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ClusterSecurityGroup", t.Name.Local):
			var col types.ClusterSecurityGroupMembership
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentClusterSecurityGroupMembership(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSecurityGroupMembershipListUnwrapped(v *[]types.ClusterSecurityGroupMembership, decoder smithyxml.NodeDecoder) error {
	var sv []types.ClusterSecurityGroupMembership
	if *v == nil {
		sv = make([]types.ClusterSecurityGroupMembership, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ClusterSecurityGroupMembership
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentClusterSecurityGroupMembership(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentClusterSecurityGroupNotFoundFault(v **types.ClusterSecurityGroupNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSecurityGroupNotFoundFault
	if *v == nil {
		sv = &types.ClusterSecurityGroupNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSecurityGroupQuotaExceededFault(v **types.ClusterSecurityGroupQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSecurityGroupQuotaExceededFault
	if *v == nil {
		sv = &types.ClusterSecurityGroupQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSecurityGroups(v *[]types.ClusterSecurityGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ClusterSecurityGroup
	if *v == nil {
		sv = make([]types.ClusterSecurityGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ClusterSecurityGroup", t.Name.Local):
			var col types.ClusterSecurityGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentClusterSecurityGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSecurityGroupsUnwrapped(v *[]types.ClusterSecurityGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.ClusterSecurityGroup
	if *v == nil {
		sv = make([]types.ClusterSecurityGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ClusterSecurityGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentClusterSecurityGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentClusterSnapshotAlreadyExistsFault(v **types.ClusterSnapshotAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSnapshotAlreadyExistsFault
	if *v == nil {
		sv = &types.ClusterSnapshotAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSnapshotCopyStatus(v **types.ClusterSnapshotCopyStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSnapshotCopyStatus
	if *v == nil {
		sv = &types.ClusterSnapshotCopyStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("DestinationRegion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DestinationRegion = ptr.String(xtv)
			}

		case strings.EqualFold("ManualSnapshotRetentionPeriod", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.ManualSnapshotRetentionPeriod = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("RetentionPeriod", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.RetentionPeriod = ptr.Int64(i64)
			}

		case strings.EqualFold("SnapshotCopyGrantName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnapshotCopyGrantName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSnapshotNotFoundFault(v **types.ClusterSnapshotNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSnapshotNotFoundFault
	if *v == nil {
		sv = &types.ClusterSnapshotNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSnapshotQuotaExceededFault(v **types.ClusterSnapshotQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSnapshotQuotaExceededFault
	if *v == nil {
		sv = &types.ClusterSnapshotQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSubnetGroup(v **types.ClusterSubnetGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSubnetGroup
	if *v == nil {
		sv = &types.ClusterSubnetGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ClusterSubnetGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterSubnetGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		case strings.EqualFold("SubnetGroupStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SubnetGroupStatus = ptr.String(xtv)
			}

		case strings.EqualFold("Subnets", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSubnetList(&sv.Subnets, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("SupportedClusterIpAddressTypes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentValueStringList(&sv.SupportedClusterIpAddressTypes, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Tags", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.Tags, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("VpcId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.VpcId = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSubnetGroupAlreadyExistsFault(v **types.ClusterSubnetGroupAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSubnetGroupAlreadyExistsFault
	if *v == nil {
		sv = &types.ClusterSubnetGroupAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSubnetGroupNotFoundFault(v **types.ClusterSubnetGroupNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSubnetGroupNotFoundFault
	if *v == nil {
		sv = &types.ClusterSubnetGroupNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSubnetGroupQuotaExceededFault(v **types.ClusterSubnetGroupQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSubnetGroupQuotaExceededFault
	if *v == nil {
		sv = &types.ClusterSubnetGroupQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSubnetGroups(v *[]types.ClusterSubnetGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ClusterSubnetGroup
	if *v == nil {
		sv = make([]types.ClusterSubnetGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ClusterSubnetGroup", t.Name.Local):
			var col types.ClusterSubnetGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentClusterSubnetGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterSubnetGroupsUnwrapped(v *[]types.ClusterSubnetGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.ClusterSubnetGroup
	if *v == nil {
		sv = make([]types.ClusterSubnetGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ClusterSubnetGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentClusterSubnetGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentClusterSubnetQuotaExceededFault(v **types.ClusterSubnetQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterSubnetQuotaExceededFault
	if *v == nil {
		sv = &types.ClusterSubnetQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterVersion(v **types.ClusterVersion, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterVersion
	if *v == nil {
		sv = &types.ClusterVersion{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ClusterParameterGroupFamily", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterParameterGroupFamily = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterVersion = ptr.String(xtv)
			}

		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterVersionList(v *[]types.ClusterVersion, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ClusterVersion
	if *v == nil {
		sv = make([]types.ClusterVersion, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ClusterVersion", t.Name.Local):
			var col types.ClusterVersion
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentClusterVersion(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterVersionListUnwrapped(v *[]types.ClusterVersion, decoder smithyxml.NodeDecoder) error {
	var sv []types.ClusterVersion
	if *v == nil {
		sv = make([]types.ClusterVersion, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ClusterVersion
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentClusterVersion(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentConflictPolicyUpdateFault(v **types.ConflictPolicyUpdateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ConflictPolicyUpdateFault
	if *v == nil {
		sv = &types.ConflictPolicyUpdateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCopyToRegionDisabledFault(v **types.CopyToRegionDisabledFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CopyToRegionDisabledFault
	if *v == nil {
		sv = &types.CopyToRegionDisabledFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCustomCnameAssociationFault(v **types.CustomCnameAssociationFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CustomCnameAssociationFault
	if *v == nil {
		sv = &types.CustomCnameAssociationFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCustomDomainAssociationNotFoundFault(v **types.CustomDomainAssociationNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CustomDomainAssociationNotFoundFault
	if *v == nil {
		sv = &types.CustomDomainAssociationNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDataShare(v **types.DataShare, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DataShare
	if *v == nil {
		sv = &types.DataShare{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AllowPubliclyAccessibleConsumers", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.AllowPubliclyAccessibleConsumers = ptr.Bool(xtv)
			}

		case strings.EqualFold("DataShareArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DataShareArn = ptr.String(xtv)
			}

		case strings.EqualFold("DataShareAssociations", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentDataShareAssociationList(&sv.DataShareAssociations, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ManagedBy", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ManagedBy = ptr.String(xtv)
			}

		case strings.EqualFold("ProducerArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ProducerArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDataShareAssociation(v **types.DataShareAssociation, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DataShareAssociation
	if *v == nil {
		sv = &types.DataShareAssociation{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ConsumerAcceptedWrites", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.ConsumerAcceptedWrites = ptr.Bool(xtv)
			}

		case strings.EqualFold("ConsumerIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ConsumerIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("ConsumerRegion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ConsumerRegion = ptr.String(xtv)
			}

		case strings.EqualFold("CreatedDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CreatedDate = ptr.Time(t)
			}

		case strings.EqualFold("ProducerAllowedWrites", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.ProducerAllowedWrites = ptr.Bool(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = types.DataShareStatus(xtv)
			}

		case strings.EqualFold("StatusChangeDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.StatusChangeDate = ptr.Time(t)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDataShareAssociationList(v *[]types.DataShareAssociation, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.DataShareAssociation
	if *v == nil {
		sv = make([]types.DataShareAssociation, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.DataShareAssociation
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentDataShareAssociation(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDataShareAssociationListUnwrapped(v *[]types.DataShareAssociation, decoder smithyxml.NodeDecoder) error {
	var sv []types.DataShareAssociation
	if *v == nil {
		sv = make([]types.DataShareAssociation, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.DataShareAssociation
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentDataShareAssociation(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentDataShareList(v *[]types.DataShare, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.DataShare
	if *v == nil {
		sv = make([]types.DataShare, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.DataShare
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentDataShare(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDataShareListUnwrapped(v *[]types.DataShare, decoder smithyxml.NodeDecoder) error {
	var sv []types.DataShare
	if *v == nil {
		sv = make([]types.DataShare, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.DataShare
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentDataShare(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentDataTransferProgress(v **types.DataTransferProgress, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DataTransferProgress
	if *v == nil {
		sv = &types.DataTransferProgress{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CurrentRateInMegaBytesPerSecond", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.CurrentRateInMegaBytesPerSecond = ptr.Float64(f64)
			}

		case strings.EqualFold("DataTransferredInMegaBytes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.DataTransferredInMegaBytes = ptr.Int64(i64)
			}

		case strings.EqualFold("ElapsedTimeInSeconds", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.ElapsedTimeInSeconds = ptr.Int64(i64)
			}

		case strings.EqualFold("EstimatedTimeToCompletionInSeconds", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.EstimatedTimeToCompletionInSeconds = ptr.Int64(i64)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("TotalDataInMegaBytes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.TotalDataInMegaBytes = ptr.Int64(i64)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDefaultClusterParameters(v **types.DefaultClusterParameters, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DefaultClusterParameters
	if *v == nil {
		sv = &types.DefaultClusterParameters{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterGroupFamily", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterGroupFamily = ptr.String(xtv)
			}

		case strings.EqualFold("Parameters", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentParametersList(&sv.Parameters, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDeferredMaintenanceWindow(v **types.DeferredMaintenanceWindow, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DeferredMaintenanceWindow
	if *v == nil {
		sv = &types.DeferredMaintenanceWindow{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("DeferMaintenanceEndTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.DeferMaintenanceEndTime = ptr.Time(t)
			}

		case strings.EqualFold("DeferMaintenanceIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DeferMaintenanceIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("DeferMaintenanceStartTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.DeferMaintenanceStartTime = ptr.Time(t)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDeferredMaintenanceWindowsList(v *[]types.DeferredMaintenanceWindow, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.DeferredMaintenanceWindow
	if *v == nil {
		sv = make([]types.DeferredMaintenanceWindow, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("DeferredMaintenanceWindow", t.Name.Local):
			var col types.DeferredMaintenanceWindow
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentDeferredMaintenanceWindow(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDeferredMaintenanceWindowsListUnwrapped(v *[]types.DeferredMaintenanceWindow, decoder smithyxml.NodeDecoder) error {
	var sv []types.DeferredMaintenanceWindow
	if *v == nil {
		sv = make([]types.DeferredMaintenanceWindow, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.DeferredMaintenanceWindow
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentDeferredMaintenanceWindow(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentDependentServiceAccessDeniedFault(v **types.DependentServiceAccessDeniedFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DependentServiceAccessDeniedFault
	if *v == nil {
		sv = &types.DependentServiceAccessDeniedFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDependentServiceRequestThrottlingFault(v **types.DependentServiceRequestThrottlingFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DependentServiceRequestThrottlingFault
	if *v == nil {
		sv = &types.DependentServiceRequestThrottlingFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDependentServiceUnavailableFault(v **types.DependentServiceUnavailableFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DependentServiceUnavailableFault
	if *v == nil {
		sv = &types.DependentServiceUnavailableFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEC2SecurityGroup(v **types.EC2SecurityGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EC2SecurityGroup
	if *v == nil {
		sv = &types.EC2SecurityGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("EC2SecurityGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EC2SecurityGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("EC2SecurityGroupOwnerId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EC2SecurityGroupOwnerId = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("Tags", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.Tags, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEC2SecurityGroupList(v *[]types.EC2SecurityGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.EC2SecurityGroup
	if *v == nil {
		sv = make([]types.EC2SecurityGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("EC2SecurityGroup", t.Name.Local):
			var col types.EC2SecurityGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentEC2SecurityGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEC2SecurityGroupListUnwrapped(v *[]types.EC2SecurityGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.EC2SecurityGroup
	if *v == nil {
		sv = make([]types.EC2SecurityGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.EC2SecurityGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentEC2SecurityGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentElasticIpStatus(v **types.ElasticIpStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ElasticIpStatus
	if *v == nil {
		sv = &types.ElasticIpStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ElasticIp", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ElasticIp = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEligibleTracksToUpdateList(v *[]types.UpdateTarget, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.UpdateTarget
	if *v == nil {
		sv = make([]types.UpdateTarget, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("UpdateTarget", t.Name.Local):
			var col types.UpdateTarget
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentUpdateTarget(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEligibleTracksToUpdateListUnwrapped(v *[]types.UpdateTarget, decoder smithyxml.NodeDecoder) error {
	var sv []types.UpdateTarget
	if *v == nil {
		sv = make([]types.UpdateTarget, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.UpdateTarget
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentUpdateTarget(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentEndpoint(v **types.Endpoint, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Endpoint
	if *v == nil {
		sv = &types.Endpoint{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Address", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Address = ptr.String(xtv)
			}

		case strings.EqualFold("Port", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Port = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("VpcEndpoints", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentVpcEndpointsList(&sv.VpcEndpoints, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointAccess(v **types.EndpointAccess, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EndpointAccess
	if *v == nil {
		sv = &types.EndpointAccess{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Address", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Address = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("EndpointCreateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.EndpointCreateTime = ptr.Time(t)
			}

		case strings.EqualFold("EndpointName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EndpointName = ptr.String(xtv)
			}

		case strings.EqualFold("EndpointStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EndpointStatus = ptr.String(xtv)
			}

		case strings.EqualFold("Port", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Port = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("ResourceOwner", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ResourceOwner = ptr.String(xtv)
			}

		case strings.EqualFold("SubnetGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SubnetGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("VpcEndpoint", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentVpcEndpoint(&sv.VpcEndpoint, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("VpcSecurityGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentVpcSecurityGroupMembershipList(&sv.VpcSecurityGroups, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointAccesses(v *[]types.EndpointAccess, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.EndpointAccess
	if *v == nil {
		sv = make([]types.EndpointAccess, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.EndpointAccess
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentEndpointAccess(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointAccessesUnwrapped(v *[]types.EndpointAccess, decoder smithyxml.NodeDecoder) error {
	var sv []types.EndpointAccess
	if *v == nil {
		sv = make([]types.EndpointAccess, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.EndpointAccess
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentEndpointAccess(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentEndpointAlreadyExistsFault(v **types.EndpointAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EndpointAlreadyExistsFault
	if *v == nil {
		sv = &types.EndpointAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointAuthorization(v **types.EndpointAuthorization, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EndpointAuthorization
	if *v == nil {
		sv = &types.EndpointAuthorization{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AllowedAllVPCs", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.AllowedAllVPCs = ptr.Bool(xtv)
			}

		case strings.EqualFold("AllowedVPCs", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentVpcIdentifierList(&sv.AllowedVPCs, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("AuthorizeTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.AuthorizeTime = ptr.Time(t)
			}

		case strings.EqualFold("ClusterIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterStatus = ptr.String(xtv)
			}

		case strings.EqualFold("EndpointCount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.EndpointCount = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("Grantee", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Grantee = ptr.String(xtv)
			}

		case strings.EqualFold("Grantor", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Grantor = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = types.AuthorizationStatus(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointAuthorizationAlreadyExistsFault(v **types.EndpointAuthorizationAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EndpointAuthorizationAlreadyExistsFault
	if *v == nil {
		sv = &types.EndpointAuthorizationAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointAuthorizationNotFoundFault(v **types.EndpointAuthorizationNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EndpointAuthorizationNotFoundFault
	if *v == nil {
		sv = &types.EndpointAuthorizationNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointAuthorizations(v *[]types.EndpointAuthorization, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.EndpointAuthorization
	if *v == nil {
		sv = make([]types.EndpointAuthorization, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.EndpointAuthorization
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentEndpointAuthorization(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointAuthorizationsUnwrapped(v *[]types.EndpointAuthorization, decoder smithyxml.NodeDecoder) error {
	var sv []types.EndpointAuthorization
	if *v == nil {
		sv = make([]types.EndpointAuthorization, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.EndpointAuthorization
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentEndpointAuthorization(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentEndpointAuthorizationsPerClusterLimitExceededFault(v **types.EndpointAuthorizationsPerClusterLimitExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EndpointAuthorizationsPerClusterLimitExceededFault
	if *v == nil {
		sv = &types.EndpointAuthorizationsPerClusterLimitExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointNotFoundFault(v **types.EndpointNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EndpointNotFoundFault
	if *v == nil {
		sv = &types.EndpointNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointsPerAuthorizationLimitExceededFault(v **types.EndpointsPerAuthorizationLimitExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EndpointsPerAuthorizationLimitExceededFault
	if *v == nil {
		sv = &types.EndpointsPerAuthorizationLimitExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpointsPerClusterLimitExceededFault(v **types.EndpointsPerClusterLimitExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EndpointsPerClusterLimitExceededFault
	if *v == nil {
		sv = &types.EndpointsPerClusterLimitExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEvent(v **types.Event, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Event
	if *v == nil {
		sv = &types.Event{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Date", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.Date = ptr.Time(t)
			}

		case strings.EqualFold("EventCategories", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEventCategoriesList(&sv.EventCategories, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("EventId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EventId = ptr.String(xtv)
			}

		case strings.EqualFold("Message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		case strings.EqualFold("Severity", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Severity = ptr.String(xtv)
			}

		case strings.EqualFold("SourceIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SourceIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("SourceType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SourceType = types.SourceType(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventCategoriesList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("EventCategory", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventCategoriesListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentEventCategoriesMap(v **types.EventCategoriesMap, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EventCategoriesMap
	if *v == nil {
		sv = &types.EventCategoriesMap{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Events", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEventInfoMapList(&sv.Events, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("SourceType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SourceType = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventCategoriesMapList(v *[]types.EventCategoriesMap, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.EventCategoriesMap
	if *v == nil {
		sv = make([]types.EventCategoriesMap, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("EventCategoriesMap", t.Name.Local):
			var col types.EventCategoriesMap
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentEventCategoriesMap(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventCategoriesMapListUnwrapped(v *[]types.EventCategoriesMap, decoder smithyxml.NodeDecoder) error {
	var sv []types.EventCategoriesMap
	if *v == nil {
		sv = make([]types.EventCategoriesMap, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.EventCategoriesMap
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentEventCategoriesMap(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentEventInfoMap(v **types.EventInfoMap, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EventInfoMap
	if *v == nil {
		sv = &types.EventInfoMap{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("EventCategories", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEventCategoriesList(&sv.EventCategories, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("EventDescription", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EventDescription = ptr.String(xtv)
			}

		case strings.EqualFold("EventId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EventId = ptr.String(xtv)
			}

		case strings.EqualFold("Severity", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Severity = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventInfoMapList(v *[]types.EventInfoMap, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.EventInfoMap
	if *v == nil {
		sv = make([]types.EventInfoMap, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("EventInfoMap", t.Name.Local):
			var col types.EventInfoMap
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentEventInfoMap(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventInfoMapListUnwrapped(v *[]types.EventInfoMap, decoder smithyxml.NodeDecoder) error {
	var sv []types.EventInfoMap
	if *v == nil {
		sv = make([]types.EventInfoMap, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.EventInfoMap
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentEventInfoMap(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentEventList(v *[]types.Event, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Event
	if *v == nil {
		sv = make([]types.Event, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("Event", t.Name.Local):
			var col types.Event
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentEvent(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventListUnwrapped(v *[]types.Event, decoder smithyxml.NodeDecoder) error {
	var sv []types.Event
	if *v == nil {
		sv = make([]types.Event, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Event
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentEvent(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentEventSubscription(v **types.EventSubscription, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EventSubscription
	if *v == nil {
		sv = &types.EventSubscription{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CustomerAwsId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CustomerAwsId = ptr.String(xtv)
			}

		case strings.EqualFold("CustSubscriptionId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CustSubscriptionId = ptr.String(xtv)
			}

		case strings.EqualFold("Enabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.Enabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("EventCategoriesList", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEventCategoriesList(&sv.EventCategoriesList, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Severity", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Severity = ptr.String(xtv)
			}

		case strings.EqualFold("SnsTopicArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnsTopicArn = ptr.String(xtv)
			}

		case strings.EqualFold("SourceIdsList", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSourceIdsList(&sv.SourceIdsList, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("SourceType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SourceType = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("SubscriptionCreationTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.SubscriptionCreationTime = ptr.Time(t)
			}

		case strings.EqualFold("Tags", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.Tags, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventSubscriptionQuotaExceededFault(v **types.EventSubscriptionQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EventSubscriptionQuotaExceededFault
	if *v == nil {
		sv = &types.EventSubscriptionQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventSubscriptionsList(v *[]types.EventSubscription, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.EventSubscription
	if *v == nil {
		sv = make([]types.EventSubscription, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("EventSubscription", t.Name.Local):
			var col types.EventSubscription
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentEventSubscription(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventSubscriptionsListUnwrapped(v *[]types.EventSubscription, decoder smithyxml.NodeDecoder) error {
	var sv []types.EventSubscription
	if *v == nil {
		sv = make([]types.EventSubscription, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.EventSubscription
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentEventSubscription(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentHsmClientCertificate(v **types.HsmClientCertificate, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.HsmClientCertificate
	if *v == nil {
		sv = &types.HsmClientCertificate{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("HsmClientCertificateIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.HsmClientCertificateIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("HsmClientCertificatePublicKey", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.HsmClientCertificatePublicKey = ptr.String(xtv)
			}

		case strings.EqualFold("Tags", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.Tags, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentHsmClientCertificateAlreadyExistsFault(v **types.HsmClientCertificateAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.HsmClientCertificateAlreadyExistsFault
	if *v == nil {
		sv = &types.HsmClientCertificateAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentHsmClientCertificateList(v *[]types.HsmClientCertificate, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.HsmClientCertificate
	if *v == nil {
		sv = make([]types.HsmClientCertificate, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("HsmClientCertificate", t.Name.Local):
			var col types.HsmClientCertificate
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentHsmClientCertificate(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentHsmClientCertificateListUnwrapped(v *[]types.HsmClientCertificate, decoder smithyxml.NodeDecoder) error {
	var sv []types.HsmClientCertificate
	if *v == nil {
		sv = make([]types.HsmClientCertificate, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.HsmClientCertificate
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentHsmClientCertificate(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentHsmClientCertificateNotFoundFault(v **types.HsmClientCertificateNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.HsmClientCertificateNotFoundFault
	if *v == nil {
		sv = &types.HsmClientCertificateNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentHsmClientCertificateQuotaExceededFault(v **types.HsmClientCertificateQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.HsmClientCertificateQuotaExceededFault
	if *v == nil {
		sv = &types.HsmClientCertificateQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentHsmConfiguration(v **types.HsmConfiguration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.HsmConfiguration
	if *v == nil {
		sv = &types.HsmConfiguration{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		case strings.EqualFold("HsmConfigurationIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.HsmConfigurationIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("HsmIpAddress", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.HsmIpAddress = ptr.String(xtv)
			}

		case strings.EqualFold("HsmPartitionName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.HsmPartitionName = ptr.String(xtv)
			}

		case strings.EqualFold("Tags", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.Tags, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentHsmConfigurationAlreadyExistsFault(v **types.HsmConfigurationAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.HsmConfigurationAlreadyExistsFault
	if *v == nil {
		sv = &types.HsmConfigurationAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentHsmConfigurationList(v *[]types.HsmConfiguration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.HsmConfiguration
	if *v == nil {
		sv = make([]types.HsmConfiguration, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("HsmConfiguration", t.Name.Local):
			var col types.HsmConfiguration
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentHsmConfiguration(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentHsmConfigurationListUnwrapped(v *[]types.HsmConfiguration, decoder smithyxml.NodeDecoder) error {
	var sv []types.HsmConfiguration
	if *v == nil {
		sv = make([]types.HsmConfiguration, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.HsmConfiguration
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentHsmConfiguration(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentHsmConfigurationNotFoundFault(v **types.HsmConfigurationNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.HsmConfigurationNotFoundFault
	if *v == nil {
		sv = &types.HsmConfigurationNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentHsmConfigurationQuotaExceededFault(v **types.HsmConfigurationQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.HsmConfigurationQuotaExceededFault
	if *v == nil {
		sv = &types.HsmConfigurationQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentHsmStatus(v **types.HsmStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.HsmStatus
	if *v == nil {
		sv = &types.HsmStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("HsmClientCertificateIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.HsmClientCertificateIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("HsmConfigurationIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.HsmConfigurationIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentImportTablesCompleted(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentImportTablesCompletedUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentImportTablesInProgress(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentImportTablesInProgressUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentImportTablesNotStarted(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentImportTablesNotStartedUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentInboundIntegration(v **types.InboundIntegration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InboundIntegration
	if *v == nil {
		sv = &types.InboundIntegration{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CreateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CreateTime = ptr.Time(t)
			}

		case strings.EqualFold("Errors", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentIntegrationErrorList(&sv.Errors, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("IntegrationArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IntegrationArn = ptr.String(xtv)
			}

		case strings.EqualFold("SourceArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SourceArn = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = types.ZeroETLIntegrationStatus(xtv)
			}

		case strings.EqualFold("TargetArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TargetArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInboundIntegrationList(v *[]types.InboundIntegration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.InboundIntegration
	if *v == nil {
		sv = make([]types.InboundIntegration, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("InboundIntegration", t.Name.Local):
			var col types.InboundIntegration
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentInboundIntegration(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInboundIntegrationListUnwrapped(v *[]types.InboundIntegration, decoder smithyxml.NodeDecoder) error {
	var sv []types.InboundIntegration
	if *v == nil {
		sv = make([]types.InboundIntegration, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.InboundIntegration
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentInboundIntegration(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentIncompatibleOrderableOptions(v **types.IncompatibleOrderableOptions, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.IncompatibleOrderableOptions
	if *v == nil {
		sv = &types.IncompatibleOrderableOptions{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInProgressTableRestoreQuotaExceededFault(v **types.InProgressTableRestoreQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InProgressTableRestoreQuotaExceededFault
	if *v == nil {
		sv = &types.InProgressTableRestoreQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInsufficientClusterCapacityFault(v **types.InsufficientClusterCapacityFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InsufficientClusterCapacityFault
	if *v == nil {
		sv = &types.InsufficientClusterCapacityFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInsufficientS3BucketPolicyFault(v **types.InsufficientS3BucketPolicyFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InsufficientS3BucketPolicyFault
	if *v == nil {
		sv = &types.InsufficientS3BucketPolicyFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentIntegrationError(v **types.IntegrationError, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.IntegrationError
	if *v == nil {
		sv = &types.IntegrationError{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ErrorCode", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ErrorCode = ptr.String(xtv)
			}

		case strings.EqualFold("ErrorMessage", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ErrorMessage = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentIntegrationErrorList(v *[]types.IntegrationError, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.IntegrationError
	if *v == nil {
		sv = make([]types.IntegrationError, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("IntegrationError", t.Name.Local):
			var col types.IntegrationError
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentIntegrationError(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentIntegrationErrorListUnwrapped(v *[]types.IntegrationError, decoder smithyxml.NodeDecoder) error {
	var sv []types.IntegrationError
	if *v == nil {
		sv = make([]types.IntegrationError, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.IntegrationError
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentIntegrationError(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentIntegrationNotFoundFault(v **types.IntegrationNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.IntegrationNotFoundFault
	if *v == nil {
		sv = &types.IntegrationNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidAuthenticationProfileRequestFault(v **types.InvalidAuthenticationProfileRequestFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidAuthenticationProfileRequestFault
	if *v == nil {
		sv = &types.InvalidAuthenticationProfileRequestFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidAuthorizationStateFault(v **types.InvalidAuthorizationStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidAuthorizationStateFault
	if *v == nil {
		sv = &types.InvalidAuthorizationStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidClusterParameterGroupStateFault(v **types.InvalidClusterParameterGroupStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidClusterParameterGroupStateFault
	if *v == nil {
		sv = &types.InvalidClusterParameterGroupStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidClusterSecurityGroupStateFault(v **types.InvalidClusterSecurityGroupStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidClusterSecurityGroupStateFault
	if *v == nil {
		sv = &types.InvalidClusterSecurityGroupStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidClusterSnapshotScheduleStateFault(v **types.InvalidClusterSnapshotScheduleStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidClusterSnapshotScheduleStateFault
	if *v == nil {
		sv = &types.InvalidClusterSnapshotScheduleStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidClusterSnapshotStateFault(v **types.InvalidClusterSnapshotStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidClusterSnapshotStateFault
	if *v == nil {
		sv = &types.InvalidClusterSnapshotStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidClusterStateFault(v **types.InvalidClusterStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidClusterStateFault
	if *v == nil {
		sv = &types.InvalidClusterStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidClusterSubnetGroupStateFault(v **types.InvalidClusterSubnetGroupStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidClusterSubnetGroupStateFault
	if *v == nil {
		sv = &types.InvalidClusterSubnetGroupStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidClusterSubnetStateFault(v **types.InvalidClusterSubnetStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidClusterSubnetStateFault
	if *v == nil {
		sv = &types.InvalidClusterSubnetStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidClusterTrackFault(v **types.InvalidClusterTrackFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidClusterTrackFault
	if *v == nil {
		sv = &types.InvalidClusterTrackFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidDataShareFault(v **types.InvalidDataShareFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidDataShareFault
	if *v == nil {
		sv = &types.InvalidDataShareFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidElasticIpFault(v **types.InvalidElasticIpFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidElasticIpFault
	if *v == nil {
		sv = &types.InvalidElasticIpFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidEndpointStateFault(v **types.InvalidEndpointStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidEndpointStateFault
	if *v == nil {
		sv = &types.InvalidEndpointStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidHsmClientCertificateStateFault(v **types.InvalidHsmClientCertificateStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidHsmClientCertificateStateFault
	if *v == nil {
		sv = &types.InvalidHsmClientCertificateStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidHsmConfigurationStateFault(v **types.InvalidHsmConfigurationStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidHsmConfigurationStateFault
	if *v == nil {
		sv = &types.InvalidHsmConfigurationStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidNamespaceFault(v **types.InvalidNamespaceFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidNamespaceFault
	if *v == nil {
		sv = &types.InvalidNamespaceFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidPolicyFault(v **types.InvalidPolicyFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidPolicyFault
	if *v == nil {
		sv = &types.InvalidPolicyFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidReservedNodeStateFault(v **types.InvalidReservedNodeStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidReservedNodeStateFault
	if *v == nil {
		sv = &types.InvalidReservedNodeStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidRestoreFault(v **types.InvalidRestoreFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidRestoreFault
	if *v == nil {
		sv = &types.InvalidRestoreFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidRetentionPeriodFault(v **types.InvalidRetentionPeriodFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidRetentionPeriodFault
	if *v == nil {
		sv = &types.InvalidRetentionPeriodFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidS3BucketNameFault(v **types.InvalidS3BucketNameFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidS3BucketNameFault
	if *v == nil {
		sv = &types.InvalidS3BucketNameFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidS3KeyPrefixFault(v **types.InvalidS3KeyPrefixFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidS3KeyPrefixFault
	if *v == nil {
		sv = &types.InvalidS3KeyPrefixFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidScheduledActionFault(v **types.InvalidScheduledActionFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidScheduledActionFault
	if *v == nil {
		sv = &types.InvalidScheduledActionFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidScheduleFault(v **types.InvalidScheduleFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidScheduleFault
	if *v == nil {
		sv = &types.InvalidScheduleFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidSnapshotCopyGrantStateFault(v **types.InvalidSnapshotCopyGrantStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidSnapshotCopyGrantStateFault
	if *v == nil {
		sv = &types.InvalidSnapshotCopyGrantStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidSubnet(v **types.InvalidSubnet, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidSubnet
	if *v == nil {
		sv = &types.InvalidSubnet{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidSubscriptionStateFault(v **types.InvalidSubscriptionStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidSubscriptionStateFault
	if *v == nil {
		sv = &types.InvalidSubscriptionStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidTableRestoreArgumentFault(v **types.InvalidTableRestoreArgumentFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidTableRestoreArgumentFault
	if *v == nil {
		sv = &types.InvalidTableRestoreArgumentFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidTagFault(v **types.InvalidTagFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidTagFault
	if *v == nil {
		sv = &types.InvalidTagFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidUsageLimitFault(v **types.InvalidUsageLimitFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidUsageLimitFault
	if *v == nil {
		sv = &types.InvalidUsageLimitFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidVPCNetworkStateFault(v **types.InvalidVPCNetworkStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidVPCNetworkStateFault
	if *v == nil {
		sv = &types.InvalidVPCNetworkStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentIPRange(v **types.IPRange, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.IPRange
	if *v == nil {
		sv = &types.IPRange{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CIDRIP", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CIDRIP = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("Tags", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.Tags, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentIPRangeList(v *[]types.IPRange, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.IPRange
	if *v == nil {
		sv = make([]types.IPRange, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("IPRange", t.Name.Local):
			var col types.IPRange
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentIPRange(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentIPRangeListUnwrapped(v *[]types.IPRange, decoder smithyxml.NodeDecoder) error {
	var sv []types.IPRange
	if *v == nil {
		sv = make([]types.IPRange, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.IPRange
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentIPRange(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentIpv6CidrBlockNotFoundFault(v **types.Ipv6CidrBlockNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Ipv6CidrBlockNotFoundFault
	if *v == nil {
		sv = &types.Ipv6CidrBlockNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentLakeFormationQuery(v **types.LakeFormationQuery, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.LakeFormationQuery
	if *v == nil {
		sv = &types.LakeFormationQuery{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Authorization", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Authorization = types.ServiceAuthorization(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentLakeFormationScopeUnion(v *types.LakeFormationScopeUnion, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var uv types.LakeFormationScopeUnion
	var memberFound bool
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		if memberFound {
			if err = decoder.Decoder.Skip(); err != nil {
				return err
			}
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("LakeFormationQuery", t.Name.Local):
			var mv types.LakeFormationQuery
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &mv
			if err := awsAwsquery_deserializeDocumentLakeFormationQuery(&destAddr, nodeDecoder); err != nil {
				return err
			}
			mv = *destAddr
			uv = &types.LakeFormationScopeUnionMemberLakeFormationQuery{Value: mv}
			memberFound = true

		default:
			uv = &types.UnknownUnionMember{Tag: t.Name.Local}
			memberFound = true

		}
		decoder = originalDecoder
	}
	*v = uv
	return nil
}

func awsAwsquery_deserializeDocumentLakeFormationServiceIntegrations(v *[]types.LakeFormationScopeUnion, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.LakeFormationScopeUnion
	if *v == nil {
		sv = make([]types.LakeFormationScopeUnion, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.LakeFormationScopeUnion
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentLakeFormationScopeUnion(&col, nodeDecoder); err != nil {
				return err
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentLakeFormationServiceIntegrationsUnwrapped(v *[]types.LakeFormationScopeUnion, decoder smithyxml.NodeDecoder) error {
	var sv []types.LakeFormationScopeUnion
	if *v == nil {
		sv = make([]types.LakeFormationScopeUnion, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.LakeFormationScopeUnion
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		if err := awsAwsquery_deserializeDocumentLakeFormationScopeUnion(&mv, nodeDecoder); err != nil {
			return err
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentLimitExceededFault(v **types.LimitExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.LimitExceededFault
	if *v == nil {
		sv = &types.LimitExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentLogTypeList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentLogTypeListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentMaintenanceTrack(v **types.MaintenanceTrack, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.MaintenanceTrack
	if *v == nil {
		sv = &types.MaintenanceTrack{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("DatabaseVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DatabaseVersion = ptr.String(xtv)
			}

		case strings.EqualFold("MaintenanceTrackName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MaintenanceTrackName = ptr.String(xtv)
			}

		case strings.EqualFold("UpdateTargets", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEligibleTracksToUpdateList(&sv.UpdateTargets, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNetworkInterface(v **types.NetworkInterface, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NetworkInterface
	if *v == nil {
		sv = &types.NetworkInterface{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AvailabilityZone", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AvailabilityZone = ptr.String(xtv)
			}

		case strings.EqualFold("Ipv6Address", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Ipv6Address = ptr.String(xtv)
			}

		case strings.EqualFold("NetworkInterfaceId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NetworkInterfaceId = ptr.String(xtv)
			}

		case strings.EqualFold("PrivateIpAddress", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PrivateIpAddress = ptr.String(xtv)
			}

		case strings.EqualFold("SubnetId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SubnetId = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNetworkInterfaceList(v *[]types.NetworkInterface, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.NetworkInterface
	if *v == nil {
		sv = make([]types.NetworkInterface, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("NetworkInterface", t.Name.Local):
			var col types.NetworkInterface
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentNetworkInterface(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNetworkInterfaceListUnwrapped(v *[]types.NetworkInterface, decoder smithyxml.NodeDecoder) error {
	var sv []types.NetworkInterface
	if *v == nil {
		sv = make([]types.NetworkInterface, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.NetworkInterface
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentNetworkInterface(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentNodeConfigurationOption(v **types.NodeConfigurationOption, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NodeConfigurationOption
	if *v == nil {
		sv = &types.NodeConfigurationOption{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("EstimatedDiskUtilizationPercent", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.EstimatedDiskUtilizationPercent = ptr.Float64(f64)
			}

		case strings.EqualFold("Mode", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Mode = types.Mode(xtv)
			}

		case strings.EqualFold("NodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeType = ptr.String(xtv)
			}

		case strings.EqualFold("NumberOfNodes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.NumberOfNodes = ptr.Int32(int32(i64))
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeConfigurationOptionList(v *[]types.NodeConfigurationOption, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.NodeConfigurationOption
	if *v == nil {
		sv = make([]types.NodeConfigurationOption, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("NodeConfigurationOption", t.Name.Local):
			var col types.NodeConfigurationOption
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentNodeConfigurationOption(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeConfigurationOptionListUnwrapped(v *[]types.NodeConfigurationOption, decoder smithyxml.NodeDecoder) error {
	var sv []types.NodeConfigurationOption
	if *v == nil {
		sv = make([]types.NodeConfigurationOption, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.NodeConfigurationOption
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentNodeConfigurationOption(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentNumberOfNodesPerClusterLimitExceededFault(v **types.NumberOfNodesPerClusterLimitExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NumberOfNodesPerClusterLimitExceededFault
	if *v == nil {
		sv = &types.NumberOfNodesPerClusterLimitExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNumberOfNodesQuotaExceededFault(v **types.NumberOfNodesQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NumberOfNodesQuotaExceededFault
	if *v == nil {
		sv = &types.NumberOfNodesQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentOrderableClusterOption(v **types.OrderableClusterOption, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.OrderableClusterOption
	if *v == nil {
		sv = &types.OrderableClusterOption{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AvailabilityZones", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentAvailabilityZoneList(&sv.AvailabilityZones, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ClusterType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterType = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterVersion = ptr.String(xtv)
			}

		case strings.EqualFold("NodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeType = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentOrderableClusterOptionsList(v *[]types.OrderableClusterOption, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.OrderableClusterOption
	if *v == nil {
		sv = make([]types.OrderableClusterOption, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("OrderableClusterOption", t.Name.Local):
			var col types.OrderableClusterOption
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentOrderableClusterOption(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentOrderableClusterOptionsListUnwrapped(v *[]types.OrderableClusterOption, decoder smithyxml.NodeDecoder) error {
	var sv []types.OrderableClusterOption
	if *v == nil {
		sv = make([]types.OrderableClusterOption, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.OrderableClusterOption
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentOrderableClusterOption(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentParameter(v **types.Parameter, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Parameter
	if *v == nil {
		sv = &types.Parameter{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AllowedValues", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AllowedValues = ptr.String(xtv)
			}

		case strings.EqualFold("ApplyType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ApplyType = types.ParameterApplyType(xtv)
			}

		case strings.EqualFold("DataType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DataType = ptr.String(xtv)
			}

		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		case strings.EqualFold("IsModifiable", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.IsModifiable = ptr.Bool(xtv)
			}

		case strings.EqualFold("MinimumEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MinimumEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterName = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterValue", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterValue = ptr.String(xtv)
			}

		case strings.EqualFold("Source", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Source = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentParameterGroupList(v *[]types.ClusterParameterGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ClusterParameterGroup
	if *v == nil {
		sv = make([]types.ClusterParameterGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ClusterParameterGroup", t.Name.Local):
			var col types.ClusterParameterGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentClusterParameterGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentParameterGroupListUnwrapped(v *[]types.ClusterParameterGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.ClusterParameterGroup
	if *v == nil {
		sv = make([]types.ClusterParameterGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ClusterParameterGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentClusterParameterGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentParametersList(v *[]types.Parameter, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Parameter
	if *v == nil {
		sv = make([]types.Parameter, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("Parameter", t.Name.Local):
			var col types.Parameter
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentParameter(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentParametersListUnwrapped(v *[]types.Parameter, decoder smithyxml.NodeDecoder) error {
	var sv []types.Parameter
	if *v == nil {
		sv = make([]types.Parameter, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Parameter
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentParameter(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentPartnerIntegrationInfo(v **types.PartnerIntegrationInfo, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.PartnerIntegrationInfo
	if *v == nil {
		sv = &types.PartnerIntegrationInfo{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CreatedAt", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CreatedAt = ptr.Time(t)
			}

		case strings.EqualFold("DatabaseName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DatabaseName = ptr.String(xtv)
			}

		case strings.EqualFold("PartnerName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PartnerName = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = types.PartnerIntegrationStatus(xtv)
			}

		case strings.EqualFold("StatusMessage", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.StatusMessage = ptr.String(xtv)
			}

		case strings.EqualFold("UpdatedAt", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.UpdatedAt = ptr.Time(t)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPartnerIntegrationInfoList(v *[]types.PartnerIntegrationInfo, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.PartnerIntegrationInfo
	if *v == nil {
		sv = make([]types.PartnerIntegrationInfo, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("PartnerIntegrationInfo", t.Name.Local):
			var col types.PartnerIntegrationInfo
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentPartnerIntegrationInfo(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPartnerIntegrationInfoListUnwrapped(v *[]types.PartnerIntegrationInfo, decoder smithyxml.NodeDecoder) error {
	var sv []types.PartnerIntegrationInfo
	if *v == nil {
		sv = make([]types.PartnerIntegrationInfo, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.PartnerIntegrationInfo
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentPartnerIntegrationInfo(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentPartnerNotFoundFault(v **types.PartnerNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.PartnerNotFoundFault
	if *v == nil {
		sv = &types.PartnerNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPauseClusterMessage(v **types.PauseClusterMessage, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.PauseClusterMessage
	if *v == nil {
		sv = &types.PauseClusterMessage{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ClusterIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterIdentifier = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPendingActionsList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPendingActionsListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentPendingModifiedValues(v **types.PendingModifiedValues, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.PendingModifiedValues
	if *v == nil {
		sv = &types.PendingModifiedValues{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AutomatedSnapshotRetentionPeriod", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.AutomatedSnapshotRetentionPeriod = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("ClusterIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterType = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterVersion = ptr.String(xtv)
			}

		case strings.EqualFold("EncryptionType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EncryptionType = ptr.String(xtv)
			}

		case strings.EqualFold("EnhancedVpcRouting", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.EnhancedVpcRouting = ptr.Bool(xtv)
			}

		case strings.EqualFold("MaintenanceTrackName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MaintenanceTrackName = ptr.String(xtv)
			}

		case strings.EqualFold("MasterUserPassword", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MasterUserPassword = ptr.String(xtv)
			}

		case strings.EqualFold("NodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeType = ptr.String(xtv)
			}

		case strings.EqualFold("NumberOfNodes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.NumberOfNodes = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("PubliclyAccessible", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.PubliclyAccessible = ptr.Bool(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRecurringCharge(v **types.RecurringCharge, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.RecurringCharge
	if *v == nil {
		sv = &types.RecurringCharge{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("RecurringChargeAmount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.RecurringChargeAmount = ptr.Float64(f64)
			}

		case strings.EqualFold("RecurringChargeFrequency", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.RecurringChargeFrequency = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRecurringChargeList(v *[]types.RecurringCharge, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.RecurringCharge
	if *v == nil {
		sv = make([]types.RecurringCharge, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("RecurringCharge", t.Name.Local):
			var col types.RecurringCharge
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentRecurringCharge(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRecurringChargeListUnwrapped(v *[]types.RecurringCharge, decoder smithyxml.NodeDecoder) error {
	var sv []types.RecurringCharge
	if *v == nil {
		sv = make([]types.RecurringCharge, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.RecurringCharge
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentRecurringCharge(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentRedshiftIdcApplication(v **types.RedshiftIdcApplication, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.RedshiftIdcApplication
	if *v == nil {
		sv = &types.RedshiftIdcApplication{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AuthorizedTokenIssuerList", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentAuthorizedTokenIssuerList(&sv.AuthorizedTokenIssuerList, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("IamRoleArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IamRoleArn = ptr.String(xtv)
			}

		case strings.EqualFold("IdcDisplayName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IdcDisplayName = ptr.String(xtv)
			}

		case strings.EqualFold("IdcInstanceArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IdcInstanceArn = ptr.String(xtv)
			}

		case strings.EqualFold("IdcManagedApplicationArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IdcManagedApplicationArn = ptr.String(xtv)
			}

		case strings.EqualFold("IdcOnboardStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IdcOnboardStatus = ptr.String(xtv)
			}

		case strings.EqualFold("IdentityNamespace", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IdentityNamespace = ptr.String(xtv)
			}

		case strings.EqualFold("RedshiftIdcApplicationArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.RedshiftIdcApplicationArn = ptr.String(xtv)
			}

		case strings.EqualFold("RedshiftIdcApplicationName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.RedshiftIdcApplicationName = ptr.String(xtv)
			}

		case strings.EqualFold("ServiceIntegrations", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServiceIntegrationList(&sv.ServiceIntegrations, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRedshiftIdcApplicationAlreadyExistsFault(v **types.RedshiftIdcApplicationAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.RedshiftIdcApplicationAlreadyExistsFault
	if *v == nil {
		sv = &types.RedshiftIdcApplicationAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRedshiftIdcApplicationList(v *[]types.RedshiftIdcApplication, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.RedshiftIdcApplication
	if *v == nil {
		sv = make([]types.RedshiftIdcApplication, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.RedshiftIdcApplication
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentRedshiftIdcApplication(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRedshiftIdcApplicationListUnwrapped(v *[]types.RedshiftIdcApplication, decoder smithyxml.NodeDecoder) error {
	var sv []types.RedshiftIdcApplication
	if *v == nil {
		sv = make([]types.RedshiftIdcApplication, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.RedshiftIdcApplication
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentRedshiftIdcApplication(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentRedshiftIdcApplicationNotExistsFault(v **types.RedshiftIdcApplicationNotExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.RedshiftIdcApplicationNotExistsFault
	if *v == nil {
		sv = &types.RedshiftIdcApplicationNotExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRedshiftIdcApplicationQuotaExceededFault(v **types.RedshiftIdcApplicationQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.RedshiftIdcApplicationQuotaExceededFault
	if *v == nil {
		sv = &types.RedshiftIdcApplicationQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNode(v **types.ReservedNode, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedNode
	if *v == nil {
		sv = &types.ReservedNode{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CurrencyCode", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CurrencyCode = ptr.String(xtv)
			}

		case strings.EqualFold("Duration", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Duration = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("FixedPrice", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.FixedPrice = ptr.Float64(f64)
			}

		case strings.EqualFold("NodeCount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.NodeCount = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("NodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeType = ptr.String(xtv)
			}

		case strings.EqualFold("OfferingType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.OfferingType = ptr.String(xtv)
			}

		case strings.EqualFold("RecurringCharges", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentRecurringChargeList(&sv.RecurringCharges, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ReservedNodeId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReservedNodeId = ptr.String(xtv)
			}

		case strings.EqualFold("ReservedNodeOfferingId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReservedNodeOfferingId = ptr.String(xtv)
			}

		case strings.EqualFold("ReservedNodeOfferingType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReservedNodeOfferingType = types.ReservedNodeOfferingType(xtv)
			}

		case strings.EqualFold("StartTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.StartTime = ptr.Time(t)
			}

		case strings.EqualFold("State", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.State = ptr.String(xtv)
			}

		case strings.EqualFold("UsagePrice", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.UsagePrice = ptr.Float64(f64)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeAlreadyExistsFault(v **types.ReservedNodeAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedNodeAlreadyExistsFault
	if *v == nil {
		sv = &types.ReservedNodeAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeAlreadyMigratedFault(v **types.ReservedNodeAlreadyMigratedFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedNodeAlreadyMigratedFault
	if *v == nil {
		sv = &types.ReservedNodeAlreadyMigratedFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeConfigurationOption(v **types.ReservedNodeConfigurationOption, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedNodeConfigurationOption
	if *v == nil {
		sv = &types.ReservedNodeConfigurationOption{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("SourceReservedNode", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReservedNode(&sv.SourceReservedNode, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("TargetReservedNodeCount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.TargetReservedNodeCount = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("TargetReservedNodeOffering", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReservedNodeOffering(&sv.TargetReservedNodeOffering, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeConfigurationOptionList(v *[]types.ReservedNodeConfigurationOption, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ReservedNodeConfigurationOption
	if *v == nil {
		sv = make([]types.ReservedNodeConfigurationOption, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ReservedNodeConfigurationOption", t.Name.Local):
			var col types.ReservedNodeConfigurationOption
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentReservedNodeConfigurationOption(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeConfigurationOptionListUnwrapped(v *[]types.ReservedNodeConfigurationOption, decoder smithyxml.NodeDecoder) error {
	var sv []types.ReservedNodeConfigurationOption
	if *v == nil {
		sv = make([]types.ReservedNodeConfigurationOption, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ReservedNodeConfigurationOption
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentReservedNodeConfigurationOption(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentReservedNodeExchangeNotFoundFault(v **types.ReservedNodeExchangeNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedNodeExchangeNotFoundFault
	if *v == nil {
		sv = &types.ReservedNodeExchangeNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeExchangeStatus(v **types.ReservedNodeExchangeStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedNodeExchangeStatus
	if *v == nil {
		sv = &types.ReservedNodeExchangeStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("RequestTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.RequestTime = ptr.Time(t)
			}

		case strings.EqualFold("ReservedNodeExchangeRequestId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReservedNodeExchangeRequestId = ptr.String(xtv)
			}

		case strings.EqualFold("SourceReservedNodeCount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.SourceReservedNodeCount = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("SourceReservedNodeId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SourceReservedNodeId = ptr.String(xtv)
			}

		case strings.EqualFold("SourceReservedNodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SourceReservedNodeType = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = types.ReservedNodeExchangeStatusType(xtv)
			}

		case strings.EqualFold("TargetReservedNodeCount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.TargetReservedNodeCount = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("TargetReservedNodeOfferingId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TargetReservedNodeOfferingId = ptr.String(xtv)
			}

		case strings.EqualFold("TargetReservedNodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TargetReservedNodeType = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeExchangeStatusList(v *[]types.ReservedNodeExchangeStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ReservedNodeExchangeStatus
	if *v == nil {
		sv = make([]types.ReservedNodeExchangeStatus, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ReservedNodeExchangeStatus", t.Name.Local):
			var col types.ReservedNodeExchangeStatus
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentReservedNodeExchangeStatus(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeExchangeStatusListUnwrapped(v *[]types.ReservedNodeExchangeStatus, decoder smithyxml.NodeDecoder) error {
	var sv []types.ReservedNodeExchangeStatus
	if *v == nil {
		sv = make([]types.ReservedNodeExchangeStatus, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ReservedNodeExchangeStatus
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentReservedNodeExchangeStatus(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentReservedNodeList(v *[]types.ReservedNode, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ReservedNode
	if *v == nil {
		sv = make([]types.ReservedNode, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ReservedNode", t.Name.Local):
			var col types.ReservedNode
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentReservedNode(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeListUnwrapped(v *[]types.ReservedNode, decoder smithyxml.NodeDecoder) error {
	var sv []types.ReservedNode
	if *v == nil {
		sv = make([]types.ReservedNode, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ReservedNode
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentReservedNode(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentReservedNodeNotFoundFault(v **types.ReservedNodeNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedNodeNotFoundFault
	if *v == nil {
		sv = &types.ReservedNodeNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeOffering(v **types.ReservedNodeOffering, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedNodeOffering
	if *v == nil {
		sv = &types.ReservedNodeOffering{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CurrencyCode", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CurrencyCode = ptr.String(xtv)
			}

		case strings.EqualFold("Duration", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Duration = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("FixedPrice", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.FixedPrice = ptr.Float64(f64)
			}

		case strings.EqualFold("NodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeType = ptr.String(xtv)
			}

		case strings.EqualFold("OfferingType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.OfferingType = ptr.String(xtv)
			}

		case strings.EqualFold("RecurringCharges", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentRecurringChargeList(&sv.RecurringCharges, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ReservedNodeOfferingId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReservedNodeOfferingId = ptr.String(xtv)
			}

		case strings.EqualFold("ReservedNodeOfferingType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReservedNodeOfferingType = types.ReservedNodeOfferingType(xtv)
			}

		case strings.EqualFold("UsagePrice", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.UsagePrice = ptr.Float64(f64)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeOfferingList(v *[]types.ReservedNodeOffering, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ReservedNodeOffering
	if *v == nil {
		sv = make([]types.ReservedNodeOffering, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ReservedNodeOffering", t.Name.Local):
			var col types.ReservedNodeOffering
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentReservedNodeOffering(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeOfferingListUnwrapped(v *[]types.ReservedNodeOffering, decoder smithyxml.NodeDecoder) error {
	var sv []types.ReservedNodeOffering
	if *v == nil {
		sv = make([]types.ReservedNodeOffering, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ReservedNodeOffering
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentReservedNodeOffering(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentReservedNodeOfferingNotFoundFault(v **types.ReservedNodeOfferingNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedNodeOfferingNotFoundFault
	if *v == nil {
		sv = &types.ReservedNodeOfferingNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedNodeQuotaExceededFault(v **types.ReservedNodeQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedNodeQuotaExceededFault
	if *v == nil {
		sv = &types.ReservedNodeQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentResizeClusterMessage(v **types.ResizeClusterMessage, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ResizeClusterMessage
	if *v == nil {
		sv = &types.ResizeClusterMessage{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Classic", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.Classic = ptr.Bool(xtv)
			}

		case strings.EqualFold("ClusterIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterType = ptr.String(xtv)
			}

		case strings.EqualFold("NodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeType = ptr.String(xtv)
			}

		case strings.EqualFold("NumberOfNodes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.NumberOfNodes = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("ReservedNodeId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReservedNodeId = ptr.String(xtv)
			}

		case strings.EqualFold("TargetReservedNodeOfferingId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TargetReservedNodeOfferingId = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentResizeInfo(v **types.ResizeInfo, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ResizeInfo
	if *v == nil {
		sv = &types.ResizeInfo{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AllowCancelResize", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.AllowCancelResize = ptr.Bool(xtv)
			}

		case strings.EqualFold("ResizeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ResizeType = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentResizeNotFoundFault(v **types.ResizeNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ResizeNotFoundFault
	if *v == nil {
		sv = &types.ResizeNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentResourceNotFoundFault(v **types.ResourceNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ResourceNotFoundFault
	if *v == nil {
		sv = &types.ResourceNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentResourcePolicy(v **types.ResourcePolicy, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ResourcePolicy
	if *v == nil {
		sv = &types.ResourcePolicy{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Policy", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Policy = ptr.String(xtv)
			}

		case strings.EqualFold("ResourceArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ResourceArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRestorableNodeTypeList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("NodeType", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRestorableNodeTypeListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentRestoreStatus(v **types.RestoreStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.RestoreStatus
	if *v == nil {
		sv = &types.RestoreStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CurrentRestoreRateInMegaBytesPerSecond", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.CurrentRestoreRateInMegaBytesPerSecond = ptr.Float64(f64)
			}

		case strings.EqualFold("ElapsedTimeInSeconds", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.ElapsedTimeInSeconds = ptr.Int64(i64)
			}

		case strings.EqualFold("EstimatedTimeToCompletionInSeconds", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.EstimatedTimeToCompletionInSeconds = ptr.Int64(i64)
			}

		case strings.EqualFold("ProgressInMegaBytes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.ProgressInMegaBytes = ptr.Int64(i64)
			}

		case strings.EqualFold("SnapshotSizeInMegaBytes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.SnapshotSizeInMegaBytes = ptr.Int64(i64)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentResumeClusterMessage(v **types.ResumeClusterMessage, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ResumeClusterMessage
	if *v == nil {
		sv = &types.ResumeClusterMessage{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ClusterIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterIdentifier = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRevisionTarget(v **types.RevisionTarget, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.RevisionTarget
	if *v == nil {
		sv = &types.RevisionTarget{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("DatabaseRevision", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DatabaseRevision = ptr.String(xtv)
			}

		case strings.EqualFold("DatabaseRevisionReleaseDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.DatabaseRevisionReleaseDate = ptr.Time(t)
			}

		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRevisionTargetsList(v *[]types.RevisionTarget, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.RevisionTarget
	if *v == nil {
		sv = make([]types.RevisionTarget, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("RevisionTarget", t.Name.Local):
			var col types.RevisionTarget
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentRevisionTarget(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRevisionTargetsListUnwrapped(v *[]types.RevisionTarget, decoder smithyxml.NodeDecoder) error {
	var sv []types.RevisionTarget
	if *v == nil {
		sv = make([]types.RevisionTarget, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.RevisionTarget
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentRevisionTarget(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentScheduledAction(v **types.ScheduledAction, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ScheduledAction
	if *v == nil {
		sv = &types.ScheduledAction{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("EndTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.EndTime = ptr.Time(t)
			}

		case strings.EqualFold("IamRole", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IamRole = ptr.String(xtv)
			}

		case strings.EqualFold("NextInvocations", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentScheduledActionTimeList(&sv.NextInvocations, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Schedule", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Schedule = ptr.String(xtv)
			}

		case strings.EqualFold("ScheduledActionDescription", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ScheduledActionDescription = ptr.String(xtv)
			}

		case strings.EqualFold("ScheduledActionName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ScheduledActionName = ptr.String(xtv)
			}

		case strings.EqualFold("StartTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.StartTime = ptr.Time(t)
			}

		case strings.EqualFold("State", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.State = types.ScheduledActionState(xtv)
			}

		case strings.EqualFold("TargetAction", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentScheduledActionType(&sv.TargetAction, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentScheduledActionAlreadyExistsFault(v **types.ScheduledActionAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ScheduledActionAlreadyExistsFault
	if *v == nil {
		sv = &types.ScheduledActionAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentScheduledActionList(v *[]types.ScheduledAction, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ScheduledAction
	if *v == nil {
		sv = make([]types.ScheduledAction, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ScheduledAction", t.Name.Local):
			var col types.ScheduledAction
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentScheduledAction(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentScheduledActionListUnwrapped(v *[]types.ScheduledAction, decoder smithyxml.NodeDecoder) error {
	var sv []types.ScheduledAction
	if *v == nil {
		sv = make([]types.ScheduledAction, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ScheduledAction
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentScheduledAction(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentScheduledActionNotFoundFault(v **types.ScheduledActionNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ScheduledActionNotFoundFault
	if *v == nil {
		sv = &types.ScheduledActionNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentScheduledActionQuotaExceededFault(v **types.ScheduledActionQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ScheduledActionQuotaExceededFault
	if *v == nil {
		sv = &types.ScheduledActionQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Loca