//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcdn_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cdn/armcdn/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/EdgeNodes_List.json
func ExampleEdgeNodesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEdgeNodesClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EdgenodeResult = armcdn.EdgenodeResult{
		// 	Value: []*armcdn.EdgeNode{
		// 		{
		// 			Name: to.Ptr("Standard_Verizon"),
		// 			Type: to.Ptr("Microsoft.Cdn/edgenodes"),
		// 			ID: to.Ptr("/providers/Microsoft.Cdn/edgenodes/Standard_Verizon"),
		// 			Properties: &armcdn.EdgeNodeProperties{
		// 				IPAddressGroups: []*armcdn.IPAddressGroup{
		// 					{
		// 						DeliveryRegion: to.Ptr("All"),
		// 						IPv4Addresses: []*armcdn.CidrIPAddress{
		// 							{
		// 								BaseIPAddress: to.Ptr("192.229.176.0"),
		// 								PrefixLength: to.Ptr[int32](24),
		// 							},
		// 							{
		// 								BaseIPAddress: to.Ptr("180.240.184.128"),
		// 								PrefixLength: to.Ptr[int32](25),
		// 							},
		// 							{
		// 								BaseIPAddress: to.Ptr("152.195.27.0"),
		// 								PrefixLength: to.Ptr[int32](24),
		// 						}},
		// 						IPv6Addresses: []*armcdn.CidrIPAddress{
		// 							{
		// 								BaseIPAddress: to.Ptr("2606:2800:60f2::"),
		// 								PrefixLength: to.Ptr[int32](48),
		// 							},
		// 							{
		// 								BaseIPAddress: to.Ptr("2606:2800:700c::"),
		// 								PrefixLength: to.Ptr[int32](48),
		// 						}},
		// 				}},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Premium_Verizon"),
		// 			Type: to.Ptr("Microsoft.Cdn/edgenodes"),
		// 			ID: to.Ptr("/providers/Microsoft.Cdn/edgenodes/Premium_Verizon"),
		// 			Properties: &armcdn.EdgeNodeProperties{
		// 				IPAddressGroups: []*armcdn.IPAddressGroup{
		// 					{
		// 						DeliveryRegion: to.Ptr("All"),
		// 						IPv4Addresses: []*armcdn.CidrIPAddress{
		// 							{
		// 								BaseIPAddress: to.Ptr("192.229.176.0"),
		// 								PrefixLength: to.Ptr[int32](24),
		// 							},
		// 							{
		// 								BaseIPAddress: to.Ptr("152.195.27.0"),
		// 								PrefixLength: to.Ptr[int32](24),
		// 						}},
		// 						IPv6Addresses: []*armcdn.CidrIPAddress{
		// 							{
		// 								BaseIPAddress: to.Ptr("2606:2800:60f2::"),
		// 								PrefixLength: to.Ptr[int32](48),
		// 							},
		// 							{
		// 								BaseIPAddress: to.Ptr("2606:2800:700c::"),
		// 								PrefixLength: to.Ptr[int32](48),
		// 						}},
		// 				}},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Custom_Verizon"),
		// 			Type: to.Ptr("Microsoft.Cdn/edgenodes"),
		// 			ID: to.Ptr("/providers/Microsoft.Cdn/edgenodes/Custom_Verizon"),
		// 			Properties: &armcdn.EdgeNodeProperties{
		// 				IPAddressGroups: []*armcdn.IPAddressGroup{
		// 					{
		// 						DeliveryRegion: to.Ptr("All"),
		// 						IPv4Addresses: []*armcdn.CidrIPAddress{
		// 							{
		// 								BaseIPAddress: to.Ptr("192.229.176.0"),
		// 								PrefixLength: to.Ptr[int32](24),
		// 							},
		// 							{
		// 								BaseIPAddress: to.Ptr("2606:2800:420b::"),
		// 								PrefixLength: to.Ptr[int32](48),
		// 							},
		// 							{
		// 								BaseIPAddress: to.Ptr("2606:2800:700c::"),
		// 								PrefixLength: to.Ptr[int32](48),
		// 						}},
		// 				}},
		// 			},
		// 	}},
		// }
	}
}
