//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdomainservices

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ConfigDiagnostics.
func (c ConfigDiagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC1123(objectMap, "lastExecuted", c.LastExecuted)
	populate(objectMap, "validatorResults", c.ValidatorResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigDiagnostics.
func (c *ConfigDiagnostics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastExecuted":
			err = unpopulateDateTimeRFC1123(val, "LastExecuted", &c.LastExecuted)
			delete(rawMsg, key)
		case "validatorResults":
			err = unpopulate(val, "ValidatorResults", &c.ValidatorResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigDiagnosticsValidatorResult.
func (c ConfigDiagnosticsValidatorResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "issues", c.Issues)
	populate(objectMap, "replicaSetSubnetDisplayName", c.ReplicaSetSubnetDisplayName)
	populate(objectMap, "status", c.Status)
	populate(objectMap, "validatorId", c.ValidatorID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigDiagnosticsValidatorResult.
func (c *ConfigDiagnosticsValidatorResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "issues":
			err = unpopulate(val, "Issues", &c.Issues)
			delete(rawMsg, key)
		case "replicaSetSubnetDisplayName":
			err = unpopulate(val, "ReplicaSetSubnetDisplayName", &c.ReplicaSetSubnetDisplayName)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "validatorId":
			err = unpopulate(val, "ValidatorID", &c.ValidatorID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigDiagnosticsValidatorResultIssue.
func (c ConfigDiagnosticsValidatorResultIssue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "descriptionParams", c.DescriptionParams)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigDiagnosticsValidatorResultIssue.
func (c *ConfigDiagnosticsValidatorResultIssue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "descriptionParams":
			err = unpopulate(val, "DescriptionParams", &c.DescriptionParams)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerAccount.
func (c ContainerAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", c.AccountName)
	populate(objectMap, "password", c.Password)
	populate(objectMap, "spn", c.Spn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerAccount.
func (c *ContainerAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &c.AccountName)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &c.Password)
			delete(rawMsg, key)
		case "spn":
			err = unpopulate(val, "Spn", &c.Spn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainSecuritySettings.
func (d DomainSecuritySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kerberosArmoring", d.KerberosArmoring)
	populate(objectMap, "kerberosRc4Encryption", d.KerberosRc4Encryption)
	populate(objectMap, "ntlmV1", d.NtlmV1)
	populate(objectMap, "syncKerberosPasswords", d.SyncKerberosPasswords)
	populate(objectMap, "syncNtlmPasswords", d.SyncNtlmPasswords)
	populate(objectMap, "syncOnPremPasswords", d.SyncOnPremPasswords)
	populate(objectMap, "tlsV1", d.TLSV1)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainSecuritySettings.
func (d *DomainSecuritySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kerberosArmoring":
			err = unpopulate(val, "KerberosArmoring", &d.KerberosArmoring)
			delete(rawMsg, key)
		case "kerberosRc4Encryption":
			err = unpopulate(val, "KerberosRc4Encryption", &d.KerberosRc4Encryption)
			delete(rawMsg, key)
		case "ntlmV1":
			err = unpopulate(val, "NtlmV1", &d.NtlmV1)
			delete(rawMsg, key)
		case "syncKerberosPasswords":
			err = unpopulate(val, "SyncKerberosPasswords", &d.SyncKerberosPasswords)
			delete(rawMsg, key)
		case "syncNtlmPasswords":
			err = unpopulate(val, "SyncNtlmPasswords", &d.SyncNtlmPasswords)
			delete(rawMsg, key)
		case "syncOnPremPasswords":
			err = unpopulate(val, "SyncOnPremPasswords", &d.SyncOnPremPasswords)
			delete(rawMsg, key)
		case "tlsV1":
			err = unpopulate(val, "TLSV1", &d.TLSV1)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainService.
func (d DomainService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainService.
func (d *DomainService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainServiceListResult.
func (d DomainServiceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainServiceListResult.
func (d *DomainServiceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainServiceProperties.
func (d DomainServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configDiagnostics", d.ConfigDiagnostics)
	populate(objectMap, "deploymentId", d.DeploymentID)
	populate(objectMap, "domainConfigurationType", d.DomainConfigurationType)
	populate(objectMap, "domainName", d.DomainName)
	populate(objectMap, "domainSecuritySettings", d.DomainSecuritySettings)
	populate(objectMap, "filteredSync", d.FilteredSync)
	populate(objectMap, "ldapsSettings", d.LdapsSettings)
	populate(objectMap, "migrationProperties", d.MigrationProperties)
	populate(objectMap, "notificationSettings", d.NotificationSettings)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "replicaSets", d.ReplicaSets)
	populate(objectMap, "resourceForestSettings", d.ResourceForestSettings)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "syncOwner", d.SyncOwner)
	populate(objectMap, "tenantId", d.TenantID)
	populate(objectMap, "version", d.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainServiceProperties.
func (d *DomainServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configDiagnostics":
			err = unpopulate(val, "ConfigDiagnostics", &d.ConfigDiagnostics)
			delete(rawMsg, key)
		case "deploymentId":
			err = unpopulate(val, "DeploymentID", &d.DeploymentID)
			delete(rawMsg, key)
		case "domainConfigurationType":
			err = unpopulate(val, "DomainConfigurationType", &d.DomainConfigurationType)
			delete(rawMsg, key)
		case "domainName":
			err = unpopulate(val, "DomainName", &d.DomainName)
			delete(rawMsg, key)
		case "domainSecuritySettings":
			err = unpopulate(val, "DomainSecuritySettings", &d.DomainSecuritySettings)
			delete(rawMsg, key)
		case "filteredSync":
			err = unpopulate(val, "FilteredSync", &d.FilteredSync)
			delete(rawMsg, key)
		case "ldapsSettings":
			err = unpopulate(val, "LdapsSettings", &d.LdapsSettings)
			delete(rawMsg, key)
		case "migrationProperties":
			err = unpopulate(val, "MigrationProperties", &d.MigrationProperties)
			delete(rawMsg, key)
		case "notificationSettings":
			err = unpopulate(val, "NotificationSettings", &d.NotificationSettings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "replicaSets":
			err = unpopulate(val, "ReplicaSets", &d.ReplicaSets)
			delete(rawMsg, key)
		case "resourceForestSettings":
			err = unpopulate(val, "ResourceForestSettings", &d.ResourceForestSettings)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "syncOwner":
			err = unpopulate(val, "SyncOwner", &d.SyncOwner)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &d.TenantID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForestTrust.
func (f ForestTrust) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "friendlyName", f.FriendlyName)
	populate(objectMap, "remoteDnsIps", f.RemoteDNSIPs)
	populate(objectMap, "trustDirection", f.TrustDirection)
	populate(objectMap, "trustPassword", f.TrustPassword)
	populate(objectMap, "trustedDomainFqdn", f.TrustedDomainFqdn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForestTrust.
func (f *ForestTrust) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &f.FriendlyName)
			delete(rawMsg, key)
		case "remoteDnsIps":
			err = unpopulate(val, "RemoteDNSIPs", &f.RemoteDNSIPs)
			delete(rawMsg, key)
		case "trustDirection":
			err = unpopulate(val, "TrustDirection", &f.TrustDirection)
			delete(rawMsg, key)
		case "trustPassword":
			err = unpopulate(val, "TrustPassword", &f.TrustPassword)
			delete(rawMsg, key)
		case "trustedDomainFqdn":
			err = unpopulate(val, "TrustedDomainFqdn", &f.TrustedDomainFqdn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthAlert.
func (h HealthAlert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "issue", h.Issue)
	populateDateTimeRFC3339(objectMap, "lastDetected", h.LastDetected)
	populate(objectMap, "name", h.Name)
	populateDateTimeRFC3339(objectMap, "raised", h.Raised)
	populate(objectMap, "resolutionUri", h.ResolutionURI)
	populate(objectMap, "severity", h.Severity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthAlert.
func (h *HealthAlert) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "issue":
			err = unpopulate(val, "Issue", &h.Issue)
			delete(rawMsg, key)
		case "lastDetected":
			err = unpopulateDateTimeRFC3339(val, "LastDetected", &h.LastDetected)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "raised":
			err = unpopulateDateTimeRFC3339(val, "Raised", &h.Raised)
			delete(rawMsg, key)
		case "resolutionUri":
			err = unpopulate(val, "ResolutionURI", &h.ResolutionURI)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &h.Severity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthMonitor.
func (h HealthMonitor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", h.Details)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthMonitor.
func (h *HealthMonitor) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &h.Details)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LdapsSettings.
func (l LdapsSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "certificateNotAfter", l.CertificateNotAfter)
	populate(objectMap, "certificateThumbprint", l.CertificateThumbprint)
	populate(objectMap, "externalAccess", l.ExternalAccess)
	populate(objectMap, "ldaps", l.Ldaps)
	populate(objectMap, "pfxCertificate", l.PfxCertificate)
	populate(objectMap, "pfxCertificatePassword", l.PfxCertificatePassword)
	populate(objectMap, "publicCertificate", l.PublicCertificate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LdapsSettings.
func (l *LdapsSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateNotAfter":
			err = unpopulateDateTimeRFC3339(val, "CertificateNotAfter", &l.CertificateNotAfter)
			delete(rawMsg, key)
		case "certificateThumbprint":
			err = unpopulate(val, "CertificateThumbprint", &l.CertificateThumbprint)
			delete(rawMsg, key)
		case "externalAccess":
			err = unpopulate(val, "ExternalAccess", &l.ExternalAccess)
			delete(rawMsg, key)
		case "ldaps":
			err = unpopulate(val, "Ldaps", &l.Ldaps)
			delete(rawMsg, key)
		case "pfxCertificate":
			err = unpopulate(val, "PfxCertificate", &l.PfxCertificate)
			delete(rawMsg, key)
		case "pfxCertificatePassword":
			err = unpopulate(val, "PfxCertificatePassword", &l.PfxCertificatePassword)
			delete(rawMsg, key)
		case "publicCertificate":
			err = unpopulate(val, "PublicCertificate", &l.PublicCertificate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationProgress.
func (m MigrationProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completionPercentage", m.CompletionPercentage)
	populate(objectMap, "progressMessage", m.ProgressMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationProgress.
func (m *MigrationProgress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completionPercentage":
			err = unpopulate(val, "CompletionPercentage", &m.CompletionPercentage)
			delete(rawMsg, key)
		case "progressMessage":
			err = unpopulate(val, "ProgressMessage", &m.ProgressMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrationProperties.
func (m MigrationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "migrationProgress", m.MigrationProgress)
	populate(objectMap, "oldSubnetId", m.OldSubnetID)
	populate(objectMap, "oldVnetSiteId", m.OldVnetSiteID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationProperties.
func (m *MigrationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "migrationProgress":
			err = unpopulate(val, "MigrationProgress", &m.MigrationProgress)
			delete(rawMsg, key)
		case "oldSubnetId":
			err = unpopulate(val, "OldSubnetID", &m.OldSubnetID)
			delete(rawMsg, key)
		case "oldVnetSiteId":
			err = unpopulate(val, "OldVnetSiteID", &m.OldVnetSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationSettings.
func (n NotificationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalRecipients", n.AdditionalRecipients)
	populate(objectMap, "notifyDcAdmins", n.NotifyDcAdmins)
	populate(objectMap, "notifyGlobalAdmins", n.NotifyGlobalAdmins)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationSettings.
func (n *NotificationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalRecipients":
			err = unpopulate(val, "AdditionalRecipients", &n.AdditionalRecipients)
			delete(rawMsg, key)
		case "notifyDcAdmins":
			err = unpopulate(val, "NotifyDcAdmins", &n.NotifyDcAdmins)
			delete(rawMsg, key)
		case "notifyGlobalAdmins":
			err = unpopulate(val, "NotifyGlobalAdmins", &n.NotifyGlobalAdmins)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplayInfo.
func (o OperationDisplayInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplayInfo.
func (o *OperationDisplayInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationEntity.
func (o OperationEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationEntity.
func (o *OperationEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationEntityListResult.
func (o OperationEntityListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationEntityListResult.
func (o *OperationEntityListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OuContainer.
func (o OuContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", o.Etag)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "location", o.Location)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "tags", o.Tags)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OuContainer.
func (o *OuContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &o.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &o.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &o.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &o.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OuContainerListResult.
func (o OuContainerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OuContainerListResult.
func (o *OuContainerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OuContainerProperties.
func (o OuContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accounts", o.Accounts)
	populate(objectMap, "containerId", o.ContainerID)
	populate(objectMap, "deploymentId", o.DeploymentID)
	populate(objectMap, "distinguishedName", o.DistinguishedName)
	populate(objectMap, "domainName", o.DomainName)
	populate(objectMap, "provisioningState", o.ProvisioningState)
	populate(objectMap, "serviceStatus", o.ServiceStatus)
	populate(objectMap, "tenantId", o.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OuContainerProperties.
func (o *OuContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accounts":
			err = unpopulate(val, "Accounts", &o.Accounts)
			delete(rawMsg, key)
		case "containerId":
			err = unpopulate(val, "ContainerID", &o.ContainerID)
			delete(rawMsg, key)
		case "deploymentId":
			err = unpopulate(val, "DeploymentID", &o.DeploymentID)
			delete(rawMsg, key)
		case "distinguishedName":
			err = unpopulate(val, "DistinguishedName", &o.DistinguishedName)
			delete(rawMsg, key)
		case "domainName":
			err = unpopulate(val, "DomainName", &o.DomainName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &o.ProvisioningState)
			delete(rawMsg, key)
		case "serviceStatus":
			err = unpopulate(val, "ServiceStatus", &o.ServiceStatus)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &o.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicaSet.
func (r ReplicaSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainControllerIpAddress", r.DomainControllerIPAddress)
	populate(objectMap, "externalAccessIpAddress", r.ExternalAccessIPAddress)
	populate(objectMap, "healthAlerts", r.HealthAlerts)
	populateDateTimeRFC1123(objectMap, "healthLastEvaluated", r.HealthLastEvaluated)
	populate(objectMap, "healthMonitors", r.HealthMonitors)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "replicaSetId", r.ReplicaSetID)
	populate(objectMap, "serviceStatus", r.ServiceStatus)
	populate(objectMap, "subnetId", r.SubnetID)
	populate(objectMap, "vnetSiteId", r.VnetSiteID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicaSet.
func (r *ReplicaSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainControllerIpAddress":
			err = unpopulate(val, "DomainControllerIPAddress", &r.DomainControllerIPAddress)
			delete(rawMsg, key)
		case "externalAccessIpAddress":
			err = unpopulate(val, "ExternalAccessIPAddress", &r.ExternalAccessIPAddress)
			delete(rawMsg, key)
		case "healthAlerts":
			err = unpopulate(val, "HealthAlerts", &r.HealthAlerts)
			delete(rawMsg, key)
		case "healthLastEvaluated":
			err = unpopulateDateTimeRFC1123(val, "HealthLastEvaluated", &r.HealthLastEvaluated)
			delete(rawMsg, key)
		case "healthMonitors":
			err = unpopulate(val, "HealthMonitors", &r.HealthMonitors)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "replicaSetId":
			err = unpopulate(val, "ReplicaSetID", &r.ReplicaSetID)
			delete(rawMsg, key)
		case "serviceStatus":
			err = unpopulate(val, "ServiceStatus", &r.ServiceStatus)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &r.SubnetID)
			delete(rawMsg, key)
		case "vnetSiteId":
			err = unpopulate(val, "VnetSiteID", &r.VnetSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceForestSettings.
func (r ResourceForestSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceForest", r.ResourceForest)
	populate(objectMap, "settings", r.Settings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceForestSettings.
func (r *ResourceForestSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceForest":
			err = unpopulate(val, "ResourceForest", &r.ResourceForest)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &r.Settings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
