//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armlogic.ClientFactory type.
type ServerFactory struct {
	IntegrationAccountAgreementsServer                      IntegrationAccountAgreementsServer
	IntegrationAccountAssembliesServer                      IntegrationAccountAssembliesServer
	IntegrationAccountBatchConfigurationsServer             IntegrationAccountBatchConfigurationsServer
	IntegrationAccountCertificatesServer                    IntegrationAccountCertificatesServer
	IntegrationAccountMapsServer                            IntegrationAccountMapsServer
	IntegrationAccountPartnersServer                        IntegrationAccountPartnersServer
	IntegrationAccountSchemasServer                         IntegrationAccountSchemasServer
	IntegrationAccountSessionsServer                        IntegrationAccountSessionsServer
	IntegrationAccountsServer                               IntegrationAccountsServer
	IntegrationServiceEnvironmentManagedAPIOperationsServer IntegrationServiceEnvironmentManagedAPIOperationsServer
	IntegrationServiceEnvironmentManagedApisServer          IntegrationServiceEnvironmentManagedApisServer
	IntegrationServiceEnvironmentNetworkHealthServer        IntegrationServiceEnvironmentNetworkHealthServer
	IntegrationServiceEnvironmentSKUsServer                 IntegrationServiceEnvironmentSKUsServer
	IntegrationServiceEnvironmentsServer                    IntegrationServiceEnvironmentsServer
	OperationsServer                                        OperationsServer
	WorkflowRunActionRepetitionsServer                      WorkflowRunActionRepetitionsServer
	WorkflowRunActionRepetitionsRequestHistoriesServer      WorkflowRunActionRepetitionsRequestHistoriesServer
	WorkflowRunActionRequestHistoriesServer                 WorkflowRunActionRequestHistoriesServer
	WorkflowRunActionScopeRepetitionsServer                 WorkflowRunActionScopeRepetitionsServer
	WorkflowRunActionsServer                                WorkflowRunActionsServer
	WorkflowRunOperationsServer                             WorkflowRunOperationsServer
	WorkflowRunsServer                                      WorkflowRunsServer
	WorkflowTriggerHistoriesServer                          WorkflowTriggerHistoriesServer
	WorkflowTriggersServer                                  WorkflowTriggersServer
	WorkflowVersionTriggersServer                           WorkflowVersionTriggersServer
	WorkflowVersionsServer                                  WorkflowVersionsServer
	WorkflowsServer                                         WorkflowsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armlogic.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armlogic.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                                       *ServerFactory
	trMu                                                      sync.Mutex
	trIntegrationAccountAgreementsServer                      *IntegrationAccountAgreementsServerTransport
	trIntegrationAccountAssembliesServer                      *IntegrationAccountAssembliesServerTransport
	trIntegrationAccountBatchConfigurationsServer             *IntegrationAccountBatchConfigurationsServerTransport
	trIntegrationAccountCertificatesServer                    *IntegrationAccountCertificatesServerTransport
	trIntegrationAccountMapsServer                            *IntegrationAccountMapsServerTransport
	trIntegrationAccountPartnersServer                        *IntegrationAccountPartnersServerTransport
	trIntegrationAccountSchemasServer                         *IntegrationAccountSchemasServerTransport
	trIntegrationAccountSessionsServer                        *IntegrationAccountSessionsServerTransport
	trIntegrationAccountsServer                               *IntegrationAccountsServerTransport
	trIntegrationServiceEnvironmentManagedAPIOperationsServer *IntegrationServiceEnvironmentManagedAPIOperationsServerTransport
	trIntegrationServiceEnvironmentManagedApisServer          *IntegrationServiceEnvironmentManagedApisServerTransport
	trIntegrationServiceEnvironmentNetworkHealthServer        *IntegrationServiceEnvironmentNetworkHealthServerTransport
	trIntegrationServiceEnvironmentSKUsServer                 *IntegrationServiceEnvironmentSKUsServerTransport
	trIntegrationServiceEnvironmentsServer                    *IntegrationServiceEnvironmentsServerTransport
	trOperationsServer                                        *OperationsServerTransport
	trWorkflowRunActionRepetitionsServer                      *WorkflowRunActionRepetitionsServerTransport
	trWorkflowRunActionRepetitionsRequestHistoriesServer      *WorkflowRunActionRepetitionsRequestHistoriesServerTransport
	trWorkflowRunActionRequestHistoriesServer                 *WorkflowRunActionRequestHistoriesServerTransport
	trWorkflowRunActionScopeRepetitionsServer                 *WorkflowRunActionScopeRepetitionsServerTransport
	trWorkflowRunActionsServer                                *WorkflowRunActionsServerTransport
	trWorkflowRunOperationsServer                             *WorkflowRunOperationsServerTransport
	trWorkflowRunsServer                                      *WorkflowRunsServerTransport
	trWorkflowTriggerHistoriesServer                          *WorkflowTriggerHistoriesServerTransport
	trWorkflowTriggersServer                                  *WorkflowTriggersServerTransport
	trWorkflowVersionTriggersServer                           *WorkflowVersionTriggersServerTransport
	trWorkflowVersionsServer                                  *WorkflowVersionsServerTransport
	trWorkflowsServer                                         *WorkflowsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "IntegrationAccountAgreementsClient":
		initServer(s, &s.trIntegrationAccountAgreementsServer, func() *IntegrationAccountAgreementsServerTransport {
			return NewIntegrationAccountAgreementsServerTransport(&s.srv.IntegrationAccountAgreementsServer)
		})
		resp, err = s.trIntegrationAccountAgreementsServer.Do(req)
	case "IntegrationAccountAssembliesClient":
		initServer(s, &s.trIntegrationAccountAssembliesServer, func() *IntegrationAccountAssembliesServerTransport {
			return NewIntegrationAccountAssembliesServerTransport(&s.srv.IntegrationAccountAssembliesServer)
		})
		resp, err = s.trIntegrationAccountAssembliesServer.Do(req)
	case "IntegrationAccountBatchConfigurationsClient":
		initServer(s, &s.trIntegrationAccountBatchConfigurationsServer, func() *IntegrationAccountBatchConfigurationsServerTransport {
			return NewIntegrationAccountBatchConfigurationsServerTransport(&s.srv.IntegrationAccountBatchConfigurationsServer)
		})
		resp, err = s.trIntegrationAccountBatchConfigurationsServer.Do(req)
	case "IntegrationAccountCertificatesClient":
		initServer(s, &s.trIntegrationAccountCertificatesServer, func() *IntegrationAccountCertificatesServerTransport {
			return NewIntegrationAccountCertificatesServerTransport(&s.srv.IntegrationAccountCertificatesServer)
		})
		resp, err = s.trIntegrationAccountCertificatesServer.Do(req)
	case "IntegrationAccountMapsClient":
		initServer(s, &s.trIntegrationAccountMapsServer, func() *IntegrationAccountMapsServerTransport {
			return NewIntegrationAccountMapsServerTransport(&s.srv.IntegrationAccountMapsServer)
		})
		resp, err = s.trIntegrationAccountMapsServer.Do(req)
	case "IntegrationAccountPartnersClient":
		initServer(s, &s.trIntegrationAccountPartnersServer, func() *IntegrationAccountPartnersServerTransport {
			return NewIntegrationAccountPartnersServerTransport(&s.srv.IntegrationAccountPartnersServer)
		})
		resp, err = s.trIntegrationAccountPartnersServer.Do(req)
	case "IntegrationAccountSchemasClient":
		initServer(s, &s.trIntegrationAccountSchemasServer, func() *IntegrationAccountSchemasServerTransport {
			return NewIntegrationAccountSchemasServerTransport(&s.srv.IntegrationAccountSchemasServer)
		})
		resp, err = s.trIntegrationAccountSchemasServer.Do(req)
	case "IntegrationAccountSessionsClient":
		initServer(s, &s.trIntegrationAccountSessionsServer, func() *IntegrationAccountSessionsServerTransport {
			return NewIntegrationAccountSessionsServerTransport(&s.srv.IntegrationAccountSessionsServer)
		})
		resp, err = s.trIntegrationAccountSessionsServer.Do(req)
	case "IntegrationAccountsClient":
		initServer(s, &s.trIntegrationAccountsServer, func() *IntegrationAccountsServerTransport {
			return NewIntegrationAccountsServerTransport(&s.srv.IntegrationAccountsServer)
		})
		resp, err = s.trIntegrationAccountsServer.Do(req)
	case "IntegrationServiceEnvironmentManagedAPIOperationsClient":
		initServer(s, &s.trIntegrationServiceEnvironmentManagedAPIOperationsServer, func() *IntegrationServiceEnvironmentManagedAPIOperationsServerTransport {
			return NewIntegrationServiceEnvironmentManagedAPIOperationsServerTransport(&s.srv.IntegrationServiceEnvironmentManagedAPIOperationsServer)
		})
		resp, err = s.trIntegrationServiceEnvironmentManagedAPIOperationsServer.Do(req)
	case "IntegrationServiceEnvironmentManagedApisClient":
		initServer(s, &s.trIntegrationServiceEnvironmentManagedApisServer, func() *IntegrationServiceEnvironmentManagedApisServerTransport {
			return NewIntegrationServiceEnvironmentManagedApisServerTransport(&s.srv.IntegrationServiceEnvironmentManagedApisServer)
		})
		resp, err = s.trIntegrationServiceEnvironmentManagedApisServer.Do(req)
	case "IntegrationServiceEnvironmentNetworkHealthClient":
		initServer(s, &s.trIntegrationServiceEnvironmentNetworkHealthServer, func() *IntegrationServiceEnvironmentNetworkHealthServerTransport {
			return NewIntegrationServiceEnvironmentNetworkHealthServerTransport(&s.srv.IntegrationServiceEnvironmentNetworkHealthServer)
		})
		resp, err = s.trIntegrationServiceEnvironmentNetworkHealthServer.Do(req)
	case "IntegrationServiceEnvironmentSKUsClient":
		initServer(s, &s.trIntegrationServiceEnvironmentSKUsServer, func() *IntegrationServiceEnvironmentSKUsServerTransport {
			return NewIntegrationServiceEnvironmentSKUsServerTransport(&s.srv.IntegrationServiceEnvironmentSKUsServer)
		})
		resp, err = s.trIntegrationServiceEnvironmentSKUsServer.Do(req)
	case "IntegrationServiceEnvironmentsClient":
		initServer(s, &s.trIntegrationServiceEnvironmentsServer, func() *IntegrationServiceEnvironmentsServerTransport {
			return NewIntegrationServiceEnvironmentsServerTransport(&s.srv.IntegrationServiceEnvironmentsServer)
		})
		resp, err = s.trIntegrationServiceEnvironmentsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "WorkflowRunActionRepetitionsClient":
		initServer(s, &s.trWorkflowRunActionRepetitionsServer, func() *WorkflowRunActionRepetitionsServerTransport {
			return NewWorkflowRunActionRepetitionsServerTransport(&s.srv.WorkflowRunActionRepetitionsServer)
		})
		resp, err = s.trWorkflowRunActionRepetitionsServer.Do(req)
	case "WorkflowRunActionRepetitionsRequestHistoriesClient":
		initServer(s, &s.trWorkflowRunActionRepetitionsRequestHistoriesServer, func() *WorkflowRunActionRepetitionsRequestHistoriesServerTransport {
			return NewWorkflowRunActionRepetitionsRequestHistoriesServerTransport(&s.srv.WorkflowRunActionRepetitionsRequestHistoriesServer)
		})
		resp, err = s.trWorkflowRunActionRepetitionsRequestHistoriesServer.Do(req)
	case "WorkflowRunActionRequestHistoriesClient":
		initServer(s, &s.trWorkflowRunActionRequestHistoriesServer, func() *WorkflowRunActionRequestHistoriesServerTransport {
			return NewWorkflowRunActionRequestHistoriesServerTransport(&s.srv.WorkflowRunActionRequestHistoriesServer)
		})
		resp, err = s.trWorkflowRunActionRequestHistoriesServer.Do(req)
	case "WorkflowRunActionScopeRepetitionsClient":
		initServer(s, &s.trWorkflowRunActionScopeRepetitionsServer, func() *WorkflowRunActionScopeRepetitionsServerTransport {
			return NewWorkflowRunActionScopeRepetitionsServerTransport(&s.srv.WorkflowRunActionScopeRepetitionsServer)
		})
		resp, err = s.trWorkflowRunActionScopeRepetitionsServer.Do(req)
	case "WorkflowRunActionsClient":
		initServer(s, &s.trWorkflowRunActionsServer, func() *WorkflowRunActionsServerTransport {
			return NewWorkflowRunActionsServerTransport(&s.srv.WorkflowRunActionsServer)
		})
		resp, err = s.trWorkflowRunActionsServer.Do(req)
	case "WorkflowRunOperationsClient":
		initServer(s, &s.trWorkflowRunOperationsServer, func() *WorkflowRunOperationsServerTransport {
			return NewWorkflowRunOperationsServerTransport(&s.srv.WorkflowRunOperationsServer)
		})
		resp, err = s.trWorkflowRunOperationsServer.Do(req)
	case "WorkflowRunsClient":
		initServer(s, &s.trWorkflowRunsServer, func() *WorkflowRunsServerTransport { return NewWorkflowRunsServerTransport(&s.srv.WorkflowRunsServer) })
		resp, err = s.trWorkflowRunsServer.Do(req)
	case "WorkflowTriggerHistoriesClient":
		initServer(s, &s.trWorkflowTriggerHistoriesServer, func() *WorkflowTriggerHistoriesServerTransport {
			return NewWorkflowTriggerHistoriesServerTransport(&s.srv.WorkflowTriggerHistoriesServer)
		})
		resp, err = s.trWorkflowTriggerHistoriesServer.Do(req)
	case "WorkflowTriggersClient":
		initServer(s, &s.trWorkflowTriggersServer, func() *WorkflowTriggersServerTransport {
			return NewWorkflowTriggersServerTransport(&s.srv.WorkflowTriggersServer)
		})
		resp, err = s.trWorkflowTriggersServer.Do(req)
	case "WorkflowVersionTriggersClient":
		initServer(s, &s.trWorkflowVersionTriggersServer, func() *WorkflowVersionTriggersServerTransport {
			return NewWorkflowVersionTriggersServerTransport(&s.srv.WorkflowVersionTriggersServer)
		})
		resp, err = s.trWorkflowVersionTriggersServer.Do(req)
	case "WorkflowVersionsClient":
		initServer(s, &s.trWorkflowVersionsServer, func() *WorkflowVersionsServerTransport {
			return NewWorkflowVersionsServerTransport(&s.srv.WorkflowVersionsServer)
		})
		resp, err = s.trWorkflowVersionsServer.Do(req)
	case "WorkflowsClient":
		initServer(s, &s.trWorkflowsServer, func() *WorkflowsServerTransport { return NewWorkflowsServerTransport(&s.srv.WorkflowsServer) })
		resp, err = s.trWorkflowsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
