//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpanngfw

import "time"

// AdvSecurityObjectListResponse - advanced security object
type AdvSecurityObjectListResponse struct {
	// REQUIRED; response value
	Value *AdvSecurityObjectModel

	// next link
	NextLink *string
}

// AdvSecurityObjectModel - List of custom and predefined url category
type AdvSecurityObjectModel struct {
	// REQUIRED; URL entry
	Entry []*NameDescriptionObject

	// type of object
	Type *string
}

// AppSeenData - Data Type for App Seen
type AppSeenData struct {
	// REQUIRED; array of appSeen
	AppSeenList []*AppSeenInfo

	// REQUIRED; number of rows
	Count *int32
}

// AppSeenInfo - Definition for App Seen
type AppSeenInfo struct {
	// REQUIRED; category
	Category *string

	// REQUIRED; risk
	Risk *string

	// REQUIRED; standardPorts
	StandardPorts *string

	// REQUIRED; subCategory
	SubCategory *string

	// REQUIRED; tag
	Tag *string

	// REQUIRED; technology
	Technology *string

	// REQUIRED; title
	Title *string
}

// ApplicationInsights - Application Insights key
type ApplicationInsights struct {
	// Resource id for Application Insights
	ID *string

	// Application Insights key
	Key *string
}

// AzureResourceManagerManagedIdentityProperties - The properties of the managed service identities assigned to this resource.
type AzureResourceManagerManagedIdentityProperties struct {
	// REQUIRED; The type of managed identity assigned to this resource.
	Type *ManagedIdentityType

	// The identities assigned to this resource by the user.
	UserAssignedIdentities map[string]*AzureResourceManagerUserAssignedIdentity

	// READ-ONLY; The active directory identifier of this principal.
	PrincipalID *string

	// READ-ONLY; The Active Directory tenant id of the principal.
	TenantID *string
}

// AzureResourceManagerUserAssignedIdentity - A managed identity assigned by the user.
type AzureResourceManagerUserAssignedIdentity struct {
	// The active directory client identifier for this principal.
	ClientID *string

	// The active directory identifier for this principal.
	PrincipalID *string
}

// Category - URL/EDL to match
type Category struct {
	// REQUIRED; feed list
	Feeds []*string

	// REQUIRED; custom URL
	URLCustom []*string
}

// CertificateObject - certificate used for inbound and outbound decryption
type CertificateObject struct {
	// REQUIRED; use certificate self signed
	CertificateSelfSigned *BooleanEnum

	// comment for this object
	AuditComment *string

	// Resource Id of certificate signer, to be populated only when certificateSelfSigned is false
	CertificateSignerResourceID *string

	// user description for this object
	Description *string

	// read only string representing last create or update
	Etag *string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// CertificateObjectGlobalRulestackResource - GlobalRulestack Certificate Object
type CertificateObjectGlobalRulestackResource struct {
	// REQUIRED; The resource-specific properties for this resource.
	Properties *CertificateObject

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CertificateObjectGlobalRulestackResourceListResult - The response of a CertificateObjectGlobalRulestackResource list operation.
type CertificateObjectGlobalRulestackResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*CertificateObjectGlobalRulestackResource

	// The link to the next page of items
	NextLink *string
}

// CertificateObjectLocalRulestackResource - LocalRulestack Certificate Object
type CertificateObjectLocalRulestackResource struct {
	// REQUIRED; The resource-specific properties for this resource.
	Properties *CertificateObject

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CertificateObjectLocalRulestackResourceListResult - The response of a CertificateObjectLocalRulestackResource list operation.
type CertificateObjectLocalRulestackResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*CertificateObjectLocalRulestackResource

	// The link to the next page of items
	NextLink *string
}

// Changelog list
type Changelog struct {
	// REQUIRED; list of changes
	Changes []*string

	// lastCommitted timestamp
	LastCommitted *time.Time

	// lastModified timestamp
	LastModified *time.Time
}

// CountriesResponse - Countries Response Object
type CountriesResponse struct {
	// REQUIRED; List of countries
	Value []*Country

	// next link
	NextLink *string
}

// Country Description
type Country struct {
	// REQUIRED; country code
	Code *string

	// code description
	Description *string
}

// DNSSettings - DNS Proxy settings for Firewall
type DNSSettings struct {
	// List of IPs associated with the Firewall
	DNSServers []*IPAddress

	// Enable DNS proxy, disabled by default
	EnableDNSProxy *DNSProxy

	// Enabled DNS proxy type, disabled by default
	EnabledDNSType *EnabledDNSType
}

// DestinationAddr - destination address
type DestinationAddr struct {
	// special value 'any'
	Cidrs []*string

	// list of countries
	Countries []*string

	// list of feeds
	Feeds []*string

	// fqdn list
	FqdnLists []*string

	// prefix list
	PrefixLists []*string
}

// EndpointConfiguration - Endpoint Configuration for frontend and backend
type EndpointConfiguration struct {
	// REQUIRED; Address Space
	Address *IPAddress

	// REQUIRED; port ID
	Port *string
}

// EventHub configurations
type EventHub struct {
	// Resource ID of EventHub
	ID *string

	// EventHub name
	Name *string

	// EventHub namespace
	NameSpace *string

	// EventHub policy name
	PolicyName *string

	// Subscription Id
	SubscriptionID *string
}

// FirewallDeploymentProperties - Properties specific to the Firewall resource deployment.
type FirewallDeploymentProperties struct {
	// REQUIRED; DNS settings for Firewall
	DNSSettings *DNSSettings

	// REQUIRED; Marketplace details
	MarketplaceDetails *MarketplaceDetails

	// REQUIRED; Network settings
	NetworkProfile *NetworkProfile

	// REQUIRED; Billing plan information.
	PlanData *PlanData

	// Associated Rulestack
	AssociatedRulestack *RulestackDetails

	// Frontend settings for Firewall
	FrontEndSettings []*FrontendSetting

	// Panorama Managed: Default is False. Default will be CloudSec managed
	IsPanoramaManaged *BooleanEnum

	// panEtag info
	PanEtag *string

	// Panorama Configuration
	PanoramaConfig *PanoramaConfig

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// FirewallResource - PaloAltoNetworks Firewall
type FirewallResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The resource-specific properties for this resource.
	Properties *FirewallDeploymentProperties

	// The managed service identities assigned to this resource.
	Identity *AzureResourceManagerManagedIdentityProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FirewallResourceListResult - The response of a FirewallResource list operation.
type FirewallResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*FirewallResource

	// The link to the next page of items
	NextLink *string
}

// FirewallResourceUpdate - The type used for update operations of the FirewallResource.
type FirewallResourceUpdate struct {
	// The managed service identities assigned to this resource.
	Identity *AzureResourceManagerManagedIdentityProperties

	// The updatable properties of the FirewallResource.
	Properties *FirewallResourceUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// FirewallResourceUpdateProperties - The updatable properties of the FirewallResource.
type FirewallResourceUpdateProperties struct {
	// Associated Rulestack
	AssociatedRulestack *RulestackDetails

	// DNS settings for Firewall
	DNSSettings *DNSSettings

	// Frontend settings for Firewall
	FrontEndSettings []*FrontendSetting

	// Panorama Managed: Default is False. Default will be CloudSec managed
	IsPanoramaManaged *BooleanEnum

	// Marketplace details
	MarketplaceDetails *MarketplaceDetails

	// Network settings
	NetworkProfile *NetworkProfile

	// panEtag info
	PanEtag *string

	// Panorama Configuration
	PanoramaConfig *PanoramaConfig

	// Billing plan information.
	PlanData *PlanData
}

// FirewallStatusProperty - Firewall Status
type FirewallStatusProperty struct {
	// READ-ONLY; Detail description of current health of the Firewall
	HealthReason *string

	// READ-ONLY; Current status of the Firewall
	HealthStatus *HealthStatus

	// READ-ONLY; Panorama Managed: Default is False. Default will be CloudSec managed
	IsPanoramaManaged *BooleanEnum

	// READ-ONLY; Panorama Status
	PanoramaStatus *PanoramaStatus

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ReadOnlyProvisioningState
}

// FirewallStatusResource - Firewall Status
type FirewallStatusResource struct {
	// REQUIRED; The resource-specific properties for this resource.
	Properties *FirewallStatusProperty

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FirewallStatusResourceListResult - The response of a FirewallStatusResource list operation.
type FirewallStatusResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*FirewallStatusResource

	// The link to the next page of items
	NextLink *string
}

// FqdnListGlobalRulestackResource - GlobalRulestack fqdnList
type FqdnListGlobalRulestackResource struct {
	// REQUIRED; The resource-specific properties for this resource.
	Properties *FqdnObject

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FqdnListGlobalRulestackResourceListResult - The response of a FqdnListGlobalRulestackResource list operation.
type FqdnListGlobalRulestackResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*FqdnListGlobalRulestackResource

	// The link to the next page of items
	NextLink *string
}

// FqdnListLocalRulestackResource - LocalRulestack fqdnList
type FqdnListLocalRulestackResource struct {
	// REQUIRED; The resource-specific properties for this resource.
	Properties *FqdnObject

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FqdnListLocalRulestackResourceListResult - The response of a FqdnListLocalRulestackResource list operation.
type FqdnListLocalRulestackResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*FqdnListLocalRulestackResource

	// The link to the next page of items
	NextLink *string
}

// FqdnObject - fqdn object
type FqdnObject struct {
	// REQUIRED; fqdn list
	FqdnList []*string

	// comment for this object
	AuditComment *string

	// fqdn object description
	Description *string

	// etag info
	Etag *string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// FrontendSetting - Frontend setting for Firewall
type FrontendSetting struct {
	// REQUIRED; Backend configurations
	BackendConfiguration *EndpointConfiguration

	// REQUIRED; Frontend configurations
	FrontendConfiguration *EndpointConfiguration

	// REQUIRED; Settings name
	Name *string

	// REQUIRED; Protocol Type
	Protocol *ProtocolType
}

// GlobalRulestackInfo - PAN Rulestack Describe Object
type GlobalRulestackInfo struct {
	// REQUIRED; rulestack description
	AzureID *string
}

// GlobalRulestackResource - PaloAltoNetworks GlobalRulestack
type GlobalRulestackResource struct {
	// REQUIRED; Global Location
	Location *string

	// REQUIRED; The resource-specific properties for this resource.
	Properties *RulestackProperties

	// The managed service identities assigned to this resource.
	Identity *AzureResourceManagerManagedIdentityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GlobalRulestackResourceListResult - The response of a GlobalRulestackResource list operation.
type GlobalRulestackResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*GlobalRulestackResource

	// The link to the next page of items
	NextLink *string
}

// GlobalRulestackResourceUpdate - The type used for update operations of the GlobalRulestackResource.
type GlobalRulestackResourceUpdate struct {
	// The managed service identities assigned to this resource.
	Identity *AzureResourceManagerManagedIdentityProperties

	// Global Location
	Location *string

	// The updatable properties of the GlobalRulestackResource.
	Properties *GlobalRulestackResourceUpdateProperties
}

// GlobalRulestackResourceUpdateProperties - The updatable properties of the GlobalRulestackResource.
type GlobalRulestackResourceUpdateProperties struct {
	// subscription scope of global rulestack
	AssociatedSubscriptions []*string

	// Mode for default rules creation
	DefaultMode *DefaultMode

	// rulestack description
	Description *string

	// minimum version
	MinAppIDVersion *string

	// PanEtag info
	PanEtag *string

	// Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks
	PanLocation *string

	// Rulestack Type
	Scope *ScopeType

	// Security Profile
	SecurityServices *SecurityServices
}

// IPAddress - IP Address
type IPAddress struct {
	// Address value
	Address *string

	// Resource Id
	ResourceID *string
}

// IPAddressSpace - IP Address Space
type IPAddressSpace struct {
	// Address Space
	AddressSpace *string

	// Resource Id
	ResourceID *string
}

type ListAppIDResponse struct {
	// REQUIRED; List of AppIds
	Value []*string

	// next Link
	NextLink *string
}

// ListFirewallsResponse - List firewalls response
type ListFirewallsResponse struct {
	// REQUIRED; firewalls list
	Value []*string

	// next link
	NextLink *string
}

// LocalRulesResource - LocalRulestack rule list
type LocalRulesResource struct {
	// REQUIRED; The resource-specific properties for this resource.
	Properties *RuleEntry

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LocalRulesResourceListResult - The response of a LocalRulesResource list operation.
type LocalRulesResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*LocalRulesResource

	// The link to the next page of items
	NextLink *string
}

// LocalRulestackResource - PaloAltoNetworks LocalRulestack
type LocalRulestackResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; The resource-specific properties for this resource.
	Properties *RulestackProperties

	// The managed service identities assigned to this resource.
	Identity *AzureResourceManagerManagedIdentityProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LocalRulestackResourceListResult - The response of a LocalRulestackResource list operation.
type LocalRulestackResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*LocalRulestackResource

	// The link to the next page of items
	NextLink *string
}

// LocalRulestackResourceUpdate - The type used for update operations of the LocalRulestackResource.
type LocalRulestackResourceUpdate struct {
	// The managed service identities assigned to this resource.
	Identity *AzureResourceManagerManagedIdentityProperties

	// The updatable properties of the LocalRulestackResource.
	Properties *LocalRulestackResourceUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// LocalRulestackResourceUpdateProperties - The updatable properties of the LocalRulestackResource.
type LocalRulestackResourceUpdateProperties struct {
	// subscription scope of global rulestack
	AssociatedSubscriptions []*string

	// Mode for default rules creation
	DefaultMode *DefaultMode

	// rulestack description
	Description *string

	// minimum version
	MinAppIDVersion *string

	// PanEtag info
	PanEtag *string

	// Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks
	PanLocation *string

	// Rulestack Type
	Scope *ScopeType

	// Security Profile
	SecurityServices *SecurityServices
}

// LogDestination - Log Destination
type LogDestination struct {
	// Event Hub configurations
	EventHubConfigurations *EventHub

	// Monitor Log configurations
	MonitorConfigurations *MonitorLog

	// Storage account configurations
	StorageConfigurations *StorageAccount
}

// LogSettings - Log Settings for Firewall
type LogSettings struct {
	// Application Insight details
	ApplicationInsights *ApplicationInsights

	// Common destination configurations
	CommonDestination *LogDestination

	// Decrypt destination configurations
	DecryptLogDestination *LogDestination

	// Log option SAME/INDIVIDUAL
	LogOption *LogOption

	// One of possible log type
	LogType *LogType

	// Threat destination configurations
	ThreatLogDestination *LogDestination

	// Traffic destination configurations
	TrafficLogDestination *LogDestination
}

// MarketplaceDetails of PAN Firewall resource
type MarketplaceDetails struct {
	// REQUIRED; Offer Id
	OfferID *string

	// REQUIRED; Publisher Id
	PublisherID *string

	// Marketplace Subscription Status
	MarketplaceSubscriptionStatus *MarketplaceSubscriptionStatus

	// READ-ONLY; Marketplace Subscription Id
	MarketplaceSubscriptionID *string
}

// MonitorLog configurations
type MonitorLog struct {
	// Resource ID of MonitorLog
	ID *string

	// Primary Key value for Monitor
	PrimaryKey *string

	// Secondary Key value for Monitor
	SecondaryKey *string

	// Subscription Id
	SubscriptionID *string

	// MonitorLog workspace
	Workspace *string
}

// NameDescriptionObject - object type info
type NameDescriptionObject struct {
	// REQUIRED; name value
	Name *string

	// description value
	Description *string
}

// NetworkProfile - Network settings for Firewall
type NetworkProfile struct {
	// REQUIRED; Enable egress NAT, enabled by default
	EnableEgressNat *EgressNat

	// REQUIRED; vnet or vwan, cannot be updated
	NetworkType *NetworkType

	// REQUIRED; List of IPs associated with the Firewall
	PublicIPs []*IPAddress

	// Egress nat IP to use
	EgressNatIP []*IPAddress

	// Non-RFC 1918 address
	TrustedRanges []*string

	// Vnet configurations
	VnetConfiguration *VnetConfiguration

	// Vwan configurations
	VwanConfiguration *VwanConfiguration
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// PanoramaConfig - Panorama Config
type PanoramaConfig struct {
	// REQUIRED; Base64 encoded string representing Panorama parameters to be used by Firewall to connect to Panorama. This string
	// is generated via azure plugin in Panorama
	ConfigString *string

	// READ-ONLY; Panorama Collector Group to join - (Once configured we can not edit the value)
	CgName *string

	// READ-ONLY; Panorama Device Group to join
	DgName *string

	// READ-ONLY; Resource name(may be unique) for PN admin
	HostName *string

	// READ-ONLY; Primary Panorama Server IP address value in dotted format for IPv4
	PanoramaServer *string

	// READ-ONLY; Secondary Panorama Server IP address value in dotted format for IPv4
	PanoramaServer2 *string

	// READ-ONLY; Panorama Template Stack to join - (Once configured we can not edit the value)
	TplName *string

	// READ-ONLY; VM auth key for panorama connectivity
	VMAuthKey *string
}

// PanoramaStatus - Panorama connectivity information
type PanoramaStatus struct {
	// READ-ONLY; Secondary Panorama connection status
	PanoramaServer2Status *ServerStatus

	// READ-ONLY; Primary Panorama connection status
	PanoramaServerStatus *ServerStatus
}

// PlanData - Billing plan information.
type PlanData struct {
	// REQUIRED; different billing cycles like MONTHLY/WEEKLY
	BillingCycle *BillingCycle

	// REQUIRED; plan id as published by Liftr.PAN
	PlanID *string

	// different usage type like PAYG/COMMITTED
	UsageType *UsageType

	// READ-ONLY; date when plan was applied
	EffectiveDate *time.Time
}

// PostRulesResource - PostRulestack rule list
type PostRulesResource struct {
	// REQUIRED; The resource-specific properties for this resource.
	Properties *RuleEntry

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PostRulesResourceListResult - The response of a PostRulesResource list operation.
type PostRulesResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*PostRulesResource

	// The link to the next page of items
	NextLink *string
}

// PreRulesResource - PreRulestack rule list
type PreRulesResource struct {
	// REQUIRED; The resource-specific properties for this resource.
	Properties *RuleEntry

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PreRulesResourceListResult - The response of a PreRulesResource list operation.
type PreRulesResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*PreRulesResource

	// The link to the next page of items
	NextLink *string
}

// PredefinedURLCategoriesResponse - predefined url categories response
type PredefinedURLCategoriesResponse struct {
	// REQUIRED; predefined url categories
	Value []*PredefinedURLCategory

	// next link
	NextLink *string
}

// PredefinedURLCategory - Predefined URL category object
type PredefinedURLCategory struct {
	// REQUIRED
	Action *string

	// REQUIRED
	Name *string
}

// PrefixListGlobalRulestackResource - GlobalRulestack prefixList
type PrefixListGlobalRulestackResource struct {
	// REQUIRED; The resource-specific properties for this resource.
	Properties *PrefixObject

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrefixListGlobalRulestackResourceListResult - The response of a PrefixListGlobalRulestackResource list operation.
type PrefixListGlobalRulestackResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*PrefixListGlobalRulestackResource

	// The link to the next page of items
	NextLink *string
}

// PrefixListResource - LocalRulestack prefixList
type PrefixListResource struct {
	// REQUIRED; The resource-specific properties for this resource.
	Properties *PrefixObject

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrefixListResourceListResult - The response of a PrefixListResource list operation.
type PrefixListResourceListResult struct {
	// REQUIRED; The items on this page
	Value []*PrefixListResource

	// The link to the next page of items
	NextLink *string
}

// PrefixObject - prefix entry
type PrefixObject struct {
	// REQUIRED; prefix list
	PrefixList []*string

	// comment for this object
	AuditComment *string

	// prefix description
	Description *string

	// etag info
	Etag *string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// RuleCounter - Rule counter
type RuleCounter struct {
	// REQUIRED; priority number
	Priority *string

	// REQUIRED; rule name
	RuleName *string

	// apps seen
	AppSeen *AppSeenData

	// firewall name
	FirewallName *string

	// hit count
	HitCount *int32

	// last updated timestamp
	LastUpdatedTimestamp *time.Time

	// timestamp of request
	RequestTimestamp *time.Time

	// rule list name
	RuleListName *string

	// rule Stack Name
	RuleStackName *string

	// timestamp of response
	Timestamp *time.Time
}

// RuleCounterReset - Rule counter reset
type RuleCounterReset struct {
	// firewall name
	FirewallName *string

	// rule list name
	RuleListName *string

	// rule name
	RuleName *string

	// rule Stack Name
	RuleStackName *string

	// READ-ONLY; priority number
	Priority *string
}

// RuleEntry - definition of rule
type RuleEntry struct {
	// REQUIRED; rule name
	RuleName *string

	// rule action
	ActionType *ActionEnum

	// array of rule applications
	Applications []*string

	// rule comment
	AuditComment *string

	// rule category
	Category *Category

	// enable or disable decryption
	DecryptionRuleType *DecryptionRuleTypeEnum

	// rule description
	Description *string

	// destination address
	Destination *DestinationAddr

	// enable or disable logging
	EnableLogging *StateEnum

	// etag info
	Etag *string

	// inbound Inspection Certificate
	InboundInspectionCertificate *string

	// cidr should not be 'any'
	NegateDestination *BooleanEnum

	// cidr should not be 'any'
	NegateSource *BooleanEnum

	// any, application-default, TCP:number, UDP:number
	Protocol *string

	// prot port list
	ProtocolPortList []*string

	// state of this rule
	RuleState *StateEnum

	// source address
	Source *SourceAddr

	// tag for rule
	Tags []*TagInfo

	// READ-ONLY
	Priority *int32

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// RulestackDetails - Associated rulestack details
type RulestackDetails struct {
	// Rulestack location
	Location *string

	// Resource Id
	ResourceID *string

	// Associated rulestack Id
	RulestackID *string
}

// RulestackProperties - PAN Rulestack Describe Object
type RulestackProperties struct {
	// subscription scope of global rulestack
	AssociatedSubscriptions []*string

	// Mode for default rules creation
	DefaultMode *DefaultMode

	// rulestack description
	Description *string

	// minimum version
	MinAppIDVersion *string

	// PanEtag info
	PanEtag *string

	// Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks
	PanLocation *string

	// Rulestack Type
	Scope *ScopeType

	// Security Profile
	SecurityServices *SecurityServices

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// SecurityServices - security services
type SecurityServices struct {
	// Anti spyware Profile data
	AntiSpywareProfile *string

	// anti virus profile data
	AntiVirusProfile *string

	// DNS Subscription profile data
	DNSSubscription *string

	// File blocking profile data
	FileBlockingProfile *string

	// Trusted Egress Decryption profile data
	OutboundTrustCertificate *string

	// Untrusted Egress Decryption profile data
	OutboundUnTrustCertificate *string

	// URL filtering profile data
	URLFilteringProfile *string

	// IPs Vulnerability Profile Data
	VulnerabilityProfile *string
}

// SecurityServicesResponse - Security services list response
type SecurityServicesResponse struct {
	// REQUIRED; response value
	Value *SecurityServicesTypeList

	// next link
	NextLink *string
}

// SecurityServicesTypeList - Security services type list
type SecurityServicesTypeList struct {
	// REQUIRED; list
	Entry []*NameDescriptionObject

	// security services type
	Type *string
}

// SourceAddr - Address properties
type SourceAddr struct {
	// special value 'any'
	Cidrs []*string

	// list of countries
	Countries []*string

	// list of feeds
	Feeds []*string

	// prefix list
	PrefixLists []*string
}

// StorageAccount - Storage Account configurations
type StorageAccount struct {
	// Storage account name
	AccountName *string

	// Resource ID of storage account
	ID *string

	// Subscription Id
	SubscriptionID *string
}

// SupportInfo - Support information for the resource
type SupportInfo struct {
	// Support account associated with given resource
	AccountID *string

	// account registered in Customer Support Portal
	AccountRegistered *BooleanEnum

	// Product usage is in free trial period
	FreeTrial *BooleanEnum

	// Free trial credit remaining
	FreeTrialCreditLeft *int32

	// Free trial days remaining
	FreeTrialDaysLeft *int32

	// URL for paloaltonetworks live community
	HelpURL *string

	// product SKU associated with given resource
	ProductSKU *string

	// product Serial associated with given resource
	ProductSerial *string

	// URL for registering product in paloaltonetworks Customer Service Portal
	RegisterURL *string

	// URL for paloaltonetworks Customer Service Portal
	SupportURL *string

	// user domain is supported in Customer Support Portal
	UserDomainSupported *BooleanEnum

	// user registered in Customer Support Portal
	UserRegistered *BooleanEnum
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagInfo - Tag
type TagInfo struct {
	// REQUIRED; tag name
	Key *string

	// REQUIRED; tag value
	Value *string
}

// VnetConfiguration - VnetInfo for Firewall Networking
type VnetConfiguration struct {
	// REQUIRED; Trust Subnet
	TrustSubnet *IPAddressSpace

	// REQUIRED; Untrust Subnet
	UnTrustSubnet *IPAddressSpace

	// REQUIRED; Azure Virtual Network
	Vnet *IPAddressSpace

	// IP of trust subnet for UDR
	IPOfTrustSubnetForUdr *IPAddress
}

// VwanConfiguration - VwanInfo for Firewall Networking
type VwanConfiguration struct {
	// REQUIRED; vHub Address
	VHub *IPAddressSpace

	// IP of trust subnet for UDR
	IPOfTrustSubnetForUdr *IPAddress

	// Network Virtual Appliance resource ID
	NetworkVirtualApplianceID *string

	// Trust Subnet
	TrustSubnet *IPAddressSpace

	// Untrust Subnet
	UnTrustSubnet *IPAddressSpace
}
