//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// HealthReportClient contains the methods for the HealthReport group.
// Don't use this type directly, use NewHealthReportClient() instead.
type HealthReportClient struct {
	internal *arm.Client
}

// NewHealthReportClient creates a new instance of HealthReportClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewHealthReportClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*HealthReportClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &HealthReportClient{
		internal: cl,
	}
	return client, nil
}

// Get - Get health report of resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-01-preview
//   - resourceID - The identifier of the resource.
//   - healthReportName - The health report Key - Unique key for the health report type
//   - options - HealthReportClientGetOptions contains the optional parameters for the HealthReportClient.Get method.
func (client *HealthReportClient) Get(ctx context.Context, resourceID string, healthReportName string, options *HealthReportClientGetOptions) (HealthReportClientGetResponse, error) {
	var err error
	const operationName = "HealthReportClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceID, healthReportName, options)
	if err != nil {
		return HealthReportClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return HealthReportClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return HealthReportClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *HealthReportClient) getCreateRequest(ctx context.Context, resourceID string, healthReportName string, options *HealthReportClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/healthReports/{healthReportName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	if healthReportName == "" {
		return nil, errors.New("parameter healthReportName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{healthReportName}", url.PathEscape(healthReportName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *HealthReportClient) getHandleResponse(resp *http.Response) (HealthReportClientGetResponse, error) {
	result := HealthReportClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HealthReport); err != nil {
		return HealthReportClientGetResponse{}, err
	}
	return result, nil
}
