//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstreamanalytics

// ClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the ClustersClient.BeginCreateOrUpdate method.
type ClustersClientBeginCreateOrUpdateOptions struct {
	// The ETag of the resource. Omit this value to always overwrite the current record set. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string

	// Set to '*' to allow a new resource to be created, but to prevent updating an existing record set. Other values will result
	// in a 412 Pre-condition Failed response.
	IfNoneMatch *string

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginDeleteOptions contains the optional parameters for the ClustersClient.BeginDelete method.
type ClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginUpdateOptions contains the optional parameters for the ClustersClient.BeginUpdate method.
type ClustersClientBeginUpdateOptions struct {
	// The ETag of the resource. Omit this value to always overwrite the current record set. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientGetOptions contains the optional parameters for the ClustersClient.Get method.
type ClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListByResourceGroupOptions contains the optional parameters for the ClustersClient.NewListByResourceGroupPager
// method.
type ClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListBySubscriptionOptions contains the optional parameters for the ClustersClient.NewListBySubscriptionPager
// method.
type ClustersClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListStreamingJobsOptions contains the optional parameters for the ClustersClient.NewListStreamingJobsPager
// method.
type ClustersClientListStreamingJobsOptions struct {
	// placeholder for future optional parameters
}

// FunctionsClientBeginTestOptions contains the optional parameters for the FunctionsClient.BeginTest method.
type FunctionsClientBeginTestOptions struct {
	// If the function specified does not already exist, this parameter must contain the full function definition intended to
	// be tested. If the function specified already exists, this parameter can be left
	// null to test the existing function as is or if specified, the properties specified will overwrite the corresponding properties
	// in the existing function (exactly like a PATCH operation) and the
	// resulting function will be tested.
	Function *Function

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FunctionsClientCreateOrReplaceOptions contains the optional parameters for the FunctionsClient.CreateOrReplace method.
type FunctionsClientCreateOrReplaceOptions struct {
	// The ETag of the function. Omit this value to always overwrite the current function. Specify the last-seen ETag value to
	// prevent accidentally overwriting concurrent changes.
	IfMatch *string

	// Set to '*' to allow a new function to be created, but to prevent updating an existing function. Other values will result
	// in a 412 Pre-condition Failed response.
	IfNoneMatch *string
}

// FunctionsClientDeleteOptions contains the optional parameters for the FunctionsClient.Delete method.
type FunctionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// FunctionsClientGetOptions contains the optional parameters for the FunctionsClient.Get method.
type FunctionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// FunctionsClientListByStreamingJobOptions contains the optional parameters for the FunctionsClient.NewListByStreamingJobPager
// method.
type FunctionsClientListByStreamingJobOptions struct {
	// The $select OData query parameter. This is a comma-separated list of structural properties to include in the response,
	// or "" to include all properties. By default, all properties are returned except
	// diagnostics. Currently only accepts '' as a valid value.
	Select *string
}

// FunctionsClientRetrieveDefaultDefinitionOptions contains the optional parameters for the FunctionsClient.RetrieveDefaultDefinition
// method.
type FunctionsClientRetrieveDefaultDefinitionOptions struct {
	// Parameters used to specify the type of function to retrieve the default definition for.
	FunctionRetrieveDefaultDefinitionParameters FunctionRetrieveDefaultDefinitionParametersClassification
}

// FunctionsClientUpdateOptions contains the optional parameters for the FunctionsClient.Update method.
type FunctionsClientUpdateOptions struct {
	// The ETag of the function. Omit this value to always overwrite the current function. Specify the last-seen ETag value to
	// prevent accidentally overwriting concurrent changes.
	IfMatch *string
}

// InputsClientBeginTestOptions contains the optional parameters for the InputsClient.BeginTest method.
type InputsClientBeginTestOptions struct {
	// If the input specified does not already exist, this parameter must contain the full input definition intended to be tested.
	// If the input specified already exists, this parameter can be left null to
	// test the existing input as is or if specified, the properties specified will overwrite the corresponding properties in
	// the existing input (exactly like a PATCH operation) and the resulting input will
	// be tested.
	Input *Input

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InputsClientCreateOrReplaceOptions contains the optional parameters for the InputsClient.CreateOrReplace method.
type InputsClientCreateOrReplaceOptions struct {
	// The ETag of the input. Omit this value to always overwrite the current input. Specify the last-seen ETag value to prevent
	// accidentally overwriting concurrent changes.
	IfMatch *string

	// Set to '*' to allow a new input to be created, but to prevent updating an existing input. Other values will result in a
	// 412 Pre-condition Failed response.
	IfNoneMatch *string
}

// InputsClientDeleteOptions contains the optional parameters for the InputsClient.Delete method.
type InputsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// InputsClientGetOptions contains the optional parameters for the InputsClient.Get method.
type InputsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InputsClientListByStreamingJobOptions contains the optional parameters for the InputsClient.NewListByStreamingJobPager
// method.
type InputsClientListByStreamingJobOptions struct {
	// The $select OData query parameter. This is a comma-separated list of structural properties to include in the response,
	// or "" to include all properties. By default, all properties are returned except
	// diagnostics. Currently only accepts '' as a valid value.
	Select *string
}

// InputsClientUpdateOptions contains the optional parameters for the InputsClient.Update method.
type InputsClientUpdateOptions struct {
	// The ETag of the input. Omit this value to always overwrite the current input. Specify the last-seen ETag value to prevent
	// accidentally overwriting concurrent changes.
	IfMatch *string
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OutputsClientBeginTestOptions contains the optional parameters for the OutputsClient.BeginTest method.
type OutputsClientBeginTestOptions struct {
	// If the output specified does not already exist, this parameter must contain the full output definition intended to be tested.
	// If the output specified already exists, this parameter can be left null to
	// test the existing output as is or if specified, the properties specified will overwrite the corresponding properties in
	// the existing output (exactly like a PATCH operation) and the resulting output
	// will be tested.
	Output *Output

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OutputsClientCreateOrReplaceOptions contains the optional parameters for the OutputsClient.CreateOrReplace method.
type OutputsClientCreateOrReplaceOptions struct {
	// The ETag of the output. Omit this value to always overwrite the current output. Specify the last-seen ETag value to prevent
	// accidentally overwriting concurrent changes.
	IfMatch *string

	// Set to '*' to allow a new output to be created, but to prevent updating an existing output. Other values will result in
	// a 412 Pre-condition Failed response.
	IfNoneMatch *string
}

// OutputsClientDeleteOptions contains the optional parameters for the OutputsClient.Delete method.
type OutputsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// OutputsClientGetOptions contains the optional parameters for the OutputsClient.Get method.
type OutputsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OutputsClientListByStreamingJobOptions contains the optional parameters for the OutputsClient.NewListByStreamingJobPager
// method.
type OutputsClientListByStreamingJobOptions struct {
	// The $select OData query parameter. This is a comma-separated list of structural properties to include in the response,
	// or "" to include all properties. By default, all properties are returned except
	// diagnostics. Currently only accepts '' as a valid value.
	Select *string
}

// OutputsClientUpdateOptions contains the optional parameters for the OutputsClient.Update method.
type OutputsClientUpdateOptions struct {
	// The ETag of the output. Omit this value to always overwrite the current output. Specify the last-seen ETag value to prevent
	// accidentally overwriting concurrent changes.
	IfMatch *string
}

// PrivateEndpointsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointsClient.BeginDelete method.
type PrivateEndpointsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointsClientCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointsClient.CreateOrUpdate
// method.
type PrivateEndpointsClientCreateOrUpdateOptions struct {
	// The ETag of the resource. Omit this value to always overwrite the current record set. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string

	// Set to '*' to allow a new resource to be created, but to prevent updating an existing record set. Other values will result
	// in a 412 Pre-condition Failed response.
	IfNoneMatch *string
}

// PrivateEndpointsClientGetOptions contains the optional parameters for the PrivateEndpointsClient.Get method.
type PrivateEndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointsClientListByClusterOptions contains the optional parameters for the PrivateEndpointsClient.NewListByClusterPager
// method.
type PrivateEndpointsClientListByClusterOptions struct {
	// placeholder for future optional parameters
}

// StreamingJobsClientBeginCreateOrReplaceOptions contains the optional parameters for the StreamingJobsClient.BeginCreateOrReplace
// method.
type StreamingJobsClientBeginCreateOrReplaceOptions struct {
	// The ETag of the streaming job. Omit this value to always overwrite the current record set. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string

	// Set to '*' to allow a new streaming job to be created, but to prevent updating an existing record set. Other values will
	// result in a 412 Pre-condition Failed response.
	IfNoneMatch *string

	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingJobsClientBeginDeleteOptions contains the optional parameters for the StreamingJobsClient.BeginDelete method.
type StreamingJobsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingJobsClientBeginScaleOptions contains the optional parameters for the StreamingJobsClient.BeginScale method.
type StreamingJobsClientBeginScaleOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string

	// Parameters applicable to a scale streaming job operation.
	ScaleJobParameters *ScaleStreamingJobParameters
}

// StreamingJobsClientBeginStartOptions contains the optional parameters for the StreamingJobsClient.BeginStart method.
type StreamingJobsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string

	// Parameters applicable to a start streaming job operation.
	StartJobParameters *StartStreamingJobParameters
}

// StreamingJobsClientBeginStopOptions contains the optional parameters for the StreamingJobsClient.BeginStop method.
type StreamingJobsClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StreamingJobsClientGetOptions contains the optional parameters for the StreamingJobsClient.Get method.
type StreamingJobsClientGetOptions struct {
	// The $expand OData query parameter. This is a comma-separated list of additional streaming job properties to include in
	// the response, beyond the default set returned when this parameter is absent. The
	// default set is all streaming job properties other than 'inputs', 'transformation', 'outputs', and 'functions'.
	Expand *string
}

// StreamingJobsClientListByResourceGroupOptions contains the optional parameters for the StreamingJobsClient.NewListByResourceGroupPager
// method.
type StreamingJobsClientListByResourceGroupOptions struct {
	// The $expand OData query parameter. This is a comma-separated list of additional streaming job properties to include in
	// the response, beyond the default set returned when this parameter is absent. The
	// default set is all streaming job properties other than 'inputs', 'transformation', 'outputs', and 'functions'.
	Expand *string
}

// StreamingJobsClientListOptions contains the optional parameters for the StreamingJobsClient.NewListPager method.
type StreamingJobsClientListOptions struct {
	// The $expand OData query parameter. This is a comma-separated list of additional streaming job properties to include in
	// the response, beyond the default set returned when this parameter is absent. The
	// default set is all streaming job properties other than 'inputs', 'transformation', 'outputs', and 'functions'.
	Expand *string
}

// StreamingJobsClientUpdateOptions contains the optional parameters for the StreamingJobsClient.Update method.
type StreamingJobsClientUpdateOptions struct {
	// The ETag of the streaming job. Omit this value to always overwrite the current record set. Specify the last-seen ETag value
	// to prevent accidentally overwriting concurrent changes.
	IfMatch *string
}

// SubscriptionsClientListQuotasOptions contains the optional parameters for the SubscriptionsClient.ListQuotas method.
type SubscriptionsClientListQuotasOptions struct {
	// placeholder for future optional parameters
}

// TransformationsClientCreateOrReplaceOptions contains the optional parameters for the TransformationsClient.CreateOrReplace
// method.
type TransformationsClientCreateOrReplaceOptions struct {
	// The ETag of the transformation. Omit this value to always overwrite the current transformation. Specify the last-seen ETag
	// value to prevent accidentally overwriting concurrent changes.
	IfMatch *string

	// Set to '*' to allow a new transformation to be created, but to prevent updating an existing transformation. Other values
	// will result in a 412 Pre-condition Failed response.
	IfNoneMatch *string
}

// TransformationsClientGetOptions contains the optional parameters for the TransformationsClient.Get method.
type TransformationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TransformationsClientUpdateOptions contains the optional parameters for the TransformationsClient.Update method.
type TransformationsClientUpdateOptions struct {
	// The ETag of the transformation. Omit this value to always overwrite the current transformation. Specify the last-seen ETag
	// value to prevent accidentally overwriting concurrent changes.
	IfMatch *string
}
