// Package catalog implements the Azure ARM Catalog service API version 2016-11-01.
//
// Creates an Azure Data Lake Analytics catalog client.
package catalog

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

const (
	// DefaultAdlaCatalogDNSSuffix is the default value for adla catalog dns suffix
	DefaultAdlaCatalogDNSSuffix = "azuredatalakeanalytics.net"
)

// BaseClient is the base client for Catalog.
type BaseClient struct {
	autorest.Client
	AdlaCatalogDNSSuffix string
}

// New creates an instance of the BaseClient client.
func New() BaseClient {
	return NewWithoutDefaults(DefaultAdlaCatalogDNSSuffix)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(adlaCatalogDNSSuffix string) BaseClient {
	return BaseClient{
		Client:               autorest.NewClientWithUserAgent(UserAgent()),
		AdlaCatalogDNSSuffix: adlaCatalogDNSSuffix,
	}
}
