package keyvault

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// AutoRenew ...
	AutoRenew ActionType = "AutoRenew"
	// EmailContacts ...
	EmailContacts ActionType = "EmailContacts"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{AutoRenew, EmailContacts}
}

// JSONWebKeyEncryptionAlgorithm enumerates the values for json web key encryption algorithm.
type JSONWebKeyEncryptionAlgorithm string

const (
	// RSA15 ...
	RSA15 JSONWebKeyEncryptionAlgorithm = "RSA1_5"
	// RSAOAEP ...
	RSAOAEP JSONWebKeyEncryptionAlgorithm = "RSA-OAEP"
	// RSAOAEP256 ...
	RSAOAEP256 JSONWebKeyEncryptionAlgorithm = "RSA-OAEP-256"
)

// PossibleJSONWebKeyEncryptionAlgorithmValues returns an array of possible values for the JSONWebKeyEncryptionAlgorithm const type.
func PossibleJSONWebKeyEncryptionAlgorithmValues() []JSONWebKeyEncryptionAlgorithm {
	return []JSONWebKeyEncryptionAlgorithm{RSA15, RSAOAEP, RSAOAEP256}
}

// JSONWebKeyOperation enumerates the values for json web key operation.
type JSONWebKeyOperation string

const (
	// Decrypt ...
	Decrypt JSONWebKeyOperation = "decrypt"
	// Encrypt ...
	Encrypt JSONWebKeyOperation = "encrypt"
	// Sign ...
	Sign JSONWebKeyOperation = "sign"
	// UnwrapKey ...
	UnwrapKey JSONWebKeyOperation = "unwrapKey"
	// Verify ...
	Verify JSONWebKeyOperation = "verify"
	// WrapKey ...
	WrapKey JSONWebKeyOperation = "wrapKey"
)

// PossibleJSONWebKeyOperationValues returns an array of possible values for the JSONWebKeyOperation const type.
func PossibleJSONWebKeyOperationValues() []JSONWebKeyOperation {
	return []JSONWebKeyOperation{Decrypt, Encrypt, Sign, UnwrapKey, Verify, WrapKey}
}

// JSONWebKeySignatureAlgorithm enumerates the values for json web key signature algorithm.
type JSONWebKeySignatureAlgorithm string

const (
	// PS256 ...
	PS256 JSONWebKeySignatureAlgorithm = "PS256"
	// PS384 ...
	PS384 JSONWebKeySignatureAlgorithm = "PS384"
	// PS512 ...
	PS512 JSONWebKeySignatureAlgorithm = "PS512"
	// RS256 ...
	RS256 JSONWebKeySignatureAlgorithm = "RS256"
	// RS384 ...
	RS384 JSONWebKeySignatureAlgorithm = "RS384"
	// RS512 ...
	RS512 JSONWebKeySignatureAlgorithm = "RS512"
	// RSNULL ...
	RSNULL JSONWebKeySignatureAlgorithm = "RSNULL"
)

// PossibleJSONWebKeySignatureAlgorithmValues returns an array of possible values for the JSONWebKeySignatureAlgorithm const type.
func PossibleJSONWebKeySignatureAlgorithmValues() []JSONWebKeySignatureAlgorithm {
	return []JSONWebKeySignatureAlgorithm{PS256, PS384, PS512, RS256, RS384, RS512, RSNULL}
}

// JSONWebKeyType enumerates the values for json web key type.
type JSONWebKeyType string

const (
	// EC ...
	EC JSONWebKeyType = "EC"
	// Oct ...
	Oct JSONWebKeyType = "oct"
	// RSA ...
	RSA JSONWebKeyType = "RSA"
	// RSAHSM ...
	RSAHSM JSONWebKeyType = "RSA-HSM"
)

// PossibleJSONWebKeyTypeValues returns an array of possible values for the JSONWebKeyType const type.
func PossibleJSONWebKeyTypeValues() []JSONWebKeyType {
	return []JSONWebKeyType{EC, Oct, RSA, RSAHSM}
}

// KeyUsageType enumerates the values for key usage type.
type KeyUsageType string

const (
	// CRLSign ...
	CRLSign KeyUsageType = "cRLSign"
	// DataEncipherment ...
	DataEncipherment KeyUsageType = "dataEncipherment"
	// DecipherOnly ...
	DecipherOnly KeyUsageType = "decipherOnly"
	// DigitalSignature ...
	DigitalSignature KeyUsageType = "digitalSignature"
	// EncipherOnly ...
	EncipherOnly KeyUsageType = "encipherOnly"
	// KeyAgreement ...
	KeyAgreement KeyUsageType = "keyAgreement"
	// KeyCertSign ...
	KeyCertSign KeyUsageType = "keyCertSign"
	// KeyEncipherment ...
	KeyEncipherment KeyUsageType = "keyEncipherment"
	// NonRepudiation ...
	NonRepudiation KeyUsageType = "nonRepudiation"
)

// PossibleKeyUsageTypeValues returns an array of possible values for the KeyUsageType const type.
func PossibleKeyUsageTypeValues() []KeyUsageType {
	return []KeyUsageType{CRLSign, DataEncipherment, DecipherOnly, DigitalSignature, EncipherOnly, KeyAgreement, KeyCertSign, KeyEncipherment, NonRepudiation}
}
