/* gsound-play.c generated by valac 0.30.0, the Vala compiler
 * generated from gsound-play.vala, do not modify */

/* gsound-play.vala
 *
 * Copyright (C) 2014 Tristan Brindle <t.c.brindle@gmail.com>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gsound.h>
#include <gio/gio.h>

typedef struct _PlayData PlayData;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _PlayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gint _tmp0_;
	GSoundContext* _tmp1_;
	GHashTable* _tmp2_;
	GError * _inner_error_;
};


extern gchar* event_id;
gchar* event_id = NULL;
extern gchar* filename;
gchar* filename = NULL;
extern gchar* desc;
gchar* desc = NULL;
extern gchar* cache;
gchar* cache = NULL;
extern gint loops;
gint loops = 0;
extern gdouble volume;
gdouble volume = 0.0;
extern gchar* driver;
gchar* driver = NULL;
extern GMainLoop* main_loop;
GMainLoop* main_loop = NULL;
extern GSoundContext* gs_ctx;
GSoundContext* gs_ctx = NULL;
extern GHashTable* attrs;
GHashTable* attrs = NULL;

static void play_data_free (gpointer _data);
void play (GAsyncReadyCallback _callback_, gpointer _user_data_);
void play_finish (GAsyncResult* _res_, GError** error);
static gboolean play_co (PlayData* _data_);
static void play_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint _vala_main (gchar** args, int args_length1);
static void _g_free0_ (gpointer var);
static void ___lambda4_ (GObject* obj, GAsyncResult* res);
static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);

const GOptionEntry opts[8] = {{"id", 'i', 0, G_OPTION_ARG_STRING, &event_id, "Event sound identifier", "STRING"}, {"file", 'f', 0, G_OPTION_ARG_FILENAME, &filename, "Play file", "PATH"}, {"description", 'd', 0, G_OPTION_ARG_STRING, &desc, "Event sound description", "STRING"}, {"cache-control", 'c', 0, G_OPTION_ARG_STRING, &cache, "Cache control (permanent, volatile, never", "STRING"}, {"loop", 'l', 0, G_OPTION_ARG_INT, &loops, "Loop many times (default: 1)", "INTEGER"}, {"volume", 'V', 0, G_OPTION_ARG_DOUBLE, &volume, "A floating point dB value for the sample volume (ex: 0.0)", "STRING"}, {"backend", 'b', 0, G_OPTION_ARG_STRING, &driver, "libcanberra backend to use", "STRING"}, {NULL}};

static void play_data_free (gpointer _data) {
	PlayData* _data_;
	_data_ = _data;
	g_slice_free (PlayData, _data_);
}


void play (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PlayData* _data_;
	_data_ = g_slice_new0 (PlayData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, play);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, play_data_free);
	play_co (_data_);
}


void play_finish (GAsyncResult* _res_, GError** error) {
	PlayData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void play_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	PlayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	play_co (_data_);
}


static gboolean play_co (PlayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	while (TRUE) {
		_data_->_tmp0_ = 0;
		_data_->_tmp0_ = loops;
		loops = _data_->_tmp0_ - 1;
		if (!(_data_->_tmp0_ > 0)) {
			break;
		}
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = gs_ctx;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = attrs;
		_data_->_state_ = 1;
		gsound_context_play_fullv (_data_->_tmp1_, _data_->_tmp2_, NULL, play_ready, _data_);
		return FALSE;
		_state_1:
		gsound_context_play_full_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}


static void ___lambda4_ (GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		play_finish (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_print ("Error: %s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally1:
	{
		GMainLoop* _tmp3_ = NULL;
		_tmp3_ = main_loop;
		g_main_loop_quit (_tmp3_);
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda4_ (source_object, res);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* opt_ctx = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_set_application_name ("gsound-play");
	_tmp0_ = g_option_context_new (NULL);
	opt_ctx = _tmp0_;
	_tmp1_ = opt_ctx;
	g_option_context_add_main_entries (_tmp1_, opts, NULL);
	{
		GOptionContext* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_ = NULL;
		GSoundContext* _tmp6_ = NULL;
		GSoundContext* _tmp7_ = NULL;
		GSoundContext* _tmp8_ = NULL;
		GSoundContext* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GHashFunc _tmp13_ = NULL;
		GEqualFunc _tmp14_ = NULL;
		GHashTable* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp26_ = NULL;
		gdouble _tmp31_ = 0.0;
		gint _tmp36_ = 0;
		GMainLoop* _tmp37_ = NULL;
		GMainLoop* _tmp38_ = NULL;
		_tmp2_ = opt_ctx;
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = event_id;
		if (_tmp4_ == NULL) {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = filename;
			_tmp3_ = _tmp5_ == NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			g_print ("No event id or file specified.\n");
			result = 1;
			_g_option_context_free0 (opt_ctx);
			return result;
		}
		_tmp7_ = gsound_context_new (NULL, &_inner_error_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (gs_ctx);
		gs_ctx = _tmp8_;
		_tmp9_ = gs_ctx;
		gsound_context_set_attributes (_tmp9_, &_inner_error_, GSOUND_ATTR_APPLICATION_ID, "org.gnome.gsound-test", NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			goto __catch0_g_error;
		}
		_tmp10_ = driver;
		if (_tmp10_ != NULL) {
			GSoundContext* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			_tmp11_ = gs_ctx;
			_tmp12_ = driver;
			gsound_context_set_driver (_tmp11_, _tmp12_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (_tmp6_);
				goto __catch0_g_error;
			}
		}
		_tmp13_ = g_str_hash;
		_tmp14_ = g_str_equal;
		_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, _g_free0_, _g_free0_);
		_g_hash_table_unref0 (attrs);
		attrs = _tmp15_;
		_tmp16_ = event_id;
		if (_tmp16_ != NULL) {
			GHashTable* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_tmp17_ = attrs;
			_tmp18_ = g_strdup (GSOUND_ATTR_EVENT_ID);
			_tmp19_ = event_id;
			_tmp20_ = g_strdup (_tmp19_);
			g_hash_table_insert (_tmp17_, _tmp18_, _tmp20_);
		}
		_tmp21_ = filename;
		if (_tmp21_ != NULL) {
			GHashTable* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			_tmp22_ = attrs;
			_tmp23_ = g_strdup (GSOUND_ATTR_MEDIA_FILENAME);
			_tmp24_ = filename;
			_tmp25_ = g_strdup (_tmp24_);
			g_hash_table_insert (_tmp22_, _tmp23_, _tmp25_);
		}
		_tmp26_ = cache;
		if (_tmp26_ != NULL) {
			GHashTable* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			_tmp27_ = attrs;
			_tmp28_ = g_strdup (GSOUND_ATTR_CANBERRA_CACHE_CONTROL);
			_tmp29_ = cache;
			_tmp30_ = g_strdup (_tmp29_);
			g_hash_table_insert (_tmp27_, _tmp28_, _tmp30_);
		}
		_tmp31_ = volume;
		if (_tmp31_ != 0.0) {
			GHashTable* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gdouble _tmp34_ = 0.0;
			gchar* _tmp35_ = NULL;
			_tmp32_ = attrs;
			_tmp33_ = g_strdup (GSOUND_ATTR_CANBERRA_VOLUME);
			_tmp34_ = volume;
			_tmp35_ = double_to_string (_tmp34_);
			g_hash_table_insert (_tmp32_, _tmp33_, _tmp35_);
		}
		_tmp36_ = loops;
		if (_tmp36_ == 0) {
			loops = 1;
		}
		play (____lambda4__gasync_ready_callback, NULL);
		_tmp37_ = g_main_loop_new (NULL, FALSE);
		_g_main_loop_unref0 (main_loop);
		main_loop = _tmp37_;
		_tmp38_ = main_loop;
		g_main_loop_run (_tmp38_);
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp39_ = e;
		_tmp40_ = _tmp39_->message;
		g_print ("Error: %s\n", _tmp40_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (opt_ctx);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (opt_ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_option_context_free0 (opt_ctx);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}



