/***************************************************************************
                          game.cpp  -  description
                             -------------------
    begin                : Mon Jan 21 2002
    copyright            : (C) 2002 by Brian Ashe & Jacques Fortier
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "game.h"
#include <algorithm>

Game::Game(){
	// Set default turn
	this->turn = tplayer1;
	this->cat_is_set = false;
	this->shot = false;
	this->first_ball_hit = -1;
	this->first_ball_sunk = -1;
	
	// Setup players
	strcpy(this->player_1.player_name, "Player 1");
	strcpy(this->player_2.player_name, "Player 2");
	// Reset scores to 0
	this->player_1.score = 0;
	this->player_2.score = 0;
	
	// Clear categories
	this->player_1.category = this->player_2.category = false;
	
	// No winner yet, we just started
	this->winner = -1;
	
	// Clear sunk balls
	this->player_1.sunkballs.erase(this->player_1.sunkballs.begin(), this->player_1.sunkballs.end());
	this->player_2.sunkballs.erase(this->player_2.sunkballs.begin(), this->player_2.sunkballs.end());
	
}
Game::~Game(){
}

bool Game::switch_turns(int game) {
   	if (this->scratched)
   	{
   		if (this->winner >= 0)
   		{
			switch (this->turn)
			{
				case tplayer1:
					this->winner = tplayer2;
					break;
				case tplayer2:
					this->winner = tplayer1;
					break;
			}
			
			strcpy(this->comment, "Awww, so close, but you blew it.\n");
		
		} else
		{
   			this->do_switch = true;
			strcpy(this->comment, "Oops, you scratched\n");
		}
   	}
   	
   	if (this->hit_wrong_ball)
   	{
   		this->do_switch = true;
   		this->do_foul = true;
   		if (game == eight_ball)
			strcpy(this->comment, "You shouldn't play with other peoples balls.\n");
		else
			strcpy(this->comment, "That's not the lowest ball.\n");
   	}
   	
   	if (!this->first_ball_sunk)
   	{
		strcpy(this->comment, "Missed them all!\n");
   		this->do_switch = true;
   	}

	if (this->do_switch)
	{
		switch (this->turn)
		{
			case tplayer1:
				this->turn = tplayer2;
				break;
			case tplayer2:
				this->turn = tplayer1;
				break;
		}
		return true;
	}
	return false;
}

void Game::set_category(check_pocket &cp) {
	switch (this->turn)
	{
		case tplayer1:
			if (cp.solid)
			{
				this->player_1.category = solids;
				this->player_2.category = stripes;
			}
			if (cp.stripe)
			{
				this->player_1.category = stripes;
				this->player_2.category = solids;
			}
			break;
		case tplayer2:
			if (cp.solid)
			{
				this->player_2.category = solids;
				this->player_1.category = stripes;
			}
			if (cp.stripe)
			{
				this->player_2.category = stripes;
				this->player_1.category = solids;
			}
			break;
	}
	this->cat_is_set = true;
}	

void Game::eight_ball_rules(check_pocket &cp, Ball *bnc) {
   	// If there is no category set yet, assign them
   	if (!this->cat_is_set)
   	{
   		this->set_category(cp);
   	}
   	// Place balls in the rack and determine if a turn switch must happen
   	switch (this->turn)
   	{
   		case tplayer1:
   			if (cp.eight)
   			{
				if (this->player_1.sunkballs.size() == 7)
					this->winner = tplayer1;
				else
					this->winner = tplayer2;
			}
			
			if (cp.category == player_1.category)
			{
				this->first_ball_sunk = true;
				strcpy(this->comment, "Nice Shot!\n");
				this->player_1.sunkballs.push_back(bnc->ball_num);
			}
   			
			if (cp.category != player_1.category)
			{
				if (!this->first_ball_sunk)
				{
					this->first_ball_sunk = true;
					this->do_switch = true;
				}
				
				strcpy(this->comment, "Hey! Wrong ball.\n");
				this->player_2.sunkballs.push_back(bnc->ball_num);
			}
   			break;
   		case tplayer2:
   			if (cp.eight)
   			{
   				if (this->player_2.sunkballs.size() == 7)
   					this->winner = tplayer2;
   				else
   					this->winner = tplayer1;
   			}
   			
			if (cp.category == player_2.category)
			{
				this->first_ball_sunk = true;
				strcpy(this->comment, "Nice Shot!\n");
				this->player_2.sunkballs.push_back(bnc->ball_num);
			}
   			
			if (cp.category != player_2.category)
			{
				if (!this->first_ball_sunk)
				{
					this->first_ball_sunk = true;
					this->do_switch = true;
				}
				
				strcpy(this->comment, "Hey! Wrong ball.\n");
				this->player_1.sunkballs.push_back(bnc->ball_num);
			}
   			break;
   	}
					
}

void Game::nine_ball_rules(check_pocket &cp, Ball *bnc) {
   	switch (this->turn)
   	{
   		case tplayer1:
   			if (cp.nine && !this->hit_wrong_ball)
				this->winner = tplayer1;
			else if (cp.nine && this->hit_wrong_ball)
				this->winner = tplayer2;
			
			strcpy(this->comment, "Nice Shot!\n");
			this->player_1.sunkballs.push_back(bnc->ball_num);
			this->first_ball_sunk = true;
		break;
   		case tplayer2:
   			if (cp.nine && !this->hit_wrong_ball)
				this->winner = tplayer2;
			else if (cp.nine && this->hit_wrong_ball)
				this->winner = tplayer1;
			
			strcpy(this->comment, "Nice Shot!\n");
			this->player_2.sunkballs.push_back(bnc->ball_num);
			this->first_ball_sunk = true;
		break;
	}

}

void Game::rotation_rules(check_pocket &cp, Ball *bnc) {
   	switch (this->turn)
   	{
   		case tplayer1:
			this->first_ball_sunk = true;
   			if (!this->hit_wrong_ball)
   			{
				strcpy(this->comment, "Nice Shot!\n");
				this->player_1.sunkballs.push_back(bnc->ball_num);
   				this->player_1.score += cp.ball_num;
	   		}
	   			
   			if (this->player_1.score > 60 && !this->hit_wrong_ball)
				this->winner = tplayer1;

		break;
   		case tplayer2:
			this->first_ball_sunk = true;
   			if (!this->hit_wrong_ball)
   			{
				strcpy(this->comment, "Nice Shot!\n");
				this->player_2.sunkballs.push_back(bnc->ball_num);
   				this->player_2.score += cp.ball_num;
	   		}
	   			
   			if (this->player_2.score > 60 && !this->hit_wrong_ball)
				this->winner = tplayer1;

		break;
	}

}

void Game::new_shot() {
	this->first_ball_hit = false;
	this->first_ball_sunk = false;
	this->do_switch = false;
	this->do_foul = false;
	this->hit_wrong_ball = false;
	this->scratched = false;
}

bool Game::shot_over(std::vector<Ball> &balls) {
	moving mv = for_each(balls.begin(), balls.end(), moving());
	if (!mv.is_moving)
		return true;
	else
		return false;
}
