; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================
;
; RUN: igc_opt --igc-scalarize --opaque-pointers -S < %s | FileCheck %s
; REQUIRES: llvm-14-plus
; ------------------------------------------------
; ScalarizeFunction
; ------------------------------------------------
; The pass should break vector operation into many scalar operations
; ------------------------------------------------

define <2 x i1> @basic(<2 x i32> %src1, <2 x i32> %src2) {
; CHECK-LABEL: define <2 x i1> @basic(
; CHECK-SAME: <2 x i32> [[SRC1:%.*]], <2 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x i32> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x i32> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[SRC1_SCALAR]], [[SRC2_SCALAR]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[SRC1_SCALAR1]], [[SRC2_SCALAR2]]
; CHECK-NEXT:    [[DOTASSEMBLED_VECT:%.*]] = insertelement <2 x i1> undef, i1 [[TMP1]], i32 0
; CHECK-NEXT:    [[DOTASSEMBLED_VECT3:%.*]] = insertelement <2 x i1> [[DOTASSEMBLED_VECT]], i1 [[TMP2]], i32 1
; CHECK-NEXT:    ret <2 x i1> [[DOTASSEMBLED_VECT3]]
;
  %1 = icmp eq <2 x i32> %src1, %src2
  ret <2 x i1> %1
}

define <2 x i1> @should_preserve_metadata(<2 x i32> %src1, <2 x i32> %src2) {
; CHECK-LABEL: define <2 x i1> @should_preserve_metadata(
; CHECK-SAME: <2 x i32> [[SRC1:%.*]], <2 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x i32> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x i32> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[SRC1_SCALAR]], [[SRC2_SCALAR]], !any_metadata [[META0:![0-9]+]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[SRC1_SCALAR1]], [[SRC2_SCALAR2]], !any_metadata [[META0]]
; CHECK-NEXT:    [[DOTASSEMBLED_VECT:%.*]] = insertelement <2 x i1> undef, i1 [[TMP1]], i32 0
; CHECK-NEXT:    [[DOTASSEMBLED_VECT3:%.*]] = insertelement <2 x i1> [[DOTASSEMBLED_VECT]], i1 [[TMP2]], i32 1
; CHECK-NEXT:    ret <2 x i1> [[DOTASSEMBLED_VECT3]]
;
  %1 = icmp eq <2 x i32> %src1, %src2, !any_metadata !{i32 0}
  ret <2 x i1> %1
}

define <2 x i1> @should_work_with_different_instruction_type(<2 x float> %src1, <2 x float> %src2) {
; CHECK-LABEL: define <2 x i1> @should_work_with_different_instruction_type(
; CHECK-SAME: <2 x float> [[SRC1:%.*]], <2 x float> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x float> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x float> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x float> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x float> [[SRC1]], i32 1
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp ueq float [[SRC1_SCALAR]], [[SRC2_SCALAR]]
; CHECK-NEXT:    [[TMP2:%.*]] = fcmp ueq float [[SRC1_SCALAR1]], [[SRC2_SCALAR2]]
; CHECK-NEXT:    [[DOTASSEMBLED_VECT:%.*]] = insertelement <2 x i1> undef, i1 [[TMP1]], i32 0
; CHECK-NEXT:    [[DOTASSEMBLED_VECT3:%.*]] = insertelement <2 x i1> [[DOTASSEMBLED_VECT]], i1 [[TMP2]], i32 1
; CHECK-NEXT:    ret <2 x i1> [[DOTASSEMBLED_VECT3]]
;
  %1 = fcmp ueq <2 x float> %src1, %src2
  ret <2 x i1> %1
}

define <2 x i1> @should_work_with_fast_math_flags(<2 x float> %src1, <2 x float> %src2) {
; CHECK-LABEL: define <2 x i1> @should_work_with_fast_math_flags(
; CHECK-SAME: <2 x float> [[SRC1:%.*]], <2 x float> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x float> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x float> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x float> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x float> [[SRC1]], i32 1
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp fast ueq float [[SRC1_SCALAR]], [[SRC2_SCALAR]]
; CHECK-NEXT:    [[TMP2:%.*]] = fcmp fast ueq float [[SRC1_SCALAR1]], [[SRC2_SCALAR2]]
; CHECK-NEXT:    [[DOTASSEMBLED_VECT:%.*]] = insertelement <2 x i1> undef, i1 [[TMP1]], i32 0
; CHECK-NEXT:    [[DOTASSEMBLED_VECT3:%.*]] = insertelement <2 x i1> [[DOTASSEMBLED_VECT]], i1 [[TMP2]], i32 1
; CHECK-NEXT:    ret <2 x i1> [[DOTASSEMBLED_VECT3]]
;
  %1 = fcmp fast ueq <2 x float> %src1, %src2
  ret <2 x i1> %1
}

define <2 x i1> @should_work_with_different_value_type(<2 x i64> %src1, <2 x i64> %src2) {
; CHECK-LABEL: define <2 x i1> @should_work_with_different_value_type(
; CHECK-SAME: <2 x i64> [[SRC1:%.*]], <2 x i64> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x i64> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x i64> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i64> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x i64> [[SRC1]], i32 1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[SRC1_SCALAR]], [[SRC2_SCALAR]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[SRC1_SCALAR1]], [[SRC2_SCALAR2]]
; CHECK-NEXT:    [[DOTASSEMBLED_VECT:%.*]] = insertelement <2 x i1> undef, i1 [[TMP1]], i32 0
; CHECK-NEXT:    [[DOTASSEMBLED_VECT3:%.*]] = insertelement <2 x i1> [[DOTASSEMBLED_VECT]], i1 [[TMP2]], i32 1
; CHECK-NEXT:    ret <2 x i1> [[DOTASSEMBLED_VECT3]]
;
  %1 = icmp eq <2 x i64> %src1, %src2
  ret <2 x i1> %1
}

define <16 x i1> @should_work_with_larger_vector_size(<16 x i32> %src1, <16 x i32> %src2) {
; CHECK-LABEL: define <16 x i1> @should_work_with_larger_vector_size(
; CHECK-SAME: <16 x i32> [[SRC1:%.*]], <16 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <16 x i32> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR16:%.*]] = extractelement <16 x i32> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC2_SCALAR17:%.*]] = extractelement <16 x i32> [[SRC2]], i32 2
; CHECK-NEXT:    [[SRC2_SCALAR18:%.*]] = extractelement <16 x i32> [[SRC2]], i32 3
; CHECK-NEXT:    [[SRC2_SCALAR19:%.*]] = extractelement <16 x i32> [[SRC2]], i32 4
; CHECK-NEXT:    [[SRC2_SCALAR20:%.*]] = extractelement <16 x i32> [[SRC2]], i32 5
; CHECK-NEXT:    [[SRC2_SCALAR21:%.*]] = extractelement <16 x i32> [[SRC2]], i32 6
; CHECK-NEXT:    [[SRC2_SCALAR22:%.*]] = extractelement <16 x i32> [[SRC2]], i32 7
; CHECK-NEXT:    [[SRC2_SCALAR23:%.*]] = extractelement <16 x i32> [[SRC2]], i32 8
; CHECK-NEXT:    [[SRC2_SCALAR24:%.*]] = extractelement <16 x i32> [[SRC2]], i32 9
; CHECK-NEXT:    [[SRC2_SCALAR25:%.*]] = extractelement <16 x i32> [[SRC2]], i32 10
; CHECK-NEXT:    [[SRC2_SCALAR26:%.*]] = extractelement <16 x i32> [[SRC2]], i32 11
; CHECK-NEXT:    [[SRC2_SCALAR27:%.*]] = extractelement <16 x i32> [[SRC2]], i32 12
; CHECK-NEXT:    [[SRC2_SCALAR28:%.*]] = extractelement <16 x i32> [[SRC2]], i32 13
; CHECK-NEXT:    [[SRC2_SCALAR29:%.*]] = extractelement <16 x i32> [[SRC2]], i32 14
; CHECK-NEXT:    [[SRC2_SCALAR30:%.*]] = extractelement <16 x i32> [[SRC2]], i32 15
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <16 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <16 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR2:%.*]] = extractelement <16 x i32> [[SRC1]], i32 2
; CHECK-NEXT:    [[SRC1_SCALAR3:%.*]] = extractelement <16 x i32> [[SRC1]], i32 3
; CHECK-NEXT:    [[SRC1_SCALAR4:%.*]] = extractelement <16 x i32> [[SRC1]], i32 4
; CHECK-NEXT:    [[SRC1_SCALAR5:%.*]] = extractelement <16 x i32> [[SRC1]], i32 5
; CHECK-NEXT:    [[SRC1_SCALAR6:%.*]] = extractelement <16 x i32> [[SRC1]], i32 6
; CHECK-NEXT:    [[SRC1_SCALAR7:%.*]] = extractelement <16 x i32> [[SRC1]], i32 7
; CHECK-NEXT:    [[SRC1_SCALAR8:%.*]] = extractelement <16 x i32> [[SRC1]], i32 8
; CHECK-NEXT:    [[SRC1_SCALAR9:%.*]] = extractelement <16 x i32> [[SRC1]], i32 9
; CHECK-NEXT:    [[SRC1_SCALAR10:%.*]] = extractelement <16 x i32> [[SRC1]], i32 10
; CHECK-NEXT:    [[SRC1_SCALAR11:%.*]] = extractelement <16 x i32> [[SRC1]], i32 11
; CHECK-NEXT:    [[SRC1_SCALAR12:%.*]] = extractelement <16 x i32> [[SRC1]], i32 12
; CHECK-NEXT:    [[SRC1_SCALAR13:%.*]] = extractelement <16 x i32> [[SRC1]], i32 13
; CHECK-NEXT:    [[SRC1_SCALAR14:%.*]] = extractelement <16 x i32> [[SRC1]], i32 14
; CHECK-NEXT:    [[SRC1_SCALAR15:%.*]] = extractelement <16 x i32> [[SRC1]], i32 15
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[SRC1_SCALAR]], [[SRC2_SCALAR]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[SRC1_SCALAR1]], [[SRC2_SCALAR16]]
; CHECK-NEXT:    [[TMP3:%.*]] = icmp eq i32 [[SRC1_SCALAR2]], [[SRC2_SCALAR17]]
; CHECK-NEXT:    [[TMP4:%.*]] = icmp eq i32 [[SRC1_SCALAR3]], [[SRC2_SCALAR18]]
; CHECK-NEXT:    [[TMP5:%.*]] = icmp eq i32 [[SRC1_SCALAR4]], [[SRC2_SCALAR19]]
; CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i32 [[SRC1_SCALAR5]], [[SRC2_SCALAR20]]
; CHECK-NEXT:    [[TMP7:%.*]] = icmp eq i32 [[SRC1_SCALAR6]], [[SRC2_SCALAR21]]
; CHECK-NEXT:    [[TMP8:%.*]] = icmp eq i32 [[SRC1_SCALAR7]], [[SRC2_SCALAR22]]
; CHECK-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[SRC1_SCALAR8]], [[SRC2_SCALAR23]]
; CHECK-NEXT:    [[TMP10:%.*]] = icmp eq i32 [[SRC1_SCALAR9]], [[SRC2_SCALAR24]]
; CHECK-NEXT:    [[TMP11:%.*]] = icmp eq i32 [[SRC1_SCALAR10]], [[SRC2_SCALAR25]]
; CHECK-NEXT:    [[TMP12:%.*]] = icmp eq i32 [[SRC1_SCALAR11]], [[SRC2_SCALAR26]]
; CHECK-NEXT:    [[TMP13:%.*]] = icmp eq i32 [[SRC1_SCALAR12]], [[SRC2_SCALAR27]]
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i32 [[SRC1_SCALAR13]], [[SRC2_SCALAR28]]
; CHECK-NEXT:    [[TMP15:%.*]] = icmp eq i32 [[SRC1_SCALAR14]], [[SRC2_SCALAR29]]
; CHECK-NEXT:    [[TMP16:%.*]] = icmp eq i32 [[SRC1_SCALAR15]], [[SRC2_SCALAR30]]
; CHECK-NEXT:    [[DOTASSEMBLED_VECT:%.*]] = insertelement <16 x i1> undef, i1 [[TMP1]], i32 0
; CHECK-NEXT:    [[DOTASSEMBLED_VECT31:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT]], i1 [[TMP2]], i32 1
; CHECK-NEXT:    [[DOTASSEMBLED_VECT32:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT31]], i1 [[TMP3]], i32 2
; CHECK-NEXT:    [[DOTASSEMBLED_VECT33:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT32]], i1 [[TMP4]], i32 3
; CHECK-NEXT:    [[DOTASSEMBLED_VECT34:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT33]], i1 [[TMP5]], i32 4
; CHECK-NEXT:    [[DOTASSEMBLED_VECT35:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT34]], i1 [[TMP6]], i32 5
; CHECK-NEXT:    [[DOTASSEMBLED_VECT36:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT35]], i1 [[TMP7]], i32 6
; CHECK-NEXT:    [[DOTASSEMBLED_VECT37:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT36]], i1 [[TMP8]], i32 7
; CHECK-NEXT:    [[DOTASSEMBLED_VECT38:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT37]], i1 [[TMP9]], i32 8
; CHECK-NEXT:    [[DOTASSEMBLED_VECT39:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT38]], i1 [[TMP10]], i32 9
; CHECK-NEXT:    [[DOTASSEMBLED_VECT40:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT39]], i1 [[TMP11]], i32 10
; CHECK-NEXT:    [[DOTASSEMBLED_VECT41:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT40]], i1 [[TMP12]], i32 11
; CHECK-NEXT:    [[DOTASSEMBLED_VECT42:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT41]], i1 [[TMP13]], i32 12
; CHECK-NEXT:    [[DOTASSEMBLED_VECT43:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT42]], i1 [[TMP14]], i32 13
; CHECK-NEXT:    [[DOTASSEMBLED_VECT44:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT43]], i1 [[TMP15]], i32 14
; CHECK-NEXT:    [[DOTASSEMBLED_VECT45:%.*]] = insertelement <16 x i1> [[DOTASSEMBLED_VECT44]], i1 [[TMP16]], i32 15
; CHECK-NEXT:    ret <16 x i1> [[DOTASSEMBLED_VECT45]]
;
  %1 = icmp eq <16 x i32> %src1, %src2
  ret <16 x i1> %1
}

define <2 x i1> @should_work_with_constant_value(<2 x i32> %src1) {
; CHECK-LABEL: define <2 x i1> @should_work_with_constant_value(
; CHECK-SAME: <2 x i32> [[SRC1:%.*]]) {
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[SRC1_SCALAR]], 4
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[SRC1_SCALAR1]], 8
; CHECK-NEXT:    [[DOTASSEMBLED_VECT:%.*]] = insertelement <2 x i1> undef, i1 [[TMP1]], i32 0
; CHECK-NEXT:    [[DOTASSEMBLED_VECT2:%.*]] = insertelement <2 x i1> [[DOTASSEMBLED_VECT]], i1 [[TMP2]], i32 1
; CHECK-NEXT:    ret <2 x i1> [[DOTASSEMBLED_VECT2]]
;
  %1 = icmp eq <2 x i32> %src1, <i32 4, i32 8>
  ret <2 x i1> %1
}

define <2 x i1> @should_work_with_different_coparison_type(<2 x i32> %src1, <2 x i32> %src2) {
; CHECK-LABEL: define <2 x i1> @should_work_with_different_coparison_type(
; CHECK-SAME: <2 x i32> [[SRC1:%.*]], <2 x i32> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x i32> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x i32> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x i32> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x i32> [[SRC1]], i32 1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp uge i32 [[SRC1_SCALAR]], [[SRC2_SCALAR]]
; CHECK-NEXT:    [[TMP2:%.*]] = icmp uge i32 [[SRC1_SCALAR1]], [[SRC2_SCALAR2]]
; CHECK-NEXT:    [[DOTASSEMBLED_VECT:%.*]] = insertelement <2 x i1> undef, i1 [[TMP1]], i32 0
; CHECK-NEXT:    [[DOTASSEMBLED_VECT3:%.*]] = insertelement <2 x i1> [[DOTASSEMBLED_VECT]], i1 [[TMP2]], i32 1
; CHECK-NEXT:    ret <2 x i1> [[DOTASSEMBLED_VECT3]]
;
  %1 = icmp uge <2 x i32> %src1, %src2
  ret <2 x i1> %1
}

; triangulating with @should_work_with_different_instruction_type
define <2 x i1> @should_work_with_different_coparison_type_2(<2 x float> %src1, <2 x float> %src2) {
; CHECK-LABEL: define <2 x i1> @should_work_with_different_coparison_type_2(
; CHECK-SAME: <2 x float> [[SRC1:%.*]], <2 x float> [[SRC2:%.*]]) {
; CHECK-NEXT:    [[SRC2_SCALAR:%.*]] = extractelement <2 x float> [[SRC2]], i32 0
; CHECK-NEXT:    [[SRC2_SCALAR2:%.*]] = extractelement <2 x float> [[SRC2]], i32 1
; CHECK-NEXT:    [[SRC1_SCALAR:%.*]] = extractelement <2 x float> [[SRC1]], i32 0
; CHECK-NEXT:    [[SRC1_SCALAR1:%.*]] = extractelement <2 x float> [[SRC1]], i32 1
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp false float [[SRC1_SCALAR]], [[SRC2_SCALAR]]
; CHECK-NEXT:    [[TMP2:%.*]] = fcmp false float [[SRC1_SCALAR1]], [[SRC2_SCALAR2]]
; CHECK-NEXT:    [[DOTASSEMBLED_VECT:%.*]] = insertelement <2 x i1> undef, i1 [[TMP1]], i32 0
; CHECK-NEXT:    [[DOTASSEMBLED_VECT3:%.*]] = insertelement <2 x i1> [[DOTASSEMBLED_VECT]], i1 [[TMP2]], i32 1
; CHECK-NEXT:    ret <2 x i1> [[DOTASSEMBLED_VECT3]]
;
  %1 = fcmp false <2 x float> %src1, %src2
  ret <2 x i1> %1
}

define <2 x i1> @should_not_scalarize_two_constants() {
; CHECK-LABEL: define <2 x i1> @should_not_scalarize_two_constants() {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i32> <i32 4, i32 4>, <i32 4, i32 8>
; CHECK-NEXT:    ret <2 x i1> [[TMP1]]
;
  %1 = icmp eq <2 x i32> <i32 4, i32 4>, <i32 4, i32 8>
  ret <2 x i1> %1
}

; CHECK: [[META0]] = !{i32 0}