
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSslSocket.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSslSocket>
#include <QAuthenticator>
#include <QEvent>
#include <QHostAddress>
#include <QNetworkProxy>
#include <QObject>
#include <QSslCertificate>
#include <QSslCipher>
#include <QSslConfiguration>
#include <QSslError>
#include <QSslKey>
#include <QThread>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSslSocket

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSslSocket::staticMetaObject);
}


//  Constructor QSslSocket::QSslSocket(QObject *parent)


static void _init_ctor_QSslSocket_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSslSocket> ();
}

static void _call_ctor_QSslSocket_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QSslSocket *> (new QSslSocket (arg1));
}


// void QSslSocket::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->abort ();
}


// void QSslSocket::addCaCertificate(const QSslCertificate &certificate)


static void _init_f_addCaCertificate_2823 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificate");
  decl->add_arg<const QSslCertificate & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addCaCertificate_2823 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSslCertificate &arg1 = gsi::arg_reader<const QSslCertificate & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->addCaCertificate (arg1);
}


// bool QSslSocket::addCaCertificates(const QString &path, QSsl::EncodingFormat format, QRegExp::PatternSyntax syntax)


static void _init_f_addCaCertificates_6773 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QSsl::Pem");
  decl->add_arg<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("syntax", true, "QRegExp::FixedString");
  decl->add_arg<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_addCaCertificates_6773 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QSsl::EncodingFormat>(heap, QSsl::Pem), heap);
  const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QRegExp::PatternSyntax>(heap, QRegExp::FixedString), heap);
  ret.write<bool > ((bool)((QSslSocket *)cls)->addCaCertificates (arg1, qt_gsi::QtToCppAdaptor<QSsl::EncodingFormat>(arg2).cref(), qt_gsi::QtToCppAdaptor<QRegExp::PatternSyntax>(arg3).cref()));
}


// void QSslSocket::addCaCertificates(const QList<QSslCertificate> &certificates)


static void _init_f_addCaCertificates_3438 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificates");
  decl->add_arg<const QList<QSslCertificate> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addCaCertificates_3438 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QSslCertificate> &arg1 = gsi::arg_reader<const QList<QSslCertificate> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->addCaCertificates (arg1);
}


// bool QSslSocket::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSslSocket *)cls)->atEnd ());
}


// qint64 QSslSocket::bytesAvailable()


static void _init_f_bytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QSslSocket *)cls)->bytesAvailable ());
}


// qint64 QSslSocket::bytesToWrite()


static void _init_f_bytesToWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesToWrite_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QSslSocket *)cls)->bytesToWrite ());
}


// QList<QSslCertificate> QSslSocket::caCertificates()


static void _init_f_caCertificates_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QSslCertificate> > ();
}

static void _call_f_caCertificates_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QSslCertificate> > ((QList<QSslCertificate>)((QSslSocket *)cls)->caCertificates ());
}


// bool QSslSocket::canReadLine()


static void _init_f_canReadLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canReadLine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSslSocket *)cls)->canReadLine ());
}


// QList<QSslCipher> QSslSocket::ciphers()


static void _init_f_ciphers_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QSslCipher> > ();
}

static void _call_f_ciphers_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QSslCipher> > ((QList<QSslCipher>)((QSslSocket *)cls)->ciphers ());
}


// void QSslSocket::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->close ();
}


// void QSslSocket::connectToHostEncrypted(const QString &hostName, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_connectToHostEncrypted_6151 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hostName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_connectToHostEncrypted_6151 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  quint16 arg2 = gsi::arg_reader<quint16 >() (args, heap);
  QFlags<QIODevice::OpenModeFlag> arg3 = args ? gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODevice::OpenModeFlag> >() (QIODevice::ReadWrite, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->connectToHostEncrypted (arg1, arg2, arg3);
}


// void QSslSocket::connectToHostEncrypted(const QString &hostName, quint16 port, const QString &sslPeerName, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_connectToHostEncrypted_8068 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hostName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sslPeerName");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_connectToHostEncrypted_8068 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  quint16 arg2 = gsi::arg_reader<quint16 >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QIODevice::OpenModeFlag> arg4 = args ? gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODevice::OpenModeFlag> >() (QIODevice::ReadWrite, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->connectToHostEncrypted (arg1, arg2, arg3, arg4);
}


// qint64 QSslSocket::encryptedBytesAvailable()


static void _init_f_encryptedBytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_encryptedBytesAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QSslSocket *)cls)->encryptedBytesAvailable ());
}


// qint64 QSslSocket::encryptedBytesToWrite()


static void _init_f_encryptedBytesToWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_encryptedBytesToWrite_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QSslSocket *)cls)->encryptedBytesToWrite ());
}


// bool QSslSocket::flush()


static void _init_f_flush_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSslSocket *)cls)->flush ());
}


// void QSslSocket::ignoreSslErrors(const QList<QSslError> &errors)


static void _init_f_ignoreSslErrors_2837 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("errors");
  decl->add_arg<const QList<QSslError> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ignoreSslErrors_2837 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QSslError> &arg1 = gsi::arg_reader<const QList<QSslError> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->ignoreSslErrors (arg1);
}


// void QSslSocket::ignoreSslErrors()


static void _init_f_ignoreSslErrors_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ignoreSslErrors_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->ignoreSslErrors ();
}


// bool QSslSocket::isEncrypted()


static void _init_f_isEncrypted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEncrypted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSslSocket *)cls)->isEncrypted ());
}


// QSslCertificate QSslSocket::localCertificate()


static void _init_f_localCertificate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslCertificate > ();
}

static void _call_f_localCertificate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSslCertificate > ((QSslCertificate)((QSslSocket *)cls)->localCertificate ());
}


// QSslSocket::SslMode QSslSocket::mode()


static void _init_f_mode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSslSocket::SslMode>::target_type > ();
}

static void _call_f_mode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSslSocket::SslMode>::target_type > ((qt_gsi::Converter<QSslSocket::SslMode>::target_type)qt_gsi::CppToQtAdaptor<QSslSocket::SslMode>(((QSslSocket *)cls)->mode ()));
}


// QSslCertificate QSslSocket::peerCertificate()


static void _init_f_peerCertificate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslCertificate > ();
}

static void _call_f_peerCertificate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSslCertificate > ((QSslCertificate)((QSslSocket *)cls)->peerCertificate ());
}


// QList<QSslCertificate> QSslSocket::peerCertificateChain()


static void _init_f_peerCertificateChain_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QSslCertificate> > ();
}

static void _call_f_peerCertificateChain_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QSslCertificate> > ((QList<QSslCertificate>)((QSslSocket *)cls)->peerCertificateChain ());
}


// int QSslSocket::peerVerifyDepth()


static void _init_f_peerVerifyDepth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_peerVerifyDepth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSslSocket *)cls)->peerVerifyDepth ());
}


// QSslSocket::PeerVerifyMode QSslSocket::peerVerifyMode()


static void _init_f_peerVerifyMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type > ();
}

static void _call_f_peerVerifyMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type > ((qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type)qt_gsi::CppToQtAdaptor<QSslSocket::PeerVerifyMode>(((QSslSocket *)cls)->peerVerifyMode ()));
}


// QSslKey QSslSocket::privateKey()


static void _init_f_privateKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslKey > ();
}

static void _call_f_privateKey_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSslKey > ((QSslKey)((QSslSocket *)cls)->privateKey ());
}


// QSsl::SslProtocol QSslSocket::protocol()


static void _init_f_protocol_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSsl::SslProtocol>::target_type > ();
}

static void _call_f_protocol_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSsl::SslProtocol>::target_type > ((qt_gsi::Converter<QSsl::SslProtocol>::target_type)qt_gsi::CppToQtAdaptor<QSsl::SslProtocol>(((QSslSocket *)cls)->protocol ()));
}


// QSslCipher QSslSocket::sessionCipher()


static void _init_f_sessionCipher_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslCipher > ();
}

static void _call_f_sessionCipher_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSslCipher > ((QSslCipher)((QSslSocket *)cls)->sessionCipher ());
}


// void QSslSocket::setCaCertificates(const QList<QSslCertificate> &certificates)


static void _init_f_setCaCertificates_3438 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificates");
  decl->add_arg<const QList<QSslCertificate> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCaCertificates_3438 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QSslCertificate> &arg1 = gsi::arg_reader<const QList<QSslCertificate> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setCaCertificates (arg1);
}


// void QSslSocket::setCiphers(const QList<QSslCipher> &ciphers)


static void _init_f_setCiphers_2918 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ciphers");
  decl->add_arg<const QList<QSslCipher> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCiphers_2918 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QSslCipher> &arg1 = gsi::arg_reader<const QList<QSslCipher> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setCiphers (arg1);
}


// void QSslSocket::setCiphers(const QString &ciphers)


static void _init_f_setCiphers_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ciphers");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCiphers_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setCiphers (arg1);
}


// void QSslSocket::setLocalCertificate(const QSslCertificate &certificate)


static void _init_f_setLocalCertificate_2823 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificate");
  decl->add_arg<const QSslCertificate & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLocalCertificate_2823 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSslCertificate &arg1 = gsi::arg_reader<const QSslCertificate & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setLocalCertificate (arg1);
}


// void QSslSocket::setLocalCertificate(const QString &fileName, QSsl::EncodingFormat format)


static void _init_f_setLocalCertificate_4280 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QSsl::Pem");
  decl->add_arg<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setLocalCertificate_4280 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QSsl::EncodingFormat>(heap, QSsl::Pem), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setLocalCertificate (arg1, qt_gsi::QtToCppAdaptor<QSsl::EncodingFormat>(arg2).cref());
}


// void QSslSocket::setPeerVerifyDepth(int depth)


static void _init_f_setPeerVerifyDepth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("depth");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPeerVerifyDepth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setPeerVerifyDepth (arg1);
}


// void QSslSocket::setPeerVerifyMode(QSslSocket::PeerVerifyMode mode)


static void _init_f_setPeerVerifyMode_2970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPeerVerifyMode_2970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setPeerVerifyMode (qt_gsi::QtToCppAdaptor<QSslSocket::PeerVerifyMode>(arg1).cref());
}


// void QSslSocket::setPrivateKey(const QSslKey &key)


static void _init_f_setPrivateKey_1997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QSslKey & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPrivateKey_1997 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSslKey &arg1 = gsi::arg_reader<const QSslKey & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setPrivateKey (arg1);
}


// void QSslSocket::setPrivateKey(const QString &fileName, QSsl::KeyAlgorithm algorithm, QSsl::EncodingFormat format, const QByteArray &passPhrase)


static void _init_f_setPrivateKey_8544 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("algorithm", true, "QSsl::Rsa");
  decl->add_arg<const qt_gsi::Converter<QSsl::KeyAlgorithm>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format", true, "QSsl::Pem");
  decl->add_arg<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("passPhrase", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setPrivateKey_8544 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QSsl::KeyAlgorithm>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QSsl::KeyAlgorithm>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QSsl::KeyAlgorithm>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QSsl::KeyAlgorithm>(heap, QSsl::Rsa), heap);
  const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QSsl::EncodingFormat>(heap, QSsl::Pem), heap);
  const QByteArray &arg4 = args ? gsi::arg_reader<const QByteArray & >() (args, heap) : gsi::arg_maker<const QByteArray & >() (QByteArray(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setPrivateKey (arg1, qt_gsi::QtToCppAdaptor<QSsl::KeyAlgorithm>(arg2).cref(), qt_gsi::QtToCppAdaptor<QSsl::EncodingFormat>(arg3).cref(), arg4);
}


// void QSslSocket::setProtocol(QSsl::SslProtocol protocol)


static void _init_f_setProtocol_2095 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("protocol");
  decl->add_arg<const qt_gsi::Converter<QSsl::SslProtocol>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProtocol_2095 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSsl::SslProtocol>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSsl::SslProtocol>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setProtocol (qt_gsi::QtToCppAdaptor<QSsl::SslProtocol>(arg1).cref());
}


// void QSslSocket::setReadBufferSize(qint64 size)


static void _init_f_setReadBufferSize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadBufferSize_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setReadBufferSize (arg1);
}


// bool QSslSocket::setSocketDescriptor(int socketDescriptor, QAbstractSocket::SocketState state, QFlags<QIODevice::OpenModeFlag> openMode)


static void _init_f_setSocketDescriptor_6993 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socketDescriptor");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("state", true, "QAbstractSocket::ConnectedState");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("openMode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setSocketDescriptor_6993 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractSocket::SocketState>(heap, QAbstractSocket::ConnectedState), heap);
  QFlags<QIODevice::OpenModeFlag> arg3 = args ? gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODevice::OpenModeFlag> >() (QIODevice::ReadWrite, heap);
  ret.write<bool > ((bool)((QSslSocket *)cls)->setSocketDescriptor (arg1, qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketState>(arg2).cref(), arg3));
}


// void QSslSocket::setSocketOption(QAbstractSocket::SocketOption option, const QVariant &value)


static void _init_f_setSocketOption_5331 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSocketOption_5331 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setSocketOption (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketOption>(arg1).cref(), arg2);
}


// void QSslSocket::setSslConfiguration(const QSslConfiguration &config)


static void _init_f_setSslConfiguration_3068 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("config");
  decl->add_arg<const QSslConfiguration & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSslConfiguration_3068 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSslConfiguration &arg1 = gsi::arg_reader<const QSslConfiguration & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->setSslConfiguration (arg1);
}


// QVariant QSslSocket::socketOption(QAbstractSocket::SocketOption option)


static void _init_f_socketOption_3320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_socketOption_3320 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QSslSocket *)cls)->socketOption (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketOption>(arg1).cref()));
}


// QSslConfiguration QSslSocket::sslConfiguration()


static void _init_f_sslConfiguration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslConfiguration > ();
}

static void _call_f_sslConfiguration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSslConfiguration > ((QSslConfiguration)((QSslSocket *)cls)->sslConfiguration ());
}


// QList<QSslError> QSslSocket::sslErrors()


static void _init_f_sslErrors_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QSslError> > ();
}

static void _call_f_sslErrors_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QSslError> > ((QList<QSslError>)((QSslSocket *)cls)->sslErrors ());
}


// void QSslSocket::startClientEncryption()


static void _init_f_startClientEncryption_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_startClientEncryption_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->startClientEncryption ();
}


// void QSslSocket::startServerEncryption()


static void _init_f_startServerEncryption_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_startServerEncryption_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSslSocket *)cls)->startServerEncryption ();
}


// bool QSslSocket::waitForBytesWritten(int msecs)


static void _init_f_waitForBytesWritten_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForBytesWritten_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QSslSocket *)cls)->waitForBytesWritten (arg1));
}


// bool QSslSocket::waitForConnected(int msecs)


static void _init_f_waitForConnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForConnected_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QSslSocket *)cls)->waitForConnected (arg1));
}


// bool QSslSocket::waitForDisconnected(int msecs)


static void _init_f_waitForDisconnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForDisconnected_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QSslSocket *)cls)->waitForDisconnected (arg1));
}


// bool QSslSocket::waitForEncrypted(int msecs)


static void _init_f_waitForEncrypted_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForEncrypted_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QSslSocket *)cls)->waitForEncrypted (arg1));
}


// bool QSslSocket::waitForReadyRead(int msecs)


static void _init_f_waitForReadyRead_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForReadyRead_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QSslSocket *)cls)->waitForReadyRead (arg1));
}


// static void QSslSocket::addDefaultCaCertificate(const QSslCertificate &certificate)


static void _init_f_addDefaultCaCertificate_2823 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificate");
  decl->add_arg<const QSslCertificate & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addDefaultCaCertificate_2823 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSslCertificate &arg1 = gsi::arg_reader<const QSslCertificate & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QSslSocket::addDefaultCaCertificate (arg1);
}


// static bool QSslSocket::addDefaultCaCertificates(const QString &path, QSsl::EncodingFormat format, QRegExp::PatternSyntax syntax)


static void _init_f_addDefaultCaCertificates_6773 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QSsl::Pem");
  decl->add_arg<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("syntax", true, "QRegExp::FixedString");
  decl->add_arg<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_addDefaultCaCertificates_6773 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QSsl::EncodingFormat>(heap, QSsl::Pem), heap);
  const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QRegExp::PatternSyntax>(heap, QRegExp::FixedString), heap);
  ret.write<bool > ((bool)QSslSocket::addDefaultCaCertificates (arg1, qt_gsi::QtToCppAdaptor<QSsl::EncodingFormat>(arg2).cref(), qt_gsi::QtToCppAdaptor<QRegExp::PatternSyntax>(arg3).cref()));
}


// static void QSslSocket::addDefaultCaCertificates(const QList<QSslCertificate> &certificates)


static void _init_f_addDefaultCaCertificates_3438 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificates");
  decl->add_arg<const QList<QSslCertificate> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addDefaultCaCertificates_3438 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QSslCertificate> &arg1 = gsi::arg_reader<const QList<QSslCertificate> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QSslSocket::addDefaultCaCertificates (arg1);
}


// static QList<QSslCertificate> QSslSocket::defaultCaCertificates()


static void _init_f_defaultCaCertificates_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QSslCertificate> > ();
}

static void _call_f_defaultCaCertificates_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QSslCertificate> > ((QList<QSslCertificate>)QSslSocket::defaultCaCertificates ());
}


// static QList<QSslCipher> QSslSocket::defaultCiphers()


static void _init_f_defaultCiphers_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QSslCipher> > ();
}

static void _call_f_defaultCiphers_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QSslCipher> > ((QList<QSslCipher>)QSslSocket::defaultCiphers ());
}


// static void QSslSocket::setDefaultCaCertificates(const QList<QSslCertificate> &certificates)


static void _init_f_setDefaultCaCertificates_3438 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificates");
  decl->add_arg<const QList<QSslCertificate> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultCaCertificates_3438 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QSslCertificate> &arg1 = gsi::arg_reader<const QList<QSslCertificate> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QSslSocket::setDefaultCaCertificates (arg1);
}


// static void QSslSocket::setDefaultCiphers(const QList<QSslCipher> &ciphers)


static void _init_f_setDefaultCiphers_2918 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ciphers");
  decl->add_arg<const QList<QSslCipher> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultCiphers_2918 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QSslCipher> &arg1 = gsi::arg_reader<const QList<QSslCipher> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QSslSocket::setDefaultCiphers (arg1);
}


// static QList<QSslCipher> QSslSocket::supportedCiphers()


static void _init_f_supportedCiphers_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QSslCipher> > ();
}

static void _call_f_supportedCiphers_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QSslCipher> > ((QList<QSslCipher>)QSslSocket::supportedCiphers ());
}


// static bool QSslSocket::supportsSsl()


static void _init_f_supportsSsl_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_supportsSsl_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QSslSocket::supportsSsl ());
}


// static QList<QSslCertificate> QSslSocket::systemCaCertificates()


static void _init_f_systemCaCertificates_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QSslCertificate> > ();
}

static void _call_f_systemCaCertificates_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QSslCertificate> > ((QList<QSslCertificate>)QSslSocket::systemCaCertificates ());
}


// static QString QSslSocket::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QSslSocket::tr (arg1, arg2));
}


// static QString QSslSocket::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QSslSocket::tr (arg1, arg2, arg3));
}


// static QString QSslSocket::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QSslSocket::trUtf8 (arg1, arg2));
}


// static QString QSslSocket::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QSslSocket::trUtf8 (arg1, arg2, arg3));
}



namespace gsi
{

static gsi::Methods methods_QSslSocket () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSslSocket::QSslSocket(QObject *parent)\nThis method creates an object of class QSslSocket.", &_init_ctor_QSslSocket_1302, &_call_ctor_QSslSocket_1302);
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("abort", "@brief Method void QSslSocket::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
  methods += new qt_gsi::GenericMethod ("addCaCertificate", "@brief Method void QSslSocket::addCaCertificate(const QSslCertificate &certificate)\n", false, &_init_f_addCaCertificate_2823, &_call_f_addCaCertificate_2823);
  methods += new qt_gsi::GenericMethod ("addCaCertificates", "@brief Method bool QSslSocket::addCaCertificates(const QString &path, QSsl::EncodingFormat format, QRegExp::PatternSyntax syntax)\n", false, &_init_f_addCaCertificates_6773, &_call_f_addCaCertificates_6773);
  methods += new qt_gsi::GenericMethod ("addCaCertificates", "@brief Method void QSslSocket::addCaCertificates(const QList<QSslCertificate> &certificates)\n", false, &_init_f_addCaCertificates_3438, &_call_f_addCaCertificates_3438);
  methods += new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QSslSocket::atEnd()\nThis is a reimplementation of QAbstractSocket::atEnd", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
  methods += new qt_gsi::GenericMethod ("bytesAvailable", "@brief Method qint64 QSslSocket::bytesAvailable()\nThis is a reimplementation of QAbstractSocket::bytesAvailable", true, &_init_f_bytesAvailable_c0, &_call_f_bytesAvailable_c0);
  methods += new qt_gsi::GenericMethod ("bytesToWrite", "@brief Method qint64 QSslSocket::bytesToWrite()\nThis is a reimplementation of QAbstractSocket::bytesToWrite", true, &_init_f_bytesToWrite_c0, &_call_f_bytesToWrite_c0);
  methods += new qt_gsi::GenericMethod (":caCertificates", "@brief Method QList<QSslCertificate> QSslSocket::caCertificates()\n", true, &_init_f_caCertificates_c0, &_call_f_caCertificates_c0);
  methods += new qt_gsi::GenericMethod ("canReadLine", "@brief Method bool QSslSocket::canReadLine()\nThis is a reimplementation of QAbstractSocket::canReadLine", true, &_init_f_canReadLine_c0, &_call_f_canReadLine_c0);
  methods += new qt_gsi::GenericMethod (":ciphers", "@brief Method QList<QSslCipher> QSslSocket::ciphers()\n", true, &_init_f_ciphers_c0, &_call_f_ciphers_c0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method void QSslSocket::close()\nThis is a reimplementation of QAbstractSocket::close", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod ("connectToHostEncrypted", "@brief Method void QSslSocket::connectToHostEncrypted(const QString &hostName, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_connectToHostEncrypted_6151, &_call_f_connectToHostEncrypted_6151);
  methods += new qt_gsi::GenericMethod ("connectToHostEncrypted", "@brief Method void QSslSocket::connectToHostEncrypted(const QString &hostName, quint16 port, const QString &sslPeerName, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_connectToHostEncrypted_8068, &_call_f_connectToHostEncrypted_8068);
  methods += new qt_gsi::GenericMethod ("encryptedBytesAvailable", "@brief Method qint64 QSslSocket::encryptedBytesAvailable()\n", true, &_init_f_encryptedBytesAvailable_c0, &_call_f_encryptedBytesAvailable_c0);
  methods += new qt_gsi::GenericMethod ("encryptedBytesToWrite", "@brief Method qint64 QSslSocket::encryptedBytesToWrite()\n", true, &_init_f_encryptedBytesToWrite_c0, &_call_f_encryptedBytesToWrite_c0);
  methods += new qt_gsi::GenericMethod ("flush", "@brief Method bool QSslSocket::flush()\n", false, &_init_f_flush_0, &_call_f_flush_0);
  methods += new qt_gsi::GenericMethod ("ignoreSslErrors", "@brief Method void QSslSocket::ignoreSslErrors(const QList<QSslError> &errors)\n", false, &_init_f_ignoreSslErrors_2837, &_call_f_ignoreSslErrors_2837);
  methods += new qt_gsi::GenericMethod ("ignoreSslErrors", "@brief Method void QSslSocket::ignoreSslErrors()\n", false, &_init_f_ignoreSslErrors_0, &_call_f_ignoreSslErrors_0);
  methods += new qt_gsi::GenericMethod ("isEncrypted?", "@brief Method bool QSslSocket::isEncrypted()\n", true, &_init_f_isEncrypted_c0, &_call_f_isEncrypted_c0);
  methods += new qt_gsi::GenericMethod (":localCertificate", "@brief Method QSslCertificate QSslSocket::localCertificate()\n", true, &_init_f_localCertificate_c0, &_call_f_localCertificate_c0);
  methods += new qt_gsi::GenericMethod ("mode", "@brief Method QSslSocket::SslMode QSslSocket::mode()\n", true, &_init_f_mode_c0, &_call_f_mode_c0);
  methods += new qt_gsi::GenericMethod ("peerCertificate", "@brief Method QSslCertificate QSslSocket::peerCertificate()\n", true, &_init_f_peerCertificate_c0, &_call_f_peerCertificate_c0);
  methods += new qt_gsi::GenericMethod ("peerCertificateChain", "@brief Method QList<QSslCertificate> QSslSocket::peerCertificateChain()\n", true, &_init_f_peerCertificateChain_c0, &_call_f_peerCertificateChain_c0);
  methods += new qt_gsi::GenericMethod (":peerVerifyDepth", "@brief Method int QSslSocket::peerVerifyDepth()\n", true, &_init_f_peerVerifyDepth_c0, &_call_f_peerVerifyDepth_c0);
  methods += new qt_gsi::GenericMethod (":peerVerifyMode", "@brief Method QSslSocket::PeerVerifyMode QSslSocket::peerVerifyMode()\n", true, &_init_f_peerVerifyMode_c0, &_call_f_peerVerifyMode_c0);
  methods += new qt_gsi::GenericMethod (":privateKey", "@brief Method QSslKey QSslSocket::privateKey()\n", true, &_init_f_privateKey_c0, &_call_f_privateKey_c0);
  methods += new qt_gsi::GenericMethod (":protocol", "@brief Method QSsl::SslProtocol QSslSocket::protocol()\n", true, &_init_f_protocol_c0, &_call_f_protocol_c0);
  methods += new qt_gsi::GenericMethod ("sessionCipher", "@brief Method QSslCipher QSslSocket::sessionCipher()\n", true, &_init_f_sessionCipher_c0, &_call_f_sessionCipher_c0);
  methods += new qt_gsi::GenericMethod ("setCaCertificates|caCertificates=", "@brief Method void QSslSocket::setCaCertificates(const QList<QSslCertificate> &certificates)\n", false, &_init_f_setCaCertificates_3438, &_call_f_setCaCertificates_3438);
  methods += new qt_gsi::GenericMethod ("setCiphers|ciphers=", "@brief Method void QSslSocket::setCiphers(const QList<QSslCipher> &ciphers)\n", false, &_init_f_setCiphers_2918, &_call_f_setCiphers_2918);
  methods += new qt_gsi::GenericMethod ("setCiphers|ciphers=", "@brief Method void QSslSocket::setCiphers(const QString &ciphers)\n", false, &_init_f_setCiphers_2025, &_call_f_setCiphers_2025);
  methods += new qt_gsi::GenericMethod ("setLocalCertificate|localCertificate=", "@brief Method void QSslSocket::setLocalCertificate(const QSslCertificate &certificate)\n", false, &_init_f_setLocalCertificate_2823, &_call_f_setLocalCertificate_2823);
  methods += new qt_gsi::GenericMethod ("setLocalCertificate", "@brief Method void QSslSocket::setLocalCertificate(const QString &fileName, QSsl::EncodingFormat format)\n", false, &_init_f_setLocalCertificate_4280, &_call_f_setLocalCertificate_4280);
  methods += new qt_gsi::GenericMethod ("setPeerVerifyDepth|peerVerifyDepth=", "@brief Method void QSslSocket::setPeerVerifyDepth(int depth)\n", false, &_init_f_setPeerVerifyDepth_767, &_call_f_setPeerVerifyDepth_767);
  methods += new qt_gsi::GenericMethod ("setPeerVerifyMode|peerVerifyMode=", "@brief Method void QSslSocket::setPeerVerifyMode(QSslSocket::PeerVerifyMode mode)\n", false, &_init_f_setPeerVerifyMode_2970, &_call_f_setPeerVerifyMode_2970);
  methods += new qt_gsi::GenericMethod ("setPrivateKey|privateKey=", "@brief Method void QSslSocket::setPrivateKey(const QSslKey &key)\n", false, &_init_f_setPrivateKey_1997, &_call_f_setPrivateKey_1997);
  methods += new qt_gsi::GenericMethod ("setPrivateKey", "@brief Method void QSslSocket::setPrivateKey(const QString &fileName, QSsl::KeyAlgorithm algorithm, QSsl::EncodingFormat format, const QByteArray &passPhrase)\n", false, &_init_f_setPrivateKey_8544, &_call_f_setPrivateKey_8544);
  methods += new qt_gsi::GenericMethod ("setProtocol|protocol=", "@brief Method void QSslSocket::setProtocol(QSsl::SslProtocol protocol)\n", false, &_init_f_setProtocol_2095, &_call_f_setProtocol_2095);
  methods += new qt_gsi::GenericMethod ("setReadBufferSize|readBufferSize=", "@brief Method void QSslSocket::setReadBufferSize(qint64 size)\n", false, &_init_f_setReadBufferSize_986, &_call_f_setReadBufferSize_986);
  methods += new qt_gsi::GenericMethod ("setSocketDescriptor", "@brief Method bool QSslSocket::setSocketDescriptor(int socketDescriptor, QAbstractSocket::SocketState state, QFlags<QIODevice::OpenModeFlag> openMode)\n", false, &_init_f_setSocketDescriptor_6993, &_call_f_setSocketDescriptor_6993);
  methods += new qt_gsi::GenericMethod ("setSocketOption", "@brief Method void QSslSocket::setSocketOption(QAbstractSocket::SocketOption option, const QVariant &value)\n", false, &_init_f_setSocketOption_5331, &_call_f_setSocketOption_5331);
  methods += new qt_gsi::GenericMethod ("setSslConfiguration|sslConfiguration=", "@brief Method void QSslSocket::setSslConfiguration(const QSslConfiguration &config)\n", false, &_init_f_setSslConfiguration_3068, &_call_f_setSslConfiguration_3068);
  methods += new qt_gsi::GenericMethod ("socketOption", "@brief Method QVariant QSslSocket::socketOption(QAbstractSocket::SocketOption option)\n", false, &_init_f_socketOption_3320, &_call_f_socketOption_3320);
  methods += new qt_gsi::GenericMethod (":sslConfiguration", "@brief Method QSslConfiguration QSslSocket::sslConfiguration()\n", true, &_init_f_sslConfiguration_c0, &_call_f_sslConfiguration_c0);
  methods += new qt_gsi::GenericMethod ("sslErrors", "@brief Method QList<QSslError> QSslSocket::sslErrors()\n", true, &_init_f_sslErrors_c0, &_call_f_sslErrors_c0);
  methods += new qt_gsi::GenericMethod ("startClientEncryption", "@brief Method void QSslSocket::startClientEncryption()\n", false, &_init_f_startClientEncryption_0, &_call_f_startClientEncryption_0);
  methods += new qt_gsi::GenericMethod ("startServerEncryption", "@brief Method void QSslSocket::startServerEncryption()\n", false, &_init_f_startServerEncryption_0, &_call_f_startServerEncryption_0);
  methods += new qt_gsi::GenericMethod ("waitForBytesWritten", "@brief Method bool QSslSocket::waitForBytesWritten(int msecs)\nThis is a reimplementation of QAbstractSocket::waitForBytesWritten", false, &_init_f_waitForBytesWritten_767, &_call_f_waitForBytesWritten_767);
  methods += new qt_gsi::GenericMethod ("waitForConnected", "@brief Method bool QSslSocket::waitForConnected(int msecs)\n", false, &_init_f_waitForConnected_767, &_call_f_waitForConnected_767);
  methods += new qt_gsi::GenericMethod ("waitForDisconnected", "@brief Method bool QSslSocket::waitForDisconnected(int msecs)\n", false, &_init_f_waitForDisconnected_767, &_call_f_waitForDisconnected_767);
  methods += new qt_gsi::GenericMethod ("waitForEncrypted", "@brief Method bool QSslSocket::waitForEncrypted(int msecs)\n", false, &_init_f_waitForEncrypted_767, &_call_f_waitForEncrypted_767);
  methods += new qt_gsi::GenericMethod ("waitForReadyRead", "@brief Method bool QSslSocket::waitForReadyRead(int msecs)\nThis is a reimplementation of QAbstractSocket::waitForReadyRead", false, &_init_f_waitForReadyRead_767, &_call_f_waitForReadyRead_767);
  methods += gsi::qt_signal ("aboutToClose()", "aboutToClose", "@brief Signal declaration for QSslSocket::aboutToClose()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("bytesWritten(qint64)", "bytesWritten", gsi::arg("bytes"), "@brief Signal declaration for QSslSocket::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("connected()", "connected", "@brief Signal declaration for QSslSocket::connected()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSslSocket::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("disconnected()", "disconnected", "@brief Signal declaration for QSslSocket::disconnected()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("encrypted()", "encrypted", "@brief Signal declaration for QSslSocket::encrypted()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("encryptedBytesWritten(qint64)", "encryptedBytesWritten", gsi::arg("totalBytes"), "@brief Signal declaration for QSslSocket::encryptedBytesWritten(qint64 totalBytes)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractSocket::SocketError>::target_type & > ("error(QAbstractSocket::SocketError)", "error_sig", gsi::arg("arg1"), "@brief Signal declaration for QSslSocket::error(QAbstractSocket::SocketError)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("hostFound()", "hostFound", "@brief Signal declaration for QSslSocket::hostFound()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QSslSocket::SslMode>::target_type & > ("modeChanged(QSslSocket::SslMode)", "modeChanged", gsi::arg("newMode"), "@brief Signal declaration for QSslSocket::modeChanged(QSslSocket::SslMode newMode)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QSslError & > ("peerVerifyError(const QSslError &)", "peerVerifyError", gsi::arg("error"), "@brief Signal declaration for QSslSocket::peerVerifyError(const QSslError &error)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QNetworkProxy &, QAuthenticator * > ("proxyAuthenticationRequired(const QNetworkProxy &, QAuthenticator *)", "proxyAuthenticationRequired", gsi::arg("proxy"), gsi::arg("authenticator"), "@brief Signal declaration for QSslSocket::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readChannelFinished()", "readChannelFinished", "@brief Signal declaration for QSslSocket::readChannelFinished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readyRead()", "readyRead", "@brief Signal declaration for QSslSocket::readyRead()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QSslError> & > ("sslErrors(const QList<QSslError> &)", "sslErrors_sig", gsi::arg("errors"), "@brief Signal declaration for QSslSocket::sslErrors(const QList<QSslError> &errors)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & > ("stateChanged(QAbstractSocket::SocketState)", "stateChanged", gsi::arg("arg1"), "@brief Signal declaration for QSslSocket::stateChanged(QAbstractSocket::SocketState)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("addDefaultCaCertificate", "@brief Static method void QSslSocket::addDefaultCaCertificate(const QSslCertificate &certificate)\nThis method is static and can be called without an instance.", &_init_f_addDefaultCaCertificate_2823, &_call_f_addDefaultCaCertificate_2823);
  methods += new qt_gsi::GenericStaticMethod ("addDefaultCaCertificates", "@brief Static method bool QSslSocket::addDefaultCaCertificates(const QString &path, QSsl::EncodingFormat format, QRegExp::PatternSyntax syntax)\nThis method is static and can be called without an instance.", &_init_f_addDefaultCaCertificates_6773, &_call_f_addDefaultCaCertificates_6773);
  methods += new qt_gsi::GenericStaticMethod ("addDefaultCaCertificates", "@brief Static method void QSslSocket::addDefaultCaCertificates(const QList<QSslCertificate> &certificates)\nThis method is static and can be called without an instance.", &_init_f_addDefaultCaCertificates_3438, &_call_f_addDefaultCaCertificates_3438);
  methods += new qt_gsi::GenericStaticMethod (":defaultCaCertificates", "@brief Static method QList<QSslCertificate> QSslSocket::defaultCaCertificates()\nThis method is static and can be called without an instance.", &_init_f_defaultCaCertificates_0, &_call_f_defaultCaCertificates_0);
  methods += new qt_gsi::GenericStaticMethod (":defaultCiphers", "@brief Static method QList<QSslCipher> QSslSocket::defaultCiphers()\nThis method is static and can be called without an instance.", &_init_f_defaultCiphers_0, &_call_f_defaultCiphers_0);
  methods += new qt_gsi::GenericStaticMethod ("setDefaultCaCertificates|defaultCaCertificates=", "@brief Static method void QSslSocket::setDefaultCaCertificates(const QList<QSslCertificate> &certificates)\nThis method is static and can be called without an instance.", &_init_f_setDefaultCaCertificates_3438, &_call_f_setDefaultCaCertificates_3438);
  methods += new qt_gsi::GenericStaticMethod ("setDefaultCiphers|defaultCiphers=", "@brief Static method void QSslSocket::setDefaultCiphers(const QList<QSslCipher> &ciphers)\nThis method is static and can be called without an instance.", &_init_f_setDefaultCiphers_2918, &_call_f_setDefaultCiphers_2918);
  methods += new qt_gsi::GenericStaticMethod ("supportedCiphers", "@brief Static method QList<QSslCipher> QSslSocket::supportedCiphers()\nThis method is static and can be called without an instance.", &_init_f_supportedCiphers_0, &_call_f_supportedCiphers_0);
  methods += new qt_gsi::GenericStaticMethod ("supportsSsl", "@brief Static method bool QSslSocket::supportsSsl()\nThis method is static and can be called without an instance.", &_init_f_supportsSsl_0, &_call_f_supportsSsl_0);
  methods += new qt_gsi::GenericStaticMethod ("systemCaCertificates", "@brief Static method QList<QSslCertificate> QSslSocket::systemCaCertificates()\nThis method is static and can be called without an instance.", &_init_f_systemCaCertificates_0, &_call_f_systemCaCertificates_0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSslSocket::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSslSocket::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSslSocket::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSslSocket::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QTcpSocket> &qtdecl_QTcpSocket ();

qt_gsi::QtNativeClass<QSslSocket> decl_QSslSocket (qtdecl_QTcpSocket (), "QtNetwork", "QSslSocket",
  methods_QSslSocket (),
  "@qt\n@brief Binding of QSslSocket");


GSI_QTNETWORK_PUBLIC gsi::Class<QSslSocket> &qtdecl_QSslSocket () { return decl_QSslSocket; }

}


//  Implementation of the enum wrapper class for QSslSocket::PeerVerifyMode
namespace qt_gsi
{

static gsi::Enum<QSslSocket::PeerVerifyMode> decl_QSslSocket_PeerVerifyMode_Enum ("QtNetwork", "QSslSocket_PeerVerifyMode",
    gsi::enum_const ("VerifyNone", QSslSocket::VerifyNone, "@brief Enum constant QSslSocket::VerifyNone") +
    gsi::enum_const ("QueryPeer", QSslSocket::QueryPeer, "@brief Enum constant QSslSocket::QueryPeer") +
    gsi::enum_const ("VerifyPeer", QSslSocket::VerifyPeer, "@brief Enum constant QSslSocket::VerifyPeer") +
    gsi::enum_const ("AutoVerifyPeer", QSslSocket::AutoVerifyPeer, "@brief Enum constant QSslSocket::AutoVerifyPeer"),
  "@qt\n@brief This class represents the QSslSocket::PeerVerifyMode enum");

static gsi::QFlagsClass<QSslSocket::PeerVerifyMode > decl_QSslSocket_PeerVerifyMode_Enums ("QtNetwork", "QSslSocket_QFlags_PeerVerifyMode",
  "@qt\n@brief This class represents the QFlags<QSslSocket::PeerVerifyMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSslSocket> inject_QSslSocket_PeerVerifyMode_Enum_in_parent (decl_QSslSocket_PeerVerifyMode_Enum.defs ());
static gsi::ClassExt<QSslSocket> decl_QSslSocket_PeerVerifyMode_Enum_as_child (decl_QSslSocket_PeerVerifyMode_Enum, "PeerVerifyMode");
static gsi::ClassExt<QSslSocket> decl_QSslSocket_PeerVerifyMode_Enums_as_child (decl_QSslSocket_PeerVerifyMode_Enums, "QFlags_PeerVerifyMode");

}


//  Implementation of the enum wrapper class for QSslSocket::SslMode
namespace qt_gsi
{

static gsi::Enum<QSslSocket::SslMode> decl_QSslSocket_SslMode_Enum ("QtNetwork", "QSslSocket_SslMode",
    gsi::enum_const ("UnencryptedMode", QSslSocket::UnencryptedMode, "@brief Enum constant QSslSocket::UnencryptedMode") +
    gsi::enum_const ("SslClientMode", QSslSocket::SslClientMode, "@brief Enum constant QSslSocket::SslClientMode") +
    gsi::enum_const ("SslServerMode", QSslSocket::SslServerMode, "@brief Enum constant QSslSocket::SslServerMode"),
  "@qt\n@brief This class represents the QSslSocket::SslMode enum");

static gsi::QFlagsClass<QSslSocket::SslMode > decl_QSslSocket_SslMode_Enums ("QtNetwork", "QSslSocket_QFlags_SslMode",
  "@qt\n@brief This class represents the QFlags<QSslSocket::SslMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSslSocket> inject_QSslSocket_SslMode_Enum_in_parent (decl_QSslSocket_SslMode_Enum.defs ());
static gsi::ClassExt<QSslSocket> decl_QSslSocket_SslMode_Enum_as_child (decl_QSslSocket_SslMode_Enum, "SslMode");
static gsi::ClassExt<QSslSocket> decl_QSslSocket_SslMode_Enums_as_child (decl_QSslSocket_SslMode_Enums, "QFlags_SslMode");

}

