#ifndef __SHUTTLE_H__
#define __SHUTTLE_H__

#include <linux/input.h>
#include <sys/time.h>

#define SHUTTLE_SHUTTLE         1
#define SHUTTLE_JOG             2
#define SHUTTLE_LEFTMOST        4
#define SHUTTLE_LEFT            8
#define SHUTTLE_MIDDLE          16
#define SHUTTLE_RIGHT           32
#define SHUTTLE_RIGHTMOST       64

#define SHUTTLE_TYPE_KEY        1
#define SHUTTLE_TYPE_JOGSHUTTLE 2

typedef struct _shuttle_data {
	int fd;

	int value;
	int lastvalue;
	int code;
	int lastcode;
	int type;

	int buttonstates;
	int jogstate;
	int shuttlestate;
	float shuttledelta;
	
	long timediff;
	struct timeval lastevent;
} shuttle_data_t;

shuttle_data_t* shuttle_new();
int shuttle_open (shuttle_data_t* shuttle);
int shuttle_close (shuttle_data_t* shuttle);
int shuttle_poll (shuttle_data_t* shuttle);

#endif /* __SHUTTLE_H__ */
