/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.lisaac.ldt.launch.CompilerOutputParser;
import org.lisaac.ldt.launch.LisaacLauncher;
import org.lisaac.ldt.model.LisaacModel;

public class LisaacCompiler {
    protected String inputFile;
    protected String lipFile;
    protected ArrayList<String> options;
    protected LisaacModel model;
    protected String outputName;

    public LisaacCompiler(LisaacModel model, String inputFile, String outputName, String lipFile) {
        this.inputFile = inputFile;
        this.lipFile = lipFile;
        this.outputName = outputName;
        this.model = model;
    }

    public LisaacCompiler(String lipFile) {
        this.lipFile = lipFile;
    }

    public IContainer launchInConsole(ILaunch launch, IProject project, IProgressMonitor monitor) throws CoreException {
        String prototypePath = this.model.getPathManager().getFullPath(LisaacModel.extractPrototypeName(this.inputFile));
        if (prototypePath != null) {
            IContainer container;
            Path location = new Path(prototypePath);
            IPath projectLocation = project.getLocation();
            IFile file = null;
            if (projectLocation.isPrefixOf((IPath)location) && LisaacLauncher.executeCommandInConsole(launch, monitor, container = (file = project.getFile((IPath)(location = location.removeFirstSegments(projectLocation.segmentCount())))).getParent(), this.toCommandLineArray(), this)) {
                return container;
            }
        }
        return null;
    }

    public Process launch(IProject project, IProgressMonitor monitor) throws CoreException {
        return LisaacLauncher.executeCommand(monitor, (IContainer)project, this.toCommandLineArray());
    }

    public String[] toCommandLineArray() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("lisaac ");
        if (this.lipFile != null) {
            cmd.add(this.lipFile);
        }
        if (this.inputFile != null) {
            cmd.add(this.inputFile);
        }
        if (this.options != null) {
            cmd.addAll(this.options);
        }
        return cmd.toArray(new String[cmd.size()]);
    }

    public String toCommandLine() {
        StringBuffer result = new StringBuffer();
        result.append("lisaac ");
        if (this.lipFile != null) {
            result.append(this.lipFile);
        }
        if (this.inputFile != null) {
            result.append(" " + this.inputFile);
        }
        if (this.options != null) {
            int i = 0;
            while (i < this.options.size()) {
                result.append(" " + this.options.get(i));
                ++i;
            }
        }
        return result.toString();
    }

    public void addOption(String option) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        this.options.add(option);
    }

    public void moveFiles(IContainer output) throws CoreException {
        Path generatedPath;
        IFile executable;
        IProject project = this.model.getProject();
        output.refreshLocal(2, null);
        IFolder bin = project.getFolder("bin");
        if (!bin.exists()) {
            bin.create(false, true, null);
        }
        if (!(executable = output.getFile((IPath)(generatedPath = new Path(this.outputName)))).exists()) {
            generatedPath = new Path(String.valueOf(this.outputName) + ".exe");
            executable = output.getFile((IPath)generatedPath);
        }
        if (executable.exists()) {
            IFile destFile = bin.getFile((IPath)generatedPath);
            if (destFile.exists()) {
                destFile.delete(true, null);
            }
            executable.move(bin.getFullPath().append((IPath)generatedPath), true, null);
        }
        this.moveFile(String.valueOf(this.outputName) + ".o", output, (IContainer)bin);
        this.moveFile(String.valueOf(this.outputName) + ".c", output, (IContainer)bin);
        project.refreshLocal(2, null);
        this.model.setCompiled(true);
    }

    private void moveFile(String filename, IContainer origin, IContainer destination) throws CoreException {
        Path path = new Path(filename);
        IFile originFile = origin.getFile((IPath)path);
        if (originFile.exists()) {
            IFile destFile = destination.getFile((IPath)path);
            if (destFile.exists()) {
                destFile.delete(true, null);
            }
            originFile.move(destination.getFullPath().append((IPath)path), true, null);
        }
    }

    public void cleanFiles() throws CoreException {
        IFile file;
        IFolder bin = this.model.getProject().getFolder("bin");
        IFile executable = bin.getFile((IPath)new Path(this.outputName));
        if (executable.exists()) {
            executable.delete(true, null);
        }
        if ((executable = bin.getFile((IPath)new Path(String.valueOf(this.outputName) + ".exe"))).exists()) {
            executable.delete(true, null);
        }
        if ((file = bin.getFile((IPath)new Path(String.valueOf(this.outputName) + ".o"))).exists()) {
            file.delete(true, null);
        }
        if ((file = bin.getFile((IPath)new Path(String.valueOf(this.outputName) + ".c"))).exists()) {
            file.delete(true, null);
        }
    }

    public void showErrors(String output) throws CoreException {
        new CompilerOutputParser(output).run(this.model);
    }
}

