/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2024 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_x_fd_lb94.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t28, t29, t30, t31, t32;
  double t33, t34, t36, t39, t42, t46, tzk0;

  gga_x_fd_lb94_params *params;

  assert(p->params != NULL);
  params = (gga_x_fd_lb94_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = sqrt(sigma[0]);
  t21 = M_CBRT2;
  t22 = t20 * t21;
  t24 = 0.1e1 / t18 / rho[0];
  t25 = t22 * t24;
  t26 = t3 * t3;
  t28 = POW_1_3(0.1e1 / M_PI);
  t29 = 0.1e1 / t28;
  t30 = t26 * t29;
  t31 = M_CBRT4;
  t32 = t20 * t24;
  t33 = xc_integrate(func0, &(params->beta), 0.0, t32);
  t34 = log(t32);
  t36 = xc_integrate(func1, &(params->beta), 0.0, t32);
  t39 = t30 * t31 * (t33 * t34 - t36);
  t42 = 0.1e1 - 0.2e1 / 0.9e1 * t25 * t39;
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t28, t29, t30, t31, t32;
  double t33, t34, t36, t39, t42, t46, tzk0;

  double t47, t49, t53, t55, t56, t59, t62, t67;
  double tvrho0, t70, t71, t72, t76, t80, tvsigma0;

  gga_x_fd_lb94_params *params;

  assert(p->params != NULL);
  params = (gga_x_fd_lb94_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = sqrt(sigma[0]);
  t21 = M_CBRT2;
  t22 = t20 * t21;
  t24 = 0.1e1 / t18 / rho[0];
  t25 = t22 * t24;
  t26 = t3 * t3;
  t28 = POW_1_3(0.1e1 / M_PI);
  t29 = 0.1e1 / t28;
  t30 = t26 * t29;
  t31 = M_CBRT4;
  t32 = t20 * t24;
  t33 = xc_integrate(func0, &(params->beta), 0.0, t32);
  t34 = log(t32);
  t36 = xc_integrate(func1, &(params->beta), 0.0, t32);
  t39 = t30 * t31 * (t33 * t34 - t36);
  t42 = 0.1e1 - 0.2e1 / 0.9e1 * t25 * t39;
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t47 = t18 * t18;
  t49 = t17 / t47;
  t53 = rho[0] * rho[0];
  t55 = 0.1e1 / t18 / t53;
  t56 = t22 * t55;
  t59 = t30 * t31 * t33;
  t62 = 0.8e1 / 0.27e2 * t56 * t39 + 0.8e1 / 0.27e2 * t56 * t59;
  t67 = my_piecewise3(t2, 0, -t6 * t49 * t42 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t62);
  tvrho0 = 0.2e1 * rho[0] * t67 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t70 = 0.1e1 / t20;
  t71 = t70 * t21;
  t72 = t71 * t24;
  t76 = -t72 * t39 / 0.9e1 - t72 * t59 / 0.9e1;
  t80 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t76);
  tvsigma0 = 0.2e1 * rho[0] * t80;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t28, t29, t30, t31, t32;
  double t33, t34, t36, t39, t42, t46, tzk0;

  double t47, t49, t53, t55, t56, t59, t62, t67;
  double tvrho0, t70, t71, t72, t76, t80, tvsigma0;

  double t85, t92, t94, t95, t100, t101, t102, t104;
  double t105, t106, t107, t108, t110, t112, t113, t114;
  double t115, t119, t122, t125, t130, tv2rho20, t136, t142;
  double t143, t147, t152, tv2rhosigma0, t156, t157, t158, t162;
  double t163, t164, t167, t171, tv2sigma20;

  gga_x_fd_lb94_params *params;

  assert(p->params != NULL);
  params = (gga_x_fd_lb94_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = sqrt(sigma[0]);
  t21 = M_CBRT2;
  t22 = t20 * t21;
  t24 = 0.1e1 / t18 / rho[0];
  t25 = t22 * t24;
  t26 = t3 * t3;
  t28 = POW_1_3(0.1e1 / M_PI);
  t29 = 0.1e1 / t28;
  t30 = t26 * t29;
  t31 = M_CBRT4;
  t32 = t20 * t24;
  t33 = xc_integrate(func0, &(params->beta), 0.0, t32);
  t34 = log(t32);
  t36 = xc_integrate(func1, &(params->beta), 0.0, t32);
  t39 = t30 * t31 * (t33 * t34 - t36);
  t42 = 0.1e1 - 0.2e1 / 0.9e1 * t25 * t39;
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t47 = t18 * t18;
  t49 = t17 / t47;
  t53 = rho[0] * rho[0];
  t55 = 0.1e1 / t18 / t53;
  t56 = t22 * t55;
  t59 = t30 * t31 * t33;
  t62 = 0.8e1 / 0.27e2 * t56 * t39 + 0.8e1 / 0.27e2 * t56 * t59;
  t67 = my_piecewise3(t2, 0, -t6 * t49 * t42 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t62);
  tvrho0 = 0.2e1 * rho[0] * t67 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t70 = 0.1e1 / t20;
  t71 = t70 * t21;
  t72 = t71 * t24;
  t76 = -t72 * t39 / 0.9e1 - t72 * t59 / 0.9e1;
  t80 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t76);
  tvsigma0 = 0.2e1 * rho[0] * t80;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t85 = t17 / t47 / rho[0];
  t92 = t53 * rho[0];
  t94 = 0.1e1 / t18 / t92;
  t95 = t22 * t94;
  t100 = t21 * t21;
  t101 = sigma[0] * t100;
  t102 = t53 * t53;
  t104 = 0.1e1 / t47 / t102;
  t105 = t104 * t26;
  t106 = t101 * t105;
  t107 = t29 * t31;
  t108 = params->beta * t21;
  t110 = 0.1e1 / t47 / t53;
  t112 = t101 * t110 + 0.1e1;
  t113 = sqrt(t112);
  t114 = t25 + t113;
  t115 = log(t114);
  t119 = 0.3e1 * t108 * t32 * t115 + 0.1e1;
  t122 = t107 * params->beta / t119;
  t125 = -0.56e2 / 0.81e2 * t95 * t39 - 0.88e2 / 0.81e2 * t95 * t59 + 0.8e1 / 0.27e2 * t106 * t122;
  t130 = my_piecewise3(t2, 0, t6 * t85 * t42 / 0.12e2 - t6 * t49 * t62 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t125);
  tv2rho20 = 0.2e1 * rho[0] * t130 + 0.4e1 * t67;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t136 = t71 * t55;
  t142 = 0.1e1 / t47 / t92;
  t143 = t100 * t142;
  t147 = 0.4e1 / 0.27e2 * t136 * t39 + 0.8e1 / 0.27e2 * t136 * t59 - t143 * t26 * t122 / 0.9e1;
  t152 = my_piecewise3(t2, 0, -t6 * t49 * t76 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t147);
  tv2rhosigma0 = 0.2e1 * rho[0] * t152 + 0.2e1 * t80;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t156 = 0.1e1 / t20 / sigma[0];
  t157 = t156 * t21;
  t158 = t157 * t24;
  t162 = 0.1e1 / sigma[0] * t100;
  t163 = t110 * t26;
  t164 = t162 * t163;
  t167 = t158 * t39 / 0.18e2 + t164 * t122 / 0.24e2;
  t171 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t167);
  tv2sigma20 = 0.2e1 * rho[0] * t171;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t28, t29, t30, t31, t32;
  double t33, t34, t36, t39, t42, t46, tzk0;

  double t47, t49, t53, t55, t56, t59, t62, t67;
  double tvrho0, t70, t71, t72, t76, t80, tvsigma0;

  double t85, t92, t94, t95, t100, t101, t102, t104;
  double t105, t106, t107, t108, t110, t112, t113, t114;
  double t115, t119, t122, t125, t130, tv2rho20, t136, t142;
  double t143, t147, t152, tv2rhosigma0, t156, t157, t158, t162;
  double t163, t164, t167, t171, tv2sigma20;

  double t174, t185, t186, t191, t193, t195, t198, t199;
  double t200, t205, t207, t211, t213, t214, t217, t219;
  double t222, t227, tv3rho30, t237, t242, t246, t247, t249;
  double t252, t257, tv3rho2sigma0, t263, t268, t269, t274, t279;
  double tv3rhosigma20, t282, t285, t286, t292, t293, t302, t303;
  double t304, t307, t309, t312, t316, tv3sigma30;

  gga_x_fd_lb94_params *params;

  assert(p->params != NULL);
  params = (gga_x_fd_lb94_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = sqrt(sigma[0]);
  t21 = M_CBRT2;
  t22 = t20 * t21;
  t24 = 0.1e1 / t18 / rho[0];
  t25 = t22 * t24;
  t26 = t3 * t3;
  t28 = POW_1_3(0.1e1 / M_PI);
  t29 = 0.1e1 / t28;
  t30 = t26 * t29;
  t31 = M_CBRT4;
  t32 = t20 * t24;
  t33 = xc_integrate(func0, &(params->beta), 0.0, t32);
  t34 = log(t32);
  t36 = xc_integrate(func1, &(params->beta), 0.0, t32);
  t39 = t30 * t31 * (t33 * t34 - t36);
  t42 = 0.1e1 - 0.2e1 / 0.9e1 * t25 * t39;
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t47 = t18 * t18;
  t49 = t17 / t47;
  t53 = rho[0] * rho[0];
  t55 = 0.1e1 / t18 / t53;
  t56 = t22 * t55;
  t59 = t30 * t31 * t33;
  t62 = 0.8e1 / 0.27e2 * t56 * t39 + 0.8e1 / 0.27e2 * t56 * t59;
  t67 = my_piecewise3(t2, 0, -t6 * t49 * t42 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t62);
  tvrho0 = 0.2e1 * rho[0] * t67 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t70 = 0.1e1 / t20;
  t71 = t70 * t21;
  t72 = t71 * t24;
  t76 = -t72 * t39 / 0.9e1 - t72 * t59 / 0.9e1;
  t80 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t76);
  tvsigma0 = 0.2e1 * rho[0] * t80;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t85 = t17 / t47 / rho[0];
  t92 = t53 * rho[0];
  t94 = 0.1e1 / t18 / t92;
  t95 = t22 * t94;
  t100 = t21 * t21;
  t101 = sigma[0] * t100;
  t102 = t53 * t53;
  t104 = 0.1e1 / t47 / t102;
  t105 = t104 * t26;
  t106 = t101 * t105;
  t107 = t29 * t31;
  t108 = params->beta * t21;
  t110 = 0.1e1 / t47 / t53;
  t112 = t101 * t110 + 0.1e1;
  t113 = sqrt(t112);
  t114 = t25 + t113;
  t115 = log(t114);
  t119 = 0.3e1 * t108 * t32 * t115 + 0.1e1;
  t122 = t107 * params->beta / t119;
  t125 = -0.56e2 / 0.81e2 * t95 * t39 - 0.88e2 / 0.81e2 * t95 * t59 + 0.8e1 / 0.27e2 * t106 * t122;
  t130 = my_piecewise3(t2, 0, t6 * t85 * t42 / 0.12e2 - t6 * t49 * t62 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t125);
  tv2rho20 = 0.2e1 * rho[0] * t130 + 0.4e1 * t67;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t136 = t71 * t55;
  t142 = 0.1e1 / t47 / t92;
  t143 = t100 * t142;
  t147 = 0.4e1 / 0.27e2 * t136 * t39 + 0.8e1 / 0.27e2 * t136 * t59 - t143 * t26 * t122 / 0.9e1;
  t152 = my_piecewise3(t2, 0, -t6 * t49 * t76 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t147);
  tv2rhosigma0 = 0.2e1 * rho[0] * t152 + 0.2e1 * t80;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t156 = 0.1e1 / t20 / sigma[0];
  t157 = t156 * t21;
  t158 = t157 * t24;
  t162 = 0.1e1 / sigma[0] * t100;
  t163 = t110 * t26;
  t164 = t162 * t163;
  t167 = t158 * t39 / 0.18e2 + t164 * t122 / 0.24e2;
  t171 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t167);
  tv2sigma20 = 0.2e1 * rho[0] * t171;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t174 = t17 * t110;
  t185 = 0.1e1 / t18 / t102;
  t186 = t22 * t185;
  t191 = t102 * rho[0];
  t193 = 0.1e1 / t47 / t191;
  t195 = t101 * t193 * t26;
  t198 = t119 * t119;
  t199 = 0.1e1 / t198;
  t200 = params->beta * t199;
  t205 = t108 * t20;
  t207 = 0.1e1 / t113 * t100;
  t211 = -0.4e1 / 0.3e1 * t207 * sigma[0] * t142 - 0.4e1 / 0.3e1 * t56;
  t213 = 0.1e1 / t114;
  t214 = t24 * t211 * t213;
  t217 = -0.4e1 * t108 * t20 * t55 * t115 + 0.3e1 * t205 * t214;
  t219 = t107 * t200 * t217;
  t222 = 0.56e3 / 0.243e3 * t186 * t39 + 0.368e3 / 0.81e2 * t186 * t59 - 0.2e3 / 0.81e2 * t195 * t122 - 0.8e1 / 0.27e2 * t106 * t219;
  t227 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t174 * t42 + t6 * t85 * t62 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t49 * t125 - 0.3e1 / 0.8e1 * t6 * t19 * t222);
  tv3rho30 = 0.2e1 * rho[0] * t227 + 0.6e1 * t130;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t237 = t71 * t94;
  t242 = t100 * t104;
  t246 = t143 * t30;
  t247 = t31 * params->beta;
  t249 = t247 * t199 * t217;
  t252 = -0.28e2 / 0.81e2 * t237 * t39 - 0.8e1 / 0.9e1 * t237 * t59 + 0.19e2 / 0.27e2 * t242 * t26 * t122 + t246 * t249 / 0.9e1;
  t257 = my_piecewise3(t2, 0, t6 * t85 * t76 / 0.12e2 - t6 * t49 * t147 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t252);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t257 + 0.4e1 * t152;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t263 = t157 * t55;
  t268 = t142 * t26;
  t269 = t162 * t268;
  t274 = -0.2e1 / 0.27e2 * t263 * t39 - 0.2e1 / 0.27e2 * t263 * t59 - t269 * t122 / 0.9e1 - t164 * t219 / 0.24e2;
  t279 = my_piecewise3(t2, 0, -t6 * t49 * t167 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t274);
  tv3rhosigma20 = 0.2e1 * rho[0] * t279 + 0.2e1 * t171;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t282 = sigma[0] * sigma[0];
  t285 = 0.1e1 / t20 / t282 * t21;
  t286 = t285 * t24;
  t292 = 0.1e1 / t282 * t100;
  t293 = t292 * t163;
  t302 = t207 * t110 / 0.2e1 + t72 / 0.2e1;
  t303 = t24 * t302;
  t304 = t303 * t213;
  t307 = 0.3e1 / 0.2e1 * t108 * t70 * t24 * t115 + 0.3e1 * t205 * t304;
  t309 = t107 * t200 * t307;
  t312 = -t286 * t39 / 0.12e2 + t286 * t59 / 0.36e2 - t293 * t122 / 0.24e2 - t164 * t309 / 0.24e2;
  t316 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t312);
  tv3sigma30 = 0.2e1 * rho[0] * t316;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t28, t29, t30, t31, t32;
  double t33, t34, t36, t39, t42, t46, tzk0;

  double t47, t49, t53, t55, t56, t59, t62, t67;
  double tvrho0, t70, t71, t72, t76, t80, tvsigma0;

  double t85, t92, t94, t95, t100, t101, t102, t104;
  double t105, t106, t107, t108, t110, t112, t113, t114;
  double t115, t119, t122, t125, t130, tv2rho20, t136, t142;
  double t143, t147, t152, tv2rhosigma0, t156, t157, t158, t162;
  double t163, t164, t167, t171, tv2sigma20;

  double t174, t185, t186, t191, t193, t195, t198, t199;
  double t200, t205, t207, t211, t213, t214, t217, t219;
  double t222, t227, tv3rho30, t237, t242, t246, t247, t249;
  double t252, t257, tv3rho2sigma0, t263, t268, t269, t274, t279;
  double tv3rhosigma20, t282, t285, t286, t292, t293, t302, t303;
  double t304, t307, t309, t312, t316, tv3sigma30;

  double t333, t334, t339, t349, t350, t351, t353, t367;
  double t382, t384, t385, t389, t391, t399, tv4rho40, t412;
  double t437, tv4rho3sigma0, t447, t466, tv4rho2sigma20, t472, t495, t529;
  double tv4rhosigma30, t532, t536, t548, t567, t581, tv4sigma40;

  gga_x_fd_lb94_params *params;

  assert(p->params != NULL);
  params = (gga_x_fd_lb94_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = sqrt(sigma[0]);
  t21 = M_CBRT2;
  t22 = t20 * t21;
  t24 = 0.1e1 / t18 / rho[0];
  t25 = t22 * t24;
  t26 = t3 * t3;
  t28 = POW_1_3(0.1e1 / M_PI);
  t29 = 0.1e1 / t28;
  t30 = t26 * t29;
  t31 = M_CBRT4;
  t32 = t20 * t24;
  t33 = xc_integrate(func0, &(params->beta), 0.0, t32);
  t34 = log(t32);
  t36 = xc_integrate(func1, &(params->beta), 0.0, t32);
  t39 = t30 * t31 * (t33 * t34 - t36);
  t42 = 0.1e1 - 0.2e1 / 0.9e1 * t25 * t39;
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t47 = t18 * t18;
  t49 = t17 / t47;
  t53 = rho[0] * rho[0];
  t55 = 0.1e1 / t18 / t53;
  t56 = t22 * t55;
  t59 = t30 * t31 * t33;
  t62 = 0.8e1 / 0.27e2 * t56 * t39 + 0.8e1 / 0.27e2 * t56 * t59;
  t67 = my_piecewise3(t2, 0, -t6 * t49 * t42 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t62);
  tvrho0 = 0.2e1 * rho[0] * t67 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t70 = 0.1e1 / t20;
  t71 = t70 * t21;
  t72 = t71 * t24;
  t76 = -t72 * t39 / 0.9e1 - t72 * t59 / 0.9e1;
  t80 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t76);
  tvsigma0 = 0.2e1 * rho[0] * t80;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t85 = t17 / t47 / rho[0];
  t92 = t53 * rho[0];
  t94 = 0.1e1 / t18 / t92;
  t95 = t22 * t94;
  t100 = t21 * t21;
  t101 = sigma[0] * t100;
  t102 = t53 * t53;
  t104 = 0.1e1 / t47 / t102;
  t105 = t104 * t26;
  t106 = t101 * t105;
  t107 = t29 * t31;
  t108 = params->beta * t21;
  t110 = 0.1e1 / t47 / t53;
  t112 = t101 * t110 + 0.1e1;
  t113 = sqrt(t112);
  t114 = t25 + t113;
  t115 = log(t114);
  t119 = 0.3e1 * t108 * t32 * t115 + 0.1e1;
  t122 = t107 * params->beta / t119;
  t125 = -0.56e2 / 0.81e2 * t95 * t39 - 0.88e2 / 0.81e2 * t95 * t59 + 0.8e1 / 0.27e2 * t106 * t122;
  t130 = my_piecewise3(t2, 0, t6 * t85 * t42 / 0.12e2 - t6 * t49 * t62 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t125);
  tv2rho20 = 0.2e1 * rho[0] * t130 + 0.4e1 * t67;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t136 = t71 * t55;
  t142 = 0.1e1 / t47 / t92;
  t143 = t100 * t142;
  t147 = 0.4e1 / 0.27e2 * t136 * t39 + 0.8e1 / 0.27e2 * t136 * t59 - t143 * t26 * t122 / 0.9e1;
  t152 = my_piecewise3(t2, 0, -t6 * t49 * t76 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t147);
  tv2rhosigma0 = 0.2e1 * rho[0] * t152 + 0.2e1 * t80;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t156 = 0.1e1 / t20 / sigma[0];
  t157 = t156 * t21;
  t158 = t157 * t24;
  t162 = 0.1e1 / sigma[0] * t100;
  t163 = t110 * t26;
  t164 = t162 * t163;
  t167 = t158 * t39 / 0.18e2 + t164 * t122 / 0.24e2;
  t171 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t167);
  tv2sigma20 = 0.2e1 * rho[0] * t171;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t174 = t17 * t110;
  t185 = 0.1e1 / t18 / t102;
  t186 = t22 * t185;
  t191 = t102 * rho[0];
  t193 = 0.1e1 / t47 / t191;
  t195 = t101 * t193 * t26;
  t198 = t119 * t119;
  t199 = 0.1e1 / t198;
  t200 = params->beta * t199;
  t205 = t108 * t20;
  t207 = 0.1e1 / t113 * t100;
  t211 = -0.4e1 / 0.3e1 * t207 * sigma[0] * t142 - 0.4e1 / 0.3e1 * t56;
  t213 = 0.1e1 / t114;
  t214 = t24 * t211 * t213;
  t217 = -0.4e1 * t108 * t20 * t55 * t115 + 0.3e1 * t205 * t214;
  t219 = t107 * t200 * t217;
  t222 = 0.56e3 / 0.243e3 * t186 * t39 + 0.368e3 / 0.81e2 * t186 * t59 - 0.2e3 / 0.81e2 * t195 * t122 - 0.8e1 / 0.27e2 * t106 * t219;
  t227 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t174 * t42 + t6 * t85 * t62 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t49 * t125 - 0.3e1 / 0.8e1 * t6 * t19 * t222);
  tv3rho30 = 0.2e1 * rho[0] * t227 + 0.6e1 * t130;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t237 = t71 * t94;
  t242 = t100 * t104;
  t246 = t143 * t30;
  t247 = t31 * params->beta;
  t249 = t247 * t199 * t217;
  t252 = -0.28e2 / 0.81e2 * t237 * t39 - 0.8e1 / 0.9e1 * t237 * t59 + 0.19e2 / 0.27e2 * t242 * t26 * t122 + t246 * t249 / 0.9e1;
  t257 = my_piecewise3(t2, 0, t6 * t85 * t76 / 0.12e2 - t6 * t49 * t147 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t252);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t257 + 0.4e1 * t152;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t263 = t157 * t55;
  t268 = t142 * t26;
  t269 = t162 * t268;
  t274 = -0.2e1 / 0.27e2 * t263 * t39 - 0.2e1 / 0.27e2 * t263 * t59 - t269 * t122 / 0.9e1 - t164 * t219 / 0.24e2;
  t279 = my_piecewise3(t2, 0, -t6 * t49 * t167 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t274);
  tv3rhosigma20 = 0.2e1 * rho[0] * t279 + 0.2e1 * t171;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t282 = sigma[0] * sigma[0];
  t285 = 0.1e1 / t20 / t282 * t21;
  t286 = t285 * t24;
  t292 = 0.1e1 / t282 * t100;
  t293 = t292 * t163;
  t302 = t207 * t110 / 0.2e1 + t72 / 0.2e1;
  t303 = t24 * t302;
  t304 = t303 * t213;
  t307 = 0.3e1 / 0.2e1 * t108 * t70 * t24 * t115 + 0.3e1 * t205 * t304;
  t309 = t107 * t200 * t307;
  t312 = -t286 * t39 / 0.12e2 + t286 * t59 / 0.36e2 - t293 * t122 / 0.24e2 - t164 * t309 / 0.24e2;
  t316 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t312);
  tv3sigma30 = 0.2e1 * rho[0] * t316;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t333 = 0.1e1 / t18 / t191;
  t334 = t22 * t333;
  t339 = t102 * t53;
  t349 = 0.1e1 / t198 / t119;
  t350 = params->beta * t349;
  t351 = t217 * t217;
  t353 = t107 * t350 * t351;
  t367 = 0.1e1 / t113 / t112 * t21;
  t382 = t211 * t211;
  t384 = t114 * t114;
  t385 = 0.1e1 / t384;
  t389 = 0.28e2 / 0.3e1 * t108 * t20 * t94 * t115 - 0.8e1 * t205 * t55 * t211 * t213 + 0.3e1 * t205 * t24 * (0.28e2 / 0.9e1 * t95 - 0.32e2 / 0.9e1 * t367 * t282 / t18 / t102 / t92 + 0.44e2 / 0.9e1 * t207 * sigma[0] * t104) * t213 - 0.3e1 * t205 * t24 * t382 * t385;
  t391 = t107 * t200 * t389;
  t399 = my_piecewise3(t2, 0, 0.1e2 / 0.27e2 * t6 * t17 * t142 * t42 - 0.5e1 / 0.9e1 * t6 * t174 * t62 + t6 * t85 * t125 / 0.2e1 - t6 * t49 * t222 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.728e4 / 0.729e3 * t334 * t39 - 0.16592e5 / 0.729e3 * t334 * t59 + 0.4504e4 / 0.243e3 * t101 / t47 / t339 * t26 * t122 + 0.104e3 / 0.27e2 * t195 * t219 + 0.16e2 / 0.27e2 * t106 * t353 - 0.8e1 / 0.27e2 * t106 * t391));
  tv4rho40 = 0.2e1 * rho[0] * t399 + 0.8e1 * t227;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t412 = t71 * t185;
  t437 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t174 * t76 + t6 * t85 * t147 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t49 * t252 - 0.3e1 / 0.8e1 * t6 * t19 * (0.28e3 / 0.243e3 * t412 * t39 + 0.832e3 / 0.243e3 * t412 * t59 - 0.338e3 / 0.81e2 * t100 * t193 * t26 * t122 - 0.1e2 / 0.9e1 * t242 * t30 * t249 - 0.2e1 / 0.9e1 * t246 * t247 * t349 * t351 + t246 * t247 * t199 * t389 / 0.9e1));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t437 + 0.6e1 * t257;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t447 = t157 * t94;
  t466 = my_piecewise3(t2, 0, t6 * t85 * t167 / 0.12e2 - t6 * t49 * t274 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * (0.14e2 / 0.81e2 * t447 * t39 + 0.22e2 / 0.81e2 * t447 * t59 + t162 * t105 * t122 / 0.3e1 + 0.2e1 / 0.9e1 * t269 * t219 + t164 * t353 / 0.12e2 - t164 * t391 / 0.24e2));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t466 + 0.4e1 * t279;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t472 = t285 * t55;
  t495 = t108 * t70;
  t529 = my_piecewise3(t2, 0, -t6 * t49 * t312 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t472 * t39 / 0.9e1 + 0.2e1 / 0.27e2 * t472 * t59 + 0.5e1 / 0.36e2 * t292 * t268 * t122 + t293 * t219 / 0.24e2 + t269 * t309 / 0.9e1 + t162 * t163 * t29 * t247 * t349 * t307 * t217 / 0.12e2 - t164 * t107 * t200 * (-0.2e1 * t108 * t70 * t55 * t115 + 0.3e1 / 0.2e1 * t495 * t214 - 0.4e1 * t205 * t55 * t302 * t213 + 0.3e1 * t205 * t24 * (-0.2e1 / 0.3e1 * t136 + 0.4e1 / 0.3e1 * t367 / t18 / t339 * sigma[0] - 0.4e1 / 0.3e1 * t207 * t142) * t213 - 0.3e1 * t205 * t303 * t385 * t211) / 0.24e2));
  tv4rhosigma30 = 0.2e1 * rho[0] * t529 + 0.2e1 * t316;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t532 = t282 * sigma[0];
  t536 = 0.1e1 / t20 / t532 * t21 * t24;
  t548 = t307 * t307;
  t567 = t302 * t302;
  t581 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (0.5e1 / 0.24e2 * t536 * t39 - t536 * t59 / 0.9e1 + 0.7e1 / 0.96e2 / t532 * t100 * t163 * t122 + t293 * t309 / 0.12e2 + t164 * t107 * t350 * t548 / 0.12e2 - t164 * t107 * t200 * (-0.3e1 / 0.4e1 * t108 * t156 * t24 * t115 + 0.3e1 * t495 * t304 + 0.3e1 * t205 * t24 * (-t158 / 0.4e1 - t367 * t333 / 0.2e1) * t213 - 0.3e1 * t205 * t24 * t567 * t385) / 0.24e2));
  tv4sigma40 = 0.2e1 * rho[0] * t581;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t36, t37, t38, t39, t40, t41, t43;
  double t44, t45, t47, t49, t52, t56, t57, t58;
  double t60, t61, t62, t63, t65, t66, t67, t68;
  double t70, t71, t74, t75, t76, t78, t80, t83;
  double t87, tzk0;

  gga_x_fd_lb94_params *params;

  assert(p->params != NULL);
  params = (gga_x_fd_lb94_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = sqrt(sigma[0]);
  t29 = POW_1_3(rho[0]);
  t31 = 0.1e1 / t29 / rho[0];
  t32 = t28 * t31;
  t33 = t2 * t2;
  t36 = POW_1_3(0.1e1 / M_PI);
  t37 = 0.1e1 / t36;
  t38 = M_CBRT4;
  t39 = t37 * t38;
  t40 = M_CBRT2;
  t41 = t40 * t40;
  t43 = t32 * t41 / 0.2e1;
  t44 = xc_integrate(func0, &(params->beta), 0.0, t43);
  t45 = log(t43);
  t47 = xc_integrate(func1, &(params->beta), 0.0, t43);
  t49 = t39 * (t44 * t45 - t47);
  t52 = 0.1e1 - 0.2e1 / 0.9e1 * t32 * t33 * t49;
  t56 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t52);
  t57 = rho[1] <= p->dens_threshold;
  t58 = -t16;
  t60 = my_piecewise5(t14, t11, t10, t15, t58 * t7);
  t61 = 0.1e1 + t60;
  t62 = t61 <= p->zeta_threshold;
  t63 = POW_1_3(t61);
  t65 = my_piecewise3(t62, t22, t63 * t61);
  t66 = t65 * t26;
  t67 = sqrt(sigma[2]);
  t68 = POW_1_3(rho[1]);
  t70 = 0.1e1 / t68 / rho[1];
  t71 = t67 * t70;
  t74 = t71 * t41 / 0.2e1;
  t75 = xc_integrate(func0, &(params->beta), 0.0, t74);
  t76 = log(t74);
  t78 = xc_integrate(func1, &(params->beta), 0.0, t74);
  t80 = t39 * (t75 * t76 - t78);
  t83 = 0.1e1 - 0.2e1 / 0.9e1 * t71 * t33 * t80;
  t87 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t83);
  tzk0 = t56 + t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t36, t37, t38, t39, t40, t41, t43;
  double t44, t45, t47, t49, t52, t56, t57, t58;
  double t60, t61, t62, t63, t65, t66, t67, t68;
  double t70, t71, t74, t75, t76, t78, t80, t83;
  double t87, tzk0;

  double t88, t89, t90, t92, t95, t96, t100, t101;
  double t102, t105, t106, t108, t109, t110, t112, t115;
  double t120, t121, t123, t126, t127, t131, t134, t136;
  double tvrho0, t140, t143, t144, t149, t151, t154, t155;
  double t159, t161, t162, t163, t165, t168, t173, tvrho1;
  double t176, t177, t178, t182, t186, tvsigma0, tvsigma1, t187;
  double t188, t189, t193, t197, tvsigma2;

  gga_x_fd_lb94_params *params;

  assert(p->params != NULL);
  params = (gga_x_fd_lb94_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = sqrt(sigma[0]);
  t29 = POW_1_3(rho[0]);
  t31 = 0.1e1 / t29 / rho[0];
  t32 = t28 * t31;
  t33 = t2 * t2;
  t36 = POW_1_3(0.1e1 / M_PI);
  t37 = 0.1e1 / t36;
  t38 = M_CBRT4;
  t39 = t37 * t38;
  t40 = M_CBRT2;
  t41 = t40 * t40;
  t43 = t32 * t41 / 0.2e1;
  t44 = xc_integrate(func0, &(params->beta), 0.0, t43);
  t45 = log(t43);
  t47 = xc_integrate(func1, &(params->beta), 0.0, t43);
  t49 = t39 * (t44 * t45 - t47);
  t52 = 0.1e1 - 0.2e1 / 0.9e1 * t32 * t33 * t49;
  t56 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t52);
  t57 = rho[1] <= p->dens_threshold;
  t58 = -t16;
  t60 = my_piecewise5(t14, t11, t10, t15, t58 * t7);
  t61 = 0.1e1 + t60;
  t62 = t61 <= p->zeta_threshold;
  t63 = POW_1_3(t61);
  t65 = my_piecewise3(t62, t22, t63 * t61);
  t66 = t65 * t26;
  t67 = sqrt(sigma[2]);
  t68 = POW_1_3(rho[1]);
  t70 = 0.1e1 / t68 / rho[1];
  t71 = t67 * t70;
  t74 = t71 * t41 / 0.2e1;
  t75 = xc_integrate(func0, &(params->beta), 0.0, t74);
  t76 = log(t74);
  t78 = xc_integrate(func1, &(params->beta), 0.0, t74);
  t80 = t39 * (t75 * t76 - t78);
  t83 = 0.1e1 - 0.2e1 / 0.9e1 * t71 * t33 * t80;
  t87 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t83);
  tzk0 = t56 + t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t88 = t6 * t6;
  t89 = 0.1e1 / t88;
  t90 = t16 * t89;
  t92 = my_piecewise5(t10, 0, t14, 0, t7 - t90);
  t95 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t92);
  t96 = t95 * t26;
  t100 = t26 * t26;
  t101 = 0.1e1 / t100;
  t102 = t25 * t101;
  t105 = t5 * t102 * t52 / 0.8e1;
  t106 = rho[0] * rho[0];
  t108 = 0.1e1 / t29 / t106;
  t109 = t28 * t108;
  t110 = t109 * t33;
  t112 = t39 * t44;
  t115 = 0.8e1 / 0.27e2 * t110 * t112 + 0.8e1 / 0.27e2 * t110 * t49;
  t120 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t96 * t52 - t105 - 0.3e1 / 0.8e1 * t5 * t27 * t115);
  t121 = t58 * t89;
  t123 = my_piecewise5(t14, 0, t10, 0, -t7 - t121);
  t126 = my_piecewise3(t62, 0, 0.4e1 / 0.3e1 * t63 * t123);
  t127 = t126 * t26;
  t131 = t65 * t101;
  t134 = t5 * t131 * t83 / 0.8e1;
  t136 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t127 * t83 - t134);
  tvrho0 = t56 + t87 + t6 * (t120 + t136);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t140 = my_piecewise5(t10, 0, t14, 0, -t7 - t90);
  t143 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t140);
  t144 = t143 * t26;
  t149 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t144 * t52 - t105);
  t151 = my_piecewise5(t14, 0, t10, 0, t7 - t121);
  t154 = my_piecewise3(t62, 0, 0.4e1 / 0.3e1 * t63 * t151);
  t155 = t154 * t26;
  t159 = rho[1] * rho[1];
  t161 = 0.1e1 / t68 / t159;
  t162 = t67 * t161;
  t163 = t162 * t33;
  t165 = t39 * t75;
  t168 = 0.8e1 / 0.27e2 * t163 * t165 + 0.8e1 / 0.27e2 * t163 * t80;
  t173 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t155 * t83 - t134 - 0.3e1 / 0.8e1 * t5 * t66 * t168);
  tvrho1 = t56 + t87 + t6 * (t149 + t173);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t176 = 0.1e1 / t28;
  t177 = t176 * t31;
  t178 = t177 * t33;
  t182 = -t178 * t112 / 0.9e1 - t178 * t49 / 0.9e1;
  t186 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t182);
  tvsigma0 = t6 * t186;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t187 = 0.1e1 / t67;
  t188 = t187 * t70;
  t189 = t188 * t33;
  t193 = -t189 * t165 / 0.9e1 - t189 * t80 / 0.9e1;
  t197 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t193);
  tvsigma2 = t6 * t197;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t36, t37, t38, t39, t40, t41, t43;
  double t44, t45, t47, t49, t52, t56, t57, t58;
  double t60, t61, t62, t63, t65, t66, t67, t68;
  double t70, t71, t74, t75, t76, t78, t80, t83;
  double t87, tzk0;

  double t88, t89, t90, t92, t95, t96, t100, t101;
  double t102, t105, t106, t108, t109, t110, t112, t115;
  double t120, t121, t123, t126, t127, t131, t134, t136;
  double tvrho0, t140, t143, t144, t149, t151, t154, t155;
  double t159, t161, t162, t163, t165, t168, t173, tvrho1;
  double t176, t177, t178, t182, t186, tvsigma0, tvsigma1, t187;
  double t188, t189, t193, t197, tvsigma2;

  double t200, t201, t202, t205, t206, t207, t210, t214;
  double t215, t219, t221, t227, t228, t231, t233, t235;
  double t237, t238, t239, t244, t245, t247, t248, t250;
  double t252, t254, t255, t256, t257, t258, t261, t262;
  double t264, t267, t272, t273, t274, t275, t278, t281;
  double t285, t286, t290, t292, t294, t297, t299, tv2rho20;
  double t302, t306, t310, t311, t315, t317, t325, t326;
  double t330, t334, t335, t339, t341, t348, t351, tv2rho21;
  double t356, t361, t365, t366, t372, t373, t378, t382;
  double t383, t392, t394, t395, t396, t401, t402, t404;
  double t405, t407, t409, t411, t412, t413, t414, t415;
  double t418, t419, t421, t424, t429, tv2rho22, t437, t438;
  double t439, t445, t447, t448, t449, t452, t457, tv2rhosigma0;
  double tv2rhosigma1, t464, t466, tv2rhosigma2, t472, tv2rhosigma3, tv2rhosigma4, t477;
  double t478, t484, t486, t487, t490, t495, tv2rhosigma5, t498;
  double t499, t503, t504, t508, t512, tv2sigma20, tv2sigma21, tv2sigma22;
  double tv2sigma23, tv2sigma24, t514, t515, t519, t520, t524, t528;
  double tv2sigma25;

  gga_x_fd_lb94_params *params;

  assert(p->params != NULL);
  params = (gga_x_fd_lb94_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = sqrt(sigma[0]);
  t29 = POW_1_3(rho[0]);
  t31 = 0.1e1 / t29 / rho[0];
  t32 = t28 * t31;
  t33 = t2 * t2;
  t36 = POW_1_3(0.1e1 / M_PI);
  t37 = 0.1e1 / t36;
  t38 = M_CBRT4;
  t39 = t37 * t38;
  t40 = M_CBRT2;
  t41 = t40 * t40;
  t43 = t32 * t41 / 0.2e1;
  t44 = xc_integrate(func0, &(params->beta), 0.0, t43);
  t45 = log(t43);
  t47 = xc_integrate(func1, &(params->beta), 0.0, t43);
  t49 = t39 * (t44 * t45 - t47);
  t52 = 0.1e1 - 0.2e1 / 0.9e1 * t32 * t33 * t49;
  t56 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t52);
  t57 = rho[1] <= p->dens_threshold;
  t58 = -t16;
  t60 = my_piecewise5(t14, t11, t10, t15, t58 * t7);
  t61 = 0.1e1 + t60;
  t62 = t61 <= p->zeta_threshold;
  t63 = POW_1_3(t61);
  t65 = my_piecewise3(t62, t22, t63 * t61);
  t66 = t65 * t26;
  t67 = sqrt(sigma[2]);
  t68 = POW_1_3(rho[1]);
  t70 = 0.1e1 / t68 / rho[1];
  t71 = t67 * t70;
  t74 = t71 * t41 / 0.2e1;
  t75 = xc_integrate(func0, &(params->beta), 0.0, t74);
  t76 = log(t74);
  t78 = xc_integrate(func1, &(params->beta), 0.0, t74);
  t80 = t39 * (t75 * t76 - t78);
  t83 = 0.1e1 - 0.2e1 / 0.9e1 * t71 * t33 * t80;
  t87 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t83);
  tzk0 = t56 + t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t88 = t6 * t6;
  t89 = 0.1e1 / t88;
  t90 = t16 * t89;
  t92 = my_piecewise5(t10, 0, t14, 0, t7 - t90);
  t95 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t92);
  t96 = t95 * t26;
  t100 = t26 * t26;
  t101 = 0.1e1 / t100;
  t102 = t25 * t101;
  t105 = t5 * t102 * t52 / 0.8e1;
  t106 = rho[0] * rho[0];
  t108 = 0.1e1 / t29 / t106;
  t109 = t28 * t108;
  t110 = t109 * t33;
  t112 = t39 * t44;
  t115 = 0.8e1 / 0.27e2 * t110 * t112 + 0.8e1 / 0.27e2 * t110 * t49;
  t120 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t96 * t52 - t105 - 0.3e1 / 0.8e1 * t5 * t27 * t115);
  t121 = t58 * t89;
  t123 = my_piecewise5(t14, 0, t10, 0, -t7 - t121);
  t126 = my_piecewise3(t62, 0, 0.4e1 / 0.3e1 * t63 * t123);
  t127 = t126 * t26;
  t131 = t65 * t101;
  t134 = t5 * t131 * t83 / 0.8e1;
  t136 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t127 * t83 - t134);
  tvrho0 = t56 + t87 + t6 * (t120 + t136);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t140 = my_piecewise5(t10, 0, t14, 0, -t7 - t90);
  t143 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t140);
  t144 = t143 * t26;
  t149 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t144 * t52 - t105);
  t151 = my_piecewise5(t14, 0, t10, 0, t7 - t121);
  t154 = my_piecewise3(t62, 0, 0.4e1 / 0.3e1 * t63 * t151);
  t155 = t154 * t26;
  t159 = rho[1] * rho[1];
  t161 = 0.1e1 / t68 / t159;
  t162 = t67 * t161;
  t163 = t162 * t33;
  t165 = t39 * t75;
  t168 = 0.8e1 / 0.27e2 * t163 * t165 + 0.8e1 / 0.27e2 * t163 * t80;
  t173 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t155 * t83 - t134 - 0.3e1 / 0.8e1 * t5 * t66 * t168);
  tvrho1 = t56 + t87 + t6 * (t149 + t173);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t176 = 0.1e1 / t28;
  t177 = t176 * t31;
  t178 = t177 * t33;
  t182 = -t178 * t112 / 0.9e1 - t178 * t49 / 0.9e1;
  t186 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t182);
  tvsigma0 = t6 * t186;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t187 = 0.1e1 / t67;
  t188 = t187 * t70;
  t189 = t188 * t33;
  t193 = -t189 * t165 / 0.9e1 - t189 * t80 / 0.9e1;
  t197 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t193);
  tvsigma2 = t6 * t197;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t200 = t23 * t23;
  t201 = 0.1e1 / t200;
  t202 = t92 * t92;
  t205 = t88 * t6;
  t206 = 0.1e1 / t205;
  t207 = t16 * t206;
  t210 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t89 + 0.2e1 * t207);
  t214 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t201 * t202 + 0.4e1 / 0.3e1 * t23 * t210);
  t215 = t214 * t26;
  t219 = t95 * t101;
  t221 = t5 * t219 * t52;
  t227 = 0.1e1 / t100 / t6;
  t228 = t25 * t227;
  t231 = t5 * t228 * t52 / 0.12e2;
  t233 = t5 * t102 * t115;
  t235 = t106 * rho[0];
  t237 = 0.1e1 / t29 / t235;
  t238 = t28 * t237;
  t239 = t238 * t33;
  t244 = t106 * t106;
  t245 = t29 * t29;
  t247 = 0.1e1 / t245 / t244;
  t248 = sigma[0] * t247;
  t250 = params->beta * t28;
  t252 = 0.1e1 / t245 / t106;
  t254 = sigma[0] * t252 + 0.1e1;
  t255 = sqrt(t254);
  t256 = t32 + t255;
  t257 = log(t256);
  t258 = t31 * t257;
  t261 = 0.3e1 * t250 * t258 + 0.1e1;
  t262 = 0.1e1 / t261;
  t264 = t39 * params->beta * t262;
  t267 = -0.56e2 / 0.81e2 * t239 * t49 - 0.88e2 / 0.81e2 * t239 * t112 + 0.8e1 / 0.27e2 * t248 * t33 * t264;
  t272 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t215 * t52 - t221 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t96 * t115 + t231 - t233 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t267);
  t273 = t63 * t63;
  t274 = 0.1e1 / t273;
  t275 = t123 * t123;
  t278 = t58 * t206;
  t281 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t89 + 0.2e1 * t278);
  t285 = my_piecewise3(t62, 0, 0.4e1 / 0.9e1 * t274 * t275 + 0.4e1 / 0.3e1 * t63 * t281);
  t286 = t285 * t26;
  t290 = t126 * t101;
  t292 = t5 * t290 * t83;
  t294 = t65 * t227;
  t297 = t5 * t294 * t83 / 0.12e2;
  t299 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t286 * t83 - t292 / 0.4e1 + t297);
  tv2rho20 = 0.2e1 * t120 + 0.2e1 * t136 + t6 * (t272 + t299);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t302 = t201 * t140;
  t306 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t207);
  t310 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t302 * t92 + 0.4e1 / 0.3e1 * t23 * t306);
  t311 = t310 * t26;
  t315 = t143 * t101;
  t317 = t5 * t315 * t52;
  t325 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t311 * t52 - t317 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t144 * t115 - t221 / 0.8e1 + t231 - t233 / 0.8e1);
  t326 = t274 * t151;
  t330 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t278);
  t334 = my_piecewise3(t62, 0, 0.4e1 / 0.9e1 * t326 * t123 + 0.4e1 / 0.3e1 * t63 * t330);
  t335 = t334 * t26;
  t339 = t154 * t101;
  t341 = t5 * t339 * t83;
  t348 = t5 * t131 * t168;
  t351 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t335 * t83 - t341 / 0.8e1 - t292 / 0.8e1 + t297 - 0.3e1 / 0.8e1 * t5 * t127 * t168 - t348 / 0.8e1);
  tv2rho21 = t120 + t136 + t149 + t173 + t6 * (t325 + t351);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t356 = t140 * t140;
  t361 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t89 + 0.2e1 * t207);
  t365 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t201 * t356 + 0.4e1 / 0.3e1 * t23 * t361);
  t366 = t365 * t26;
  t372 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t366 * t52 - t317 / 0.4e1 + t231);
  t373 = t151 * t151;
  t378 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t89 + 0.2e1 * t278);
  t382 = my_piecewise3(t62, 0, 0.4e1 / 0.9e1 * t274 * t373 + 0.4e1 / 0.3e1 * t63 * t378);
  t383 = t382 * t26;
  t392 = t159 * rho[1];
  t394 = 0.1e1 / t68 / t392;
  t395 = t67 * t394;
  t396 = t395 * t33;
  t401 = t159 * t159;
  t402 = t68 * t68;
  t404 = 0.1e1 / t402 / t401;
  t405 = sigma[2] * t404;
  t407 = params->beta * t67;
  t409 = 0.1e1 / t402 / t159;
  t411 = sigma[2] * t409 + 0.1e1;
  t412 = sqrt(t411);
  t413 = t71 + t412;
  t414 = log(t413);
  t415 = t70 * t414;
  t418 = 0.3e1 * t407 * t415 + 0.1e1;
  t419 = 0.1e1 / t418;
  t421 = t39 * params->beta * t419;
  t424 = -0.56e2 / 0.81e2 * t396 * t80 - 0.88e2 / 0.81e2 * t396 * t165 + 0.8e1 / 0.27e2 * t405 * t33 * t421;
  t429 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t383 * t83 - t341 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t155 * t168 + t297 - t348 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t66 * t424);
  tv2rho22 = 0.2e1 * t149 + 0.2e1 * t173 + t6 * (t372 + t429);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t437 = t5 * t102 * t182 / 0.8e1;
  t438 = t176 * t108;
  t439 = t438 * t33;
  t445 = 0.1e1 / t245 / t235;
  t447 = t445 * t33 * t37;
  t448 = t38 * params->beta;
  t449 = t448 * t262;
  t452 = 0.4e1 / 0.27e2 * t439 * t49 + 0.8e1 / 0.27e2 * t439 * t112 - t447 * t449 / 0.9e1;
  t457 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t96 * t182 - t437 - 0.3e1 / 0.8e1 * t5 * t27 * t452);
  tv2rhosigma0 = t6 * t457 + t186;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t464 = t5 * t131 * t193 / 0.8e1;
  t466 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t127 * t193 - t464);
  tv2rhosigma2 = t6 * t466 + t197;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t472 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t144 * t182 - t437);
  tv2rhosigma3 = t6 * t472 + t186;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t477 = t187 * t161;
  t478 = t477 * t33;
  t484 = 0.1e1 / t402 / t392;
  t486 = t484 * t33 * t37;
  t487 = t448 * t419;
  t490 = 0.4e1 / 0.27e2 * t478 * t80 + 0.8e1 / 0.27e2 * t478 * t165 - t486 * t487 / 0.9e1;
  t495 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t155 * t193 - t464 - 0.3e1 / 0.8e1 * t5 * t66 * t490);
  tv2rhosigma5 = t6 * t495 + t197;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t498 = 0.1e1 / t28 / sigma[0];
  t499 = t498 * t31;
  t503 = 0.1e1 / sigma[0];
  t504 = t503 * t252;
  t508 = t499 * t33 * t49 / 0.18e2 + t504 * t33 * t264 / 0.24e2;
  t512 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t508);
  tv2sigma20 = t6 * t512;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t514 = 0.1e1 / t67 / sigma[2];
  t515 = t514 * t70;
  t519 = 0.1e1 / sigma[2];
  t520 = t519 * t409;
  t524 = t515 * t33 * t80 / 0.18e2 + t520 * t33 * t421 / 0.24e2;
  t528 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t524);
  tv2sigma25 = t6 * t528;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t36, t37, t38, t39, t40, t41, t43;
  double t44, t45, t47, t49, t52, t56, t57, t58;
  double t60, t61, t62, t63, t65, t66, t67, t68;
  double t70, t71, t74, t75, t76, t78, t80, t83;
  double t87, tzk0;

  double t88, t89, t90, t92, t95, t96, t100, t101;
  double t102, t105, t106, t108, t109, t110, t112, t115;
  double t120, t121, t123, t126, t127, t131, t134, t136;
  double tvrho0, t140, t143, t144, t149, t151, t154, t155;
  double t159, t161, t162, t163, t165, t168, t173, tvrho1;
  double t176, t177, t178, t182, t186, tvsigma0, tvsigma1, t187;
  double t188, t189, t193, t197, tvsigma2;

  double t200, t201, t202, t205, t206, t207, t210, t214;
  double t215, t219, t221, t227, t228, t231, t233, t235;
  double t237, t238, t239, t244, t245, t247, t248, t250;
  double t252, t254, t255, t256, t257, t258, t261, t262;
  double t264, t267, t272, t273, t274, t275, t278, t281;
  double t285, t286, t290, t292, t294, t297, t299, tv2rho20;
  double t302, t306, t310, t311, t315, t317, t325, t326;
  double t330, t334, t335, t339, t341, t348, t351, tv2rho21;
  double t356, t361, t365, t366, t372, t373, t378, t382;
  double t383, t392, t394, t395, t396, t401, t402, t404;
  double t405, t407, t409, t411, t412, t413, t414, t415;
  double t418, t419, t421, t424, t429, tv2rho22, t437, t438;
  double t439, t445, t447, t448, t449, t452, t457, tv2rhosigma0;
  double tv2rhosigma1, t464, t466, tv2rhosigma2, t472, tv2rhosigma3, tv2rhosigma4, t477;
  double t478, t484, t486, t487, t490, t495, tv2rhosigma5, t498;
  double t499, t503, t504, t508, t512, tv2sigma20, tv2sigma21, tv2sigma22;
  double tv2sigma23, tv2sigma24, t514, t515, t519, t520, t524, t528;
  double tv2sigma25;

  double t532, t533, t536, t539, t540, t541, t544, t548;
  double t549, t553, t555, t560, t562, t565, t571, t572;
  double t575, t577, t580, t583, t585, t590, t592, t593;
  double t597, t598, t599, t600, t601, t604, t605, t608;
  double t610, t611, t614, t616, t619, t624, t626, t627;
  double t630, t633, t636, t640, t641, t645, t647, t649;
  double t651, t653, t656, t658, tv3rho30, t661, t662, t663;
  double t666, t671, t672, t674, t678, t679, t683, t686;
  double t690, t692, t696, t705, t706, t707, t710, t715;
  double t717, t721, t722, t726, t729, t730, t732, t741;
  double t743, t746, tv3rho31, t749, t754, t758, t762, t763;
  double t767, t769, t778, t779, t784, t788, t792, t793;
  double t797, t799, t806, t814, t816, t817, tv3rho32, t822;
  double t829, t833, t834, t841, t842, t849, t853, t854;
  double t870, t872, t877, t879, t880, t884, t885, t886;
  double t887, t890, t891, t894, t896, t897, t900, t902;
  double t905, t910, tv3rho33, t918, t925, t927, t930, t936;
  double t941, t946, tv3rho2sigma0, tv3rho2sigma1, t953, t957, t959, tv3rho2sigma2;
  double t965, t973, tv3rho2sigma3, tv3rho2sigma4, t979, t986, t989, tv3rho2sigma5;
  double t997, tv3rho2sigma6, tv3rho2sigma7, t1009, t1015, t1020, t1025, tv3rho2sigma8;
  double t1032, t1034, t1039, t1043, t1046, t1051, tv3rhosigma20, tv3rhosigma21;
  double tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1058, t1060, tv3rhosigma25, t1066, tv3rhosigma26;
  double tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1072, t1077, t1081, t1084;
  double t1089, tv3rhosigma211, t1091, t1093, t1095, t1100, t1101, t1105;
  double t1110, t1112, t1115, t1117, t1120, t1124, tv3sigma30, tv3sigma31;
  double tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t1125;
  double t1127, t1129, t1134, t1135, t1139, t1144, t1146, t1149;
  double t1151, t1154, t1158, tv3sigma39;

  gga_x_fd_lb94_params *params;

  assert(p->params != NULL);
  params = (gga_x_fd_lb94_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = sqrt(sigma[0]);
  t29 = POW_1_3(rho[0]);
  t31 = 0.1e1 / t29 / rho[0];
  t32 = t28 * t31;
  t33 = t2 * t2;
  t36 = POW_1_3(0.1e1 / M_PI);
  t37 = 0.1e1 / t36;
  t38 = M_CBRT4;
  t39 = t37 * t38;
  t40 = M_CBRT2;
  t41 = t40 * t40;
  t43 = t32 * t41 / 0.2e1;
  t44 = xc_integrate(func0, &(params->beta), 0.0, t43);
  t45 = log(t43);
  t47 = xc_integrate(func1, &(params->beta), 0.0, t43);
  t49 = t39 * (t44 * t45 - t47);
  t52 = 0.1e1 - 0.2e1 / 0.9e1 * t32 * t33 * t49;
  t56 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t52);
  t57 = rho[1] <= p->dens_threshold;
  t58 = -t16;
  t60 = my_piecewise5(t14, t11, t10, t15, t58 * t7);
  t61 = 0.1e1 + t60;
  t62 = t61 <= p->zeta_threshold;
  t63 = POW_1_3(t61);
  t65 = my_piecewise3(t62, t22, t63 * t61);
  t66 = t65 * t26;
  t67 = sqrt(sigma[2]);
  t68 = POW_1_3(rho[1]);
  t70 = 0.1e1 / t68 / rho[1];
  t71 = t67 * t70;
  t74 = t71 * t41 / 0.2e1;
  t75 = xc_integrate(func0, &(params->beta), 0.0, t74);
  t76 = log(t74);
  t78 = xc_integrate(func1, &(params->beta), 0.0, t74);
  t80 = t39 * (t75 * t76 - t78);
  t83 = 0.1e1 - 0.2e1 / 0.9e1 * t71 * t33 * t80;
  t87 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t83);
  tzk0 = t56 + t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t88 = t6 * t6;
  t89 = 0.1e1 / t88;
  t90 = t16 * t89;
  t92 = my_piecewise5(t10, 0, t14, 0, t7 - t90);
  t95 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t92);
  t96 = t95 * t26;
  t100 = t26 * t26;
  t101 = 0.1e1 / t100;
  t102 = t25 * t101;
  t105 = t5 * t102 * t52 / 0.8e1;
  t106 = rho[0] * rho[0];
  t108 = 0.1e1 / t29 / t106;
  t109 = t28 * t108;
  t110 = t109 * t33;
  t112 = t39 * t44;
  t115 = 0.8e1 / 0.27e2 * t110 * t112 + 0.8e1 / 0.27e2 * t110 * t49;
  t120 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t96 * t52 - t105 - 0.3e1 / 0.8e1 * t5 * t27 * t115);
  t121 = t58 * t89;
  t123 = my_piecewise5(t14, 0, t10, 0, -t7 - t121);
  t126 = my_piecewise3(t62, 0, 0.4e1 / 0.3e1 * t63 * t123);
  t127 = t126 * t26;
  t131 = t65 * t101;
  t134 = t5 * t131 * t83 / 0.8e1;
  t136 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t127 * t83 - t134);
  tvrho0 = t56 + t87 + t6 * (t120 + t136);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t140 = my_piecewise5(t10, 0, t14, 0, -t7 - t90);
  t143 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t140);
  t144 = t143 * t26;
  t149 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t144 * t52 - t105);
  t151 = my_piecewise5(t14, 0, t10, 0, t7 - t121);
  t154 = my_piecewise3(t62, 0, 0.4e1 / 0.3e1 * t63 * t151);
  t155 = t154 * t26;
  t159 = rho[1] * rho[1];
  t161 = 0.1e1 / t68 / t159;
  t162 = t67 * t161;
  t163 = t162 * t33;
  t165 = t39 * t75;
  t168 = 0.8e1 / 0.27e2 * t163 * t165 + 0.8e1 / 0.27e2 * t163 * t80;
  t173 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t155 * t83 - t134 - 0.3e1 / 0.8e1 * t5 * t66 * t168);
  tvrho1 = t56 + t87 + t6 * (t149 + t173);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t176 = 0.1e1 / t28;
  t177 = t176 * t31;
  t178 = t177 * t33;
  t182 = -t178 * t112 / 0.9e1 - t178 * t49 / 0.9e1;
  t186 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t182);
  tvsigma0 = t6 * t186;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t187 = 0.1e1 / t67;
  t188 = t187 * t70;
  t189 = t188 * t33;
  t193 = -t189 * t165 / 0.9e1 - t189 * t80 / 0.9e1;
  t197 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t193);
  tvsigma2 = t6 * t197;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t200 = t23 * t23;
  t201 = 0.1e1 / t200;
  t202 = t92 * t92;
  t205 = t88 * t6;
  t206 = 0.1e1 / t205;
  t207 = t16 * t206;
  t210 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t89 + 0.2e1 * t207);
  t214 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t201 * t202 + 0.4e1 / 0.3e1 * t23 * t210);
  t215 = t214 * t26;
  t219 = t95 * t101;
  t221 = t5 * t219 * t52;
  t227 = 0.1e1 / t100 / t6;
  t228 = t25 * t227;
  t231 = t5 * t228 * t52 / 0.12e2;
  t233 = t5 * t102 * t115;
  t235 = t106 * rho[0];
  t237 = 0.1e1 / t29 / t235;
  t238 = t28 * t237;
  t239 = t238 * t33;
  t244 = t106 * t106;
  t245 = t29 * t29;
  t247 = 0.1e1 / t245 / t244;
  t248 = sigma[0] * t247;
  t250 = params->beta * t28;
  t252 = 0.1e1 / t245 / t106;
  t254 = sigma[0] * t252 + 0.1e1;
  t255 = sqrt(t254);
  t256 = t32 + t255;
  t257 = log(t256);
  t258 = t31 * t257;
  t261 = 0.3e1 * t250 * t258 + 0.1e1;
  t262 = 0.1e1 / t261;
  t264 = t39 * params->beta * t262;
  t267 = -0.56e2 / 0.81e2 * t239 * t49 - 0.88e2 / 0.81e2 * t239 * t112 + 0.8e1 / 0.27e2 * t248 * t33 * t264;
  t272 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t215 * t52 - t221 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t96 * t115 + t231 - t233 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t267);
  t273 = t63 * t63;
  t274 = 0.1e1 / t273;
  t275 = t123 * t123;
  t278 = t58 * t206;
  t281 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t89 + 0.2e1 * t278);
  t285 = my_piecewise3(t62, 0, 0.4e1 / 0.9e1 * t274 * t275 + 0.4e1 / 0.3e1 * t63 * t281);
  t286 = t285 * t26;
  t290 = t126 * t101;
  t292 = t5 * t290 * t83;
  t294 = t65 * t227;
  t297 = t5 * t294 * t83 / 0.12e2;
  t299 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t286 * t83 - t292 / 0.4e1 + t297);
  tv2rho20 = 0.2e1 * t120 + 0.2e1 * t136 + t6 * (t272 + t299);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t302 = t201 * t140;
  t306 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t207);
  t310 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t302 * t92 + 0.4e1 / 0.3e1 * t23 * t306);
  t311 = t310 * t26;
  t315 = t143 * t101;
  t317 = t5 * t315 * t52;
  t325 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t311 * t52 - t317 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t144 * t115 - t221 / 0.8e1 + t231 - t233 / 0.8e1);
  t326 = t274 * t151;
  t330 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t278);
  t334 = my_piecewise3(t62, 0, 0.4e1 / 0.9e1 * t326 * t123 + 0.4e1 / 0.3e1 * t63 * t330);
  t335 = t334 * t26;
  t339 = t154 * t101;
  t341 = t5 * t339 * t83;
  t348 = t5 * t131 * t168;
  t351 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t335 * t83 - t341 / 0.8e1 - t292 / 0.8e1 + t297 - 0.3e1 / 0.8e1 * t5 * t127 * t168 - t348 / 0.8e1);
  tv2rho21 = t120 + t136 + t149 + t173 + t6 * (t325 + t351);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t356 = t140 * t140;
  t361 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t89 + 0.2e1 * t207);
  t365 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t201 * t356 + 0.4e1 / 0.3e1 * t23 * t361);
  t366 = t365 * t26;
  t372 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t366 * t52 - t317 / 0.4e1 + t231);
  t373 = t151 * t151;
  t378 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t89 + 0.2e1 * t278);
  t382 = my_piecewise3(t62, 0, 0.4e1 / 0.9e1 * t274 * t373 + 0.4e1 / 0.3e1 * t63 * t378);
  t383 = t382 * t26;
  t392 = t159 * rho[1];
  t394 = 0.1e1 / t68 / t392;
  t395 = t67 * t394;
  t396 = t395 * t33;
  t401 = t159 * t159;
  t402 = t68 * t68;
  t404 = 0.1e1 / t402 / t401;
  t405 = sigma[2] * t404;
  t407 = params->beta * t67;
  t409 = 0.1e1 / t402 / t159;
  t411 = sigma[2] * t409 + 0.1e1;
  t412 = sqrt(t411);
  t413 = t71 + t412;
  t414 = log(t413);
  t415 = t70 * t414;
  t418 = 0.3e1 * t407 * t415 + 0.1e1;
  t419 = 0.1e1 / t418;
  t421 = t39 * params->beta * t419;
  t424 = -0.56e2 / 0.81e2 * t396 * t80 - 0.88e2 / 0.81e2 * t396 * t165 + 0.8e1 / 0.27e2 * t405 * t33 * t421;
  t429 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t383 * t83 - t341 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t155 * t168 + t297 - t348 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t66 * t424);
  tv2rho22 = 0.2e1 * t149 + 0.2e1 * t173 + t6 * (t372 + t429);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t437 = t5 * t102 * t182 / 0.8e1;
  t438 = t176 * t108;
  t439 = t438 * t33;
  t445 = 0.1e1 / t245 / t235;
  t447 = t445 * t33 * t37;
  t448 = t38 * params->beta;
  t449 = t448 * t262;
  t452 = 0.4e1 / 0.27e2 * t439 * t49 + 0.8e1 / 0.27e2 * t439 * t112 - t447 * t449 / 0.9e1;
  t457 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t96 * t182 - t437 - 0.3e1 / 0.8e1 * t5 * t27 * t452);
  tv2rhosigma0 = t6 * t457 + t186;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t464 = t5 * t131 * t193 / 0.8e1;
  t466 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t127 * t193 - t464);
  tv2rhosigma2 = t6 * t466 + t197;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t472 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t144 * t182 - t437);
  tv2rhosigma3 = t6 * t472 + t186;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t477 = t187 * t161;
  t478 = t477 * t33;
  t484 = 0.1e1 / t402 / t392;
  t486 = t484 * t33 * t37;
  t487 = t448 * t419;
  t490 = 0.4e1 / 0.27e2 * t478 * t80 + 0.8e1 / 0.27e2 * t478 * t165 - t486 * t487 / 0.9e1;
  t495 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t155 * t193 - t464 - 0.3e1 / 0.8e1 * t5 * t66 * t490);
  tv2rhosigma5 = t6 * t495 + t197;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t498 = 0.1e1 / t28 / sigma[0];
  t499 = t498 * t31;
  t503 = 0.1e1 / sigma[0];
  t504 = t503 * t252;
  t508 = t499 * t33 * t49 / 0.18e2 + t504 * t33 * t264 / 0.24e2;
  t512 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t508);
  tv2sigma20 = t6 * t512;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t514 = 0.1e1 / t67 / sigma[2];
  t515 = t514 * t70;
  t519 = 0.1e1 / sigma[2];
  t520 = t519 * t409;
  t524 = t515 * t33 * t80 / 0.18e2 + t520 * t33 * t421 / 0.24e2;
  t528 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t524);
  tv2sigma25 = t6 * t528;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t532 = 0.1e1 / t200 / t19;
  t533 = t202 * t92;
  t536 = t201 * t92;
  t539 = t88 * t88;
  t540 = 0.1e1 / t539;
  t541 = t16 * t540;
  t544 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t206 - 0.6e1 * t541);
  t548 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t532 * t533 + 0.4e1 / 0.3e1 * t536 * t210 + 0.4e1 / 0.3e1 * t23 * t544);
  t549 = t548 * t26;
  t553 = t214 * t101;
  t555 = t5 * t553 * t52;
  t560 = t95 * t227;
  t562 = t5 * t560 * t52;
  t565 = t5 * t219 * t115;
  t571 = 0.1e1 / t100 / t88;
  t572 = t25 * t571;
  t575 = 0.5e1 / 0.36e2 * t5 * t572 * t52;
  t577 = t5 * t228 * t115;
  t580 = t5 * t102 * t267;
  t583 = 0.1e1 / t29 / t244;
  t585 = t28 * t583 * t33;
  t590 = t244 * rho[0];
  t592 = 0.1e1 / t245 / t590;
  t593 = sigma[0] * t592;
  t597 = t33 * t37;
  t598 = t248 * t597;
  t599 = t261 * t261;
  t600 = 0.1e1 / t599;
  t601 = t108 * t257;
  t604 = 0.1e1 / t255;
  t605 = t604 * sigma[0];
  t608 = -0.4e1 / 0.3e1 * t605 * t445 - 0.4e1 / 0.3e1 * t109;
  t610 = 0.1e1 / t256;
  t611 = t31 * t608 * t610;
  t614 = -0.4e1 * t250 * t601 + 0.3e1 * t250 * t611;
  t616 = t448 * t600 * t614;
  t619 = 0.56e3 / 0.243e3 * t585 * t49 + 0.368e3 / 0.81e2 * t585 * t112 - 0.2e3 / 0.81e2 * t593 * t33 * t264 - 0.8e1 / 0.27e2 * t598 * t616;
  t624 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t549 * t52 - 0.3e1 / 0.8e1 * t555 - 0.9e1 / 0.8e1 * t5 * t215 * t115 + t562 / 0.4e1 - 0.3e1 / 0.4e1 * t565 - 0.9e1 / 0.8e1 * t5 * t96 * t267 - t575 + t577 / 0.4e1 - 0.3e1 / 0.8e1 * t580 - 0.3e1 / 0.8e1 * t5 * t27 * t619);
  t626 = 0.1e1 / t273 / t61;
  t627 = t275 * t123;
  t630 = t274 * t123;
  t633 = t58 * t540;
  t636 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t206 - 0.6e1 * t633);
  t640 = my_piecewise3(t62, 0, -0.8e1 / 0.27e2 * t626 * t627 + 0.4e1 / 0.3e1 * t630 * t281 + 0.4e1 / 0.3e1 * t63 * t636);
  t641 = t640 * t26;
  t645 = t285 * t101;
  t647 = t5 * t645 * t83;
  t649 = t126 * t227;
  t651 = t5 * t649 * t83;
  t653 = t65 * t571;
  t656 = 0.5e1 / 0.36e2 * t5 * t653 * t83;
  t658 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t641 * t83 - 0.3e1 / 0.8e1 * t647 + t651 / 0.4e1 - t656);
  tv3rho30 = 0.3e1 * t272 + 0.3e1 * t299 + t6 * (t624 + t658);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t661 = 0.2e1 * t325;
  t662 = 0.2e1 * t351;
  t663 = t532 * t140;
  t666 = t201 * t306;
  t671 = 0.2e1 * t206;
  t672 = 0.6e1 * t541;
  t674 = my_piecewise5(t10, 0, t14, 0, t671 - t672);
  t678 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t663 * t202 + 0.8e1 / 0.9e1 * t666 * t92 + 0.4e1 / 0.9e1 * t302 * t210 + 0.4e1 / 0.3e1 * t23 * t674);
  t679 = t678 * t26;
  t683 = t310 * t101;
  t686 = t5 * t683 * t52 / 0.4e1;
  t690 = t143 * t227;
  t692 = t5 * t690 * t52;
  t696 = t5 * t315 * t115 / 0.4e1;
  t705 = -0.3e1 / 0.8e1 * t5 * t679 * t52 - t686 - 0.3e1 / 0.4e1 * t5 * t311 * t115 + t692 / 0.12e2 - t696 - 0.3e1 / 0.8e1 * t5 * t144 * t267 - t555 / 0.8e1 + t562 / 0.6e1 - t565 / 0.4e1 - t575 + t577 / 0.6e1 - t580 / 0.8e1;
  t706 = my_piecewise3(t1, 0, t705);
  t707 = t626 * t151;
  t710 = t274 * t330;
  t715 = 0.6e1 * t633;
  t717 = my_piecewise5(t14, 0, t10, 0, -t671 - t715);
  t721 = my_piecewise3(t62, 0, -0.8e1 / 0.27e2 * t707 * t275 + 0.8e1 / 0.9e1 * t710 * t123 + 0.4e1 / 0.9e1 * t326 * t281 + 0.4e1 / 0.3e1 * t63 * t717);
  t722 = t721 * t26;
  t726 = t334 * t101;
  t729 = t5 * t726 * t83 / 0.4e1;
  t730 = t154 * t227;
  t732 = t5 * t730 * t83;
  t741 = t5 * t290 * t168 / 0.4e1;
  t743 = t5 * t294 * t168;
  t746 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t722 * t83 - t729 + t732 / 0.12e2 - t647 / 0.8e1 + t651 / 0.6e1 - t656 - 0.3e1 / 0.8e1 * t5 * t286 * t168 - t741 + t743 / 0.12e2);
  tv3rho31 = t272 + t299 + t661 + t662 + t6 * (t706 + t746);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t749 = t532 * t356;
  t754 = t201 * t361;
  t758 = my_piecewise5(t10, 0, t14, 0, -t671 - t672);
  t762 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t749 * t92 + 0.8e1 / 0.9e1 * t302 * t306 + 0.4e1 / 0.9e1 * t754 * t92 + 0.4e1 / 0.3e1 * t23 * t758);
  t763 = t762 * t26;
  t767 = t365 * t101;
  t769 = t5 * t767 * t52;
  t778 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t763 * t52 - t769 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t366 * t115 - t686 + t692 / 0.6e1 - t696 + t562 / 0.12e2 - t575 + t577 / 0.12e2);
  t779 = t626 * t373;
  t784 = t274 * t378;
  t788 = my_piecewise5(t14, 0, t10, 0, t671 - t715);
  t792 = my_piecewise3(t62, 0, -0.8e1 / 0.27e2 * t779 * t123 + 0.8e1 / 0.9e1 * t326 * t330 + 0.4e1 / 0.9e1 * t784 * t123 + 0.4e1 / 0.3e1 * t63 * t788);
  t793 = t792 * t26;
  t797 = t382 * t101;
  t799 = t5 * t797 * t83;
  t806 = t5 * t339 * t168;
  t814 = t5 * t131 * t424;
  t816 = -0.3e1 / 0.8e1 * t5 * t793 * t83 - t799 / 0.8e1 - t729 + t732 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t335 * t168 - t806 / 0.4e1 + t651 / 0.12e2 - t656 - t741 + t743 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t127 * t424 - t814 / 0.8e1;
  t817 = my_piecewise3(t57, 0, t816);
  tv3rho32 = t661 + t662 + t372 + t429 + t6 * (t778 + t817);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t822 = t356 * t140;
  t829 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t206 - 0.6e1 * t541);
  t833 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t532 * t822 + 0.4e1 / 0.3e1 * t302 * t361 + 0.4e1 / 0.3e1 * t23 * t829);
  t834 = t833 * t26;
  t841 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t834 * t52 - 0.3e1 / 0.8e1 * t769 + t692 / 0.4e1 - t575);
  t842 = t373 * t151;
  t849 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t206 - 0.6e1 * t633);
  t853 = my_piecewise3(t62, 0, -0.8e1 / 0.27e2 * t626 * t842 + 0.4e1 / 0.3e1 * t326 * t378 + 0.4e1 / 0.3e1 * t63 * t849);
  t854 = t853 * t26;
  t870 = 0.1e1 / t68 / t401;
  t872 = t67 * t870 * t33;
  t877 = t401 * rho[1];
  t879 = 0.1e1 / t402 / t877;
  t880 = sigma[2] * t879;
  t884 = t405 * t597;
  t885 = t418 * t418;
  t886 = 0.1e1 / t885;
  t887 = t161 * t414;
  t890 = 0.1e1 / t412;
  t891 = t890 * sigma[2];
  t894 = -0.4e1 / 0.3e1 * t891 * t484 - 0.4e1 / 0.3e1 * t162;
  t896 = 0.1e1 / t413;
  t897 = t70 * t894 * t896;
  t900 = -0.4e1 * t407 * t887 + 0.3e1 * t407 * t897;
  t902 = t448 * t886 * t900;
  t905 = 0.56e3 / 0.243e3 * t872 * t80 + 0.368e3 / 0.81e2 * t872 * t165 - 0.2e3 / 0.81e2 * t880 * t33 * t421 - 0.8e1 / 0.27e2 * t884 * t902;
  t910 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t854 * t83 - 0.3e1 / 0.8e1 * t799 - 0.9e1 / 0.8e1 * t5 * t383 * t168 + t732 / 0.4e1 - 0.3e1 / 0.4e1 * t806 - 0.9e1 / 0.8e1 * t5 * t155 * t424 - t656 + t743 / 0.4e1 - 0.3e1 / 0.8e1 * t814 - 0.3e1 / 0.8e1 * t5 * t66 * t905);
  tv3rho33 = 0.3e1 * t372 + 0.3e1 * t429 + t6 * (t841 + t910);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t918 = t5 * t219 * t182;
  t925 = t5 * t228 * t182 / 0.12e2;
  t927 = t5 * t102 * t452;
  t930 = t176 * t237 * t33;
  t936 = t247 * t33 * t37;
  t941 = -0.28e2 / 0.81e2 * t930 * t49 - 0.8e1 / 0.9e1 * t930 * t112 + 0.19e2 / 0.27e2 * t936 * t449 + t447 * t616 / 0.9e1;
  t946 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t215 * t182 - t918 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t96 * t452 + t925 - t927 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t941);
  tv3rho2sigma0 = t6 * t946 + 0.2e1 * t457;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t953 = t5 * t290 * t193;
  t957 = t5 * t294 * t193 / 0.12e2;
  t959 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t286 * t193 - t953 / 0.4e1 + t957);
  tv3rho2sigma2 = t6 * t959 + 0.2e1 * t466;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t965 = t5 * t315 * t182;
  t973 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t311 * t182 - t965 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t144 * t452 - t918 / 0.8e1 + t925 - t927 / 0.8e1);
  tv3rho2sigma3 = t6 * t973 + t457 + t472;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t979 = t5 * t339 * t193;
  t986 = t5 * t131 * t490;
  t989 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t335 * t193 - t979 / 0.8e1 - t953 / 0.8e1 + t957 - 0.3e1 / 0.8e1 * t5 * t127 * t490 - t986 / 0.8e1);
  tv3rho2sigma5 = t6 * t989 + t466 + t495;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t997 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t366 * t182 - t965 / 0.4e1 + t925);
  tv3rho2sigma6 = t6 * t997 + 0.2e1 * t472;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1009 = t187 * t394 * t33;
  t1015 = t404 * t33 * t37;
  t1020 = -0.28e2 / 0.81e2 * t1009 * t80 - 0.8e1 / 0.9e1 * t1009 * t165 + 0.19e2 / 0.27e2 * t1015 * t487 + t486 * t902 / 0.9e1;
  t1025 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t383 * t193 - t979 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t155 * t490 + t957 - t986 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t66 * t1020);
  tv3rho2sigma8 = t6 * t1025 + 0.2e1 * t495;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1032 = t5 * t102 * t508 / 0.8e1;
  t1034 = t498 * t108 * t33;
  t1039 = t503 * t445;
  t1043 = t504 * t597;
  t1046 = -0.2e1 / 0.27e2 * t1034 * t49 - 0.2e1 / 0.27e2 * t1034 * t112 - t1039 * t33 * t264 / 0.9e1 - t1043 * t616 / 0.24e2;
  t1051 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t96 * t508 - t1032 - 0.3e1 / 0.8e1 * t5 * t27 * t1046);
  tv3rhosigma20 = t6 * t1051 + t512;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1058 = t5 * t131 * t524 / 0.8e1;
  t1060 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t127 * t524 - t1058);
  tv3rhosigma25 = t6 * t1060 + t528;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1066 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t144 * t508 - t1032);
  tv3rhosigma26 = t6 * t1066 + t512;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1072 = t514 * t161 * t33;
  t1077 = t519 * t484;
  t1081 = t520 * t597;
  t1084 = -0.2e1 / 0.27e2 * t1072 * t80 - 0.2e1 / 0.27e2 * t1072 * t165 - t1077 * t33 * t421 / 0.9e1 - t1081 * t902 / 0.24e2;
  t1089 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t155 * t524 - t1058 - 0.3e1 / 0.8e1 * t5 * t66 * t1084);
  tv3rhosigma211 = t6 * t1089 + t528;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1091 = sigma[0] * sigma[0];
  t1093 = 0.1e1 / t28 / t1091;
  t1095 = t1093 * t31 * t33;
  t1100 = 0.1e1 / t1091;
  t1101 = t1100 * t252;
  t1105 = params->beta * t176;
  t1110 = t604 * t252 / 0.2e1 + t177 / 0.2e1;
  t1112 = t31 * t1110 * t610;
  t1115 = 0.3e1 / 0.2e1 * t1105 * t258 + 0.3e1 * t250 * t1112;
  t1117 = t448 * t600 * t1115;
  t1120 = -t1095 * t49 / 0.12e2 + t1095 * t112 / 0.36e2 - t1101 * t33 * t264 / 0.24e2 - t1043 * t1117 / 0.24e2;
  t1124 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1120);
  tv3sigma30 = t6 * t1124;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1125 = sigma[2] * sigma[2];
  t1127 = 0.1e1 / t67 / t1125;
  t1129 = t1127 * t70 * t33;
  t1134 = 0.1e1 / t1125;
  t1135 = t1134 * t409;
  t1139 = params->beta * t187;
  t1144 = t890 * t409 / 0.2e1 + t188 / 0.2e1;
  t1146 = t70 * t1144 * t896;
  t1149 = 0.3e1 / 0.2e1 * t1139 * t415 + 0.3e1 * t407 * t1146;
  t1151 = t448 * t886 * t1149;
  t1154 = -t1129 * t80 / 0.12e2 + t1129 * t165 / 0.36e2 - t1135 * t33 * t421 / 0.24e2 - t1081 * t1151 / 0.24e2;
  t1158 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t1154);
  tv3sigma39 = t6 * t1158;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t36, t37, t38, t39, t40, t41, t43;
  double t44, t45, t47, t49, t52, t56, t57, t58;
  double t60, t61, t62, t63, t65, t66, t67, t68;
  double t70, t71, t74, t75, t76, t78, t80, t83;
  double t87, tzk0;

  double t88, t89, t90, t92, t95, t96, t100, t101;
  double t102, t105, t106, t108, t109, t110, t112, t115;
  double t120, t121, t123, t126, t127, t131, t134, t136;
  double tvrho0, t140, t143, t144, t149, t151, t154, t155;
  double t159, t161, t162, t163, t165, t168, t173, tvrho1;
  double t176, t177, t178, t182, t186, tvsigma0, tvsigma1, t187;
  double t188, t189, t193, t197, tvsigma2;

  double t200, t201, t202, t205, t206, t207, t210, t214;
  double t215, t219, t221, t227, t228, t231, t233, t235;
  double t237, t238, t239, t244, t245, t247, t248, t250;
  double t252, t254, t255, t256, t257, t258, t261, t262;
  double t264, t267, t272, t273, t274, t275, t278, t281;
  double t285, t286, t290, t292, t294, t297, t299, tv2rho20;
  double t302, t306, t310, t311, t315, t317, t325, t326;
  double t330, t334, t335, t339, t341, t348, t351, tv2rho21;
  double t356, t361, t365, t366, t372, t373, t378, t382;
  double t383, t392, t394, t395, t396, t401, t402, t404;
  double t405, t407, t409, t411, t412, t413, t414, t415;
  double t418, t419, t421, t424, t429, tv2rho22, t437, t438;
  double t439, t445, t447, t448, t449, t452, t457, tv2rhosigma0;
  double tv2rhosigma1, t464, t466, tv2rhosigma2, t472, tv2rhosigma3, tv2rhosigma4, t477;
  double t478, t484, t486, t487, t490, t495, tv2rhosigma5, t498;
  double t499, t503, t504, t508, t512, tv2sigma20, tv2sigma21, tv2sigma22;
  double tv2sigma23, tv2sigma24, t514, t515, t519, t520, t524, t528;
  double tv2sigma25;

  double t532, t533, t536, t539, t540, t541, t544, t548;
  double t549, t553, t555, t560, t562, t565, t571, t572;
  double t575, t577, t580, t583, t585, t590, t592, t593;
  double t597, t598, t599, t600, t601, t604, t605, t608;
  double t610, t611, t614, t616, t619, t624, t626, t627;
  double t630, t633, t636, t640, t641, t645, t647, t649;
  double t651, t653, t656, t658, tv3rho30, t661, t662, t663;
  double t666, t671, t672, t674, t678, t679, t683, t686;
  double t690, t692, t696, t705, t706, t707, t710, t715;
  double t717, t721, t722, t726, t729, t730, t732, t741;
  double t743, t746, tv3rho31, t749, t754, t758, t762, t763;
  double t767, t769, t778, t779, t784, t788, t792, t793;
  double t797, t799, t806, t814, t816, t817, tv3rho32, t822;
  double t829, t833, t834, t841, t842, t849, t853, t854;
  double t870, t872, t877, t879, t880, t884, t885, t886;
  double t887, t890, t891, t894, t896, t897, t900, t902;
  double t905, t910, tv3rho33, t918, t925, t927, t930, t936;
  double t941, t946, tv3rho2sigma0, tv3rho2sigma1, t953, t957, t959, tv3rho2sigma2;
  double t965, t973, tv3rho2sigma3, tv3rho2sigma4, t979, t986, t989, tv3rho2sigma5;
  double t997, tv3rho2sigma6, tv3rho2sigma7, t1009, t1015, t1020, t1025, tv3rho2sigma8;
  double t1032, t1034, t1039, t1043, t1046, t1051, tv3rhosigma20, tv3rhosigma21;
  double tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1058, t1060, tv3rhosigma25, t1066, tv3rhosigma26;
  double tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1072, t1077, t1081, t1084;
  double t1089, tv3rhosigma211, t1091, t1093, t1095, t1100, t1101, t1105;
  double t1110, t1112, t1115, t1117, t1120, t1124, tv3sigma30, tv3sigma31;
  double tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t1125;
  double t1127, t1129, t1134, t1135, t1139, t1144, t1146, t1149;
  double t1151, t1154, t1158, tv3sigma39;

  double t1162, t1166, t1169, t1173, t1177, t1179, t1181, t1182;
  double t1188, t1194, t1195, t1198, t1202, t1211, t1217, t1219;
  double t1225, t1228, t1231, t1234, t1236, t1241, t1252, t1253;
  double t1255, t1267, t1281, t1283, t1284, t1290, t1297, t1298;
  double t1299, t1301, t1302, t1308, t1313, t1316, t1320, t1327;
  double t1331, t1335, t1340, t1342, tv4rho40, t1363, t1364, t1366;
  double t1370, t1379, t1385, t1386, t1388, t1395, t1399, t1400;
  double t1403, t1414, t1415, t1432, t1434, t1438, t1445, t1449;
  double t1450, t1453, t1462, t1465, t1466, t1468, t1470, t1471;
  double tv4rho41, t1480, t1484, t1494, t1507, t1511, t1520, t1536;
  double t1537, t1546, t1559, t1563, t1570, t1574, t1583, t1586;
  double t1597, t1600, t1602, t1603, tv4rho42, t1624, t1628, t1635;
  double t1646, t1647, t1664, t1668, t1675, t1683, t1692, t1702;
  double t1704, t1705, tv4rho43, t1710, t1715, t1722, t1726, t1735;
  double t1754, t1756, t1761, t1772, t1773, t1775, t1787, t1801;
  double t1803, t1804, t1810, t1817, t1822, t1829, t1833, t1838;
  double t1839, tv4rho44, t1847, t1853, t1856, t1863, t1865, t1868;
  double t1871, t1891, tv4rho3sigma0, tv4rho3sigma1, t1898, t1901, t1905, t1907;
  double tv4rho3sigma2, t1909, t1915, t1920, t1924, t1933, t1934, tv4rho3sigma3;
  double tv4rho3sigma4, t1936, t1942, t1944, t1953, t1955, t1958, tv4rho3sigma5;
  double t1964, t1973, tv4rho3sigma6, tv4rho3sigma7, t1979, t1986, t1994, t1996;
  double t1997, tv4rho3sigma8, t2006, tv4rho3sigma9, tv4rho3sigma10, t2024, t2044, tv4rho3sigma11;
  double t2051, t2058, t2060, t2063, t2072, t2084, tv4rho2sigma20, tv4rho2sigma21;
  double tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t2091, t2095, t2097, tv4rho2sigma25, t2103;
  double t2111, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t2117, t2124;
  double t2127, tv4rho2sigma211, t2135, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216;
  double t2147, t2156, t2168, tv4rho2sigma217, t2175, t2177, t2186, t2232;
  double tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37;
  double tv4rhosigma38, t2239, t2241, tv4rhosigma39, t2247, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312;
  double tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t2253, t2262;
  double t2308, tv4rhosigma319, t2310, t2314, t2326, t2343, t2357, tv4sigma40;
  double tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48;
  double tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t2358, t2362, t2374;
  double t2391, t2405, tv4sigma414;

  gga_x_fd_lb94_params *params;

  assert(p->params != NULL);
  params = (gga_x_fd_lb94_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = sqrt(sigma[0]);
  t29 = POW_1_3(rho[0]);
  t31 = 0.1e1 / t29 / rho[0];
  t32 = t28 * t31;
  t33 = t2 * t2;
  t36 = POW_1_3(0.1e1 / M_PI);
  t37 = 0.1e1 / t36;
  t38 = M_CBRT4;
  t39 = t37 * t38;
  t40 = M_CBRT2;
  t41 = t40 * t40;
  t43 = t32 * t41 / 0.2e1;
  t44 = xc_integrate(func0, &(params->beta), 0.0, t43);
  t45 = log(t43);
  t47 = xc_integrate(func1, &(params->beta), 0.0, t43);
  t49 = t39 * (t44 * t45 - t47);
  t52 = 0.1e1 - 0.2e1 / 0.9e1 * t32 * t33 * t49;
  t56 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t52);
  t57 = rho[1] <= p->dens_threshold;
  t58 = -t16;
  t60 = my_piecewise5(t14, t11, t10, t15, t58 * t7);
  t61 = 0.1e1 + t60;
  t62 = t61 <= p->zeta_threshold;
  t63 = POW_1_3(t61);
  t65 = my_piecewise3(t62, t22, t63 * t61);
  t66 = t65 * t26;
  t67 = sqrt(sigma[2]);
  t68 = POW_1_3(rho[1]);
  t70 = 0.1e1 / t68 / rho[1];
  t71 = t67 * t70;
  t74 = t71 * t41 / 0.2e1;
  t75 = xc_integrate(func0, &(params->beta), 0.0, t74);
  t76 = log(t74);
  t78 = xc_integrate(func1, &(params->beta), 0.0, t74);
  t80 = t39 * (t75 * t76 - t78);
  t83 = 0.1e1 - 0.2e1 / 0.9e1 * t71 * t33 * t80;
  t87 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t83);
  tzk0 = t56 + t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t88 = t6 * t6;
  t89 = 0.1e1 / t88;
  t90 = t16 * t89;
  t92 = my_piecewise5(t10, 0, t14, 0, t7 - t90);
  t95 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t92);
  t96 = t95 * t26;
  t100 = t26 * t26;
  t101 = 0.1e1 / t100;
  t102 = t25 * t101;
  t105 = t5 * t102 * t52 / 0.8e1;
  t106 = rho[0] * rho[0];
  t108 = 0.1e1 / t29 / t106;
  t109 = t28 * t108;
  t110 = t109 * t33;
  t112 = t39 * t44;
  t115 = 0.8e1 / 0.27e2 * t110 * t112 + 0.8e1 / 0.27e2 * t110 * t49;
  t120 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t96 * t52 - t105 - 0.3e1 / 0.8e1 * t5 * t27 * t115);
  t121 = t58 * t89;
  t123 = my_piecewise5(t14, 0, t10, 0, -t7 - t121);
  t126 = my_piecewise3(t62, 0, 0.4e1 / 0.3e1 * t63 * t123);
  t127 = t126 * t26;
  t131 = t65 * t101;
  t134 = t5 * t131 * t83 / 0.8e1;
  t136 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t127 * t83 - t134);
  tvrho0 = t56 + t87 + t6 * (t120 + t136);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t140 = my_piecewise5(t10, 0, t14, 0, -t7 - t90);
  t143 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t140);
  t144 = t143 * t26;
  t149 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t144 * t52 - t105);
  t151 = my_piecewise5(t14, 0, t10, 0, t7 - t121);
  t154 = my_piecewise3(t62, 0, 0.4e1 / 0.3e1 * t63 * t151);
  t155 = t154 * t26;
  t159 = rho[1] * rho[1];
  t161 = 0.1e1 / t68 / t159;
  t162 = t67 * t161;
  t163 = t162 * t33;
  t165 = t39 * t75;
  t168 = 0.8e1 / 0.27e2 * t163 * t165 + 0.8e1 / 0.27e2 * t163 * t80;
  t173 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t155 * t83 - t134 - 0.3e1 / 0.8e1 * t5 * t66 * t168);
  tvrho1 = t56 + t87 + t6 * (t149 + t173);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t176 = 0.1e1 / t28;
  t177 = t176 * t31;
  t178 = t177 * t33;
  t182 = -t178 * t112 / 0.9e1 - t178 * t49 / 0.9e1;
  t186 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t182);
  tvsigma0 = t6 * t186;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t187 = 0.1e1 / t67;
  t188 = t187 * t70;
  t189 = t188 * t33;
  t193 = -t189 * t165 / 0.9e1 - t189 * t80 / 0.9e1;
  t197 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t193);
  tvsigma2 = t6 * t197;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t200 = t23 * t23;
  t201 = 0.1e1 / t200;
  t202 = t92 * t92;
  t205 = t88 * t6;
  t206 = 0.1e1 / t205;
  t207 = t16 * t206;
  t210 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t89 + 0.2e1 * t207);
  t214 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t201 * t202 + 0.4e1 / 0.3e1 * t23 * t210);
  t215 = t214 * t26;
  t219 = t95 * t101;
  t221 = t5 * t219 * t52;
  t227 = 0.1e1 / t100 / t6;
  t228 = t25 * t227;
  t231 = t5 * t228 * t52 / 0.12e2;
  t233 = t5 * t102 * t115;
  t235 = t106 * rho[0];
  t237 = 0.1e1 / t29 / t235;
  t238 = t28 * t237;
  t239 = t238 * t33;
  t244 = t106 * t106;
  t245 = t29 * t29;
  t247 = 0.1e1 / t245 / t244;
  t248 = sigma[0] * t247;
  t250 = params->beta * t28;
  t252 = 0.1e1 / t245 / t106;
  t254 = sigma[0] * t252 + 0.1e1;
  t255 = sqrt(t254);
  t256 = t32 + t255;
  t257 = log(t256);
  t258 = t31 * t257;
  t261 = 0.3e1 * t250 * t258 + 0.1e1;
  t262 = 0.1e1 / t261;
  t264 = t39 * params->beta * t262;
  t267 = -0.56e2 / 0.81e2 * t239 * t49 - 0.88e2 / 0.81e2 * t239 * t112 + 0.8e1 / 0.27e2 * t248 * t33 * t264;
  t272 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t215 * t52 - t221 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t96 * t115 + t231 - t233 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t267);
  t273 = t63 * t63;
  t274 = 0.1e1 / t273;
  t275 = t123 * t123;
  t278 = t58 * t206;
  t281 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t89 + 0.2e1 * t278);
  t285 = my_piecewise3(t62, 0, 0.4e1 / 0.9e1 * t274 * t275 + 0.4e1 / 0.3e1 * t63 * t281);
  t286 = t285 * t26;
  t290 = t126 * t101;
  t292 = t5 * t290 * t83;
  t294 = t65 * t227;
  t297 = t5 * t294 * t83 / 0.12e2;
  t299 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t286 * t83 - t292 / 0.4e1 + t297);
  tv2rho20 = 0.2e1 * t120 + 0.2e1 * t136 + t6 * (t272 + t299);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t302 = t201 * t140;
  t306 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t207);
  t310 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t302 * t92 + 0.4e1 / 0.3e1 * t23 * t306);
  t311 = t310 * t26;
  t315 = t143 * t101;
  t317 = t5 * t315 * t52;
  t325 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t311 * t52 - t317 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t144 * t115 - t221 / 0.8e1 + t231 - t233 / 0.8e1);
  t326 = t274 * t151;
  t330 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t278);
  t334 = my_piecewise3(t62, 0, 0.4e1 / 0.9e1 * t326 * t123 + 0.4e1 / 0.3e1 * t63 * t330);
  t335 = t334 * t26;
  t339 = t154 * t101;
  t341 = t5 * t339 * t83;
  t348 = t5 * t131 * t168;
  t351 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t335 * t83 - t341 / 0.8e1 - t292 / 0.8e1 + t297 - 0.3e1 / 0.8e1 * t5 * t127 * t168 - t348 / 0.8e1);
  tv2rho21 = t120 + t136 + t149 + t173 + t6 * (t325 + t351);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t356 = t140 * t140;
  t361 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t89 + 0.2e1 * t207);
  t365 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t201 * t356 + 0.4e1 / 0.3e1 * t23 * t361);
  t366 = t365 * t26;
  t372 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t366 * t52 - t317 / 0.4e1 + t231);
  t373 = t151 * t151;
  t378 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t89 + 0.2e1 * t278);
  t382 = my_piecewise3(t62, 0, 0.4e1 / 0.9e1 * t274 * t373 + 0.4e1 / 0.3e1 * t63 * t378);
  t383 = t382 * t26;
  t392 = t159 * rho[1];
  t394 = 0.1e1 / t68 / t392;
  t395 = t67 * t394;
  t396 = t395 * t33;
  t401 = t159 * t159;
  t402 = t68 * t68;
  t404 = 0.1e1 / t402 / t401;
  t405 = sigma[2] * t404;
  t407 = params->beta * t67;
  t409 = 0.1e1 / t402 / t159;
  t411 = sigma[2] * t409 + 0.1e1;
  t412 = sqrt(t411);
  t413 = t71 + t412;
  t414 = log(t413);
  t415 = t70 * t414;
  t418 = 0.3e1 * t407 * t415 + 0.1e1;
  t419 = 0.1e1 / t418;
  t421 = t39 * params->beta * t419;
  t424 = -0.56e2 / 0.81e2 * t396 * t80 - 0.88e2 / 0.81e2 * t396 * t165 + 0.8e1 / 0.27e2 * t405 * t33 * t421;
  t429 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t383 * t83 - t341 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t155 * t168 + t297 - t348 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t66 * t424);
  tv2rho22 = 0.2e1 * t149 + 0.2e1 * t173 + t6 * (t372 + t429);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t437 = t5 * t102 * t182 / 0.8e1;
  t438 = t176 * t108;
  t439 = t438 * t33;
  t445 = 0.1e1 / t245 / t235;
  t447 = t445 * t33 * t37;
  t448 = t38 * params->beta;
  t449 = t448 * t262;
  t452 = 0.4e1 / 0.27e2 * t439 * t49 + 0.8e1 / 0.27e2 * t439 * t112 - t447 * t449 / 0.9e1;
  t457 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t96 * t182 - t437 - 0.3e1 / 0.8e1 * t5 * t27 * t452);
  tv2rhosigma0 = t6 * t457 + t186;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t464 = t5 * t131 * t193 / 0.8e1;
  t466 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t127 * t193 - t464);
  tv2rhosigma2 = t6 * t466 + t197;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t472 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t144 * t182 - t437);
  tv2rhosigma3 = t6 * t472 + t186;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t477 = t187 * t161;
  t478 = t477 * t33;
  t484 = 0.1e1 / t402 / t392;
  t486 = t484 * t33 * t37;
  t487 = t448 * t419;
  t490 = 0.4e1 / 0.27e2 * t478 * t80 + 0.8e1 / 0.27e2 * t478 * t165 - t486 * t487 / 0.9e1;
  t495 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t155 * t193 - t464 - 0.3e1 / 0.8e1 * t5 * t66 * t490);
  tv2rhosigma5 = t6 * t495 + t197;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t498 = 0.1e1 / t28 / sigma[0];
  t499 = t498 * t31;
  t503 = 0.1e1 / sigma[0];
  t504 = t503 * t252;
  t508 = t499 * t33 * t49 / 0.18e2 + t504 * t33 * t264 / 0.24e2;
  t512 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t508);
  tv2sigma20 = t6 * t512;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t514 = 0.1e1 / t67 / sigma[2];
  t515 = t514 * t70;
  t519 = 0.1e1 / sigma[2];
  t520 = t519 * t409;
  t524 = t515 * t33 * t80 / 0.18e2 + t520 * t33 * t421 / 0.24e2;
  t528 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t524);
  tv2sigma25 = t6 * t528;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t532 = 0.1e1 / t200 / t19;
  t533 = t202 * t92;
  t536 = t201 * t92;
  t539 = t88 * t88;
  t540 = 0.1e1 / t539;
  t541 = t16 * t540;
  t544 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t206 - 0.6e1 * t541);
  t548 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t532 * t533 + 0.4e1 / 0.3e1 * t536 * t210 + 0.4e1 / 0.3e1 * t23 * t544);
  t549 = t548 * t26;
  t553 = t214 * t101;
  t555 = t5 * t553 * t52;
  t560 = t95 * t227;
  t562 = t5 * t560 * t52;
  t565 = t5 * t219 * t115;
  t571 = 0.1e1 / t100 / t88;
  t572 = t25 * t571;
  t575 = 0.5e1 / 0.36e2 * t5 * t572 * t52;
  t577 = t5 * t228 * t115;
  t580 = t5 * t102 * t267;
  t583 = 0.1e1 / t29 / t244;
  t585 = t28 * t583 * t33;
  t590 = t244 * rho[0];
  t592 = 0.1e1 / t245 / t590;
  t593 = sigma[0] * t592;
  t597 = t33 * t37;
  t598 = t248 * t597;
  t599 = t261 * t261;
  t600 = 0.1e1 / t599;
  t601 = t108 * t257;
  t604 = 0.1e1 / t255;
  t605 = t604 * sigma[0];
  t608 = -0.4e1 / 0.3e1 * t605 * t445 - 0.4e1 / 0.3e1 * t109;
  t610 = 0.1e1 / t256;
  t611 = t31 * t608 * t610;
  t614 = -0.4e1 * t250 * t601 + 0.3e1 * t250 * t611;
  t616 = t448 * t600 * t614;
  t619 = 0.56e3 / 0.243e3 * t585 * t49 + 0.368e3 / 0.81e2 * t585 * t112 - 0.2e3 / 0.81e2 * t593 * t33 * t264 - 0.8e1 / 0.27e2 * t598 * t616;
  t624 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t549 * t52 - 0.3e1 / 0.8e1 * t555 - 0.9e1 / 0.8e1 * t5 * t215 * t115 + t562 / 0.4e1 - 0.3e1 / 0.4e1 * t565 - 0.9e1 / 0.8e1 * t5 * t96 * t267 - t575 + t577 / 0.4e1 - 0.3e1 / 0.8e1 * t580 - 0.3e1 / 0.8e1 * t5 * t27 * t619);
  t626 = 0.1e1 / t273 / t61;
  t627 = t275 * t123;
  t630 = t274 * t123;
  t633 = t58 * t540;
  t636 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t206 - 0.6e1 * t633);
  t640 = my_piecewise3(t62, 0, -0.8e1 / 0.27e2 * t626 * t627 + 0.4e1 / 0.3e1 * t630 * t281 + 0.4e1 / 0.3e1 * t63 * t636);
  t641 = t640 * t26;
  t645 = t285 * t101;
  t647 = t5 * t645 * t83;
  t649 = t126 * t227;
  t651 = t5 * t649 * t83;
  t653 = t65 * t571;
  t656 = 0.5e1 / 0.36e2 * t5 * t653 * t83;
  t658 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t641 * t83 - 0.3e1 / 0.8e1 * t647 + t651 / 0.4e1 - t656);
  tv3rho30 = 0.3e1 * t272 + 0.3e1 * t299 + t6 * (t624 + t658);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t661 = 0.2e1 * t325;
  t662 = 0.2e1 * t351;
  t663 = t532 * t140;
  t666 = t201 * t306;
  t671 = 0.2e1 * t206;
  t672 = 0.6e1 * t541;
  t674 = my_piecewise5(t10, 0, t14, 0, t671 - t672);
  t678 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t663 * t202 + 0.8e1 / 0.9e1 * t666 * t92 + 0.4e1 / 0.9e1 * t302 * t210 + 0.4e1 / 0.3e1 * t23 * t674);
  t679 = t678 * t26;
  t683 = t310 * t101;
  t686 = t5 * t683 * t52 / 0.4e1;
  t690 = t143 * t227;
  t692 = t5 * t690 * t52;
  t696 = t5 * t315 * t115 / 0.4e1;
  t705 = -0.3e1 / 0.8e1 * t5 * t679 * t52 - t686 - 0.3e1 / 0.4e1 * t5 * t311 * t115 + t692 / 0.12e2 - t696 - 0.3e1 / 0.8e1 * t5 * t144 * t267 - t555 / 0.8e1 + t562 / 0.6e1 - t565 / 0.4e1 - t575 + t577 / 0.6e1 - t580 / 0.8e1;
  t706 = my_piecewise3(t1, 0, t705);
  t707 = t626 * t151;
  t710 = t274 * t330;
  t715 = 0.6e1 * t633;
  t717 = my_piecewise5(t14, 0, t10, 0, -t671 - t715);
  t721 = my_piecewise3(t62, 0, -0.8e1 / 0.27e2 * t707 * t275 + 0.8e1 / 0.9e1 * t710 * t123 + 0.4e1 / 0.9e1 * t326 * t281 + 0.4e1 / 0.3e1 * t63 * t717);
  t722 = t721 * t26;
  t726 = t334 * t101;
  t729 = t5 * t726 * t83 / 0.4e1;
  t730 = t154 * t227;
  t732 = t5 * t730 * t83;
  t741 = t5 * t290 * t168 / 0.4e1;
  t743 = t5 * t294 * t168;
  t746 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t722 * t83 - t729 + t732 / 0.12e2 - t647 / 0.8e1 + t651 / 0.6e1 - t656 - 0.3e1 / 0.8e1 * t5 * t286 * t168 - t741 + t743 / 0.12e2);
  tv3rho31 = t272 + t299 + t661 + t662 + t6 * (t706 + t746);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t749 = t532 * t356;
  t754 = t201 * t361;
  t758 = my_piecewise5(t10, 0, t14, 0, -t671 - t672);
  t762 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t749 * t92 + 0.8e1 / 0.9e1 * t302 * t306 + 0.4e1 / 0.9e1 * t754 * t92 + 0.4e1 / 0.3e1 * t23 * t758);
  t763 = t762 * t26;
  t767 = t365 * t101;
  t769 = t5 * t767 * t52;
  t778 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t763 * t52 - t769 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t366 * t115 - t686 + t692 / 0.6e1 - t696 + t562 / 0.12e2 - t575 + t577 / 0.12e2);
  t779 = t626 * t373;
  t784 = t274 * t378;
  t788 = my_piecewise5(t14, 0, t10, 0, t671 - t715);
  t792 = my_piecewise3(t62, 0, -0.8e1 / 0.27e2 * t779 * t123 + 0.8e1 / 0.9e1 * t326 * t330 + 0.4e1 / 0.9e1 * t784 * t123 + 0.4e1 / 0.3e1 * t63 * t788);
  t793 = t792 * t26;
  t797 = t382 * t101;
  t799 = t5 * t797 * t83;
  t806 = t5 * t339 * t168;
  t814 = t5 * t131 * t424;
  t816 = -0.3e1 / 0.8e1 * t5 * t793 * t83 - t799 / 0.8e1 - t729 + t732 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t335 * t168 - t806 / 0.4e1 + t651 / 0.12e2 - t656 - t741 + t743 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t127 * t424 - t814 / 0.8e1;
  t817 = my_piecewise3(t57, 0, t816);
  tv3rho32 = t661 + t662 + t372 + t429 + t6 * (t778 + t817);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t822 = t356 * t140;
  t829 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t206 - 0.6e1 * t541);
  t833 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t532 * t822 + 0.4e1 / 0.3e1 * t302 * t361 + 0.4e1 / 0.3e1 * t23 * t829);
  t834 = t833 * t26;
  t841 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t834 * t52 - 0.3e1 / 0.8e1 * t769 + t692 / 0.4e1 - t575);
  t842 = t373 * t151;
  t849 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t206 - 0.6e1 * t633);
  t853 = my_piecewise3(t62, 0, -0.8e1 / 0.27e2 * t626 * t842 + 0.4e1 / 0.3e1 * t326 * t378 + 0.4e1 / 0.3e1 * t63 * t849);
  t854 = t853 * t26;
  t870 = 0.1e1 / t68 / t401;
  t872 = t67 * t870 * t33;
  t877 = t401 * rho[1];
  t879 = 0.1e1 / t402 / t877;
  t880 = sigma[2] * t879;
  t884 = t405 * t597;
  t885 = t418 * t418;
  t886 = 0.1e1 / t885;
  t887 = t161 * t414;
  t890 = 0.1e1 / t412;
  t891 = t890 * sigma[2];
  t894 = -0.4e1 / 0.3e1 * t891 * t484 - 0.4e1 / 0.3e1 * t162;
  t896 = 0.1e1 / t413;
  t897 = t70 * t894 * t896;
  t900 = -0.4e1 * t407 * t887 + 0.3e1 * t407 * t897;
  t902 = t448 * t886 * t900;
  t905 = 0.56e3 / 0.243e3 * t872 * t80 + 0.368e3 / 0.81e2 * t872 * t165 - 0.2e3 / 0.81e2 * t880 * t33 * t421 - 0.8e1 / 0.27e2 * t884 * t902;
  t910 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t854 * t83 - 0.3e1 / 0.8e1 * t799 - 0.9e1 / 0.8e1 * t5 * t383 * t168 + t732 / 0.4e1 - 0.3e1 / 0.4e1 * t806 - 0.9e1 / 0.8e1 * t5 * t155 * t424 - t656 + t743 / 0.4e1 - 0.3e1 / 0.8e1 * t814 - 0.3e1 / 0.8e1 * t5 * t66 * t905);
  tv3rho33 = 0.3e1 * t372 + 0.3e1 * t429 + t6 * (t841 + t910);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t918 = t5 * t219 * t182;
  t925 = t5 * t228 * t182 / 0.12e2;
  t927 = t5 * t102 * t452;
  t930 = t176 * t237 * t33;
  t936 = t247 * t33 * t37;
  t941 = -0.28e2 / 0.81e2 * t930 * t49 - 0.8e1 / 0.9e1 * t930 * t112 + 0.19e2 / 0.27e2 * t936 * t449 + t447 * t616 / 0.9e1;
  t946 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t215 * t182 - t918 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t96 * t452 + t925 - t927 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t941);
  tv3rho2sigma0 = t6 * t946 + 0.2e1 * t457;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t953 = t5 * t290 * t193;
  t957 = t5 * t294 * t193 / 0.12e2;
  t959 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t286 * t193 - t953 / 0.4e1 + t957);
  tv3rho2sigma2 = t6 * t959 + 0.2e1 * t466;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t965 = t5 * t315 * t182;
  t973 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t311 * t182 - t965 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t144 * t452 - t918 / 0.8e1 + t925 - t927 / 0.8e1);
  tv3rho2sigma3 = t6 * t973 + t457 + t472;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t979 = t5 * t339 * t193;
  t986 = t5 * t131 * t490;
  t989 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t335 * t193 - t979 / 0.8e1 - t953 / 0.8e1 + t957 - 0.3e1 / 0.8e1 * t5 * t127 * t490 - t986 / 0.8e1);
  tv3rho2sigma5 = t6 * t989 + t466 + t495;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t997 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t366 * t182 - t965 / 0.4e1 + t925);
  tv3rho2sigma6 = t6 * t997 + 0.2e1 * t472;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1009 = t187 * t394 * t33;
  t1015 = t404 * t33 * t37;
  t1020 = -0.28e2 / 0.81e2 * t1009 * t80 - 0.8e1 / 0.9e1 * t1009 * t165 + 0.19e2 / 0.27e2 * t1015 * t487 + t486 * t902 / 0.9e1;
  t1025 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t383 * t193 - t979 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t155 * t490 + t957 - t986 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t66 * t1020);
  tv3rho2sigma8 = t6 * t1025 + 0.2e1 * t495;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1032 = t5 * t102 * t508 / 0.8e1;
  t1034 = t498 * t108 * t33;
  t1039 = t503 * t445;
  t1043 = t504 * t597;
  t1046 = -0.2e1 / 0.27e2 * t1034 * t49 - 0.2e1 / 0.27e2 * t1034 * t112 - t1039 * t33 * t264 / 0.9e1 - t1043 * t616 / 0.24e2;
  t1051 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t96 * t508 - t1032 - 0.3e1 / 0.8e1 * t5 * t27 * t1046);
  tv3rhosigma20 = t6 * t1051 + t512;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1058 = t5 * t131 * t524 / 0.8e1;
  t1060 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t127 * t524 - t1058);
  tv3rhosigma25 = t6 * t1060 + t528;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1066 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t144 * t508 - t1032);
  tv3rhosigma26 = t6 * t1066 + t512;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1072 = t514 * t161 * t33;
  t1077 = t519 * t484;
  t1081 = t520 * t597;
  t1084 = -0.2e1 / 0.27e2 * t1072 * t80 - 0.2e1 / 0.27e2 * t1072 * t165 - t1077 * t33 * t421 / 0.9e1 - t1081 * t902 / 0.24e2;
  t1089 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t155 * t524 - t1058 - 0.3e1 / 0.8e1 * t5 * t66 * t1084);
  tv3rhosigma211 = t6 * t1089 + t528;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1091 = sigma[0] * sigma[0];
  t1093 = 0.1e1 / t28 / t1091;
  t1095 = t1093 * t31 * t33;
  t1100 = 0.1e1 / t1091;
  t1101 = t1100 * t252;
  t1105 = params->beta * t176;
  t1110 = t604 * t252 / 0.2e1 + t177 / 0.2e1;
  t1112 = t31 * t1110 * t610;
  t1115 = 0.3e1 / 0.2e1 * t1105 * t258 + 0.3e1 * t250 * t1112;
  t1117 = t448 * t600 * t1115;
  t1120 = -t1095 * t49 / 0.12e2 + t1095 * t112 / 0.36e2 - t1101 * t33 * t264 / 0.24e2 - t1043 * t1117 / 0.24e2;
  t1124 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1120);
  tv3sigma30 = t6 * t1124;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1125 = sigma[2] * sigma[2];
  t1127 = 0.1e1 / t67 / t1125;
  t1129 = t1127 * t70 * t33;
  t1134 = 0.1e1 / t1125;
  t1135 = t1134 * t409;
  t1139 = params->beta * t187;
  t1144 = t890 * t409 / 0.2e1 + t188 / 0.2e1;
  t1146 = t70 * t1144 * t896;
  t1149 = 0.3e1 / 0.2e1 * t1139 * t415 + 0.3e1 * t407 * t1146;
  t1151 = t448 * t886 * t1149;
  t1154 = -t1129 * t80 / 0.12e2 + t1129 * t165 / 0.36e2 - t1135 * t33 * t421 / 0.24e2 - t1081 * t1151 / 0.24e2;
  t1158 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * t1154);
  tv3sigma39 = t6 * t1158;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1162 = 0.1e1 / t100 / t205;
  t1166 = 0.1e2 / 0.27e2 * t5 * t25 * t1162 * t52;
  t1169 = t5 * t548 * t101 * t52;
  t1173 = t5 * t214 * t227 * t52;
  t1177 = t5 * t95 * t571 * t52;
  t1179 = t19 * t19;
  t1181 = 0.1e1 / t200 / t1179;
  t1182 = t202 * t202;
  t1188 = t210 * t210;
  t1194 = 0.1e1 / t539 / t6;
  t1195 = t16 * t1194;
  t1198 = my_piecewise5(t10, 0, t14, 0, -0.24e2 * t540 + 0.24e2 * t1195);
  t1202 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1181 * t1182 - 0.16e2 / 0.9e1 * t532 * t202 * t210 + 0.4e1 / 0.3e1 * t201 * t1188 + 0.16e2 / 0.9e1 * t536 * t544 + 0.4e1 / 0.3e1 * t23 * t1198);
  t1211 = t5 * t553 * t115;
  t1217 = t5 * t560 * t115;
  t1219 = t5 * t219 * t267;
  t1225 = t5 * t572 * t115;
  t1228 = t5 * t228 * t267;
  t1231 = t5 * t102 * t619;
  t1234 = 0.1e1 / t29 / t590;
  t1236 = t28 * t1234 * t33;
  t1241 = t244 * t106;
  t1252 = 0.1e1 / t599 / t261;
  t1253 = t614 * t614;
  t1255 = t448 * t1252 * t1253;
  t1267 = 0.1e1 / t255 / t254;
  t1281 = t608 * t608;
  t1283 = t256 * t256;
  t1284 = 0.1e1 / t1283;
  t1290 = t448 * t600 * (0.28e2 / 0.3e1 * t250 * t237 * t257 - 0.8e1 * t250 * t108 * t608 * t610 + 0.3e1 * t250 * t31 * (0.28e2 / 0.9e1 * t238 - 0.16e2 / 0.9e1 * t1267 * t1091 / t29 / t244 / t235 + 0.44e2 / 0.9e1 * t605 * t247) * t610 - 0.3e1 * t250 * t31 * t1281 * t1284);
  t1297 = t1166 - t1169 / 0.2e1 + t1173 / 0.2e1 - 0.5e1 / 0.9e1 * t1177 - 0.3e1 / 0.8e1 * t5 * t1202 * t26 * t52 - 0.3e1 / 0.2e1 * t5 * t549 * t115 - 0.3e1 / 0.2e1 * t1211 - 0.9e1 / 0.4e1 * t5 * t215 * t267 + t1217 - 0.3e1 / 0.2e1 * t1219 - 0.3e1 / 0.2e1 * t5 * t96 * t619 - 0.5e1 / 0.9e1 * t1225 + t1228 / 0.2e1 - t1231 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t27 * (-0.728e4 / 0.729e3 * t1236 * t49 - 0.16592e5 / 0.729e3 * t1236 * t112 + 0.4504e4 / 0.243e3 * sigma[0] / t245 / t1241 * t33 * t264 + 0.104e3 / 0.27e2 * t593 * t597 * t616 + 0.16e2 / 0.27e2 * t598 * t1255 - 0.8e1 / 0.27e2 * t598 * t1290);
  t1298 = my_piecewise3(t1, 0, t1297);
  t1299 = t61 * t61;
  t1301 = 0.1e1 / t273 / t1299;
  t1302 = t275 * t275;
  t1308 = t281 * t281;
  t1313 = t58 * t1194;
  t1316 = my_piecewise5(t14, 0, t10, 0, 0.24e2 * t540 + 0.24e2 * t1313);
  t1320 = my_piecewise3(t62, 0, 0.4e2 / 0.81e2 * t1301 * t1302 - 0.16e2 / 0.9e1 * t626 * t275 * t281 + 0.4e1 / 0.3e1 * t274 * t1308 + 0.16e2 / 0.9e1 * t630 * t636 + 0.4e1 / 0.3e1 * t63 * t1316);
  t1327 = t5 * t640 * t101 * t83;
  t1331 = t5 * t285 * t227 * t83;
  t1335 = t5 * t126 * t571 * t83;
  t1340 = 0.1e2 / 0.27e2 * t5 * t65 * t1162 * t83;
  t1342 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t1320 * t26 * t83 - t1327 / 0.2e1 + t1331 / 0.2e1 - 0.5e1 / 0.9e1 * t1335 + t1340);
  tv4rho40 = 0.4e1 * t624 + 0.4e1 * t658 + t6 * (t1298 + t1342);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1363 = 0.12e2 * t540;
  t1364 = 0.24e2 * t1195;
  t1366 = my_piecewise5(t10, 0, t14, 0, -t1363 + t1364);
  t1370 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1181 * t140 * t533 - 0.8e1 / 0.9e1 * t532 * t306 * t202 - 0.8e1 / 0.9e1 * t663 * t92 * t210 + 0.4e1 / 0.3e1 * t201 * t674 * t92 + 0.4e1 / 0.3e1 * t666 * t210 + 0.4e1 / 0.9e1 * t302 * t544 + 0.4e1 / 0.3e1 * t23 * t1366);
  t1379 = t5 * t683 * t115;
  t1385 = t5 * t690 * t115;
  t1386 = t1385 / 0.4e1;
  t1388 = t5 * t315 * t267;
  t1395 = t5 * t678 * t101 * t52;
  t1399 = t5 * t310 * t227 * t52;
  t1400 = t1399 / 0.4e1;
  t1403 = t5 * t143 * t571 * t52;
  t1414 = -0.3e1 / 0.8e1 * t5 * t1370 * t26 * t52 - 0.9e1 / 0.8e1 * t5 * t679 * t115 - 0.3e1 / 0.4e1 * t1379 - 0.9e1 / 0.8e1 * t5 * t311 * t267 + t1386 - 0.3e1 / 0.8e1 * t1388 - 0.3e1 / 0.8e1 * t5 * t144 * t619 - 0.3e1 / 0.8e1 * t1395 + t1400 - 0.5e1 / 0.36e2 * t1403 + t1166 - t1169 / 0.8e1 + t1173 / 0.4e1 - 0.5e1 / 0.12e2 * t1177 - 0.3e1 / 0.8e1 * t1211 + t1217 / 0.2e1 - 0.3e1 / 0.8e1 * t1219 - 0.5e1 / 0.12e2 * t1225 + t1228 / 0.4e1 - t1231 / 0.8e1;
  t1415 = my_piecewise3(t1, 0, t1414);
  t1432 = 0.24e2 * t1313;
  t1434 = my_piecewise5(t14, 0, t10, 0, t1363 + t1432);
  t1438 = my_piecewise3(t62, 0, 0.4e2 / 0.81e2 * t1301 * t151 * t627 - 0.8e1 / 0.9e1 * t626 * t330 * t275 - 0.8e1 / 0.9e1 * t707 * t123 * t281 + 0.4e1 / 0.3e1 * t274 * t717 * t123 + 0.4e1 / 0.3e1 * t710 * t281 + 0.4e1 / 0.9e1 * t326 * t636 + 0.4e1 / 0.3e1 * t63 * t1434);
  t1445 = t5 * t721 * t101 * t83;
  t1449 = t5 * t334 * t227 * t83;
  t1450 = t1449 / 0.4e1;
  t1453 = t5 * t154 * t571 * t83;
  t1462 = t5 * t645 * t168;
  t1465 = t5 * t649 * t168;
  t1466 = t1465 / 0.4e1;
  t1468 = t5 * t653 * t168;
  t1470 = -0.3e1 / 0.8e1 * t5 * t1438 * t26 * t83 - 0.3e1 / 0.8e1 * t1445 + t1450 - 0.5e1 / 0.36e2 * t1453 - t1327 / 0.8e1 + t1331 / 0.4e1 - 0.5e1 / 0.12e2 * t1335 + t1340 - 0.3e1 / 0.8e1 * t5 * t641 * t168 - 0.3e1 / 0.8e1 * t1462 + t1466 - 0.5e1 / 0.36e2 * t1468;
  t1471 = my_piecewise3(t57, 0, t1470);
  tv4rho41 = t624 + t658 + 0.3e1 * t706 + 0.3e1 * t746 + t6 * (t1415 + t1471);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1480 = t5 * t762 * t101 * t52;
  t1484 = t5 * t365 * t227 * t52;
  t1494 = t306 * t306;
  t1507 = my_piecewise5(t10, 0, t14, 0, t1364);
  t1511 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1181 * t356 * t202 - 0.32e2 / 0.27e2 * t663 * t92 * t306 - 0.8e1 / 0.27e2 * t749 * t210 + 0.8e1 / 0.9e1 * t201 * t1494 + 0.8e1 / 0.9e1 * t302 * t674 - 0.8e1 / 0.27e2 * t532 * t361 * t202 + 0.8e1 / 0.9e1 * t201 * t758 * t92 + 0.4e1 / 0.9e1 * t754 * t210 + 0.4e1 / 0.3e1 * t23 * t1507);
  t1520 = t5 * t767 * t115;
  t1536 = -t1480 / 0.4e1 + t1484 / 0.12e2 - 0.3e1 / 0.8e1 * t5 * t1511 * t26 * t52 - 0.3e1 / 0.4e1 * t5 * t763 * t115 - t1520 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t366 * t267 - t1379 / 0.2e1 + t1385 / 0.3e1 - t1388 / 0.4e1 - t1395 / 0.4e1 + t1399 / 0.3e1 - 0.5e1 / 0.18e2 * t1403 + t1166 + t1173 / 0.12e2 - 0.5e1 / 0.18e2 * t1177 + t1217 / 0.6e1 - 0.5e1 / 0.18e2 * t1225 + t1228 / 0.12e2;
  t1537 = my_piecewise3(t1, 0, t1536);
  t1546 = t330 * t330;
  t1559 = my_piecewise5(t14, 0, t10, 0, t1432);
  t1563 = my_piecewise3(t62, 0, 0.4e2 / 0.81e2 * t1301 * t373 * t275 - 0.32e2 / 0.27e2 * t707 * t123 * t330 - 0.8e1 / 0.27e2 * t779 * t281 + 0.8e1 / 0.9e1 * t274 * t1546 + 0.8e1 / 0.9e1 * t326 * t717 - 0.8e1 / 0.27e2 * t626 * t378 * t275 + 0.8e1 / 0.9e1 * t274 * t788 * t123 + 0.4e1 / 0.9e1 * t784 * t281 + 0.4e1 / 0.3e1 * t63 * t1559);
  t1570 = t5 * t792 * t101 * t83;
  t1574 = t5 * t382 * t227 * t83;
  t1583 = t5 * t726 * t168;
  t1586 = t5 * t730 * t168;
  t1597 = t5 * t290 * t424;
  t1600 = t5 * t294 * t424;
  t1602 = -0.3e1 / 0.8e1 * t5 * t1563 * t26 * t83 - t1570 / 0.4e1 + t1574 / 0.12e2 - t1445 / 0.4e1 + t1449 / 0.3e1 - 0.5e1 / 0.18e2 * t1453 - 0.3e1 / 0.4e1 * t5 * t722 * t168 - t1583 / 0.2e1 + t1586 / 0.6e1 + t1331 / 0.12e2 - 0.5e1 / 0.18e2 * t1335 + t1340 - t1462 / 0.4e1 + t1465 / 0.3e1 - 0.5e1 / 0.18e2 * t1468 - 0.3e1 / 0.8e1 * t5 * t286 * t424 - t1597 / 0.4e1 + t1600 / 0.12e2;
  t1603 = my_piecewise3(t57, 0, t1602);
  tv4rho42 = 0.2e1 * t706 + 0.2e1 * t746 + 0.2e1 * t778 + 0.2e1 * t817 + t6 * (t1537 + t1603);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1624 = my_piecewise5(t10, 0, t14, 0, t1363 + t1364);
  t1628 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1181 * t822 * t92 - 0.8e1 / 0.9e1 * t749 * t306 - 0.8e1 / 0.9e1 * t663 * t361 * t92 + 0.4e1 / 0.3e1 * t666 * t361 + 0.4e1 / 0.3e1 * t302 * t758 + 0.4e1 / 0.9e1 * t201 * t829 * t92 + 0.4e1 / 0.3e1 * t23 * t1624);
  t1635 = t5 * t833 * t101 * t52;
  t1646 = -0.3e1 / 0.8e1 * t5 * t1628 * t26 * t52 - t1635 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t834 * t115 - 0.3e1 / 0.8e1 * t1480 + t1484 / 0.4e1 - 0.3e1 / 0.8e1 * t1520 + t1400 - 0.5e1 / 0.12e2 * t1403 + t1386 - 0.5e1 / 0.36e2 * t1177 + t1166 - 0.5e1 / 0.36e2 * t1225;
  t1647 = my_piecewise3(t1, 0, t1646);
  t1664 = my_piecewise5(t14, 0, t10, 0, -t1363 + t1432);
  t1668 = my_piecewise3(t62, 0, 0.4e2 / 0.81e2 * t1301 * t842 * t123 - 0.8e1 / 0.9e1 * t779 * t330 - 0.8e1 / 0.9e1 * t707 * t378 * t123 + 0.4e1 / 0.3e1 * t710 * t378 + 0.4e1 / 0.3e1 * t326 * t788 + 0.4e1 / 0.9e1 * t274 * t849 * t123 + 0.4e1 / 0.3e1 * t63 * t1664);
  t1675 = t5 * t853 * t101 * t83;
  t1683 = t5 * t797 * t168;
  t1692 = t5 * t339 * t424;
  t1702 = t5 * t131 * t905;
  t1704 = -0.3e1 / 0.8e1 * t5 * t1668 * t26 * t83 - t1675 / 0.8e1 - 0.3e1 / 0.8e1 * t1570 + t1574 / 0.4e1 - 0.9e1 / 0.8e1 * t5 * t793 * t168 - 0.3e1 / 0.8e1 * t1683 + t1450 - 0.5e1 / 0.12e2 * t1453 - 0.3e1 / 0.4e1 * t1583 + t1586 / 0.2e1 - 0.9e1 / 0.8e1 * t5 * t335 * t424 - 0.3e1 / 0.8e1 * t1692 - 0.5e1 / 0.36e2 * t1335 + t1340 + t1466 - 0.5e1 / 0.12e2 * t1468 - 0.3e1 / 0.8e1 * t1597 + t1600 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t127 * t905 - t1702 / 0.8e1;
  t1705 = my_piecewise3(t57, 0, t1704);
  tv4rho43 = 0.3e1 * t778 + 0.3e1 * t817 + t841 + t910 + t6 * (t1647 + t1705);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1710 = t356 * t356;
  t1715 = t361 * t361;
  t1722 = my_piecewise5(t10, 0, t14, 0, 0.24e2 * t540 + 0.24e2 * t1195);
  t1726 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1181 * t1710 - 0.16e2 / 0.9e1 * t749 * t361 + 0.4e1 / 0.3e1 * t201 * t1715 + 0.16e2 / 0.9e1 * t302 * t829 + 0.4e1 / 0.3e1 * t23 * t1722);
  t1735 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1726 * t26 * t52 - t1635 / 0.2e1 + t1484 / 0.2e1 - 0.5e1 / 0.9e1 * t1403 + t1166);
  t1754 = 0.1e1 / t68 / t877;
  t1756 = t67 * t1754 * t33;
  t1761 = t401 * t159;
  t1772 = 0.1e1 / t885 / t418;
  t1773 = t900 * t900;
  t1775 = t448 * t1772 * t1773;
  t1787 = 0.1e1 / t412 / t411;
  t1801 = t894 * t894;
  t1803 = t413 * t413;
  t1804 = 0.1e1 / t1803;
  t1810 = t448 * t886 * (0.28e2 / 0.3e1 * t407 * t394 * t414 - 0.8e1 * t407 * t161 * t894 * t896 + 0.3e1 * t407 * t70 * (0.28e2 / 0.9e1 * t395 - 0.16e2 / 0.9e1 * t1787 * t1125 / t68 / t401 / t392 + 0.44e2 / 0.9e1 * t891 * t404) * t896 - 0.3e1 * t407 * t70 * t1801 * t1804);
  t1817 = t373 * t373;
  t1822 = t378 * t378;
  t1829 = my_piecewise5(t14, 0, t10, 0, -0.24e2 * t540 + 0.24e2 * t1313);
  t1833 = my_piecewise3(t62, 0, 0.4e2 / 0.81e2 * t1301 * t1817 - 0.16e2 / 0.9e1 * t779 * t378 + 0.4e1 / 0.3e1 * t274 * t1822 + 0.16e2 / 0.9e1 * t326 * t849 + 0.4e1 / 0.3e1 * t63 * t1829);
  t1838 = -t1702 / 0.2e1 + t1586 + t1600 / 0.2e1 - t1675 / 0.2e1 - 0.3e1 / 0.2e1 * t1683 - 0.3e1 / 0.2e1 * t1692 - 0.5e1 / 0.9e1 * t1453 - 0.5e1 / 0.9e1 * t1468 + t1574 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t854 * t168 - 0.9e1 / 0.4e1 * t5 * t383 * t424 - 0.3e1 / 0.2e1 * t5 * t155 * t905 - 0.3e1 / 0.8e1 * t5 * t66 * (-0.728e4 / 0.729e3 * t1756 * t80 - 0.16592e5 / 0.729e3 * t1756 * t165 + 0.4504e4 / 0.243e3 * sigma[2] / t402 / t1761 * t33 * t421 + 0.104e3 / 0.27e2 * t880 * t597 * t902 + 0.16e2 / 0.27e2 * t884 * t1775 - 0.8e1 / 0.27e2 * t884 * t1810) - 0.3e1 / 0.8e1 * t5 * t1833 * t26 * t83 + t1340;
  t1839 = my_piecewise3(t57, 0, t1838);
  tv4rho44 = 0.4e1 * t841 + 0.4e1 * t910 + t6 * (t1735 + t1839);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t1847 = t5 * t553 * t182;
  t1853 = t5 * t560 * t182;
  t1856 = t5 * t219 * t452;
  t1863 = 0.5e1 / 0.36e2 * t5 * t572 * t182;
  t1865 = t5 * t228 * t452;
  t1868 = t5 * t102 * t941;
  t1871 = t176 * t583 * t33;
  t1891 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t549 * t182 - 0.3e1 / 0.8e1 * t1847 - 0.9e1 / 0.8e1 * t5 * t215 * t452 + t1853 / 0.4e1 - 0.3e1 / 0.4e1 * t1856 - 0.9e1 / 0.8e1 * t5 * t96 * t941 - t1863 + t1865 / 0.4e1 - 0.3e1 / 0.8e1 * t1868 - 0.3e1 / 0.8e1 * t5 * t27 * (0.28e3 / 0.243e3 * t1871 * t49 + 0.832e3 / 0.243e3 * t1871 * t112 - 0.338e3 / 0.81e2 * t592 * t33 * t37 * t449 - 0.1e2 / 0.9e1 * t936 * t616 - 0.2e1 / 0.9e1 * t447 * t1255 + t447 * t1290 / 0.9e1));
  tv4rho3sigma0 = t6 * t1891 + 0.3e1 * t946;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t1898 = t5 * t645 * t193;
  t1901 = t5 * t649 * t193;
  t1905 = 0.5e1 / 0.36e2 * t5 * t653 * t193;
  t1907 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t641 * t193 - 0.3e1 / 0.8e1 * t1898 + t1901 / 0.4e1 - t1905);
  tv4rho3sigma2 = t6 * t1907 + 0.3e1 * t959;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t1909 = 0.2e1 * t973;
  t1915 = t5 * t683 * t182 / 0.4e1;
  t1920 = t5 * t690 * t182;
  t1924 = t5 * t315 * t452 / 0.4e1;
  t1933 = -0.3e1 / 0.8e1 * t5 * t679 * t182 - t1915 - 0.3e1 / 0.4e1 * t5 * t311 * t452 + t1920 / 0.12e2 - t1924 - 0.3e1 / 0.8e1 * t5 * t144 * t941 - t1847 / 0.8e1 + t1853 / 0.6e1 - t1856 / 0.4e1 - t1863 + t1865 / 0.6e1 - t1868 / 0.8e1;
  t1934 = my_piecewise3(t1, 0, t1933);
  tv4rho3sigma3 = t6 * t1934 + t1909 + t946;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t1936 = 0.2e1 * t989;
  t1942 = t5 * t726 * t193 / 0.4e1;
  t1944 = t5 * t730 * t193;
  t1953 = t5 * t290 * t490 / 0.4e1;
  t1955 = t5 * t294 * t490;
  t1958 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t722 * t193 - t1942 + t1944 / 0.12e2 - t1898 / 0.8e1 + t1901 / 0.6e1 - t1905 - 0.3e1 / 0.8e1 * t5 * t286 * t490 - t1953 + t1955 / 0.12e2);
  tv4rho3sigma5 = t6 * t1958 + t1936 + t959;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t1964 = t5 * t767 * t182;
  t1973 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t763 * t182 - t1964 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t366 * t452 - t1915 + t1920 / 0.6e1 - t1924 + t1853 / 0.12e2 - t1863 + t1865 / 0.12e2);
  tv4rho3sigma6 = t6 * t1973 + t1909 + t997;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t1979 = t5 * t797 * t193;
  t1986 = t5 * t339 * t490;
  t1994 = t5 * t131 * t1020;
  t1996 = -0.3e1 / 0.8e1 * t5 * t793 * t193 - t1979 / 0.8e1 - t1942 + t1944 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t335 * t490 - t1986 / 0.4e1 + t1901 / 0.12e2 - t1905 - t1953 + t1955 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t127 * t1020 - t1994 / 0.8e1;
  t1997 = my_piecewise3(t57, 0, t1996);
  tv4rho3sigma8 = t6 * t1997 + t1025 + t1936;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t2006 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t834 * t182 - 0.3e1 / 0.8e1 * t1964 + t1920 / 0.4e1 - t1863);
  tv4rho3sigma9 = t6 * t2006 + 0.3e1 * t997;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t2024 = t187 * t870 * t33;
  t2044 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t854 * t193 - 0.3e1 / 0.8e1 * t1979 - 0.9e1 / 0.8e1 * t5 * t383 * t490 + t1944 / 0.4e1 - 0.3e1 / 0.4e1 * t1986 - 0.9e1 / 0.8e1 * t5 * t155 * t1020 - t1905 + t1955 / 0.4e1 - 0.3e1 / 0.8e1 * t1994 - 0.3e1 / 0.8e1 * t5 * t66 * (0.28e3 / 0.243e3 * t2024 * t80 + 0.832e3 / 0.243e3 * t2024 * t165 - 0.338e3 / 0.81e2 * t879 * t33 * t37 * t487 - 0.1e2 / 0.9e1 * t1015 * t902 - 0.2e1 / 0.9e1 * t486 * t1775 + t486 * t1810 / 0.9e1));
  tv4rho3sigma11 = t6 * t2044 + 0.3e1 * t1025;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t2051 = t5 * t219 * t508;
  t2058 = t5 * t228 * t508 / 0.12e2;
  t2060 = t5 * t102 * t1046;
  t2063 = t498 * t237 * t33;
  t2072 = t1039 * t597;
  t2084 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t215 * t508 - t2051 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t96 * t1046 + t2058 - t2060 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * (0.14e2 / 0.81e2 * t2063 * t49 + 0.22e2 / 0.81e2 * t2063 * t112 + t503 * t247 * t33 * t264 / 0.3e1 + 0.2e1 / 0.9e1 * t2072 * t616 + t1043 * t1255 / 0.12e2 - t1043 * t1290 / 0.24e2));
  tv4rho2sigma20 = t6 * t2084 + 0.2e1 * t1051;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t2091 = t5 * t290 * t524;
  t2095 = t5 * t294 * t524 / 0.12e2;
  t2097 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t286 * t524 - t2091 / 0.4e1 + t2095);
  tv4rho2sigma25 = t6 * t2097 + 0.2e1 * t1060;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2103 = t5 * t315 * t508;
  t2111 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t311 * t508 - t2103 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t144 * t1046 - t2051 / 0.8e1 + t2058 - t2060 / 0.8e1);
  tv4rho2sigma26 = t6 * t2111 + t1051 + t1066;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t2117 = t5 * t339 * t524;
  t2124 = t5 * t131 * t1084;
  t2127 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t335 * t524 - t2117 / 0.8e1 - t2091 / 0.8e1 + t2095 - 0.3e1 / 0.8e1 * t5 * t127 * t1084 - t2124 / 0.8e1);
  tv4rho2sigma211 = t6 * t2127 + t1060 + t1089;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2135 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t366 * t508 - t2103 / 0.4e1 + t2058);
  tv4rho2sigma212 = t6 * t2135 + 0.2e1 * t1066;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t2147 = t514 * t394 * t33;
  t2156 = t1077 * t597;
  t2168 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t383 * t524 - t2117 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t155 * t1084 + t2095 - t2124 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t66 * (0.14e2 / 0.81e2 * t2147 * t80 + 0.22e2 / 0.81e2 * t2147 * t165 + t519 * t404 * t33 * t421 / 0.3e1 + 0.2e1 / 0.9e1 * t2156 * t902 + t1081 * t1775 / 0.12e2 - t1081 * t1810 / 0.24e2));
  tv4rho2sigma217 = t6 * t2168 + 0.2e1 * t1089;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2175 = t5 * t102 * t1120 / 0.8e1;
  t2177 = t1093 * t108 * t33;
  t2186 = t1101 * t597;
  t2232 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t96 * t1120 - t2175 - 0.3e1 / 0.8e1 * t5 * t27 * (t2177 * t49 / 0.9e1 + 0.2e1 / 0.27e2 * t2177 * t112 + 0.5e1 / 0.36e2 * t1100 * t445 * t33 * t264 + t2186 * t616 / 0.24e2 + t2072 * t1117 / 0.9e1 + t1043 * t448 * t1252 * t1115 * t614 / 0.12e2 - t1043 * t448 * t600 * (-0.2e1 * t1105 * t601 + 0.3e1 / 0.2e1 * t1105 * t611 - 0.4e1 * t250 * t108 * t1110 * t610 + 0.3e1 * t250 * t31 * (-0.2e1 / 0.3e1 * t438 + 0.2e1 / 0.3e1 * t1267 / t29 / t1241 * sigma[0] - 0.4e1 / 0.3e1 * t604 * t445) * t610 - 0.3e1 * t250 * t31 * t1110 * t1284 * t608) / 0.24e2));
  tv4rhosigma30 = t6 * t2232 + t1124;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t2239 = t5 * t131 * t1154 / 0.8e1;
  t2241 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t127 * t1154 - t2239);
  tv4rhosigma39 = t6 * t2241 + t1158;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t2247 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t144 * t1120 - t2175);
  tv4rhosigma310 = t6 * t2247 + t1124;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t2253 = t1127 * t161 * t33;
  t2262 = t1135 * t597;
  t2308 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t155 * t1154 - t2239 - 0.3e1 / 0.8e1 * t5 * t66 * (t2253 * t80 / 0.9e1 + 0.2e1 / 0.27e2 * t2253 * t165 + 0.5e1 / 0.36e2 * t1134 * t484 * t33 * t421 + t2262 * t902 / 0.24e2 + t2156 * t1151 / 0.9e1 + t1081 * t448 * t1772 * t1149 * t900 / 0.12e2 - t1081 * t448 * t886 * (-0.2e1 * t1139 * t887 + 0.3e1 / 0.2e1 * t1139 * t897 - 0.4e1 * t407 * t161 * t1144 * t896 + 0.3e1 * t407 * t70 * (-0.2e1 / 0.3e1 * t477 + 0.2e1 / 0.3e1 * t1787 / t68 / t1761 * sigma[2] - 0.4e1 / 0.3e1 * t890 * t484) * t896 - 0.3e1 * t407 * t70 * t1144 * t1804 * t894) / 0.24e2));
  tv4rhosigma319 = t6 * t2308 + t1158;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t2310 = t1091 * sigma[0];
  t2314 = 0.1e1 / t28 / t2310 * t31 * t33;
  t2326 = t1115 * t1115;
  t2343 = t1110 * t1110;
  t2357 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (0.5e1 / 0.24e2 * t2314 * t49 - t2314 * t112 / 0.9e1 + 0.7e1 / 0.96e2 / t2310 * t252 * t33 * t264 + t2186 * t1117 / 0.12e2 + t1043 * t448 * t1252 * t2326 / 0.12e2 - t1043 * t448 * t600 * (-0.3e1 / 0.4e1 * params->beta * t498 * t258 + 0.3e1 * t1105 * t1112 + 0.3e1 * t250 * t31 * (-t1267 * t1234 / 0.4e1 - t499 / 0.4e1) * t610 - 0.3e1 * t250 * t31 * t2343 * t1284) / 0.24e2));
  tv4sigma40 = t6 * t2357;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t2358 = t1125 * sigma[2];
  t2362 = 0.1e1 / t67 / t2358 * t70 * t33;
  t2374 = t1149 * t1149;
  t2391 = t1144 * t1144;
  t2405 = my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t66 * (0.5e1 / 0.24e2 * t2362 * t80 - t2362 * t165 / 0.9e1 + 0.7e1 / 0.96e2 / t2358 * t409 * t33 * t421 + t2262 * t1151 / 0.12e2 + t1081 * t448 * t1772 * t2374 / 0.12e2 - t1081 * t448 * t886 * (-0.3e1 / 0.4e1 * params->beta * t514 * t415 + 0.3e1 * t1139 * t1146 + 0.3e1 * t407 * t70 * (-t1787 * t1754 / 0.4e1 - t515 / 0.4e1) * t896 - 0.3e1 * t407 * t70 * t2391 * t1804) / 0.24e2));
  tv4sigma414 = t6 * t2405;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

