/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#ifndef IONIZE_RULE_HPP
#define IONIZE_RULE_HPP


/////////////////////// Local includes
#include "exportimportconfig.h"
#include "Formula.hpp"


namespace MsXpS
{


namespace libXpertMass
{


class DECLSPEC IonizeRule : public Formula
{
  public:
  IonizeRule();
  IonizeRule(const IonizeRule &other);

  void setCharge(int);
  int charge() const;

  void setLevel(int);
  int level() const;

  QString formula() const;

  using Formula::operator=;
  IonizeRule &operator=(const IonizeRule &other);

  using Formula::operator==;
  bool operator==(const IonizeRule &) const;

  using Formula::operator!=;
  bool operator!=(const IonizeRule &) const;

  // using Formula::validate;
  bool validate(IsotopicDataCstSPtr isotopic_data_csp) override;

  bool isValid() const;

  bool renderXmlIonizeRuleElement(const QDomElement &);

  QString *formatXmlIonizeRuleElement(int, const QString & = QString("  "));

  void debugPutStdErr();

  virtual QString toString() const override;

  protected:
  //! Charge brought by one ionization reaction.
  int m_charge;

  //! Level at which the ionization reaction should occur, that is
  // the number of times the ionization should occur(can be 0, in
  // which case the analyte is deionized).
  int m_level;

  //! Indicates if \c this IonizeRule is valid. Set only after a
  //! call to validate().
  bool m_isValid;
};

} // namespace libXpertMass

} // namespace MsXpS


#endif // IONIZE_RULE_HPP
