
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file XYListAttributes.h
    \\brief Definition of XYList Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "XYListAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

XYListAttributes::XYListAttributes():
	x_(ParameterManager::getDoubleArray("x_values")),
	y_(ParameterManager::getDoubleArray("y_values")),
	x_date_(ParameterManager::getStringArray("x_date_values")),
	x_base_(ParameterManager::getString("x_base_date")),
	x_offset_(ParameterManager::getString("x_date_offset")),
	y_base_(ParameterManager::getString("y_base_date")),
	y_offset_(ParameterManager::getString("y_date_offset")),
	y_date_(ParameterManager::getStringArray("y_date_values")),
	x_missing_(ParameterManager::getDouble("x_missing_value")),
	y_missing_(ParameterManager::getDouble("y_missing_value")),
	x2_(ParameterManager::getDoubleArray("x2_values")),
	y2_(ParameterManager::getDoubleArray("y2_values")),
	x2_base_(ParameterManager::getString("x2_base_date")),
	x2_offset_(ParameterManager::getString("x2_date_offset")),
	x2_date_(ParameterManager::getStringArray("x2_date_values")),
	y2_base_(ParameterManager::getString("y2_base_date")),
	y2_offset_(ParameterManager::getString("y2_date_offset")),
	y2_date_(ParameterManager::getStringArray("y2_date_values")),
	x_lower_(ParameterManager::getDoubleArray("x_lower_values")),
	y_lower_(ParameterManager::getDoubleArray("y_lower_values")),
	x_lower_date_(ParameterManager::getStringArray("x_lower_date_values")),
	y_lower_date_(ParameterManager::getStringArray("y_lower_date_values")),
	x_upper_(ParameterManager::getDoubleArray("x_upper_values")),
	y_upper_(ParameterManager::getDoubleArray("y_upper_values")),
	x_upper_date_(ParameterManager::getStringArray("x_upper_date_values")),
	y_upper_date_(ParameterManager::getStringArray("y_upper_date_values"))
	
	 
{
} 


XYListAttributes::~XYListAttributes()
{
	
}

    
void XYListAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "x_values", x_, params);
	setAttribute(prefix, "y_values", y_, params);
	setAttribute(prefix, "x_date_values", x_date_, params);
	setAttribute(prefix, "x_base_date", x_base_, params);
	setAttribute(prefix, "x_date_offset", x_offset_, params);
	setAttribute(prefix, "y_base_date", y_base_, params);
	setAttribute(prefix, "y_date_offset", y_offset_, params);
	setAttribute(prefix, "y_date_values", y_date_, params);
	setAttribute(prefix, "x_missing_value", x_missing_, params);
	setAttribute(prefix, "y_missing_value", y_missing_, params);
	setAttribute(prefix, "x2_values", x2_, params);
	setAttribute(prefix, "y2_values", y2_, params);
	setAttribute(prefix, "x2_base_date", x2_base_, params);
	setAttribute(prefix, "x2_date_offset", x2_offset_, params);
	setAttribute(prefix, "x2_date_values", x2_date_, params);
	setAttribute(prefix, "y2_base_date", y2_base_, params);
	setAttribute(prefix, "y2_date_offset", y2_offset_, params);
	setAttribute(prefix, "y2_date_values", y2_date_, params);
	setAttribute(prefix, "x_lower_values", x_lower_, params);
	setAttribute(prefix, "y_lower_values", y_lower_, params);
	setAttribute(prefix, "x_lower_date_values", x_lower_date_, params);
	setAttribute(prefix, "y_lower_date_values", y_lower_date_, params);
	setAttribute(prefix, "x_upper_values", x_upper_, params);
	setAttribute(prefix, "y_upper_values", y_upper_, params);
	setAttribute(prefix, "x_upper_date_values", x_upper_date_, params);
	setAttribute(prefix, "y_upper_date_values", y_upper_date_, params);
	
	
}

void XYListAttributes::copy(const XYListAttributes& other)
{
	x_ = other.x_;
	y_ = other.y_;
	x_date_ = other.x_date_;
	x_base_ = other.x_base_;
	x_offset_ = other.x_offset_;
	y_base_ = other.y_base_;
	y_offset_ = other.y_offset_;
	y_date_ = other.y_date_;
	x_missing_ = other.x_missing_;
	y_missing_ = other.y_missing_;
	x2_ = other.x2_;
	y2_ = other.y2_;
	x2_base_ = other.x2_base_;
	x2_offset_ = other.x2_offset_;
	x2_date_ = other.x2_date_;
	y2_base_ = other.y2_base_;
	y2_offset_ = other.y2_offset_;
	y2_date_ = other.y2_date_;
	x_lower_ = other.x_lower_;
	y_lower_ = other.y_lower_;
	x_lower_date_ = other.x_lower_date_;
	y_lower_date_ = other.y_lower_date_;
	x_upper_ = other.x_upper_;
	y_upper_ = other.y_upper_;
	x_upper_date_ = other.x_upper_date_;
	y_upper_date_ = other.y_upper_date_;
	
} 


bool XYListAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "xyinput")  )
		return true;
	
	return false;
}

void XYListAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "xyinput")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void XYListAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " x = " <<  x_;
	out << " y = " <<  y_;
	out << " x_date = " <<  x_date_;
	out << " x_base = " <<  x_base_;
	out << " x_offset = " <<  x_offset_;
	out << " y_base = " <<  y_base_;
	out << " y_offset = " <<  y_offset_;
	out << " y_date = " <<  y_date_;
	out << " x_missing = " <<  x_missing_;
	out << " y_missing = " <<  y_missing_;
	out << " x2 = " <<  x2_;
	out << " y2 = " <<  y2_;
	out << " x2_base = " <<  x2_base_;
	out << " x2_offset = " <<  x2_offset_;
	out << " x2_date = " <<  x2_date_;
	out << " y2_base = " <<  y2_base_;
	out << " y2_offset = " <<  y2_offset_;
	out << " y2_date = " <<  y2_date_;
	out << " x_lower = " <<  x_lower_;
	out << " y_lower = " <<  y_lower_;
	out << " x_lower_date = " <<  x_lower_date_;
	out << " y_lower_date = " <<  y_lower_date_;
	out << " x_upper = " <<  x_upper_;
	out << " y_upper = " <<  y_upper_;
	out << " x_upper_date = " <<  x_upper_date_;
	out << " y_upper_date = " <<  y_upper_date_;
	
	out << "]" << "\n";
}

void XYListAttributes::toxml(ostream& out)  const
{
	out <<  "\"xyinput\""; 
	out << ", \"x_values\":";
	niceprint(out,x_);
	out << ", \"y_values\":";
	niceprint(out,y_);
	out << ", \"x_date_values\":";
	niceprint(out,x_date_);
	out << ", \"x_base_date\":";
	niceprint(out,x_base_);
	out << ", \"x_date_offset\":";
	niceprint(out,x_offset_);
	out << ", \"y_base_date\":";
	niceprint(out,y_base_);
	out << ", \"y_date_offset\":";
	niceprint(out,y_offset_);
	out << ", \"y_date_values\":";
	niceprint(out,y_date_);
	out << ", \"x_missing_value\":";
	niceprint(out,x_missing_);
	out << ", \"y_missing_value\":";
	niceprint(out,y_missing_);
	out << ", \"x2_values\":";
	niceprint(out,x2_);
	out << ", \"y2_values\":";
	niceprint(out,y2_);
	out << ", \"x2_base_date\":";
	niceprint(out,x2_base_);
	out << ", \"x2_date_offset\":";
	niceprint(out,x2_offset_);
	out << ", \"x2_date_values\":";
	niceprint(out,x2_date_);
	out << ", \"y2_base_date\":";
	niceprint(out,y2_base_);
	out << ", \"y2_date_offset\":";
	niceprint(out,y2_offset_);
	out << ", \"y2_date_values\":";
	niceprint(out,y2_date_);
	out << ", \"x_lower_values\":";
	niceprint(out,x_lower_);
	out << ", \"y_lower_values\":";
	niceprint(out,y_lower_);
	out << ", \"x_lower_date_values\":";
	niceprint(out,x_lower_date_);
	out << ", \"y_lower_date_values\":";
	niceprint(out,y_lower_date_);
	out << ", \"x_upper_values\":";
	niceprint(out,x_upper_);
	out << ", \"y_upper_values\":";
	niceprint(out,y_upper_);
	out << ", \"x_upper_date_values\":";
	niceprint(out,x_upper_date_);
	out << ", \"y_upper_date_values\":";
	niceprint(out,y_upper_date_);
	
}

static MagicsParameter<doublearray> x_values("x_values", floatarray(), "");
static MagicsParameter<doublearray> y_values("y_values", floatarray(), "");
static MagicsParameter<stringarray> x_date_values("x_date_values", stringarray(), "");
static MagicsParameter<string> x_base_date("x_base_date", "", "");
static MagicsParameter<string> x_date_offset("x_date_offset", "second", "");
static MagicsParameter<string> y_base_date("y_base_date", "", "");
static MagicsParameter<string> y_date_offset("y_date_offset", "second", "");
static MagicsParameter<stringarray> y_date_values("y_date_values", stringarray(), "");
static MagicsParameter<double> x_missing_value("x_missing_value", -21.e6, "");
static MagicsParameter<double> y_missing_value("y_missing_value", -21.e6, "");
static MagicsParameter<doublearray> x2_values("x2_values", floatarray(), "");
static MagicsParameter<doublearray> y2_values("y2_values", floatarray(), "");
static MagicsParameter<string> x2_base_date("x2_base_date", "", "");
static MagicsParameter<string> x2_date_offset("x2_date_offset", "second", "");
static MagicsParameter<stringarray> x2_date_values("x2_date_values", stringarray(), "");
static MagicsParameter<string> y2_base_date("y2_base_date", "", "");
static MagicsParameter<string> y2_date_offset("y2_date_offset", "second", "");
static MagicsParameter<stringarray> y2_date_values("y2_date_values", stringarray(), "");
static MagicsParameter<doublearray> x_lower_values("x_lower_values", floatarray(), "");
static MagicsParameter<doublearray> y_lower_values("y_lower_values", floatarray(), "");
static MagicsParameter<stringarray> x_lower_date_values("x_lower_date_values", stringarray(), "");
static MagicsParameter<stringarray> y_lower_date_values("y_lower_date_values", stringarray(), "");
static MagicsParameter<doublearray> x_upper_values("x_upper_values", floatarray(), "");
static MagicsParameter<doublearray> y_upper_values("y_upper_values", floatarray(), "");
static MagicsParameter<stringarray> x_upper_date_values("x_upper_date_values", stringarray(), "");
static MagicsParameter<stringarray> y_upper_date_values("y_upper_date_values", stringarray(), "");
