/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var tape = require( 'tape' );
var dot = require( './../lib/dot.js' );


// TESTS //

tape( 'main export is a function', function test( t ) {
	t.ok( true, __filename );
	t.equal( typeof dot, 'function', 'main export is a function' );
	t.end();
});

tape( 'the function calculates the dot product of two arrays', function test( t ) {
	var expected;
	var actual;
	var x;
	var y;

	x = [ 2, 3, 1 ];
	y = [ 1, 2, 3 ];
	expected = ( 2*1 ) + ( 3*2 ) + ( 1*3 );
	actual = dot( x, y );

	t.equal( actual, expected, 'returns the dot product' );
	t.end();
});
