% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasiliskEnvironment.R
\docType{class}
\name{BasiliskEnvironment-class}
\alias{BasiliskEnvironment-class}
\alias{BasiliskEnvironment}
\title{The BasiliskEnvironment class}
\description{
The BasiliskEnvironment class provides a simple structure 
containing all of the information to construct a \pkg{basilisk} environment.
It is used by \code{\link{basiliskStart}} to perform lazy installation.
}
\section{Constructor}{

\code{BasiliskEnvironment(envname, pkgname, packages)} will return a BasiliskEnvironment object, given:
\itemize{
\item \code{envname}, string containing the name of the environment.
Environment names starting with an underscore are reserved for internal use.
\item \code{pkgname}, string containing the name of the package that owns the environment.
\item \code{packages}, character vector containing the names of the required Python packages from conda,
see \code{\link{setupBasiliskEnv}} for requirements.
\item \code{channels}, character vector specifying the Conda channels to search.
\item \code{pip}, character vector containing names of additional Python packages from PyPi,
see \code{\link{setupBasiliskEnv}} for requirements.
\item \code{paths}, character vector containing relative paths to Python packages to be installed via \code{pip}.
These paths are interpreted relative to the system directory of \code{pkgname}, i.e., they are appended to the output of \code{\link{system.file}}.
}
}

\examples{
BasiliskEnvironment("my_env1", "AaronPackage", 
    packages=c("scikit-learn=1.1.1", "pandas=1.43.1"))
}
\author{
Aaron lun
}
