% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setQuota.R
\name{setQuota}
\alias{setQuota}
\title{Set project quota}
\usage{
setQuota(
  project,
  baseline = NULL,
  growth = NULL,
  year = NULL,
  url = restUrl(),
  token = accessToken()
)
}
\arguments{
\item{project}{String containing the project name.}

\item{baseline}{Numeric scalar specifying the baseline quota (i.e., at time zero) in bytes.
If \code{NULL}, no change is made to the existing baseline of the project.}

\item{growth}{Numeric scalar specifying the annual growth rate of the quota, in bytes.
If \code{NULL}, no change is made to the existing growth rate of the project.}

\item{year}{Integer scalar specifying the year of creation (i.e., time zero) for the project.
If \code{NULL}, no change is made to the existing creation year of the project.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{token}{String containing a GitHub access token to authenticate to the gypsum REST API.
The token must refer to a gypsum administrator account.}
}
\value{
\code{NULL} is invisibly returned upon successful setting of the quota.
}
\description{
Set the storage quota for a project.
}
\examples{
if (interactive()) {
    # Creating a project for demonstration purposes.
    createProject("test-R-quota", owners="LTLA")

    # Setting a baseline of 10 GB with 5 GB in growth per year.
    setQuota("test-R-quota", baseline=10^10, growth=5^9, year=2019)
}

}
\seealso{
\code{\link{fetchQuota}}, to fetch the quota.
}
\author{
Aaron Lun
}
