% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_tidiers.R
\name{tidy_avg_comparisons}
\alias{tidy_avg_comparisons}
\title{Marginal Contrasts with \code{marginaleffects::avg_comparisons()}}
\usage{
tidy_avg_comparisons(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{a model}

\item{conf.int}{logical indicating whether or not to include a confidence
interval in the tidied output}

\item{conf.level}{the confidence level to use for the confidence interval}

\item{...}{additional parameters passed to
\code{marginaleffects::avg_comparisons()}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Use \code{marginaleffects::avg_comparisons()} to estimate marginal contrasts and
return a tibble tidied in a way that it could be used by \code{broom.helpers}
functions. See \code{marginaleffects::avg_comparisons()} for a list of supported
models.
}
\details{
By default, \code{marginaleffects::avg_comparisons()} estimate average marginal
contrasts: a contrast is computed for each observed value in the original
dataset (counterfactual approach) before being averaged.
Marginal Contrasts at the Mean could be computed by specifying
\code{newdata = "mean"}. The \code{variables} argument can be used to select the
contrasts to be computed. Please refer to the documentation page of
\code{marginaleffects::avg_comparisons()}.

See also \code{tidy_marginal_contrasts()} for taking into account interactions.
For more information, see \code{vignette("marginal_tidiers", "broom.helpers")}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Average Marginal Contrasts

df <- Titanic \%>\%
  dplyr::as_tibble() \%>\%
  tidyr::uncount(n) \%>\%
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))
mod <- glm(
  Survived ~ Class + Age + Sex,
  data = df, family = binomial
)
tidy_avg_comparisons(mod)
tidy_plus_plus(mod, tidy_fun = tidy_avg_comparisons)

mod2 <- lm(Petal.Length ~ poly(Petal.Width, 2) + Species, data = iris)
tidy_avg_comparisons(mod2)

# Custumizing the type of contrasts
tidy_avg_comparisons(
  mod2,
  variables = list(Petal.Width = 2, Species = "pairwise")
)

# Marginal Contrasts at the Mean
tidy_avg_comparisons(mod, newdata = "mean")
tidy_plus_plus(mod, tidy_fun = tidy_avg_comparisons, newdata = "mean")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{marginaleffects::avg_comparisons()}

Other marginal_tieders: 
\code{\link{tidy_all_effects}()},
\code{\link{tidy_avg_slopes}()},
\code{\link{tidy_ggpredict}()},
\code{\link{tidy_marginal_contrasts}()},
\code{\link{tidy_marginal_means}()},
\code{\link{tidy_marginal_predictions}()},
\code{\link{tidy_margins}()}
}
\concept{marginal_tieders}
