% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictMA.R
\name{predictMA}
\alias{predictMA}
\title{Prediction of model averaged linear mixed models}
\usage{
predictMA(object, new.data)
}
\arguments{
\item{object}{A object created by the model averaging function.}

\item{new.data}{Object that contains the data on which the prediction 
is to be based on.}
}
\value{
An object that contains predictions calculated based on the given 
dataset and the assumed underlying model average.
}
\description{
Function to perform prediction for model averaged linear mixed models based
on the weight selection criterion as proposed by Zhang et al.(2014)
}
\examples{
data(Orthodont, package = "nlme")
models <- list(
    model1 <- lmer(formula = distance ~ age + Sex + (1 | Subject) + age:Sex,
               data = Orthodont),
    model2 <- lmer(formula = distance ~ age + Sex + (1 | Subject),
               data = Orthodont),
    model3 <- lmer(formula = distance ~ age + (1 | Subject),
                 data = Orthodont),
    model4 <- lmer(formula = distance ~ Sex + (1 | Subject),
                data = Orthodont))
foo <- modelAvg(models = models)
predictMA(foo, new.data = Orthodont)


}
\references{
Greven, S. and Kneib T. (2010) On the behaviour of marginal and
conditional AIC in linear mixed models. Biometrika 97(4), 773-789.
}
\seealso{
\code{\link[lme4]{lme4-package}}, \code{\link[lme4]{lmer}}
}
\author{
Benjamin Saefken & Rene-Marcel Kruse
}
