% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{bizdays}
\alias{bizdays}
\title{Number of trading days in each season}
\usage{
bizdays(x, FinCenter = c("New York", "London", "NERC", "Toronto", "Zurich"))
}
\arguments{
\item{x}{Monthly or quarterly time series}

\item{FinCenter}{Major financial center.}
}
\value{
Time series
}
\description{
Returns number of trading days in each month or quarter of the observed time
period in a major financial center.
}
\details{
Useful for trading days length adjustments. More on how to define "business
days", please refer to \code{\link[timeDate]{isBizday}}.
}
\examples{

x <- ts(rnorm(30), start = c(2013, 2), frequency = 12)
bizdays(x, FinCenter = "New York")
}
\seealso{
\code{\link[forecast]{monthdays}}
}
\author{
Earo Wang
}
\keyword{ts}
