% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_location.R
\name{ph_location_label}
\alias{ph_location_label}
\title{Location of a named placeholder}
\usage{
ph_location_label(ph_label, newlabel = NULL, ...)
}
\arguments{
\item{ph_label}{placeholder label of the used layout. It can be read in PowerPoint or
with function \code{\link[=layout_properties]{layout_properties()}} in column \code{ph_label}.}

\item{newlabel}{a label to associate with the placeholder.}

\item{...}{unused arguments}
}
\description{
The function will use the label of a placeholder
to find the corresponding location.
}
\details{
The location of the bounding box associated to a placeholder
within a slide is specified with the left top coordinate,
the width and the height. These are defined in inches:

\describe{
\item{left}{left coordinate of the bounding box}
\item{top}{top coordinate of the bounding box}
\item{width}{width of the bounding box}
\item{height}{height of the bounding box}
}

In addition to these attributes, a label can be
associated with the shape. Shapes, text boxes, images and other objects
will be identified with that label in the \emph{Selection Pane} of PowerPoint.
This label can then be reused by other functions such as \code{ph_location_label()}.
It can be set with argument \code{newlabel}.
}
\examples{
library(officer)

# ph_location_label demo ----

doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content")

# all ph_label can be read here
layout_properties(doc, layout = "Title and Content")

doc <- ph_with(
  doc,
  head(iris),
  location = ph_location_label(ph_label = "Content Placeholder 2")
)
doc <- ph_with(
  doc,
  format(Sys.Date()),
  location = ph_location_label(ph_label = "Date Placeholder 3")
)
doc <- ph_with(
  doc,
  "This is a title",
  location = ph_location_label(ph_label = "Title 1")
)

print(doc, target = tempfile(fileext = ".pptx"))
}
\seealso{
Other functions for placeholder location: 
\code{\link{ph_location}()},
\code{\link{ph_location_fullsize}()},
\code{\link{ph_location_id}()},
\code{\link{ph_location_left}()},
\code{\link{ph_location_right}()},
\code{\link{ph_location_template}()},
\code{\link{ph_location_type}()}
}
\concept{functions for placeholder location}
