% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KR_modcomp.R
\name{kr__modcomp}
\alias{kr__modcomp}
\alias{KRmodcomp}
\alias{KRmodcomp.lmerMod}
\alias{KRmodcomp_internal}
\alias{KRmodcomp.mer}
\title{F-test and degrees of freedom based on Kenward-Roger approximation}
\usage{
KRmodcomp(largeModel, smallModel, betaH = 0, details = 0)

\method{KRmodcomp}{lmerMod}(largeModel, smallModel, betaH = 0, details = 0)
}
\arguments{
\item{largeModel}{An \code{lmer} model}

\item{smallModel}{An \code{lmer} model or a restriction matrix}

\item{betaH}{A number or a vector of the beta of the hypothesis,
e.g. L beta=L betaH. If \code{smallModel} is a model object then betaH=0.}

\item{details}{If larger than 0 some timing details are printed.}
}
\description{
An approximate F-test based on the Kenward-Roger approach.
}
\details{
An F test is calculated according to the approach of Kenward and
Roger (1997).  The function works for linear mixed models fitted
with the lmer() function of the \code{lme4} package. Only models where
the covariance structure is a linear combination (a weighted sum)
of known matrices can be compared.

The \code{smallModel} is the model to be tested against the \code{largeModel}.

The \code{largeModel} is a model fitted with \code{lmer()}. A technical
detail: The model must be fitted with \code{REML=TRUE}. If the model is
fitted with \code{REML=FALSE} then the model is refitted with
\code{REML=TRUE} before the p-values are calculated. Put differently,
the user needs not worry about this issue.

The \code{smallModel} can be one of several things:
\enumerate{
\item a model fitted with \code{lmer()}. It must have the same covariance
structure as \code{largeModel}. Furthermore, its linear space of
expectation must be a subspace of the space for \code{largeModel}.
\item a restriction matrix \code{L} specifying the hypothesis
\deqn{L \beta = L \beta_H}
where \code{L} is a \verb{k x p} matrix (there are k restrictions and p is
the number of fixed effect parameters (the length of
\code{fixef(largeModel)}) and \code{beta_H} is a p column vector.
\item A formula or a text string specifying what is to be removed from the
larger model to form the smaller model.
}

Notice: if you want to test a hypothesis

\deqn{L \beta = c}

with a \eqn{k} vector \eqn{c}, a suitable \eqn{\beta_H} is obtained
via \eqn{\beta_H=L c} where \eqn{L_n} is a g-inverse of \eqn{L}.

Notice: It cannot be guaranteed that the results agree with other
implementations of the Kenward-Roger approach!
}
\examples{

(fm0 <- lmer(Reaction ~ (Days|Subject), sleepstudy))
(fm1 <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy))
(fm2 <- lmer(Reaction ~ Days + I(Days^2) + (Days|Subject), sleepstudy))

## Test for no effect of Days in fm1, i.e. test fm0 under fm1
KRmodcomp(fm1, "Days")
KRmodcomp(fm1, ~.-Days)
L1 <- cbind(0, 1) 
KRmodcomp(fm1, L1)
KRmodcomp(fm1, fm0)
anova(fm1, fm0)

## Test for no effect of Days and Days-squared in fm2, i.e. test fm0 under fm2
KRmodcomp(fm2, "(Days+I(Days^2))")
KRmodcomp(fm2, ~. - Days - I(Days^2))
L2 <- rbind(c(0, 1, 0), c(0, 0, 1))
KRmodcomp(fm2, L2)
KRmodcomp(fm2, fm0)
anova(fm2, fm0)

## Test for no effect of Days-squared in fm2, i.e. test fm1 under fm2
KRmodcomp(fm2, "I(Days^2)")
KRmodcomp(fm2, ~. - I(Days^2))
L3 <- rbind(c(0, 0, 1))
KRmodcomp(fm2, L3)
KRmodcomp(fm2, fm1)
anova(fm2, fm1)
}
\references{
Ulrich Halekoh, Søren Højsgaard (2014)., A
Kenward-Roger Approximation and Parametric Bootstrap Methods
for Tests in Linear Mixed Models - The R Package pbkrtest.,
Journal of Statistical Software, 58(10), 1-30.,
\url{https://www.jstatsoft.org/v59/i09/}

Kenward, M. G. and Roger, J. H. (1997), \emph{Small Sample Inference for
Fixed Effects from Restricted Maximum Likelihood}, Biometrics 53: 983-997.
}
\seealso{
\code{\link{getKR}}, \code{\link[lme4]{lmer}},
\code{\link{vcovAdj}}, \code{\link{PBmodcomp}},
\code{\link{SATmodcomp}}
}
\author{
Ulrich Halekoh \email{uhalekoh@health.sdu.dk}, Søren Højsgaard
\email{sorenh@math.aau.dk}
}
\concept{model_comparison}
\keyword{inference}
\keyword{models}
