% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseFreq.R
\name{baseFreq}
\alias{baseFreq}
\alias{glance.phyDat}
\alias{composition_test}
\title{Summaries of alignments}
\usage{
baseFreq(obj, freq = FALSE, all = FALSE, drop.unused.levels = FALSE)

\method{glance}{phyDat}(x, ...)

composition_test(obj)
}
\arguments{
\item{obj, x}{as object of class phyDat}

\item{freq}{logical, if 'TRUE', frequencies or counts are returned otherwise
proportions}

\item{all}{all a logical; if all = TRUE, all counts of bases, ambiguous
codes, missing data, and alignment gaps are returned as defined in the
contrast.}

\item{drop.unused.levels}{logical, drop unused levels}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{baseFreq} returns a named vector and \code{glance} a one row
\code{data.frame}.
}
\description{
\code{baseFreq} computes the frequencies (absolute or relative) of the states
from a sample of sequences.
\code{glance} computes some useful information about the alignment.
\code{composition\_test} computes a \eqn{\chi^2}-test testing if the state
composition for a species differs.
}
\examples{

data(Laurasiatherian)
data(chloroplast)
# base frequencies
baseFreq(Laurasiatherian)
baseFreq(Laurasiatherian, all=TRUE)
baseFreq(Laurasiatherian, freq=TRUE)
baseFreq(chloroplast)
glance(Laurasiatherian)
glance(chloroplast)
composition_test(Laurasiatherian)[1:10,]
}
\seealso{
\code{\link{phyDat}, \link[ape]{base.freq}, \link{glance}}
}
\author{
Klaus Schliep
}
