% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{variables<-}
\alias{variables<-}
\alias{variables<-.draws_matrix}
\alias{variables<-.draws_array}
\alias{variables<-.draws_df}
\alias{variables<-.draws_list}
\alias{variables<-.draws_rvars}
\alias{set_variables}
\title{Set variable names in \code{draws} objects}
\usage{
variables(x, ...) <- value

\method{variables}{draws_matrix}(x, with_indices = TRUE, ...) <- value

\method{variables}{draws_array}(x, with_indices = TRUE, ...) <- value

\method{variables}{draws_df}(x, with_indices = TRUE, ...) <- value

\method{variables}{draws_list}(x, with_indices = TRUE, ...) <- value

\method{variables}{draws_rvars}(x, with_indices = FALSE, ...) <- value

set_variables(x, variables, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{...}{Arguments passed to individual methods (if applicable).}

\item{value, variables}{(character vector) new variable names.}

\item{with_indices}{(logical) Should indices be included in variable
names? For example, if the object includes variables named \code{"x[1]"} and
\code{"x[2]"}, if \code{TRUE}, \code{c("x[1]", "x[2]")} is returned; if \code{FALSE}, only \code{"x"}
is returned. Defaults to \code{TRUE} for all formats except \code{\link[=draws_rvars]{draws_rvars()}}.}
}
\value{
Returns a \code{\link{draws}} object of the same format as \code{x}, with
variables named as specified.
}
\description{
Set variable names for all variables in a \code{\link{draws}} object. The
\code{set_variables()} form is useful when using pipe operators.
}
\details{
\code{variables(x) <- value} allows you to modify the vector of variable names,
similar to how \code{names(x) <- value} works for vectors and lists. For renaming
specific variables, \code{set_variables(x, value)} works equivalently, but is more intuitive
when using the pipe operator.

For renaming specific variables, \code{\link[=rename_variables]{rename_variables()}} may offer a more
convenient approach.
}
\examples{
x <- example_draws()

variables(x)
nvariables(x)
variables(x) <- letters[1:nvariables(x)]

# or equivalently...
x <- set_variables(x, letters[1:nvariables(x)])

}
\seealso{
\code{\link{variables}}, \code{\link{rename_variables}}, \code{\link{draws-index}}
}
