# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2022 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from ZigbeeManager.idl.

use strict;

package Raritan::RPC::zigbee::ZigbeeManager;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "zigbee.ZigbeeManager:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::zigbee::ZigbeeManager::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant ERR_DEVICE_EXISTS => 1;

use constant ERR_MAX_DEVICE_REACHED => 2;

use constant ERR_DEVICE_NOT_FOUND => 3;

use constant ERR_INVALID_PARAMS => 4;

use constant ERR_INVALID_KEY => 5;

use constant ERR_INVALID_CHANNEL => 6;

use Raritan::RPC::zigbee::ZigbeeManager::MetaData;

sub getMetaData($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getMetaData', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::zigbee::ZigbeeManager::MetaData::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}


sub getDongleState($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getDongleState', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::zigbee::ZigbeeManager::Settings;

sub getSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::zigbee::ZigbeeManager::Settings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::zigbee::ZigbeeManager::Settings;

sub setSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::zigbee::ZigbeeManager::Settings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::zigbee::ZigbeeManager::DeviceRegistration;

sub addDevices($$) {
    my ($self, $sensors) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'sensors'} = [];
    for (my $i0 = 0; $i0 <= $#{$sensors}; $i0++) {
        $args->{'sensors'}->[$i0] = Raritan::RPC::zigbee::ZigbeeManager::DeviceRegistration::encode($sensors->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addDevices', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}

sub removeDevice($$) {
    my ($self, $sourceId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'sourceId'} = 1 * $sourceId;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'removeDevice', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}


sub getRegisteredDevices($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getRegisteredDevices', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}->[$i0], 'zigbee.ZigbeeDevice');
    }
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('zigbee.ZigbeeManager', 1, 0, 0, 'Raritan::RPC::zigbee::ZigbeeManager');
1;
