# Copyright 2015 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

require 'date'
require 'google/apis/core/base_service'
require 'google/apis/core/json_representation'
require 'google/apis/core/hashable'
require 'google/apis/errors'

module Google
  module Apis
    module ServicenetworkingV1
      
      class AddDnsRecordSetMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddDnsRecordSetRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddDnsZoneMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddDnsZoneRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddDnsZoneResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddRolesMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddRolesRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddRolesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddSubnetworkRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Api
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AuthProvider
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AuthRequirement
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Authentication
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AuthenticationRule
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Backend
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class BackendRule
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Billing
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class BillingDestination
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CancelOperationRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Connection
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ConsumerConfig
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ConsumerConfigMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ConsumerProject
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Context
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ContextRule
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Control
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CustomError
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CustomErrorRule
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CustomHttpPattern
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DeletePeeredDnsDomainMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DisableVpcServiceControlsRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DnsRecordSet
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DnsZone
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Documentation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DocumentationRule
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Empty
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class EnableVpcServiceControlsRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Endpoint
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Enum
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class EnumValue
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Field
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GoogleCloudServicenetworkingV1betaSubnetwork
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Http
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HttpRule
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class JwtLocation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class LabelDescriptor
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListConnectionsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListOperationsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListPeeredDnsDomainsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class LogDescriptor
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Logging
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class LoggingDestination
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MethodProp
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MetricDescriptor
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MetricDescriptorMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MetricRule
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Mixin
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MonitoredResourceDescriptor
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Monitoring
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MonitoringDestination
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class OAuthRequirements
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Operation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Option
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Page
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PeeredDnsDomain
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PeeredDnsDomainMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PolicyBinding
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Quota
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class QuotaLimit
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Range
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RangeReservation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RemoveDnsRecordSetMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RemoveDnsRecordSetRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RemoveDnsRecordSetResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RemoveDnsZoneMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RemoveDnsZoneRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RemoveDnsZoneResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Route
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SearchRangeRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SecondaryIpRange
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SecondaryIpRangeSpec
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Service
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SourceContext
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SourceInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Status
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Subnetwork
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SystemParameter
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SystemParameterRule
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SystemParameters
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Type
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UpdateConsumerConfigRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UpdateDnsRecordSetMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UpdateDnsRecordSetRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Usage
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UsageRule
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ValidateConsumerConfigRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ValidateConsumerConfigResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddDnsRecordSetMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class AddDnsRecordSetRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_network, as: 'consumerNetwork'
          property :dns_record_set, as: 'dnsRecordSet', class: Google::Apis::ServicenetworkingV1::DnsRecordSet, decorator: Google::Apis::ServicenetworkingV1::DnsRecordSet::Representation
      
          property :zone, as: 'zone'
        end
      end
      
      class AddDnsZoneMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class AddDnsZoneRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_network, as: 'consumerNetwork'
          property :dns_suffix, as: 'dnsSuffix'
          property :name, as: 'name'
        end
      end
      
      class AddDnsZoneResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_peering_zone, as: 'consumerPeeringZone', class: Google::Apis::ServicenetworkingV1::DnsZone, decorator: Google::Apis::ServicenetworkingV1::DnsZone::Representation
      
          property :producer_private_zone, as: 'producerPrivateZone', class: Google::Apis::ServicenetworkingV1::DnsZone, decorator: Google::Apis::ServicenetworkingV1::DnsZone::Representation
      
        end
      end
      
      class AddRolesMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class AddRolesRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_network, as: 'consumerNetwork'
          collection :policy_binding, as: 'policyBinding', class: Google::Apis::ServicenetworkingV1::PolicyBinding, decorator: Google::Apis::ServicenetworkingV1::PolicyBinding::Representation
      
        end
      end
      
      class AddRolesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :policy_binding, as: 'policyBinding', class: Google::Apis::ServicenetworkingV1::PolicyBinding, decorator: Google::Apis::ServicenetworkingV1::PolicyBinding::Representation
      
        end
      end
      
      class AddSubnetworkRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer, as: 'consumer'
          property :consumer_network, as: 'consumerNetwork'
          property :description, as: 'description'
          property :ip_prefix_length, as: 'ipPrefixLength'
          property :region, as: 'region'
          property :requested_address, as: 'requestedAddress'
          collection :secondary_ip_range_specs, as: 'secondaryIpRangeSpecs', class: Google::Apis::ServicenetworkingV1::SecondaryIpRangeSpec, decorator: Google::Apis::ServicenetworkingV1::SecondaryIpRangeSpec::Representation
      
          property :subnetwork, as: 'subnetwork'
          collection :subnetwork_users, as: 'subnetworkUsers'
        end
      end
      
      class Api
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :methods_prop, as: 'methods', class: Google::Apis::ServicenetworkingV1::MethodProp, decorator: Google::Apis::ServicenetworkingV1::MethodProp::Representation
      
          collection :mixins, as: 'mixins', class: Google::Apis::ServicenetworkingV1::Mixin, decorator: Google::Apis::ServicenetworkingV1::Mixin::Representation
      
          property :name, as: 'name'
          collection :options, as: 'options', class: Google::Apis::ServicenetworkingV1::Option, decorator: Google::Apis::ServicenetworkingV1::Option::Representation
      
          property :source_context, as: 'sourceContext', class: Google::Apis::ServicenetworkingV1::SourceContext, decorator: Google::Apis::ServicenetworkingV1::SourceContext::Representation
      
          property :syntax, as: 'syntax'
          property :version, as: 'version'
        end
      end
      
      class AuthProvider
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :audiences, as: 'audiences'
          property :authorization_url, as: 'authorizationUrl'
          property :id, as: 'id'
          property :issuer, as: 'issuer'
          property :jwks_uri, as: 'jwksUri'
          collection :jwt_locations, as: 'jwtLocations', class: Google::Apis::ServicenetworkingV1::JwtLocation, decorator: Google::Apis::ServicenetworkingV1::JwtLocation::Representation
      
        end
      end
      
      class AuthRequirement
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :audiences, as: 'audiences'
          property :provider_id, as: 'providerId'
        end
      end
      
      class Authentication
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :providers, as: 'providers', class: Google::Apis::ServicenetworkingV1::AuthProvider, decorator: Google::Apis::ServicenetworkingV1::AuthProvider::Representation
      
          collection :rules, as: 'rules', class: Google::Apis::ServicenetworkingV1::AuthenticationRule, decorator: Google::Apis::ServicenetworkingV1::AuthenticationRule::Representation
      
        end
      end
      
      class AuthenticationRule
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :allow_without_credential, as: 'allowWithoutCredential'
          property :oauth, as: 'oauth', class: Google::Apis::ServicenetworkingV1::OAuthRequirements, decorator: Google::Apis::ServicenetworkingV1::OAuthRequirements::Representation
      
          collection :requirements, as: 'requirements', class: Google::Apis::ServicenetworkingV1::AuthRequirement, decorator: Google::Apis::ServicenetworkingV1::AuthRequirement::Representation
      
          property :selector, as: 'selector'
        end
      end
      
      class Backend
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :rules, as: 'rules', class: Google::Apis::ServicenetworkingV1::BackendRule, decorator: Google::Apis::ServicenetworkingV1::BackendRule::Representation
      
        end
      end
      
      class BackendRule
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :address, as: 'address'
          property :deadline, as: 'deadline'
          property :disable_auth, as: 'disableAuth'
          property :jwt_audience, as: 'jwtAudience'
          property :min_deadline, as: 'minDeadline'
          property :operation_deadline, as: 'operationDeadline'
          property :path_translation, as: 'pathTranslation'
          property :protocol, as: 'protocol'
          property :selector, as: 'selector'
        end
      end
      
      class Billing
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :consumer_destinations, as: 'consumerDestinations', class: Google::Apis::ServicenetworkingV1::BillingDestination, decorator: Google::Apis::ServicenetworkingV1::BillingDestination::Representation
      
        end
      end
      
      class BillingDestination
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :metrics, as: 'metrics'
          property :monitored_resource, as: 'monitoredResource'
        end
      end
      
      class CancelOperationRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class Connection
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :network, as: 'network'
          property :peering, as: 'peering'
          collection :reserved_peering_ranges, as: 'reservedPeeringRanges'
          property :service, as: 'service'
        end
      end
      
      class ConsumerConfig
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_export_custom_routes, as: 'consumerExportCustomRoutes'
          property :consumer_export_subnet_routes_with_public_ip, as: 'consumerExportSubnetRoutesWithPublicIp'
          property :consumer_import_custom_routes, as: 'consumerImportCustomRoutes'
          property :consumer_import_subnet_routes_with_public_ip, as: 'consumerImportSubnetRoutesWithPublicIp'
          property :producer_export_custom_routes, as: 'producerExportCustomRoutes'
          property :producer_export_subnet_routes_with_public_ip, as: 'producerExportSubnetRoutesWithPublicIp'
          property :producer_import_custom_routes, as: 'producerImportCustomRoutes'
          property :producer_import_subnet_routes_with_public_ip, as: 'producerImportSubnetRoutesWithPublicIp'
          property :producer_network, as: 'producerNetwork'
          collection :reserved_ranges, as: 'reservedRanges'
        end
      end
      
      class ConsumerConfigMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class ConsumerProject
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :project_num, :numeric_string => true, as: 'projectNum'
        end
      end
      
      class Context
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :rules, as: 'rules', class: Google::Apis::ServicenetworkingV1::ContextRule, decorator: Google::Apis::ServicenetworkingV1::ContextRule::Representation
      
        end
      end
      
      class ContextRule
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :allowed_request_extensions, as: 'allowedRequestExtensions'
          collection :allowed_response_extensions, as: 'allowedResponseExtensions'
          collection :provided, as: 'provided'
          collection :requested, as: 'requested'
          property :selector, as: 'selector'
        end
      end
      
      class Control
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :environment, as: 'environment'
        end
      end
      
      class CustomError
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :rules, as: 'rules', class: Google::Apis::ServicenetworkingV1::CustomErrorRule, decorator: Google::Apis::ServicenetworkingV1::CustomErrorRule::Representation
      
          collection :types, as: 'types'
        end
      end
      
      class CustomErrorRule
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :is_error_type, as: 'isErrorType'
          property :selector, as: 'selector'
        end
      end
      
      class CustomHttpPattern
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :kind, as: 'kind'
          property :path, as: 'path'
        end
      end
      
      class DeletePeeredDnsDomainMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class DisableVpcServiceControlsRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_network, as: 'consumerNetwork'
        end
      end
      
      class DnsRecordSet
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :data, as: 'data'
          property :domain, as: 'domain'
          property :ttl, as: 'ttl'
          property :type, as: 'type'
        end
      end
      
      class DnsZone
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :dns_suffix, as: 'dnsSuffix'
          property :name, as: 'name'
        end
      end
      
      class Documentation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :documentation_root_url, as: 'documentationRootUrl'
          property :overview, as: 'overview'
          collection :pages, as: 'pages', class: Google::Apis::ServicenetworkingV1::Page, decorator: Google::Apis::ServicenetworkingV1::Page::Representation
      
          collection :rules, as: 'rules', class: Google::Apis::ServicenetworkingV1::DocumentationRule, decorator: Google::Apis::ServicenetworkingV1::DocumentationRule::Representation
      
          property :service_root_url, as: 'serviceRootUrl'
          property :summary, as: 'summary'
        end
      end
      
      class DocumentationRule
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :deprecation_description, as: 'deprecationDescription'
          property :description, as: 'description'
          property :selector, as: 'selector'
        end
      end
      
      class Empty
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class EnableVpcServiceControlsRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_network, as: 'consumerNetwork'
        end
      end
      
      class Endpoint
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :aliases, as: 'aliases'
          property :allow_cors, as: 'allowCors'
          property :name, as: 'name'
          property :target, as: 'target'
        end
      end
      
      class Enum
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :enumvalue, as: 'enumvalue', class: Google::Apis::ServicenetworkingV1::EnumValue, decorator: Google::Apis::ServicenetworkingV1::EnumValue::Representation
      
          property :name, as: 'name'
          collection :options, as: 'options', class: Google::Apis::ServicenetworkingV1::Option, decorator: Google::Apis::ServicenetworkingV1::Option::Representation
      
          property :source_context, as: 'sourceContext', class: Google::Apis::ServicenetworkingV1::SourceContext, decorator: Google::Apis::ServicenetworkingV1::SourceContext::Representation
      
          property :syntax, as: 'syntax'
        end
      end
      
      class EnumValue
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :number, as: 'number'
          collection :options, as: 'options', class: Google::Apis::ServicenetworkingV1::Option, decorator: Google::Apis::ServicenetworkingV1::Option::Representation
      
        end
      end
      
      class Field
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :cardinality, as: 'cardinality'
          property :default_value, as: 'defaultValue'
          property :json_name, as: 'jsonName'
          property :kind, as: 'kind'
          property :name, as: 'name'
          property :number, as: 'number'
          property :oneof_index, as: 'oneofIndex'
          collection :options, as: 'options', class: Google::Apis::ServicenetworkingV1::Option, decorator: Google::Apis::ServicenetworkingV1::Option::Representation
      
          property :packed, as: 'packed'
          property :type_url, as: 'typeUrl'
        end
      end
      
      class GoogleCloudServicenetworkingV1betaSubnetwork
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :ip_cidr_range, as: 'ipCidrRange'
          property :name, as: 'name'
          property :network, as: 'network'
          property :outside_allocation, as: 'outsideAllocation'
        end
      end
      
      class Http
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :fully_decode_reserved_expansion, as: 'fullyDecodeReservedExpansion'
          collection :rules, as: 'rules', class: Google::Apis::ServicenetworkingV1::HttpRule, decorator: Google::Apis::ServicenetworkingV1::HttpRule::Representation
      
        end
      end
      
      class HttpRule
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :additional_bindings, as: 'additionalBindings', class: Google::Apis::ServicenetworkingV1::HttpRule, decorator: Google::Apis::ServicenetworkingV1::HttpRule::Representation
      
          property :body, as: 'body'
          property :custom, as: 'custom', class: Google::Apis::ServicenetworkingV1::CustomHttpPattern, decorator: Google::Apis::ServicenetworkingV1::CustomHttpPattern::Representation
      
          property :delete, as: 'delete'
          property :get, as: 'get'
          property :patch, as: 'patch'
          property :post, as: 'post'
          property :put, as: 'put'
          property :response_body, as: 'responseBody'
          property :selector, as: 'selector'
        end
      end
      
      class JwtLocation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :header, as: 'header'
          property :query, as: 'query'
          property :value_prefix, as: 'valuePrefix'
        end
      end
      
      class LabelDescriptor
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :description, as: 'description'
          property :key, as: 'key'
          property :value_type, as: 'valueType'
        end
      end
      
      class ListConnectionsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :connections, as: 'connections', class: Google::Apis::ServicenetworkingV1::Connection, decorator: Google::Apis::ServicenetworkingV1::Connection::Representation
      
        end
      end
      
      class ListOperationsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :operations, as: 'operations', class: Google::Apis::ServicenetworkingV1::Operation, decorator: Google::Apis::ServicenetworkingV1::Operation::Representation
      
        end
      end
      
      class ListPeeredDnsDomainsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :peered_dns_domains, as: 'peeredDnsDomains', class: Google::Apis::ServicenetworkingV1::PeeredDnsDomain, decorator: Google::Apis::ServicenetworkingV1::PeeredDnsDomain::Representation
      
        end
      end
      
      class LogDescriptor
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :description, as: 'description'
          property :display_name, as: 'displayName'
          collection :labels, as: 'labels', class: Google::Apis::ServicenetworkingV1::LabelDescriptor, decorator: Google::Apis::ServicenetworkingV1::LabelDescriptor::Representation
      
          property :name, as: 'name'
        end
      end
      
      class Logging
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :consumer_destinations, as: 'consumerDestinations', class: Google::Apis::ServicenetworkingV1::LoggingDestination, decorator: Google::Apis::ServicenetworkingV1::LoggingDestination::Representation
      
          collection :producer_destinations, as: 'producerDestinations', class: Google::Apis::ServicenetworkingV1::LoggingDestination, decorator: Google::Apis::ServicenetworkingV1::LoggingDestination::Representation
      
        end
      end
      
      class LoggingDestination
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :logs, as: 'logs'
          property :monitored_resource, as: 'monitoredResource'
        end
      end
      
      class MethodProp
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          collection :options, as: 'options', class: Google::Apis::ServicenetworkingV1::Option, decorator: Google::Apis::ServicenetworkingV1::Option::Representation
      
          property :request_streaming, as: 'requestStreaming'
          property :request_type_url, as: 'requestTypeUrl'
          property :response_streaming, as: 'responseStreaming'
          property :response_type_url, as: 'responseTypeUrl'
          property :syntax, as: 'syntax'
        end
      end
      
      class MetricDescriptor
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :description, as: 'description'
          property :display_name, as: 'displayName'
          collection :labels, as: 'labels', class: Google::Apis::ServicenetworkingV1::LabelDescriptor, decorator: Google::Apis::ServicenetworkingV1::LabelDescriptor::Representation
      
          property :launch_stage, as: 'launchStage'
          property :metadata, as: 'metadata', class: Google::Apis::ServicenetworkingV1::MetricDescriptorMetadata, decorator: Google::Apis::ServicenetworkingV1::MetricDescriptorMetadata::Representation
      
          property :metric_kind, as: 'metricKind'
          collection :monitored_resource_types, as: 'monitoredResourceTypes'
          property :name, as: 'name'
          property :type, as: 'type'
          property :unit, as: 'unit'
          property :value_type, as: 'valueType'
        end
      end
      
      class MetricDescriptorMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :ingest_delay, as: 'ingestDelay'
          property :launch_stage, as: 'launchStage'
          property :sample_period, as: 'samplePeriod'
        end
      end
      
      class MetricRule
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          hash :metric_costs, as: 'metricCosts'
          property :selector, as: 'selector'
        end
      end
      
      class Mixin
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          property :root, as: 'root'
        end
      end
      
      class MonitoredResourceDescriptor
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :description, as: 'description'
          property :display_name, as: 'displayName'
          collection :labels, as: 'labels', class: Google::Apis::ServicenetworkingV1::LabelDescriptor, decorator: Google::Apis::ServicenetworkingV1::LabelDescriptor::Representation
      
          property :launch_stage, as: 'launchStage'
          property :name, as: 'name'
          property :type, as: 'type'
        end
      end
      
      class Monitoring
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :consumer_destinations, as: 'consumerDestinations', class: Google::Apis::ServicenetworkingV1::MonitoringDestination, decorator: Google::Apis::ServicenetworkingV1::MonitoringDestination::Representation
      
          collection :producer_destinations, as: 'producerDestinations', class: Google::Apis::ServicenetworkingV1::MonitoringDestination, decorator: Google::Apis::ServicenetworkingV1::MonitoringDestination::Representation
      
        end
      end
      
      class MonitoringDestination
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :metrics, as: 'metrics'
          property :monitored_resource, as: 'monitoredResource'
        end
      end
      
      class OAuthRequirements
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :canonical_scopes, as: 'canonicalScopes'
        end
      end
      
      class Operation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :done, as: 'done'
          property :error, as: 'error', class: Google::Apis::ServicenetworkingV1::Status, decorator: Google::Apis::ServicenetworkingV1::Status::Representation
      
          hash :metadata, as: 'metadata'
          property :name, as: 'name'
          hash :response, as: 'response'
        end
      end
      
      class Option
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :name, as: 'name'
          hash :value, as: 'value'
        end
      end
      
      class Page
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :content, as: 'content'
          property :name, as: 'name'
          collection :subpages, as: 'subpages', class: Google::Apis::ServicenetworkingV1::Page, decorator: Google::Apis::ServicenetworkingV1::Page::Representation
      
        end
      end
      
      class PeeredDnsDomain
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :dns_suffix, as: 'dnsSuffix'
          property :name, as: 'name'
        end
      end
      
      class PeeredDnsDomainMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class PolicyBinding
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :member, as: 'member'
          property :role, as: 'role'
        end
      end
      
      class Quota
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :limits, as: 'limits', class: Google::Apis::ServicenetworkingV1::QuotaLimit, decorator: Google::Apis::ServicenetworkingV1::QuotaLimit::Representation
      
          collection :metric_rules, as: 'metricRules', class: Google::Apis::ServicenetworkingV1::MetricRule, decorator: Google::Apis::ServicenetworkingV1::MetricRule::Representation
      
        end
      end
      
      class QuotaLimit
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :default_limit, :numeric_string => true, as: 'defaultLimit'
          property :description, as: 'description'
          property :display_name, as: 'displayName'
          property :duration, as: 'duration'
          property :free_tier, :numeric_string => true, as: 'freeTier'
          property :max_limit, :numeric_string => true, as: 'maxLimit'
          property :metric, as: 'metric'
          property :name, as: 'name'
          property :unit, as: 'unit'
          hash :values, as: 'values'
        end
      end
      
      class Range
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :ip_cidr_range, as: 'ipCidrRange'
          property :network, as: 'network'
        end
      end
      
      class RangeReservation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :ip_prefix_length, as: 'ipPrefixLength'
          collection :secondary_range_ip_prefix_lengths, as: 'secondaryRangeIpPrefixLengths'
        end
      end
      
      class RemoveDnsRecordSetMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class RemoveDnsRecordSetRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_network, as: 'consumerNetwork'
          property :dns_record_set, as: 'dnsRecordSet', class: Google::Apis::ServicenetworkingV1::DnsRecordSet, decorator: Google::Apis::ServicenetworkingV1::DnsRecordSet::Representation
      
          property :zone, as: 'zone'
        end
      end
      
      class RemoveDnsRecordSetResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class RemoveDnsZoneMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class RemoveDnsZoneRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_network, as: 'consumerNetwork'
          property :name, as: 'name'
        end
      end
      
      class RemoveDnsZoneResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class Route
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :dest_range, as: 'destRange'
          property :name, as: 'name'
          property :network, as: 'network'
          property :next_hop_gateway, as: 'nextHopGateway'
        end
      end
      
      class SearchRangeRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :ip_prefix_length, as: 'ipPrefixLength'
          property :network, as: 'network'
        end
      end
      
      class SecondaryIpRange
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :ip_cidr_range, as: 'ipCidrRange'
          property :range_name, as: 'rangeName'
        end
      end
      
      class SecondaryIpRangeSpec
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :ip_prefix_length, as: 'ipPrefixLength'
          property :range_name, as: 'rangeName'
          property :requested_address, as: 'requestedAddress'
        end
      end
      
      class Service
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :apis, as: 'apis', class: Google::Apis::ServicenetworkingV1::Api, decorator: Google::Apis::ServicenetworkingV1::Api::Representation
      
          property :authentication, as: 'authentication', class: Google::Apis::ServicenetworkingV1::Authentication, decorator: Google::Apis::ServicenetworkingV1::Authentication::Representation
      
          property :backend, as: 'backend', class: Google::Apis::ServicenetworkingV1::Backend, decorator: Google::Apis::ServicenetworkingV1::Backend::Representation
      
          property :billing, as: 'billing', class: Google::Apis::ServicenetworkingV1::Billing, decorator: Google::Apis::ServicenetworkingV1::Billing::Representation
      
          property :config_version, as: 'configVersion'
          property :context, as: 'context', class: Google::Apis::ServicenetworkingV1::Context, decorator: Google::Apis::ServicenetworkingV1::Context::Representation
      
          property :control, as: 'control', class: Google::Apis::ServicenetworkingV1::Control, decorator: Google::Apis::ServicenetworkingV1::Control::Representation
      
          property :custom_error, as: 'customError', class: Google::Apis::ServicenetworkingV1::CustomError, decorator: Google::Apis::ServicenetworkingV1::CustomError::Representation
      
          property :documentation, as: 'documentation', class: Google::Apis::ServicenetworkingV1::Documentation, decorator: Google::Apis::ServicenetworkingV1::Documentation::Representation
      
          collection :endpoints, as: 'endpoints', class: Google::Apis::ServicenetworkingV1::Endpoint, decorator: Google::Apis::ServicenetworkingV1::Endpoint::Representation
      
          collection :enums, as: 'enums', class: Google::Apis::ServicenetworkingV1::Enum, decorator: Google::Apis::ServicenetworkingV1::Enum::Representation
      
          property :http, as: 'http', class: Google::Apis::ServicenetworkingV1::Http, decorator: Google::Apis::ServicenetworkingV1::Http::Representation
      
          property :id, as: 'id'
          property :logging, as: 'logging', class: Google::Apis::ServicenetworkingV1::Logging, decorator: Google::Apis::ServicenetworkingV1::Logging::Representation
      
          collection :logs, as: 'logs', class: Google::Apis::ServicenetworkingV1::LogDescriptor, decorator: Google::Apis::ServicenetworkingV1::LogDescriptor::Representation
      
          collection :metrics, as: 'metrics', class: Google::Apis::ServicenetworkingV1::MetricDescriptor, decorator: Google::Apis::ServicenetworkingV1::MetricDescriptor::Representation
      
          collection :monitored_resources, as: 'monitoredResources', class: Google::Apis::ServicenetworkingV1::MonitoredResourceDescriptor, decorator: Google::Apis::ServicenetworkingV1::MonitoredResourceDescriptor::Representation
      
          property :monitoring, as: 'monitoring', class: Google::Apis::ServicenetworkingV1::Monitoring, decorator: Google::Apis::ServicenetworkingV1::Monitoring::Representation
      
          property :name, as: 'name'
          property :producer_project_id, as: 'producerProjectId'
          property :quota, as: 'quota', class: Google::Apis::ServicenetworkingV1::Quota, decorator: Google::Apis::ServicenetworkingV1::Quota::Representation
      
          property :source_info, as: 'sourceInfo', class: Google::Apis::ServicenetworkingV1::SourceInfo, decorator: Google::Apis::ServicenetworkingV1::SourceInfo::Representation
      
          property :system_parameters, as: 'systemParameters', class: Google::Apis::ServicenetworkingV1::SystemParameters, decorator: Google::Apis::ServicenetworkingV1::SystemParameters::Representation
      
          collection :system_types, as: 'systemTypes', class: Google::Apis::ServicenetworkingV1::Type, decorator: Google::Apis::ServicenetworkingV1::Type::Representation
      
          property :title, as: 'title'
          collection :types, as: 'types', class: Google::Apis::ServicenetworkingV1::Type, decorator: Google::Apis::ServicenetworkingV1::Type::Representation
      
          property :usage, as: 'usage', class: Google::Apis::ServicenetworkingV1::Usage, decorator: Google::Apis::ServicenetworkingV1::Usage::Representation
      
        end
      end
      
      class SourceContext
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :file_name, as: 'fileName'
        end
      end
      
      class SourceInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :source_files, as: 'sourceFiles'
        end
      end
      
      class Status
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :code, as: 'code'
          collection :details, as: 'details'
          property :message, as: 'message'
        end
      end
      
      class Subnetwork
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :ip_cidr_range, as: 'ipCidrRange'
          property :name, as: 'name'
          property :network, as: 'network'
          property :outside_allocation, as: 'outsideAllocation'
          collection :secondary_ip_ranges, as: 'secondaryIpRanges', class: Google::Apis::ServicenetworkingV1::SecondaryIpRange, decorator: Google::Apis::ServicenetworkingV1::SecondaryIpRange::Representation
      
        end
      end
      
      class SystemParameter
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :http_header, as: 'httpHeader'
          property :name, as: 'name'
          property :url_query_parameter, as: 'urlQueryParameter'
        end
      end
      
      class SystemParameterRule
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :parameters, as: 'parameters', class: Google::Apis::ServicenetworkingV1::SystemParameter, decorator: Google::Apis::ServicenetworkingV1::SystemParameter::Representation
      
          property :selector, as: 'selector'
        end
      end
      
      class SystemParameters
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :rules, as: 'rules', class: Google::Apis::ServicenetworkingV1::SystemParameterRule, decorator: Google::Apis::ServicenetworkingV1::SystemParameterRule::Representation
      
        end
      end
      
      class Type
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :fields, as: 'fields', class: Google::Apis::ServicenetworkingV1::Field, decorator: Google::Apis::ServicenetworkingV1::Field::Representation
      
          property :name, as: 'name'
          collection :oneofs, as: 'oneofs'
          collection :options, as: 'options', class: Google::Apis::ServicenetworkingV1::Option, decorator: Google::Apis::ServicenetworkingV1::Option::Representation
      
          property :source_context, as: 'sourceContext', class: Google::Apis::ServicenetworkingV1::SourceContext, decorator: Google::Apis::ServicenetworkingV1::SourceContext::Representation
      
          property :syntax, as: 'syntax'
        end
      end
      
      class UpdateConsumerConfigRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_config, as: 'consumerConfig', class: Google::Apis::ServicenetworkingV1::ConsumerConfig, decorator: Google::Apis::ServicenetworkingV1::ConsumerConfig::Representation
      
        end
      end
      
      class UpdateDnsRecordSetMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class UpdateDnsRecordSetRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_network, as: 'consumerNetwork'
          property :existing_dns_record_set, as: 'existingDnsRecordSet', class: Google::Apis::ServicenetworkingV1::DnsRecordSet, decorator: Google::Apis::ServicenetworkingV1::DnsRecordSet::Representation
      
          property :new_dns_record_set, as: 'newDnsRecordSet', class: Google::Apis::ServicenetworkingV1::DnsRecordSet, decorator: Google::Apis::ServicenetworkingV1::DnsRecordSet::Representation
      
          property :zone, as: 'zone'
        end
      end
      
      class Usage
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :producer_notification_channel, as: 'producerNotificationChannel'
          collection :requirements, as: 'requirements'
          collection :rules, as: 'rules', class: Google::Apis::ServicenetworkingV1::UsageRule, decorator: Google::Apis::ServicenetworkingV1::UsageRule::Representation
      
        end
      end
      
      class UsageRule
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :allow_unregistered_calls, as: 'allowUnregisteredCalls'
          property :selector, as: 'selector'
          property :skip_service_control, as: 'skipServiceControl'
        end
      end
      
      class ValidateConsumerConfigRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :consumer_network, as: 'consumerNetwork'
          property :consumer_project, as: 'consumerProject', class: Google::Apis::ServicenetworkingV1::ConsumerProject, decorator: Google::Apis::ServicenetworkingV1::ConsumerProject::Representation
      
          property :range_reservation, as: 'rangeReservation', class: Google::Apis::ServicenetworkingV1::RangeReservation, decorator: Google::Apis::ServicenetworkingV1::RangeReservation::Representation
      
          property :validate_network, as: 'validateNetwork'
        end
      end
      
      class ValidateConsumerConfigResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :is_valid, as: 'isValid'
          property :validation_error, as: 'validationError'
        end
      end
    end
  end
end
