#ifndef    __FTOutlineGlyph__
#define    __FTOutlineGlyph__

#include <vtk_freetype.h>
#include FT_FREETYPE_H
#include FT_GLYPH_H

#include "FTGL.h"
#include "FTGLgl.h"
#include "FTGlyph.h"

#ifdef FTGL_USE_NAMESPACE
namespace ftgl
{
#endif

class FTVectoriser;

/**
 * FTOutlineGlyph is a specialisation of FTGlyph for creating outlines.
 * 
 * @see FTGlyphContainer
 * @see FTVectoriser
 *
 */
class FTGL_EXPORT FTOutlineGlyph : public FTGlyph
{
  public:
    /**
     * Constructor
     *
     * @param glyph  The Freetype glyph to be processed
     */
    FTOutlineGlyph( FT_Glyph glyph);

    /**
     * Destructor
     */
    virtual ~FTOutlineGlyph();

    /**
     * Renders this glyph at the current pen position.
     *
     * @param pen  The current pen position.
     * @return    The advance distance for this glyph.
     */
    virtual float Render( const FT_Vector& pen,
                          const FTGLRenderContext *context = 0);
    
  private:
    /**
     * An object that helps convert freetype outlines into point
     * data
     */
    FTVectoriser* vectoriser;

    /**
     * The total number of points in the Freetype outline
     */
    int numPoints;

    /**
     * The totals number of contours in the Freetype outline
     */
    int numContours;

    /**
     * An array containing the number of points in each outline
     */
    int* contourLength;

    /**
     * Pointer to the point data
     */
    FTGL_DOUBLE* data;
    
    /**
     * OpenGL display list
     */
    GLuint glList;
  
};

#ifdef FTGL_USE_NAMESPACE
} // namespace ftgl
#endif

#endif  //  __FTOutlineGlyph__

