/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.EmptyStackException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.input.DragAwareEventQueue;
import org.fest.swing.input.EventNormalizer;
import org.fest.util.Strings;

class DragAwareEventNormalizer
extends EventNormalizer {
    private static Logger logger = Logger.getLogger(DragAwareEventNormalizer.class.getName());
    private DragAwareEventQueue dragAwareEventQueue;

    DragAwareEventNormalizer() {
    }

    public void startListening(Toolkit toolkit, AWTEventListener delegate, long mask) {
        super.startListening(toolkit, delegate, mask);
        try {
            this.dragAwareEventQueue = this.newDragAwareEventQueue(toolkit, mask);
            toolkit.getSystemEventQueue().push(this.dragAwareEventQueue);
        }
        catch (UnexpectedException e) {
            this.ignore(e);
        }
        catch (RuntimeException e) {
            this.ignore(e);
        }
    }

    private void ignore(Exception e) {
        String message = Strings.concat((Object[])new Object[]{"Ignoring error when starting up ", DragAwareEventNormalizer.class.getName()});
        logger.log(Level.WARNING, message, e);
    }

    DragAwareEventQueue newDragAwareEventQueue(Toolkit toolkit, long mask) {
        return new DragAwareEventQueue(toolkit, mask, this);
    }

    public void stopListening() {
        this.disposeDragAwareEventQueue();
        super.stopListening();
    }

    private void disposeDragAwareEventQueue() {
        if (this.dragAwareEventQueue == null) {
            return;
        }
        try {
            this.dragAwareEventQueue.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        this.dragAwareEventQueue = null;
    }
}

