.TH sane\-mustek 5 "13 Jul 2008" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-mustek
.SH NAME
sane\-mustek \- SANE backend for Mustek SCSI flatbed scanners (and some other devices)
.SH DESCRIPTION
The
.B sane\-mustek
library implements a SANE (Scanner Access Now Easy) backend that provides access
to Mustek (and some relabeled Trust and Primax) SCSI and parport flatbed
scanners.  At present, the following scanners are known to work more or less
with this backend:
.PP
.RS
Paragon MFS-6000CX
.br
Paragon MFS-12000CX
.br
Paragon MFC-600S, 600 II CD, ScanMagic 600 II SP
.br
Paragon MFC-800S, 800 II SP
.br
Paragon MFS-6000SP
.br
Paragon MFS-8000SP
.br
Paragon MFS-1200SP, MFS-12000SP
.br
ScanExpress 6000SP
.br
ScanExpress 12000SP, 12000SP Plus, Paragon 1200 III SP, ScanMagic 9636S, 9636S Plus
.br
Paragon 1200 LS
.br
ScanExpress A3 SP
.br
Paragon 1200 SP Pro
.br
Paragon 1200 A3 Pro
.br
Paragon 600 II EP
.br
Paragon 600 II N
.br
Trust Imagery 1200
.br
Trust Imagery 1200 SP
.br
Trust Imagery 4800 SP
.br
Trust SCSI Connect 19200
.br
Primax Compact 4800 SCSI
.br
.RE
.PP
More details can be found on the Mustek SCSI backend homepage
.IR http://www.meier\-geinitz.de/sane/mustek\-backend/ .
.PP
Don't mix up MFS (Paragon), Pro and ScanExpress models! They're
completely different. Check the exact model name!
.PP
Note that most of the above scanners come with a SCSI interface.  The only
non-SCSI scanners that have some support at this point is the 600 II N and 600
II EP scanners. The former one comes with its own parallel port adapter (i.e.,
it does
.I not
attach to the printer port). Both scanners use the SCSI protocol internally,
too. More info on how to use these parallel port scanners can be found below in
section
.BR "PARALLEL PORT SCANNERS" .
Other parallel port scanners are not supported by this backend but you may be
successful using the Mustek parallel port backend mustek_pp, see
.BR sane\-mustek_pp (5).
USB scanners are also not supported by this backend but the ma1509, mustek_usb,
gt68xx, and plustek backends include support for some of them, see
.BR sane\-ma1509 (5),
.BR sane\-mustek_usb (5),
.BR sane\-gt68xx "(5), and"
.BR sane\-plustek (5).
.PP
Mustek scanners have no protection against exceeding the physical scan
area height.  That is, if a scan is attempted with a height that
exceeds the height of the scan surface, the scanner begins making loud
noises and the scan mechanism may be damaged.  Thus, if you hear such
a noise, IMMEDIATELY turn off the scanner. This shouldn't happen if
your scanner is in the list of known scanners. There is more
information in the
.I @DOCDIR@/PROBLEMS
file.
.PP
If you own a Mustek (or Trust) scanner other than the ones listed
above that works with this backend, please let us know by sending the
scanner's exact model name (look at the front and back of the scanner)
and a debug output to
.IR sane\-devel@alioth-lists.debian.net .
You can get the debug output by setting the environment variable
.B SANE_DEBUG_MUSTEK
to 5 and showing the list of available scanners with
.IR "scanimage \-L" .
Please send all of it to the mailing list. You must be subscribed to sane\-devel
before you can send mail to the list. See
.I http://www.sane\-project.org/mailing\-lists.html
for details.

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.I special
.RE
.PP
Where
.I special
is either the path-name for the special device that corresponds to a
SCSI scanner or the port number at which the parallel port scanners can
be found (see section
.B "PARALLEL PORT SCANNERS"
below).  For SCSI scanners, the special device name must be a generic SCSI
device or a symlink to such a device.  The program
.BR sane\-find\-scanner (1)
helps to find out the correct device. Under Linux, such a device name
could be
.I /dev/sg0
or
.IR /dev/sg3 ,
for example.  See
.BR sane\-scsi (5)
for details.
.SH CONFIGURATION
The contents of the
.I mustek.conf
file is a list of options and device names that correspond to Mustek
scanners.  Empty lines and lines starting with a hash mark (#) are
ignored.  See
.BR sane\-scsi (5)
on details of what constitutes a valid device name.
.PP
The supported options are
.BR linedistance\-fix ,
.BR lineart\-fix ,
.BR legal\-size ,
.BR buffersize ,
.BR blocksize ,
.BR strip\-height ,
.BR disable\-double\-buffering ,
.BR disable\-backtracking ,
and
.BR force\-wait .
.PP
Options come in two flavors: global and positional ones.  Global
options apply to all devices managed by the backend whereas positional
options apply just to the most recently mentioned device.  Note that
this means that the order in which the options appear matters!
.PP
Option
.B linedistance\-fix
is positional and works around a problem that occurs with some SCSI
controllers (notably the ncr810 controller under Linux).  If color
scans have horizontal stripes and/or the colors are off, then it's
likely that your controller suffers from this problem.  Turning on
this option usually fixes the problem.
.PP
Option
.B lineart\-fix
is positional and works around a timing problem that seems to exist
with certain MFS-12000SP scanners.  The problem manifests itself in
dropped lines when scanning in lineart mode.  Turning on this option
should fix the problem but may slow down scanning a bit.
.PP
Option
.B legal\-size
is positional and sets the size of the scan area to Legal format. Set this
option if you own a Paragon 12000 LS. It can't be distinguished by
software from a ScanExpress 12000 SP (ISO A4 format).
.PP
Option
.B buffersize
is a positional option that overrides the default value set for the size of
the SCSI buffer. The buffer size is specified in kilobytes. The default value
is 128. Because of double buffering the buffer actually sent to the scanner
is half the size of this value. Try to increase this value to achieve higher
scan speeds. Note that some ScanExpress scanners don't like buffer sizes above
64 kb (buffersize = 128). If your sg driver can't set SCSI buffer sizes at
runtime you may have to change that value, too. See sane\-scsi(5) for details.
.PP
Option
.B blocksize
is a positional option that overrides the default value set for the maximum
amount of data scanned in one block. The buffer size is specified in
kilobytes. Some scanners freeze if this value is bigger than 2048. The default
value is 1 GB (so effectively no limit) for most scanners. Don't change this
value if you don't know exactly what you do.
.PP
Option
.B strip\-height
is a global option that limits the maximum height of the strip scanned with a
single SCSI read command.  The height is specified in inches and may contain a
fractional part (e.g., 1.5).  Setting the strip\-height to a small value (one
inch, for example) reduces the likelihood of encountering problems with SCSI
driver timeouts and/or timeouts with other devices on the same SCSI bus.
Unfortunately, it also increases scan times. With current SCSI adapters and
drivers this option shouldn't be needed any more.
.PP
Option
.B disable\-double\-buffering
is a global option. If set, the backend will only send one buffer at a time to
the scanner. Try this option if you have trouble while scanning, e.g. SCSI
errors, freezes, or the first few cm are repeated over and over again in your
image.
.PP
Option
.B disable\-backtracking
is a positional option. If set, the scanner will not move back its slider
after each SCSI buffer is filled (`backtracking'). Setting this option will
lead to faster scans but may also produce horizontal stripes. This option
doesn't work with every scanner (only some of the paragon models can modify
backtracking).
.PP
Finally,
.B force\-wait
is a global option. If set, the backend will wait until the device is ready
before sending the inquiry command. Further more the backend will force the
scan slider to return to its starting position (not implemented for all
scanners). This option may be necessary with the 600 II N or when
.BR scanimage (1)
is used multiple times (e.g. in scripts). The default is off (not set).
.PP
A sample configuration file is shown below:
.PP
.RS
# limit strip height of all scanners to 1.5 inches:
.br
option strip\-height 1.5
.br
.br
/dev/scanner    # first Mustek scanner
.br
# 1 MB buffer for /dev/scanner:
.br
option buffersize 1024
.br
/dev/sge        # second Mustek scanner
.br
# turn on fixes for /dev/sge:
.br
option lineart\-fix
.br
option linedistance\-fix
.RE

.SH "SCSI ADAPTER TIPS"
.PP
You need a SCSI adapter for the SCSI scanners. Even if the connector is the
same as that of parallel port scanners, connecting it to the computers
parallel port will NOT work.
.PP
Mustek SCSI scanners are typically delivered with an ISA SCSI adapter.
Unfortunately, that adapter is not worth much since it is not
interrupt driven.  It is (sometimes) possible to get the supplied card
to work, but without interrupt line, scanning will be very slow and put
so much load on the system, that it becomes almost unusable for other tasks.
.PP
If you already have a working SCSI controller in your system, you
should consider that Mustek scanners do not support the SCSI-2
disconnect/reconnect protocol and hence tie up the SCSI bus while a
scan is in progress.  This means that no other SCSI device on the same
bus can be accessed while a scan is in progress.
.PP
Because the Mustek-supplied adapter is not worth much and because
Mustek scanners do not support the SCSI-2 disconnect/reconnect
protocol, it is recommended to install a separate (cheap) SCSI
controller for Mustek scanners.  For example, ncr810 based cards are
known to work fine and cost as little as fifty US dollars.
.PP
For Mustek scanners, it is typically necessary to configure the low-level SCSI
driver to disable synchronous transfers (sync negotiation), tagged command
queuing, and target disconnects.  See
.BR sane\-scsi (5)
for driver- and platform-specific information.
.PP
The ScanExpress models have sometimes trouble with high resolution
color mode. If you encounter sporadic corrupted images (parts duplicated
or shifted horizontally) kill all other applications before scanning
and (if sufficient memory is available) disable swapping.
.PP
Details on how to get the Mustek SCSI adapters and other cards running can be
found at
.IR http://www.meier\-geinitz.de/sane/mustek\-backend/#SCSI .

.SH "PARALLEL PORT SCANNERS"
This backend has support for the Paragon 600 II EP and Paragon 600 II N parallel
port scanners.  Note that the latter scanner comes with its own ISA card that
implements a funky parallel port (in other words, the scanner does not connected
to the printer parallel port).
.PP
These scanners can be configured by listing the port number
of the adapter or the parallel port in the mustek.conf file.  Valid port numbers
for the 600 II N are
.IR 0x26b ", " 0x2ab ", " 0x2eb ", " 0x22b ", " 0x32b ", " 0x36b ", "
.IR 0x3ab ", " 0x3eb .
For the 600 II EP use one of these:
.IR parport0 ", " parport1 ", " parport2 ", " 0x378 ", " 0x278 ", " 0x3bc .
Pick one that doesn't conflict with the other hardware in your computer. Put
only one number on a single line. Example:
.PP
.RS
.I 0x3eb
.RE
.PP
Note that for these scanners usually root privileges are required to access the
I/O ports.  Thus, either make frontends such as
.BR scanimage (1)
and
.BR xscanimage (1)
setuid root (generally not recommended for safety reasons) or, alternatively,
access this backend through the network daemon
.BR saned (8).
.PP
If the Mustek backend blocks while sending the inquiry command to the scanner,
add the option
.B force\-wait
to
.IR mustek.conf .
.PP
Also note that after a while of no activity, some scanners themselves (not
the SANE backend) turns off their CCFL lamps. This shutdown is not always
perfect with the result that the lamp sometimes continues to glow
dimly at one end. This doesn't appear to be dangerous since as soon as
you use the scanner again, the lamp turns back on to the normal high
brightness. However, the first image scanned after such a shutdown may
have stripes and appear to be over-exposed.  When this happens, just
take another scan, and the image will be fine.

.SH FILES
.TP
.I @CONFIGDIR@/mustek.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane\-mustek.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-mustek.so
The shared library implementing this backend (present on systems that
support dynamic loading).

.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  On *NIX systems, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in
.IR @CONFIGDIR@ .
If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories
.IR "tmp/config" ,
.IR "." ,
and
.I "@CONFIGDIR@"
being searched (in this order).
.TP
.B SANE_DEBUG_MUSTEK
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  Higher
debug levels increase the verbosity of the output.

.ft CR
.nf
Value  Description
0      no output
1      print fatal errors
2      print important messages
3      print non-fatal errors and less important messages
4      print all but debugging messages
5      print everything
.fi
.ft R

Example:
export SANE_DEBUG_MUSTEK=4

.SH "SEE ALSO"
.BR sane (7),
.BR sane\-find\-scanner (1),
.BR sane\-scsi (5),
.BR sane\-mustek_usb (5),
.BR sane\-gt68xx (5),
.BR sane\-plustek (5),
.BR sane\-mustek_pp (5),
.BR sane\-ma1509 (5),
.BR scanimage (1),
.BR xscanimage (1)

.br
.I @DOCDIR@/mustek/mustek.CHANGES
.br
.I http://www.meier\-geinitz.de/sane/mustek\-backend/

.SH AUTHOR
David Mosberger, Andreas Czechanowski, Andreas Bolsch (SE extensions),
Henning Meier-Geinitz, James Perry (600 II EP).

.SH BUGS
Scanning with the SCSI adapters supplied by Mustek is very slow at
high resolutions and wide scan areas.
.PP
Some scanners (e.g. Paragon 1200 A3 + Pro, SE A3) need more testing.
.PP
The gamma table supports only 256 colors, even if some scanners can do more.
.PP
More detailed bug information is available at the Mustek backend
homepage:
.IR http://www.meier\-geinitz.de/sane/mustek\-backend/ .
