/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome;

import com.sun.management.OperatingSystemMXBean;
import genj.io.FileAssociation;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class FeedbackSurvey {
    private static final Logger LOG = Logger.getLogger(FeedbackSurvey.class.getName());

    private FeedbackSurvey() {
    }

    public static void start() {
        Preferences p = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        String id = p.get("ideIdentity", "unknown");
        long mem = -1L;
        try {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            mem = osBean.getTotalPhysicalMemorySize();
        }
        catch (IllegalArgumentException | NoSuchMethodError | SecurityException ex) {
            Logger.getLogger(FeedbackSurvey.class.getName()).log(Level.INFO, null, ex);
        }
        String url = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_URL", (Object)id, (Object)mem);
        if (url.length() == 0) {
            return;
        }
        try {
            int invocations;
            Preferences prefs = NbPreferences.forModule(FeedbackSurvey.class);
            long time = prefs.getLong("feedback.survey.show.at", 0L);
            if (time == 0L) {
                time = System.currentTimeMillis() + FeedbackSurvey.bundledInt("MSG_FeedbackSurvey_Delay");
                prefs.putLong("feedback.survey.show.at", time);
            }
            if ((long)(invocations = prefs.getInt("feedback.survey.startups", 0)) < FeedbackSurvey.bundledInt("MSG_FeedbackSurvey_MinimalStartups")) {
                prefs.putInt("feedback.survey.startups", invocations + 1);
                return;
            }
            if (System.currentTimeMillis() < time) {
                LOG.log(Level.FINE, "Not enough time passed");
                return;
            }
            int counts = prefs.getInt("feedback.survey.show.count", 0);
            if ((long)counts >= FeedbackSurvey.bundledInt("MSG_FeedbackSurvey_AskTimes")) {
                return;
            }
            URL u = new URL(url);
            URLConnection conn = u.openConnection();
            String type = conn.getContentType();
            if (type == null || !type.startsWith("text/html")) {
                LOG.log(Level.INFO, "Wrong mimetype - {0} - skipping survey", conn.getContentType());
                return;
            }
            prefs.putInt("feedback.survey.show.count", counts + 1);
            if (FeedbackSurvey.showDialog(u)) {
                prefs.putLong("feedback.survey.show.at", Long.MAX_VALUE);
            } else {
                prefs.putLong("feedback.survey.show.at", System.currentTimeMillis() + FeedbackSurvey.bundledInt("MSG_FeedbackSurveyAgain"));
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Cannot connect to {0}, skipping feedback survey", url);
            LOG.log(Level.FINE, ex.getMessage(), ex);
        }
    }

    private static long bundledInt(String msg) {
        return Long.parseLong(NbBundle.getMessage(FeedbackSurvey.class, (String)msg));
    }

    private static boolean showDialog(URL whereTo) {
        String msg = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_Message");
        String tit = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_Title");
        String yes = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_Yes");
        String later = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_Later");
        String never = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_Never");
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 3);
        nd.setTitle(tit);
        JButton yesButton = new JButton();
        yesButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FeedbackSurvey.class, (String)"ACSD_FeedbackSurvey_Yes"));
        Mnemonics.setLocalizedText((AbstractButton)yesButton, (String)yes);
        JButton laterButton = new JButton();
        laterButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FeedbackSurvey.class, (String)"ACSD_FeedbackSurvey_Later"));
        Mnemonics.setLocalizedText((AbstractButton)laterButton, (String)later);
        JButton neverButton = new JButton();
        neverButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FeedbackSurvey.class, (String)"ACSD_FeedbackSurvey_Never"));
        Mnemonics.setLocalizedText((AbstractButton)neverButton, (String)never);
        Object[] buttons = new Object[]{yesButton, laterButton, neverButton};
        nd.setOptions(buttons);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (res == yesButton) {
            FileAssociation.getDefault().execute(whereTo);
            return true;
        }
        if (res == neverButton) {
            Preferences prefs = NbPreferences.forModule(FeedbackSurvey.class);
            prefs.putInt("feedback.survey.show.count", (int)FeedbackSurvey.bundledInt("MSG_FeedbackSurvey_AskTimes"));
        }
        return false;
    }
}

