/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import ancestris.core.actions.AncestrisAction;
import ancestris.gedcom.GedcomDirectory;
import genj.gedcom.Property;
import genj.util.swing.ImageIcon;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import org.openide.awt.Actions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class AbstractAncestrisAction
extends AbstractAction
implements AncestrisAction {
    private static final String KEY_TEXT = "Name";
    private static final String KEY_OLDTEXT = "Name.old";
    private static final String KEY_SHORT_TEXT = "shortname";
    private static final String KEY_TIP = "ShortDescription";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_MNEMONIC = "MnemonicKey";
    private static final String KEY_ICON = "SmallIcon";
    private static final String KEY_ICONBASE = "iconBase";
    private static final String KEY_SELECTED = "SwingSelectedKey";
    private static final Logger LOG = Logger.getLogger("ancestris.actions");
    public static final String TXT_YES = NbBundle.getMessage(GedcomDirectory.class, (String)"cc.button.yes");
    public static final String TXT_NO = NbBundle.getMessage(GedcomDirectory.class, (String)"cc.button.no");
    public static final String TXT_OK = NbBundle.getMessage(GedcomDirectory.class, (String)"cc.button.ok");
    public static final String TXT_CANCEL = NbBundle.getMessage(GedcomDirectory.class, (String)"cc.button.cancel");

    public AbstractAncestrisAction() {
    }

    public AbstractAncestrisAction(String text) {
        this.setText(text);
    }

    public AbstractAncestrisAction(String text, Icon icon) {
        this.setText(text);
        this.setImage(icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public Object getValue(String key) {
        if (KEY_TEXT.equals(key)) {
            return this.getText();
        }
        if (KEY_ICON.equals(key)) {
            return this.getImage();
        }
        if (KEY_TIP.equals(key)) {
            return this.getTip();
        }
        return super.getValue(key);
    }

    @Override
    public final AncestrisAction setImage(Icon icon) {
        super.putValue(KEY_ICON, icon);
        return this;
    }

    public final AncestrisAction setIconBase(String resource) {
        super.putValue(KEY_ICONBASE, resource);
        return this;
    }

    @Override
    public final AncestrisAction setImage(String resource) {
        return this.setImage(new ImageIcon(ImageUtilities.loadImage((String)resource, (boolean)true)));
    }

    @Override
    public final AncestrisAction setText(String txt) {
        super.putValue(KEY_TEXT, txt);
        return this;
    }

    @Override
    public String getText() {
        return (String)super.getValue(KEY_TEXT);
    }

    @Override
    public AbstractAncestrisAction setTip(String tip) {
        super.putValue(KEY_TIP, tip);
        return this;
    }

    @Override
    public String getTip() {
        return (String)super.getValue(KEY_TIP);
    }

    @Override
    public Icon getImage() {
        return (Icon)super.getValue(KEY_ICON);
    }

    public JMenuItem getPopupPresenter() {
        Actions.MenuItem m = new Actions.MenuItem((Action)this, true);
        m.setToolTipText(this.getTip());
        return m;
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals((Boolean)this.getValue(KEY_SELECTED));
    }

    @Override
    public boolean setSelected(boolean selected) {
        boolean old = this.isSelected();
        this.putValue(KEY_SELECTED, selected ? Boolean.TRUE : Boolean.FALSE);
        return old;
    }

    @Override
    public boolean isDefault(Property prop) {
        return false;
    }
}

