/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.PropertyMultilineValue;
import java.util.List;
import java.util.regex.Pattern;

public class AbstractNote
extends Entity
implements MultiLineProperty {
    private PropertyMultilineValue delegate;

    protected boolean isDelegate() {
        return this.delegate != null;
    }

    protected AbstractNote(String tag, String id) {
        super(tag, id);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void moveEntityValue() {
    }

    @Override
    void addNotify(Gedcom ged) {
        super.addNotify(ged);
        if (this.delegate == null) {
            this.delegate = (PropertyMultilineValue)this.addProperty("NOTE", "");
            this.delegate.isTransient = true;
        }
    }

    public PropertyMultilineValue getDelegate() {
        if (this.delegate == null) {
            this.delegate = (PropertyMultilineValue)this.addProperty("NOTE", "");
            this.delegate.isTransient = true;
        }
        return this.delegate;
    }

    @Override
    protected String getToStringPrefix(boolean showIds) {
        return this.getDelegate().getDisplayValue();
    }

    @Override
    public String getDisplayTitle() {
        return this.getDisplayTitle(true);
    }

    @Override
    public String getDisplayTitle(boolean showIds) {
        int cut;
        int len;
        int maxLen = 30;
        String str = this.getDisplayValue().trim();
        if (!str.isEmpty() && maxLen != 0 && (len = str.length()) > maxLen && (cut = str.indexOf(" ", maxLen)) != -1) {
            str = str.substring(0, cut);
        }
        if (str.isEmpty()) {
            str = this.getPropertyName();
        }
        if (showIds) {
            return this.getId() + " - " + str;
        }
        return str;
    }

    @Override
    public void setValue(String newValue) {
        this.getDelegate().setValue(newValue);
    }

    @Override
    public void delProperty(Property which) {
        if (which != this.getDelegate()) {
            super.delProperty(which);
        }
    }

    @Override
    Property addProperty(Property which, int pos) {
        if (which instanceof PropertyMultilineValue && this.delegate != null && which.getTag().equals(this.getTag())) {
            this.delegate.setValue(this.delegate.getValue() + which.getValue());
            return this.delegate;
        }
        return super.addProperty(which, pos);
    }

    @Override
    public String getValue() {
        return this.getDelegate().getValue();
    }

    @Override
    public List<Property> findProperties(Pattern tag, Pattern value) {
        List<Property> result = super.findProperties(tag, value);
        result.remove(this);
        return result;
    }

    @Override
    public MultiLineProperty.Iterator getLineIterator(boolean isConcFile) {
        return this.getDelegate().getLineIterator(isConcFile);
    }

    @Override
    public MultiLineProperty.Collector getLineCollector() {
        return this.getDelegate().getLineCollector();
    }

    @Override
    public boolean isPrivate() {
        return this.getDelegate().isPrivate();
    }

    @Override
    public void setPrivate(boolean set, boolean recursively) {
        this.getDelegate().setPrivate(set, recursively);
    }

    @Override
    public PropertyComparator2 getDisplayComparator() {
        return NOTEComparator.getInstance();
    }

    private static class NOTEComparator
    extends PropertyComparator2.Default<AbstractNote> {
        private static final NOTEComparator INSTANCE = new NOTEComparator();

        private NOTEComparator() {
        }

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(AbstractNote n1, AbstractNote n2) {
            int r = this.compareNull(n1, n2);
            if (r != Integer.MAX_VALUE) {
                return r;
            }
            return n1.getGedcom().getCollator().compare(n1.toString(), n2.toString());
        }
    }
}

