/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Note;
import genj.gedcom.Repository;
import genj.gedcom.SNote;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.util.HashMap;
import java.util.Map;

public class GedcomConstants {
    public static final String DEST_ANY = "ANY";
    public static final String DEST_ANSTFILE = "ANSTFILE";
    public static final String DEST_TEMPLEREADY = "TempleReady";
    public static final String PASSWORD_UNKNOWN = "unknown";
    public static final String INDI = "INDI";
    public static final String FAM = "FAM";
    public static final String OBJE = "OBJE";
    public static final String NOTE = "NOTE";
    public static final String SNOTE = "SNOTE";
    public static final String SOUR = "SOUR";
    public static final String SUBM = "SUBM";
    public static final String REPO = "REPO";
    public static final String[] ENTITIES_5 = new String[]{"INDI", "FAM", "OBJE", "NOTE", "SOUR", "SUBM", "REPO"};
    public static final String[] ENTITIES_7 = new String[]{"INDI", "FAM", "OBJE", "SNOTE", "SOUR", "SUBM", "REPO"};
    public static final String[] ENTITIES = new String[]{"INDI", "FAM", "OBJE", "NOTE", "SNOTE", "SOUR", "SUBM", "REPO"};
    private static final Map<String, ImageIcon> E2_IMAGE = new HashMap<String, ImageIcon>();
    static final Map<String, String> E2PREFIX = new HashMap<String, String>();
    static final Map<String, Class<? extends Entity>> E2TYPE;

    private GedcomConstants() {
    }

    public static ImageIcon getEntityImage(String tag) {
        ImageIcon result = E2_IMAGE.get(tag);
        if (result == null) {
            result = Grammar.v70.getMeta(new TagPath(tag)).getImage();
            E2_IMAGE.put(tag, result);
        }
        return result;
    }

    static {
        E2PREFIX.put(INDI, "I");
        E2PREFIX.put(FAM, "F");
        E2PREFIX.put(OBJE, "M");
        E2PREFIX.put(NOTE, "N");
        E2PREFIX.put(SNOTE, "N");
        E2PREFIX.put(SOUR, "S");
        E2PREFIX.put(SUBM, "B");
        E2PREFIX.put(REPO, "R");
        E2TYPE = new HashMap<String, Class<? extends Entity>>();
        E2TYPE.put(INDI, Indi.class);
        E2TYPE.put(FAM, Fam.class);
        E2TYPE.put(OBJE, Media.class);
        E2TYPE.put(NOTE, Note.class);
        E2TYPE.put(SNOTE, SNote.class);
        E2TYPE.put(SOUR, Source.class);
        E2TYPE.put(SUBM, Submitter.class);
        E2TYPE.put(REPO, Repository.class);
    }

    public static enum Encodings {
        UTF8("UTF-8"),
        UNICODE("UNICODE"),
        ANSEL("ANSEL"),
        ANSI("ANSI"),
        LATIN1("LATIN1"),
        ASCII("ASCII");

        private String affichage;

        private Encodings(String value) {
            this.affichage = value;
        }

        public String toString() {
            return this.affichage;
        }
    }
}

